/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DualTableTransferHandler;
import com.jidesoft.grid.ListTableModelAdapter;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelAdapter;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.list.AbstractDualListModel;
import com.jidesoft.list.DefaultDisableableListSelectionModel;
import com.jidesoft.list.DefaultListModelWrapper;
import com.jidesoft.list.DualList;
import com.jidesoft.list.DualListModel;
import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class DualTable
extends JideSplitPane {
    public static final String COMMAND_MOVE_LEFT = "moveLeft";
    public static final String COMMAND_MOVE_RIGHT = "moveRight";
    public static final String COMMAND_MOVE_ALL_LEFT = "moveAllLeft";
    public static final String COMMAND_MOVE_ALL_RIGHT = "moveAllRight";
    public static final String COMMAND_MOVE_UP = "moveUp";
    public static final String COMMAND_MOVE_DOWN = "moveDown";
    public static final String COMMAND_MOVE_TO_TOP = "moveToTop";
    public static final String COMMAND_MOVE_TO_BOTTOM = "moveToBottom";
    static final String CLIENT_PROPERTY_DUAL_TABLE = "DualTable.dualTable";
    private static final Logger LOGGER;
    protected DualListModel _model;
    protected TableModelAdapter _tableModelAdapter;
    private JTable _originalTable;
    private JTable _selectedTable;
    private Container _buttonPanelMiddle;
    private Container _buttonPanelRight;
    private boolean _allowDuplicates = true;
    private Map<String, Action> _actions;
    private ActionHandler _handler;
    public JComponent _originalTablePane;
    public JComponent _selectedTablePane;
    public final String CLIENT_PROPERTY_ALWAYS_DISABLED = "DualTable.alwaysDisabled";
    protected DefaultListModelWrapper _selectedListModel;
    protected DefaultListModelWrapper _originalListModel;
    protected TableModel _selectedTableModel;
    protected TableModel _originalTableModel;
    private boolean _doubleClickEnabled = true;

    public DualTable(final Object[] objectArray, TableModelAdapter tableModelAdapter) {
        this(new AbstractDualListModel(){
            private static final long serialVersionUID = -2352415305921530997L;

            @Override
            public int getSize() {
                return objectArray.length;
            }

            public Object getElementAt(int n) {
                return objectArray[n];
            }
        }, tableModelAdapter);
    }

    public DualTable(final List<?> list, TableModelAdapter tableModelAdapter) {
        this(new AbstractDualListModel(){
            private static final long serialVersionUID = 7421165004351692957L;

            @Override
            public int getSize() {
                return list.size();
            }

            public Object getElementAt(int n) {
                return list.get(n);
            }
        }, tableModelAdapter);
    }

    public DualTable(DualListModel dualListModel, TableModelAdapter tableModelAdapter) {
        if (dualListModel == null) {
            throw new NullPointerException("model must be non null");
        }
        this._tableModelAdapter = tableModelAdapter;
        this.initComponent();
        this.setModel(dualListModel);
    }

    protected JTable createTable(ListModel listModel, final boolean bl) {
        ListTableModelAdapter listTableModelAdapter = this.createTableModel(listModel, this._tableModelAdapter, bl);
        if (bl) {
            this._originalTableModel = listTableModelAdapter;
        } else {
            this._selectedTableModel = listTableModelAdapter;
        }
        listModel.addListDataListener(listTableModelAdapter);
        SortableTable sortableTable = new SortableTable(listTableModelAdapter){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (bl && DualTable.this.getSelectionMode() == 1 && DualTable.this.getModel().isSelectedIndex(TableModelWrapperUtils.getActualRowAt(this.getModel(), n))) {
                    JideSwingUtilities.setEnabledRecursively(component, false);
                } else {
                    JideSwingUtilities.setEnabledRecursively(component, true);
                }
                return component;
            }

            @Override
            protected TransferHandler createDefaultTransferHandler() {
                return SystemInfo.isJdk6Above() ? new DualTableTransferHandler() : super.createDefaultTransferHandler();
            }
        };
        if (!bl) {
            sortableTable.setSortable(false);
        }
        sortableTable.setName(bl ? "DualTable.leftTable" : "DualTable.rightTable");
        return sortableTable;
    }

    protected ListTableModelAdapter createTableModel(ListModel listModel, TableModelAdapter tableModelAdapter, boolean bl) {
        return new ListTableModelAdapter(listModel, tableModelAdapter);
    }

    protected void setupTable(JTable jTable, boolean bl) {
        if (bl) {
            jTable.setSelectionModel(new DefaultDisableableListSelectionModel(jTable));
        }
        if (SystemInfo.isJdk6Above() && jTable.getTransferHandler() instanceof DualTableTransferHandler) {
            ((DualTableTransferHandler)jTable.getTransferHandler()).setAcceptImport(true);
            jTable.setDragEnabled(true);
            jTable.setDropMode(DropMode.INSERT_ROWS);
            jTable.setFillsViewportHeight(true);
            jTable.putClientProperty(CLIENT_PROPERTY_DUAL_TABLE, this);
        }
        jTable.addMouseListener(this._handler);
        jTable.getSelectionModel().addListSelectionListener(this._handler);
        SearchableUtils.installSearchable(jTable);
    }

    private void initComponent() {
        this._handler = new ActionHandler();
        this.addPropertyChangeListener("model", this._handler);
        this.addPropertyChangeListener("componentOrientation", this._handler);
        this._actions = new HashMap<String, Action>();
        this._actions.put(COMMAND_MOVE_RIGHT, this.createAction(COMMAND_MOVE_RIGHT));
        this._actions.put(COMMAND_MOVE_LEFT, this.createAction(COMMAND_MOVE_LEFT));
        this._actions.put(COMMAND_MOVE_ALL_RIGHT, this.createAction(COMMAND_MOVE_ALL_RIGHT));
        this._actions.put(COMMAND_MOVE_ALL_LEFT, this.createAction(COMMAND_MOVE_ALL_LEFT));
        this._actions.put(COMMAND_MOVE_UP, this.createAction(COMMAND_MOVE_UP));
        this._actions.put(COMMAND_MOVE_DOWN, this.createAction(COMMAND_MOVE_DOWN));
        this._actions.put(COMMAND_MOVE_TO_TOP, this.createAction(COMMAND_MOVE_TO_TOP));
        this._actions.put(COMMAND_MOVE_TO_BOTTOM, this.createAction(COMMAND_MOVE_TO_BOTTOM));
        this._originalListModel = new DefaultListModelWrapper();
        this._originalTable = this.createTable(this._originalListModel, true);
        this.setupTable(this._originalTable, true);
        this._selectedListModel = new DefaultListModelWrapper();
        this._selectedTable = this.createTable(this._selectedListModel, false);
        this.setupTable(this._selectedTable, false);
        this._originalTablePane = new NullPanel(new BorderLayout());
        this._originalTablePane.setOpaque(false);
        this._selectedTablePane = new NullPanel(new BorderLayout());
        this._selectedTablePane.setOpaque(false);
        this._originalTablePane.add(new JScrollPane(this._originalTable));
        this._selectedTablePane.add(new JScrollPane(this._selectedTable));
        this._buttonPanelMiddle = this.createButtonPanel();
        if (this._buttonPanelMiddle instanceof JPanel) {
            ((JPanel)this._buttonPanelMiddle).setBorder(new EmptyBorder(0, 2, 0, 2){
                private static final long serialVersionUID = -8373234859482038083L;

                @Override
                public Insets getBorderInsets(Component component) {
                    Insets insets = super.getBorderInsets(component);
                    JComponent jComponent = DualTable.this.getOriginalTablePane();
                    if (jComponent != null && jComponent.getBorder() != null) {
                        Insets insets2 = jComponent.getBorder().getBorderInsets(jComponent);
                        insets.top = insets2.top;
                        insets.bottom = insets2.bottom;
                    }
                    return insets;
                }
            });
        }
        this._buttonPanelMiddle.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_RIGHT))));
        AbstractButton abstractButton = this.createButton(this.getAction(COMMAND_MOVE_LEFT));
        this._buttonPanelMiddle.add(this.createDummyPanel(abstractButton));
        this._buttonPanelMiddle.add(Box.createVerticalStrut(abstractButton.getPreferredSize().height - 8));
        this._buttonPanelMiddle.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_ALL_RIGHT))));
        this._buttonPanelMiddle.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_ALL_LEFT))));
        this._buttonPanelMiddle.add(Box.createGlue(), "vary");
        this._buttonPanelRight = this.createButtonPanel();
        if (this._buttonPanelRight instanceof JPanel) {
            ((JPanel)this._buttonPanelRight).setBorder(new EmptyBorder(0, 2, 0, 2){
                private static final long serialVersionUID = -8373234859482038083L;

                @Override
                public Insets getBorderInsets(Component component) {
                    Insets insets = super.getBorderInsets(component);
                    JComponent jComponent = DualTable.this.getSelectedTablePane();
                    if (jComponent != null && jComponent.getBorder() != null) {
                        Insets insets2 = jComponent.getBorder().getBorderInsets(jComponent);
                        insets.top = insets2.top;
                        insets.bottom = insets2.bottom;
                    }
                    return insets;
                }
            });
        }
        this._buttonPanelRight.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_TO_TOP))));
        AbstractButton abstractButton2 = this.createButton(this.getAction(COMMAND_MOVE_UP));
        this._buttonPanelRight.add(this.createDummyPanel(abstractButton2));
        this._buttonPanelRight.add(Box.createVerticalStrut(abstractButton2.getPreferredSize().height - 8));
        this._buttonPanelRight.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_DOWN))));
        this._buttonPanelRight.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_TO_BOTTOM))));
        this._buttonPanelRight.add(Box.createGlue(), "vary");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this._selectedTablePane, "Center");
        jPanel.add((Component)this._buttonPanelRight, "After");
        this.installKeyboardAction();
        this.setOrientation(1);
        this.setDividerSize(this._buttonPanelMiddle.getPreferredSize().width);
        this.add((Component)this._originalTablePane, "flexible");
        this.add((Component)jPanel, "flexible");
        this.addButtonPanel(this.getDividerAt(0), this._buttonPanelMiddle);
    }

    public JTable getOriginalTable() {
        return this._originalTable;
    }

    public JTable getSelectedTable() {
        return this._selectedTable;
    }

    public JComponent getOriginalTablePane() {
        return this._originalTablePane;
    }

    public JComponent getSelectedTablePane() {
        return this._selectedTablePane;
    }

    protected void addButtonPanel(Container container, Component component) {
        container.setLayout(new BorderLayout());
        container.add(component, "First");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this._buttonPanelMiddle != null) {
            dimension.height = Math.max(dimension.height, this._buttonPanelMiddle.getPreferredSize().height);
        }
        if (this._buttonPanelRight != null) {
            dimension.height = Math.max(dimension.height, this._buttonPanelRight.getPreferredSize().height);
        }
        if (this._originalTable != null) {
            dimension.height = Math.max(dimension.height, this._originalTable.getPreferredScrollableViewportSize().height);
        }
        if (this._selectedTable != null) {
            dimension.height = Math.max(dimension.height, this._selectedTable.getPreferredScrollableViewportSize().height);
        }
        return dimension;
    }

    protected Container createButtonPanel() {
        NullPanel nullPanel = new NullPanel();
        nullPanel.setOpaque(false);
        nullPanel.setLayout(new JideBoxLayout(nullPanel, 1, 4));
        return nullPanel;
    }

    private Action createAction(String string) {
        ActionHandler actionHandler = new ActionHandler();
        actionHandler.putValue("ActionCommandKey", string);
        this.updateAction(actionHandler, string);
        return actionHandler;
    }

    private void updateAction(Action action, String string) {
        block21: {
            Object object;
            String string2;
            block20: {
                String string3;
                block19: {
                    block18: {
                        block17: {
                            string2 = "dualList." + string + ".";
                            try {
                                string3 = this.getResourceString(string2 + "text");
                                if (string3 != null && string3.trim().length() > 0) {
                                    action.putValue("Name", string3);
                                }
                            }
                            catch (Exception exception) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block17;
                                LOGGER.fine(exception.getMessage());
                            }
                        }
                        string3 = null;
                        try {
                            string3 = this.getResourceString(string2 + "icon");
                        }
                        catch (Exception exception) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block18;
                            LOGGER.fine(exception.getMessage());
                        }
                    }
                    if (string3 != null) {
                        if (string3.trim().length() == 0) {
                            string3 = String.format("icons/%s.png", string);
                        }
                        object = IconsFactory.getImageIcon(DualList.class, string3);
                        action.putValue("SmallIcon", object);
                    }
                    string3 = null;
                    try {
                        string3 = this.getResourceString(string2 + "disabledIcon");
                    }
                    catch (Exception exception) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block19;
                        LOGGER.fine(exception.getMessage());
                    }
                }
                if (string3 != null) {
                    if (string3.trim().length() == 0) {
                        string3 = String.format("icons/%s_disabled.png", string);
                    }
                    object = IconsFactory.getImageIcon(DualList.class, string3);
                    action.putValue("disabledIcon", object);
                }
                try {
                    object = this.getResourceString(string2 + "tooltip");
                    if (object != null && ((String)object).trim().length() > 0) {
                        action.putValue("ShortDescription", object);
                    }
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block20;
                    LOGGER.fine(exception.getMessage());
                }
            }
            try {
                object = this.getResourceString(string2 + "mnemonic");
                if (object != null && ((String)object).trim().length() > 1) {
                    action.putValue("MnemonicKey", Character.valueOf(((String)object).charAt(0)));
                }
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.FINE)) break block21;
                LOGGER.fine(exception.getMessage());
            }
        }
    }

    protected AbstractButton createButton(final Action action) {
        final JideButton jideButton = new JideButton(action);
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("disabledIcon".equals(propertyChangeEvent.getPropertyName())) {
                    jideButton.setDisabledIcon((Icon)action.getValue("disabledIcon"));
                }
            }
        });
        jideButton.setName("" + action.getValue("ActionCommandKey"));
        jideButton.setDisabledIcon((Icon)action.getValue("disabledIcon"));
        jideButton.setRequestFocusEnabled(false);
        return jideButton;
    }

    private void updateOriginalList() {
        DefaultDisableableListSelectionModel defaultDisableableListSelectionModel = (DefaultDisableableListSelectionModel)this._originalTable.getSelectionModel();
        if (this._model.getSelectionMode() == 1) {
            defaultDisableableListSelectionModel.setDisabledIndices(this.getSelectedIndices());
        } else {
            defaultDisableableListSelectionModel.setDisabledIndices(null);
        }
        this._originalListModel.setActualModel(this._model);
        if (this._model.getSelectionMode() == 0) {
            this._originalListModel.setIndexes(this.getUnselectedIndices());
        } else {
            this._originalListModel.reallocateIndexes();
        }
        this._originalListModel.fireListDataEvent(new ListDataEvent(this._originalListModel, 0, 0, this._originalListModel.getSize() - 1));
    }

    private void updateOriginalRenderer() {
    }

    private void updateSelectedList() {
        DefaultListModelWrapper defaultListModelWrapper = this._selectedListModel;
        defaultListModelWrapper.setActualModel(this._model);
        defaultListModelWrapper.setIndexes(this.getSelectedIndices());
        defaultListModelWrapper.fireListDataEvent(new ListDataEvent(defaultListModelWrapper, 0, 0, defaultListModelWrapper.getSize() - 1));
        this._selectedTable.revalidate();
        this._selectedTable.repaint();
    }

    public void enableAction(String string, boolean bl) {
        Action action = this.getAction(string);
        if (action != null) {
            if (!Boolean.TRUE.equals(action.getValue("DualTable.alwaysDisabled"))) {
                action.setEnabled(bl);
            } else {
                action.setEnabled(false);
            }
        }
    }

    public Action getAction(String string) {
        return this._actions.get(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        this._originalTable.clearSelection();
        this._originalTable.setEnabled(bl);
        this._selectedTable.clearSelection();
        this._selectedTable.setEnabled(bl);
        this.setButtonEnabled(COMMAND_MOVE_ALL_LEFT, bl);
        this.setButtonEnabled(COMMAND_MOVE_ALL_RIGHT, bl);
        super.setEnabled(bl);
    }

    void setSelectedIndices(JTable jTable, int[] nArray) {
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.clearSelection();
        int n = jTable.getRowCount();
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            listSelectionModel.addSelectionInterval(n2, n2);
        }
    }

    int[] getSelectedIndices(JTable jTable) {
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            nArray[n3++] = i;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    private void updateButtonPanel() {
        boolean bl;
        int[] nArray = this.getSelectedIndices(this._originalTable);
        boolean bl2 = bl = nArray.length > 0;
        if (bl && (this.getSelectionMode() == 2 && !this.isAllowDuplicates() || this.getSelectionMode() == 1)) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.getActualIndex(this._originalTable, nArray[i], null);
            }
            int[] nArray2 = this.getSelectedIndices();
            for (int n : nArray) {
                for (int n2 : nArray2) {
                    if (n != n2) continue;
                    bl = false;
                    break;
                }
                if (!bl) break;
            }
        }
        this.enableAction(COMMAND_MOVE_RIGHT, bl);
        this.enableAction(COMMAND_MOVE_ALL_RIGHT, this.getSelectionMode() == 2 || this.getUnselectedIndices().length != 0);
        this.enableAction(COMMAND_MOVE_LEFT, !this._selectedTable.getSelectionModel().isSelectionEmpty());
        this.enableAction(COMMAND_MOVE_ALL_LEFT, this.getSelectedIndices().length != 0);
        boolean bl3 = this._selectedTable.getSelectionModel().getMaxSelectionIndex() >= this.getSelectedIndices(this._selectedTable).length;
        boolean bl4 = this._selectedTable.getSelectionModel().getMinSelectionIndex() >= 0 && this._selectedTable.getSelectionModel().getMinSelectionIndex() < this._selectedTable.getRowCount() - this.getSelectedIndices(this._selectedTable).length;
        this.enableAction(COMMAND_MOVE_UP, bl3);
        this.enableAction(COMMAND_MOVE_DOWN, bl4);
        this.enableAction(COMMAND_MOVE_TO_TOP, bl3);
        this.enableAction(COMMAND_MOVE_TO_BOTTOM, bl4);
    }

    private void layoutImpl() {
        int n = this.getPreferredSize().width;
        int n2 = this.getDividerSize();
        if (this._buttonPanelMiddle.isVisible()) {
            n2 = this._buttonPanelMiddle.getPreferredSize().width;
        }
        int n3 = n - n2 >> 1;
        PortingUtils.setPreferredSize(this._originalTable.getParent().getParent(), new Dimension(n3, this.getHeight()));
        PortingUtils.setPreferredSize(this._selectedTable.getParent().getParent(), new Dimension(n3, this.getHeight()));
    }

    public int[] getSelectedIndices() {
        return this._model.getSelectedIndices();
    }

    public int[] getUnselectedIndices() {
        int n;
        int[] nArray = this._model.getSelectedIndices();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        block0: for (int i = 0; i < this._model.getSize(); ++i) {
            if (hashSet.contains(i)) continue;
            while (n2 < nArray.length) {
                n = nArray[n2];
                ++n2;
                hashSet.add(n);
                if (n != i) continue;
                continue block0;
            }
            arrayList.add(i);
        }
        int[] nArray2 = new int[arrayList.size()];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = (Integer)arrayList.get(n);
        }
        return nArray2;
    }

    protected void installKeyboardAction() {
        this._originalTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (JideSwingUtilities.isMenuShortcutKeyDown(keyEvent)) {
                    boolean bl = DualTable.this.getComponentOrientation().isLeftToRight();
                    if (n == 39 && bl || n == 37 && !bl) {
                        DualTable.this._selectedTable.requestFocusInWindow();
                        if (DualTable.this._selectedTable.getSelectionModel().isSelectionEmpty() && DualTable.this._selectedTable.getRowCount() > 0) {
                            DualTable.this._selectedTable.getSelectionModel().setSelectionInterval(0, 0);
                        }
                        keyEvent.consume();
                    }
                } else {
                    boolean bl = DualTable.this.getComponentOrientation().isLeftToRight();
                    if ((n == 10 || n == 39 && bl || n == 37 && !bl) && (n == 10 || DualTable.this._originalTable.getSelectedColumn() >= DualTable.this._originalTable.getColumnCount() - 1)) {
                        DualTable.this.performAction(DualTable.COMMAND_MOVE_RIGHT);
                        keyEvent.consume();
                    }
                }
            }
        });
        this._selectedTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    if (n == 38) {
                        DualTable.this.performAction(DualTable.COMMAND_MOVE_UP);
                        keyEvent.consume();
                    } else if (n == 40) {
                        DualTable.this.performAction(DualTable.COMMAND_MOVE_DOWN);
                        keyEvent.consume();
                    } else if (n == 36) {
                        DualTable.this.performAction(DualTable.COMMAND_MOVE_TO_TOP);
                        keyEvent.consume();
                    } else if (n == 35) {
                        DualTable.this.performAction(DualTable.COMMAND_MOVE_TO_BOTTOM);
                        keyEvent.consume();
                    }
                    boolean bl = DualTable.this.getComponentOrientation().isLeftToRight();
                    if (n == 37 && bl || n == 39 && !bl) {
                        DualTable.this._originalTable.requestFocusInWindow();
                        if (DualTable.this._originalTable.getSelectionModel().isSelectionEmpty() && DualTable.this._originalTable.getRowCount() > 0) {
                            DualTable.this._originalTable.getSelectionModel().setSelectionInterval(0, 0);
                        }
                        keyEvent.consume();
                    }
                } else {
                    boolean bl = DualTable.this.getComponentOrientation().isLeftToRight();
                    if (n == 10 || n == 127 || n == 37 && bl || n == 39 && !bl) {
                        if (n == 10 || n == 127 || DualTable.this._selectedTable.getSelectedColumn() == 0) {
                            DualTable.this.performAction(DualTable.COMMAND_MOVE_LEFT);
                            keyEvent.consume();
                        }
                    } else if (n == 27 && !DualTable.this._selectedTable.getSelectionModel().isSelectionEmpty()) {
                        DualTable.this._selectedTable.clearSelection();
                        DualTable.this._selectedTable.getSelectionModel().setAnchorSelectionIndex(-1);
                        keyEvent.consume();
                    }
                }
            }
        });
    }

    public DualListModel getModel() {
        return this._model;
    }

    public void setModel(DualListModel dualListModel) {
        if (dualListModel == null) {
            throw new NullPointerException("The model must not be null.");
        }
        if (!JideSwingUtilities.equals(this._model, dualListModel)) {
            if (this._model != null) {
                this._model.removeListSelectionListener(this._handler);
                this._model.removeListDataListener(this._handler);
                this._model.removePropertyChangeListener(this._handler);
            }
            DualListModel dualListModel2 = this._model;
            this._model = dualListModel;
            this._model.addPropertyChangeListener(this._handler);
            this._model.addListDataListener(this._handler);
            this._model.addListSelectionListener(this._handler);
            this.firePropertyChange("model", dualListModel2, dualListModel);
        }
    }

    public Object[] getSelectedValues() {
        int[] nArray = this.getSelectedIndices();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this._model.getElementAt(nArray[i]);
        }
        return objectArray;
    }

    public Object[] getUnselectedValues() {
        int[] nArray = this.getUnselectedIndices();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this._model.getElementAt(nArray[i]);
        }
        return objectArray;
    }

    public boolean isSelectedIndex(int n) {
        return this._model.isSelectedIndex(n);
    }

    public void clearSelection() {
        this._model.clearSelection();
    }

    @Deprecated
    public void addSelectionInteval(int n, int n2) {
        this.addSelectionInterval(n, n2);
    }

    @Deprecated
    public void removeSelectionInteval(int n, int n2) {
        this.removeSelectionInterval(n, n2);
    }

    public void addSelectionInterval(int n, int n2) {
        this._model.addSelectionInterval(n, n2);
    }

    public void removeSelectionInterval(int n, int n2) {
        this._model.removeSelectionInterval(n, n2);
    }

    public boolean isSelectionEmpty() {
        return this._model.isSelectionEmpty();
    }

    public int getSelectionMode() {
        return this._model.getSelectionMode();
    }

    public void setSelectionMode(int n) {
        this._model.setSelectionMode(n);
    }

    public void setButtonVisible(String string, boolean bl) {
        String string2;
        Container container;
        int n;
        boolean bl2 = true;
        for (n = this._buttonPanelMiddle.getComponentCount() - 1; n >= 0; --n) {
            container = (Container)this._buttonPanelMiddle.getComponent(n);
            if (container.getComponentCount() < 1) continue;
            string2 = container.getComponent(0).getName();
            if (string.equals(string2)) {
                container.setVisible(bl);
            }
            if (!this._actions.containsKey(string2) || !container.isVisible()) continue;
            this._buttonPanelMiddle.setVisible(true);
            bl2 = false;
        }
        if (bl2) {
            this._buttonPanelMiddle.setVisible(false);
        }
        bl2 = true;
        for (n = this._buttonPanelRight.getComponentCount() - 1; n >= 0; --n) {
            container = (Container)this._buttonPanelRight.getComponent(n);
            if (container.getComponentCount() < 1) continue;
            string2 = container.getComponent(0).getName();
            if (string.equals(string2)) {
                container.setVisible(bl);
            }
            if (!this._actions.containsKey(string2) || !container.isVisible()) continue;
            this._buttonPanelRight.setVisible(true);
            bl2 = false;
        }
        if (bl2) {
            this._buttonPanelRight.setVisible(false);
        }
    }

    public boolean isButtonVisible(String string) {
        Component component;
        int n;
        for (n = this._buttonPanelMiddle.getComponentCount() - 1; n >= 0; --n) {
            component = this._buttonPanelMiddle.getComponent(n);
            if (!string.equals(component.getName())) continue;
            return component.isVisible();
        }
        for (n = this._buttonPanelRight.getComponentCount() - 1; n >= 0; --n) {
            component = this._buttonPanelRight.getComponent(n);
            if (!string.equals(component.getName())) continue;
            return component.isVisible();
        }
        throw new NoSuchElementException();
    }

    public void setButtonEnabled(String string, boolean bl) {
        Action action = this.getAction(string);
        if (action != null) {
            if (bl) {
                action.putValue("DualTable.alwaysDisabled", null);
            } else {
                action.putValue("DualTable.alwaysDisabled", true);
            }
        } else {
            throw new NoSuchElementException();
        }
        this.updateButtonPanel();
    }

    public boolean isButtonEnabled(String string) {
        Action action = this.getAction(string);
        if (action != null) {
            return !Boolean.TRUE.equals(action.getValue("DualTable.alwaysDisabled"));
        }
        throw new NoSuchElementException();
    }

    int getActualIndex(JTable jTable, int n, ListModel listModel) {
        ListTableModelAdapter listTableModelAdapter = (ListTableModelAdapter)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), ListTableModelAdapter.class);
        int n2 = TableModelWrapperUtils.getActualRowAt(jTable.getModel(), n, ListTableModelAdapter.class);
        if (n2 < 0) {
            return -1;
        }
        if (listModel == null) {
            return ListModelWrapperUtils.getActualIndexAt(listTableModelAdapter.getListModel(), n2);
        }
        return ListModelWrapperUtils.getActualIndexAt(listTableModelAdapter.getListModel(), n2, listModel);
    }

    public void moveLeft() {
        int n;
        int[] nArray = this.getSelectedIndices(this._selectedTable);
        this._model.setValueIsAdjusting(true);
        for (n = nArray.length - 1; n >= 0; --n) {
            ListTableModelAdapter listTableModelAdapter = (ListTableModelAdapter)TableModelWrapperUtils.getActualTableModel(this._selectedTable.getModel(), ListTableModelAdapter.class);
            int n2 = TableModelWrapperUtils.getActualRowAt(this._selectedTable.getModel(), nArray[n], ListTableModelAdapter.class);
            if (n2 < 0) continue;
            ListModel listModel = listTableModelAdapter.getListModel();
            ListModel listModel2 = ListModelWrapperUtils.getActualListModel(listModel);
            while (listModel != null && listModel instanceof ListModelWrapper && ((ListModelWrapper)((Object)listModel)).getActualModel() != listModel2) {
                listModel = ((ListModelWrapper)((Object)listModel)).getActualModel();
            }
            int n3 = ListModelWrapperUtils.getActualIndexAt(listTableModelAdapter.getListModel(), n2, listModel);
            if (n3 < 0) continue;
            this._model.removeSelectionInterval(n3, n3);
        }
        this._model.setValueIsAdjusting(false);
        if (this._model.getSelectionMode() != 2) {
            this._originalTable.clearSelection();
        }
        this._originalTable.invalidate();
        this._originalTable.repaint();
        if (nArray.length > 0) {
            n = nArray[nArray.length - 1];
            if (n >= this._selectedTable.getRowCount()) {
                n = this._selectedTable.getRowCount() - 1;
            }
            if (n >= 0) {
                this._selectedTable.getSelectionModel().setSelectionInterval(n, n);
            }
        }
        this.updateButtonPanel();
        this.updateOriginalRenderer();
    }

    public void moveRight() {
        int n;
        int n2;
        int[] nArray = this.getSelectedIndices(this._originalTable);
        int n3 = this._selectedTable.getSelectionModel().getAnchorSelectionIndex();
        this._model.setValueIsAdjusting(true);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = this.getActualIndex(this._originalTable, nArray[n2], null);
            this._model.addSelectionInterval(n, n);
            int n4 = this._selectedTable.getRowCount() + n2;
            if (n3 == -1) continue;
            this._model.moveSelection(n4, n4, n3 + n2, true);
        }
        if (n3 != -1) {
            int[] nArray2 = new int[nArray.length];
            for (n = nArray.length - 1; n >= 0; --n) {
                nArray2[n] = n3 + n;
            }
            this.setSelectedIndices(this._selectedTable, nArray2);
            this._selectedTable.getSelectionModel().setLeadSelectionIndex(n3);
            this._selectedTable.getSelectionModel().setAnchorSelectionIndex(n3);
        }
        this._model.setValueIsAdjusting(false);
        if (nArray.length > 0) {
            n2 = nArray[nArray.length - 1];
            if (n2 >= this._originalTable.getRowCount()) {
                n2 = this._originalTable.getRowCount() - 1;
            }
            if (n2 >= 0) {
                this._originalTable.getSelectionModel().setSelectionInterval(n2, n2);
            }
        }
        TableUtils.ensureRowSelectionVisible(this._selectedTable);
        this.updateButtonPanel();
        this.updateOriginalRenderer();
    }

    public void moveAllLeft() {
        this._model.clearSelection();
        this.updateOriginalRenderer();
    }

    public void moveAllRight() {
        this._model.selectAll();
        int n = this._selectedTable.getRowCount();
        this._selectedTable.getSelectionModel().setSelectionInterval(0, n - 1);
        this.updateOriginalRenderer();
    }

    public void moveUp() {
        int[] nArray = this.getSelectedIndices(this._selectedTable);
        this._model.setValueIsAdjusting(true);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= i) continue;
            int n = this.getActualIndex(this._selectedTable, nArray[i], this._selectedListModel);
            int n2 = this.getActualIndex(this._selectedTable, nArray[i] - 1, this._selectedListModel);
            this._model.moveSelection(n, n, n2, true);
            int n3 = i;
            nArray[n3] = nArray[n3] - 1;
        }
        this._model.setValueIsAdjusting(false);
        this.setSelectedIndices(this._selectedTable, nArray);
        TableUtils.ensureRowSelectionVisible(this._selectedTable);
    }

    public void moveDown() {
        int[] nArray = this.getSelectedIndices(this._selectedTable);
        int n = this._selectedTable.getRowCount();
        this._model.setValueIsAdjusting(true);
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] >= n - (nArray.length - i)) continue;
            int n2 = this.getActualIndex(this._selectedTable, nArray[i], this._selectedListModel);
            int n3 = this.getActualIndex(this._selectedTable, nArray[i] + 1, this._selectedListModel);
            this._model.moveSelection(n2, n2, n3, false);
            int n4 = i;
            nArray[n4] = nArray[n4] + 1;
        }
        this._model.setValueIsAdjusting(false);
        this.setSelectedIndices(this._selectedTable, nArray);
        TableUtils.ensureRowSelectionVisible(this._selectedTable);
    }

    public void moveToTop() {
        int[] nArray = this.getSelectedIndices(this._selectedTable);
        this._model.setValueIsAdjusting(true);
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.getActualIndex(this._selectedTable, nArray[i], this._selectedListModel);
            int n2 = this.getActualIndex(this._selectedTable, i, this._selectedListModel);
            this._model.moveSelection(n, n, n2, true);
        }
        this._model.setValueIsAdjusting(false);
        this._selectedTable.getSelectionModel().setSelectionInterval(0, nArray.length - 1);
        TableUtils.ensureRowSelectionVisible(this._selectedTable);
    }

    public void moveToBottom() {
        int[] nArray = this.getSelectedIndices(this._selectedTable);
        int n = this._selectedTable.getRowCount();
        this._model.setValueIsAdjusting(true);
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n2 = this.getActualIndex(this._selectedTable, nArray[i], this._selectedListModel);
            this._model.moveSelection(n2, n2, n - (nArray.length - i), false);
        }
        this._model.setValueIsAdjusting(false);
        this._selectedTable.getSelectionModel().setSelectionInterval(n - nArray.length, n - 1);
        TableUtils.ensureRowSelectionVisible(this._selectedTable);
    }

    public boolean isAllowDuplicates() {
        return this._allowDuplicates;
    }

    public void setAllowDuplicates(boolean bl) {
        this._allowDuplicates = bl;
        this.updateButtonPanel();
    }

    public boolean isDoubleClickEnabled() {
        return this._doubleClickEnabled;
    }

    public void setDoubleClickEnabled(boolean bl) {
        this._doubleClickEnabled = bl;
    }

    private void updateArrowButtons() {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        this.updateAction(this.getAction(COMMAND_MOVE_LEFT), bl ? COMMAND_MOVE_LEFT : COMMAND_MOVE_RIGHT);
        this.updateAction(this.getAction(COMMAND_MOVE_RIGHT), bl ? COMMAND_MOVE_RIGHT : COMMAND_MOVE_LEFT);
        this.updateAction(this.getAction(COMMAND_MOVE_ALL_LEFT), bl ? COMMAND_MOVE_ALL_LEFT : COMMAND_MOVE_ALL_RIGHT);
        this.updateAction(this.getAction(COMMAND_MOVE_ALL_RIGHT), bl ? COMMAND_MOVE_ALL_RIGHT : COMMAND_MOVE_ALL_LEFT);
    }

    protected String getResourceString(String string) {
        return ResourceBundle.getBundle("com.jidesoft.list.dualList", this.getLocale()).getString(string);
    }

    protected void performAction(String string) {
        Action action = this.getAction(string);
        if (action != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(new Object(), 0, string));
        }
    }

    private JComponent createDummyPanel(Component component) {
        JPanel jPanel = JideSwingUtilities.createCenterPanel(component);
        jPanel.setCursor(Cursor.getDefaultCursor());
        return jPanel;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(DualTable.class.getName(), 4);
        }
        LOGGER = Logger.getLogger(DualTable.class.getName());
    }

    private class ActionHandler
    extends AbstractAction
    implements MouseListener,
    ListDataListener,
    ListSelectionListener,
    PropertyChangeListener {
        private static final long serialVersionUID = 4970089188727578646L;

        private ActionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1() - n + 1;
            int[] nArray = DualTable.this.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < n) continue;
                int n3 = i;
                nArray[n3] = nArray[n3] + n2;
            }
            DualTable.this._model.setValueIsAdjusting(true);
            try {
                DualTable.this._model.clearSelection();
                for (int n4 : nArray) {
                    DualTable.this._model.addSelectionInterval(n4, n4);
                }
            }
            finally {
                DualTable.this._model.setValueIsAdjusting(false);
            }
            this.modelChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            int n3 = n2 - n + 1;
            int[] nArray = DualTable.this.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] > n2) {
                    int n4 = i;
                    nArray[n4] = nArray[n4] - n3;
                    continue;
                }
                if (nArray[i] < n) continue;
                nArray[i] = -1;
            }
            DualTable.this._model.setValueIsAdjusting(true);
            try {
                DualTable.this._model.clearSelection();
                for (int n5 : nArray) {
                    if (n5 < 0) continue;
                    DualTable.this._model.addSelectionInterval(n5, n5);
                }
            }
            finally {
                DualTable.this._model.setValueIsAdjusting(false);
            }
            this.modelChanged();
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.modelChanged();
        }

        private void modelChanged() {
            DualTable.this.updateOriginalList();
            DualTable.this.updateOriginalRenderer();
            DualTable.this.updateSelectedList();
        }

        @Override
        public synchronized void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (DualTable.COMMAND_MOVE_LEFT.equals(string)) {
                DualTable.this.moveLeft();
            } else if (DualTable.COMMAND_MOVE_RIGHT.equals(string)) {
                DualTable.this.moveRight();
            } else if (DualTable.COMMAND_MOVE_ALL_LEFT.equals(string)) {
                DualTable.this.moveAllLeft();
            } else if (DualTable.COMMAND_MOVE_ALL_RIGHT.equals(string)) {
                DualTable.this.moveAllRight();
            } else if (DualTable.COMMAND_MOVE_UP.equals(string)) {
                DualTable.this.moveUp();
            } else if (DualTable.COMMAND_MOVE_DOWN.equals(string)) {
                DualTable.this.moveDown();
            } else if (DualTable.COMMAND_MOVE_TO_TOP.equals(string)) {
                DualTable.this.moveToTop();
            } else if (DualTable.COMMAND_MOVE_TO_BOTTOM.equals(string)) {
                DualTable.this.moveToBottom();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                Object object = listSelectionEvent.getSource();
                if (object == DualTable.this._model || object == DualTable.this._selectedTable) {
                    DualTable.this.updateSelectedList();
                    if (DualTable.this._model.getSelectionMode() != 2) {
                        DualTable.this.updateOriginalList();
                    }
                }
                DualTable.this.updateButtonPanel();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && DualTable.this.isDoubleClickEnabled()) {
                Object object = mouseEvent.getSource();
                if (object == DualTable.this._originalTable && !DualTable.this._originalTable.getSelectionModel().isSelectionEmpty()) {
                    DualTable.this.performAction(DualTable.COMMAND_MOVE_RIGHT);
                } else if (object == DualTable.this._selectedTable && !DualTable.this._selectedTable.getSelectionModel().isSelectionEmpty()) {
                    DualTable.this.performAction(DualTable.COMMAND_MOVE_LEFT);
                }
            }
            DualTable.this.updateButtonPanel();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl;
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            boolean bl2 = "selectionMode".equals(string) && object == DualTable.this._model;
            boolean bl3 = "model".equals(string) && object == DualTable.this;
            boolean bl4 = bl = "componentOrientation".equals(string) && object == DualTable.this;
            if (bl2 || bl3) {
                DualTable.this.updateOriginalList();
                DualTable.this.updateOriginalRenderer();
            }
            if (bl2) {
                this.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
            if (bl3) {
                DualTable.this.updateButtonPanel();
                DualTable.this.updateSelectedList();
                DualTable.this.layoutImpl();
            }
            if (bl) {
                DualTable.this.updateArrowButtons();
                DualTable.this.repaint();
            }
        }
    }
}

