/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TableUndoableSupport;
import com.jidesoft.grid.UndoableTableModelEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public class DefaultUndoableTableModel
extends DefaultTableModel
implements TableUndoableSupport {
    private static final long serialVersionUID = 6182105473579764076L;
    private UndoableTableModelEvent _event;
    private List<TableModelListener> _listeners;
    private UndoManager _undoManager;
    private UndoableEditSupport _undoableEditSupport;

    public DefaultUndoableTableModel() {
    }

    public DefaultUndoableTableModel(int n, int n2) {
        super(n, n2);
    }

    public DefaultUndoableTableModel(Vector vector, int n) {
        super(vector, n);
    }

    public DefaultUndoableTableModel(Object[] objectArray, int n) {
        super(objectArray, n);
    }

    public DefaultUndoableTableModel(Vector vector, Vector vector2) {
        super(vector, vector2);
    }

    public DefaultUndoableTableModel(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    @Override
    public UndoManager getUndoManager() {
        if (this._undoManager == null) {
            this._undoManager = new UndoManager();
        }
        return this._undoManager;
    }

    @Override
    public UndoableEditSupport getUndoableEditSupport() {
        if (this._undoableEditSupport == null) {
            this._undoableEditSupport = new UndoableEditSupport();
        }
        return this._undoableEditSupport;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this._event == null) {
            this.beginCompoundEdit(false);
            this.undoableUpdateCell(n, n2, object);
            this.endCompoundEdit();
        } else {
            this.undoableUpdateCell(n, n2, object);
        }
    }

    public void insertRow(int n, Vector vector) {
        if (this._event == null) {
            this.beginCompoundEdit(false);
            if (this._event != null) {
                this._event.addEdit(n, null, vector);
            }
            super.insertRow(n, vector);
            this.endCompoundEdit();
        } else {
            this._event.addEdit(n, null, vector);
            super.insertRow(n, vector);
        }
    }

    @Override
    public void removeRow(int n) {
        if (this._event == null) {
            this.beginCompoundEdit(false);
            Vector vector = this.getDataVector().get(n);
            if (this._event != null && vector instanceof Vector) {
                this._event.addEdit(n, vector, null);
            }
            super.removeRow(n);
            this.endCompoundEdit();
        } else {
            Vector vector = this.getDataVector().get(n);
            if (vector instanceof Vector) {
                this._event.addEdit(n, vector, null);
            }
            super.removeRow(n);
        }
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0 || tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE && tableModelEvent.getColumn() == -1) {
            if (this._listeners != null) {
                for (TableModelListener tableModelListener : this._listeners) {
                    this.addTableModelListener(tableModelListener);
                }
                this._listeners = null;
            }
            this._event = null;
        }
        super.fireTableChanged(tableModelEvent);
    }

    @Override
    public void beginCompoundEdit(boolean bl) {
        if (this._event == null) {
            this._listeners = Arrays.asList(this.getTableModelListeners());
            for (TableModelListener tableModelListener : this._listeners) {
                this.removeTableModelListener(tableModelListener);
            }
            this._event = new UndoableTableModelEvent(this);
            this._event.setUndoRedo(bl);
        }
    }

    @Override
    public void endCompoundEdit() {
        if (this._listeners != null) {
            for (TableModelListener tableModelListener : this._listeners) {
                this.addTableModelListener(tableModelListener);
            }
            this._listeners = null;
        }
        if (this._event != null) {
            UndoableTableModelEvent.fireTableModelEvent(this, this._event);
            this._event = null;
        }
    }

    @Override
    public void undoableInsertRow(int n, Vector<Object> vector) {
        if (vector.size() != this.getColumnCount()) {
            return;
        }
        if (this._event != null) {
            this._event.addEdit(n, null, vector);
        }
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            vector2.add(vector.get(i));
        }
        super.insertRow(n, vector2);
    }

    @Override
    public void undoableUpdateRow(int n, Vector<Object> vector) {
        if (this._event != null) {
            this._event.addEdit(n, this.getCurrentRowData(n), vector);
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            try {
                super.setValueAt(vector.get(i), n, i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void undoableRemoveRow(int n) {
        if (this._event != null) {
            this._event.addEdit(n, this.getCurrentRowData(n), null);
        }
        super.removeRow(n);
    }

    @Override
    public void undoableUpdateCell(int n, int n2, Object object) {
        if (this._event != null) {
            this._event.addEdit(n, n2, this.getValueAt(n, n2), object);
        }
        super.setValueAt(object, n, n2);
    }

    private Vector<Object> getCurrentRowData(int n) {
        int n2 = this.getColumnCount();
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < n2; ++i) {
            vector.add(this.getValueAt(n, i));
        }
        return vector;
    }
}

