/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TableSelectionEvent;
import com.jidesoft.grid.TableSelectionListener;
import com.jidesoft.grid.TableSelectionModel;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DefaultTableSelectionModel
implements ListSelectionListener,
TableSelectionModel {
    private static final int MIN = -1;
    private static final int MAX = Integer.MAX_VALUE;
    private static final long serialVersionUID = -4170746759513164679L;
    protected EventListenerList listenerList = new EventListenerList();
    protected Vector<ListSelectionModel> _listSelectionModels = new Vector();
    protected boolean _withinOneSelection = false;
    protected int _anchorRowIndex = -1;
    protected int _anchorColumnIndex = -1;
    protected int _leadRowIndex = -1;
    protected int _leadColumnIndex = -1;
    protected int _minRowIndex = Integer.MAX_VALUE;
    protected int _minColumnIndex = Integer.MAX_VALUE;
    protected int _maxRowIndex = -1;
    protected int _maxColumnIndex = -1;
    protected boolean _isValueAdjusting = false;
    private int _firstAdjustedRowIndex = Integer.MAX_VALUE;
    private int _firstAdjustedColumnIndex = Integer.MAX_VALUE;
    private int _lastAdjustedRowIndex = -1;
    private int _lastAdjustedColumnIndex = -1;
    private int _firstChangedRowIndex = Integer.MAX_VALUE;
    private int _lastChangedRowIndex = -1;
    private int _firstChangedColumnIndex = Integer.MAX_VALUE;
    private int _lastChangedColumnIndex = -1;

    @Override
    public boolean isValueAdjusting() {
        return this._isValueAdjusting;
    }

    @Override
    public void setValueAdjusting(boolean bl) {
        if (this._isValueAdjusting != bl) {
            this._isValueAdjusting = bl;
            this.fireValueChanged(this._isValueAdjusting);
        }
    }

    public void markAsDirty(int n, int n2, int n3, int n4) {
        this._firstAdjustedRowIndex = Math.min(this._firstAdjustedRowIndex, n);
        this._lastAdjustedRowIndex = Math.max(this._lastAdjustedRowIndex, n2);
        this._firstAdjustedColumnIndex = Math.min(this._firstAdjustedColumnIndex, n3);
        this._lastAdjustedColumnIndex = Math.max(this._lastAdjustedColumnIndex, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelection(int n, int n2) {
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n2);
        if (listSelectionModel != null) {
            try {
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.addSelectionInterval(n, n);
                this.updateMinMax(listSelectionModel, n2);
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
            this.markAsDirty(n, n, n2, n2);
            this.fireValueChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSelection(int n, int n2) {
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n2);
        if (listSelectionModel != null) {
            try {
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.removeSelectionInterval(n, n);
                this.updateMinMax(listSelectionModel, n2);
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
            this.markAsDirty(n, n, n2, n2);
            this.fireValueChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelection(int n, int n2) {
        this.clearSelection();
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n2);
        if (listSelectionModel != null) {
            try {
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.setSelectionInterval(n, n);
                this.updateMinMax(listSelectionModel, n2);
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
        this.markAsDirty(n, n, n2, n2);
        this.fireValueChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectionInterval(int n, int n2, int n3) {
        this.clearSelection();
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n3);
        if (listSelectionModel != null) {
            try {
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.setSelectionInterval(n, n2);
                this.updateMinMax(listSelectionModel, n3);
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
        this.markAsDirty(n, n2, n3, n3);
        this.fireValueChanged();
    }

    @Override
    public void setAnchorSelection(int n, int n2) {
        int n3 = this._anchorRowIndex;
        int n4 = this._anchorColumnIndex;
        this._anchorRowIndex = n;
        this._anchorColumnIndex = n2;
        if (n3 != -1 && n4 != -1) {
            this.markAsDirty(Math.min(n3, this._anchorRowIndex), Math.max(n3, this._anchorRowIndex), Math.min(n4, this._anchorColumnIndex), Math.max(n4, this._anchorColumnIndex));
        }
        this._leadColumnIndex = -1;
        this._leadRowIndex = -1;
        this._withinOneSelection = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLeadSelection(int n, int n2) {
        ListSelectionModel listSelectionModel;
        int n3;
        int n4;
        int n5;
        if (this._leadRowIndex == n && this._leadColumnIndex == n2) {
            return;
        }
        int n6 = this._leadColumnIndex;
        if (!this._withinOneSelection) {
            this._withinOneSelection = true;
        } else if (this._leadColumnIndex != -1) {
            n5 = Math.min(this._leadColumnIndex, n2);
            n4 = Math.max(this._leadColumnIndex, n2);
            for (n3 = n5; n3 <= n4; ++n3) {
                listSelectionModel = this.getListSelectionModelAt(n3);
                if (listSelectionModel == null) continue;
                try {
                    listSelectionModel.setValueIsAdjusting(true);
                    listSelectionModel.removeSelectionInterval(this._anchorRowIndex, this._leadRowIndex);
                    this.updateMinMax(listSelectionModel, n3);
                    continue;
                }
                finally {
                    listSelectionModel.setValueIsAdjusting(false);
                }
            }
        }
        n5 = Math.min(this._anchorColumnIndex, n2);
        n4 = Math.max(this._anchorColumnIndex, n2);
        for (n3 = n5; n3 <= n4; ++n3) {
            listSelectionModel = this.getListSelectionModelAt(n3);
            if (listSelectionModel == null) continue;
            try {
                listSelectionModel.setValueIsAdjusting(true);
                if (this._leadRowIndex != -1) {
                    listSelectionModel.removeSelectionInterval(this._anchorRowIndex, this._leadRowIndex);
                }
                listSelectionModel.addSelectionInterval(this._anchorRowIndex, n);
                this.updateMinMax(listSelectionModel, n3);
                continue;
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
        this._leadRowIndex = n;
        this._leadColumnIndex = n2;
        this.markAsDirty(Math.min(n6, Math.min(this._leadRowIndex, this._anchorRowIndex)), Math.max(n6, Math.max(this._leadRowIndex, this._anchorRowIndex)), Math.min(this._leadColumnIndex, this._anchorColumnIndex), Math.max(this._leadColumnIndex, this._anchorColumnIndex));
        this.fireValueChanged();
    }

    @Override
    public void moveLeadSelection(int n, int n2) {
        if (this._leadRowIndex == n && this._leadColumnIndex == n2) {
            return;
        }
        this._leadRowIndex = n;
        this._leadColumnIndex = n2;
        this.markAsDirty(Math.min(this._leadRowIndex, this._anchorRowIndex), Math.max(this._leadRowIndex, this._anchorRowIndex), Math.min(this._leadColumnIndex, this._anchorColumnIndex), Math.max(this._leadColumnIndex, this._anchorColumnIndex));
        this.fireValueChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSelection() {
        if (this.isSelectionEmpty()) {
            return;
        }
        int n = this.getMaxSelectedRowIndex();
        int n2 = this.getMinSelectedRowIndex();
        int n3 = this.getMaxSelectedColumnIndex();
        int n4 = this.getMinSelectedColumnIndex();
        for (int i = 0; i < this._listSelectionModels.size(); ++i) {
            ListSelectionModel listSelectionModel = this.getListSelectionModelAt(i);
            if (listSelectionModel == null || listSelectionModel.isSelectionEmpty()) continue;
            try {
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.clearSelection();
                this.updateMinMax(listSelectionModel, i);
                continue;
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
        this.resetMinMax();
        this.markAsDirty(n2, n, n4, n3);
        this.fireValueChanged();
    }

    private void resetMinMax() {
        this._minRowIndex = Integer.MAX_VALUE;
        this._maxRowIndex = -1;
        this._minColumnIndex = Integer.MAX_VALUE;
        this._maxColumnIndex = -1;
    }

    private void updateMinMax(ListSelectionModel listSelectionModel, int n) {
        if (!listSelectionModel.isSelectionEmpty()) {
            this._minRowIndex = Math.min(this._minRowIndex, listSelectionModel.getMinSelectionIndex());
            this._maxRowIndex = Math.max(this._maxRowIndex, listSelectionModel.getMaxSelectionIndex());
            this._minColumnIndex = Math.min(this._minColumnIndex, n);
            this._maxColumnIndex = Math.max(this._maxColumnIndex, n);
        } else {
            this.resetMinMax();
            for (int i = 0; i < this._listSelectionModels.size(); ++i) {
                ListSelectionModel listSelectionModel2 = this.getListSelectionModelAt(i);
                if (listSelectionModel2 == null || listSelectionModel2.isSelectionEmpty()) continue;
                this._minRowIndex = Math.min(this._minRowIndex, listSelectionModel2.getMinSelectionIndex());
                this._maxRowIndex = Math.max(this._maxRowIndex, listSelectionModel2.getMaxSelectionIndex());
                this._minColumnIndex = Math.min(this._minColumnIndex, i);
                this._maxColumnIndex = Math.max(this._maxColumnIndex, i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectAll(int n, int n2) {
        this.adjustColumnCount(n2);
        for (int i = 0; i < this._listSelectionModels.size(); ++i) {
            ListSelectionModel listSelectionModel = this._listSelectionModels.get(i);
            listSelectionModel.setValueIsAdjusting(true);
            try {
                listSelectionModel.setSelectionInterval(0, n - 1);
                this.updateMinMax(listSelectionModel, i);
                continue;
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
        this.markAsDirty(0, n - 1, 0, n2 - 1);
        this.fireValueChanged();
    }

    private void adjustColumnCount(int n) {
        if (n != this._listSelectionModels.size()) {
            int n2;
            for (n2 = this._listSelectionModels.size(); n2 > n; --n2) {
                this.removeColumn();
            }
            while (n > n2) {
                this.addColumn();
                ++n2;
            }
        }
    }

    @Override
    public boolean isSelected(int n, int n2) {
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n2);
        return listSelectionModel != null && listSelectionModel.isSelectedIndex(n);
    }

    public ListSelectionModel getListSelectionModelAt(int n) {
        if (n >= 0 && n < this._listSelectionModels.size()) {
            return this._listSelectionModels.elementAt(n);
        }
        return null;
    }

    @Override
    public void setColumns(int n) {
        this._listSelectionModels = new Vector();
        for (int i = 0; i < n; ++i) {
            this.addColumn();
        }
    }

    protected void addColumn() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this._listSelectionModels.add(defaultListSelectionModel);
        defaultListSelectionModel.addListSelectionListener(this);
    }

    protected void insertColumn(int n) {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this._listSelectionModels.add(n, defaultListSelectionModel);
        defaultListSelectionModel.addListSelectionListener(this);
    }

    protected void removeColumn() {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)this._listSelectionModels.lastElement();
        defaultListSelectionModel.removeListSelectionListener(this);
        this._listSelectionModels.remove(defaultListSelectionModel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            TableModel tableModel = (TableModel)propertyChangeEvent.getNewValue();
            this.setColumns(tableModel.getColumnCount());
            TableModel tableModel2 = (TableModel)propertyChangeEvent.getOldValue();
            if (tableModel2 != null) {
                tableModel2.removeTableModelListener(this);
            }
            tableModel.removeTableModelListener(this);
            tableModel.addTableModelListener(this);
        } else if ("columnModel".equals(propertyChangeEvent.getPropertyName())) {
            TableColumnModel tableColumnModel = (TableColumnModel)propertyChangeEvent.getNewValue();
            TableColumnModel tableColumnModel2 = (TableColumnModel)propertyChangeEvent.getOldValue();
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            tableColumnModel.removeColumnModelListener(this);
            tableColumnModel.addColumnModelListener(this);
        }
    }

    @Override
    public void addTableSelectionListener(TableSelectionListener tableSelectionListener) {
        this.listenerList.add(TableSelectionListener.class, tableSelectionListener);
    }

    @Override
    public void removeTableSelectionListener(TableSelectionListener tableSelectionListener) {
        this.listenerList.remove(TableSelectionListener.class, tableSelectionListener);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        TableModel tableModel = (TableModel)tableModelEvent.getSource();
        this.adjustColumnCount(tableModel.getColumnCount());
        if (this._leadRowIndex >= tableModel.getRowCount()) {
            this._leadRowIndex = tableModel.getRowCount() - 1;
        }
        if (this._leadColumnIndex >= tableModel.getColumnCount()) {
            this._leadColumnIndex = tableModel.getColumnCount() - 1;
        }
        if (this._anchorRowIndex >= tableModel.getRowCount()) {
            this._anchorRowIndex = tableModel.getRowCount() - 1;
        }
        if (this._anchorColumnIndex >= tableModel.getColumnCount()) {
            this._anchorColumnIndex = tableModel.getColumnCount() - 1;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected void fireValueChanged(boolean bl) {
        if (this._lastChangedRowIndex == -1 && this._lastChangedColumnIndex == -1) {
            return;
        }
        int n = this._firstChangedRowIndex;
        int n2 = this._lastChangedRowIndex;
        int n3 = this._firstChangedColumnIndex;
        int n4 = this._lastChangedColumnIndex;
        this._firstChangedRowIndex = Integer.MAX_VALUE;
        this._lastChangedRowIndex = -1;
        this._firstChangedColumnIndex = Integer.MAX_VALUE;
        this._lastChangedColumnIndex = -1;
        this.fireValueChanged(this, n, n2, n3, n4, bl);
    }

    protected void fireValueChanged(Object object, int n, int n2, int n3, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        TableSelectionEvent tableSelectionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableSelectionListener.class) continue;
            if (tableSelectionEvent == null) {
                tableSelectionEvent = new TableSelectionEvent(object, n, n2, n3, n3, bl);
            }
            ((TableSelectionListener)objectArray[i + 1]).valueChanged(tableSelectionEvent);
        }
    }

    protected void fireValueChanged() {
        if (this._lastAdjustedRowIndex == -1 && this._lastAdjustedColumnIndex == -1) {
            return;
        }
        this._firstChangedRowIndex = Math.min(this._firstChangedRowIndex, this._firstAdjustedRowIndex);
        this._lastChangedRowIndex = Math.max(this._lastChangedRowIndex, this._lastAdjustedRowIndex);
        this._firstChangedColumnIndex = Math.min(this._firstChangedColumnIndex, this._firstAdjustedColumnIndex);
        this._lastChangedColumnIndex = Math.max(this._lastChangedColumnIndex, this._lastAdjustedColumnIndex);
        int n = this._firstAdjustedRowIndex;
        int n2 = this._lastAdjustedRowIndex;
        int n3 = this._firstAdjustedColumnIndex;
        int n4 = this._lastAdjustedColumnIndex;
        this._firstAdjustedRowIndex = Integer.MAX_VALUE;
        this._lastAdjustedRowIndex = -1;
        this._firstAdjustedColumnIndex = Integer.MAX_VALUE;
        this._lastAdjustedColumnIndex = -1;
        this.fireValueChanged(this, n, n2, n3, n4, this.isValueAdjusting());
    }

    protected void fireValueChanged(Object object, int n, int n2, int n3, int n4, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        TableSelectionEvent tableSelectionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableSelectionListener.class) continue;
            if (tableSelectionEvent == null) {
                tableSelectionEvent = new TableSelectionEvent(object, n, n2, n3, n4, bl);
            }
            ((TableSelectionListener)objectArray[i + 1]).valueChanged(tableSelectionEvent);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n");
        for (int i = 0; i < this._listSelectionModels.size(); ++i) {
            stringBuffer.append("'").append(i).append("'={");
            ListSelectionModel listSelectionModel = this.getListSelectionModelAt(i);
            if (listSelectionModel == null) continue;
            int n = listSelectionModel.getMinSelectionIndex();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            for (int j = n; j < n2; ++j) {
                if (!listSelectionModel.isSelectedIndex(j)) continue;
                stringBuffer.append(j).append(", ");
            }
            if (listSelectionModel.isSelectedIndex(n2)) {
                stringBuffer.append(n2);
            }
            stringBuffer.append("}\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public int getAnchorRowIndex() {
        return this._anchorRowIndex;
    }

    @Override
    public int getAnchorColumnIndex() {
        return this._anchorColumnIndex;
    }

    @Override
    public int getLeadRowIndex() {
        return this._leadRowIndex;
    }

    @Override
    public int getLeadColumnIndex() {
        return this._leadColumnIndex;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this._minRowIndex > this._maxRowIndex || this._minColumnIndex > this._maxColumnIndex;
    }

    @Override
    public int[] getSelectedColumns() {
        if (!this.isSelectionEmpty()) {
            int n = this.getMinSelectedColumnIndex();
            int n2 = this.getMaxSelectedColumnIndex();
            if (n == -1 || n2 == -1) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n2 - n)];
            int n3 = 0;
            for (int i = n; i <= n2; ++i) {
                if (!this.isColumnSelected(i)) continue;
                nArray[n3++] = i;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }
        return new int[0];
    }

    @Override
    public int getSelectedColumnCount() {
        int n = this.getMinSelectedColumnIndex();
        int n2 = this.getMaxSelectedColumnIndex();
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!this.isColumnSelected(i)) continue;
            ++n3;
        }
        return n3;
    }

    @Override
    public int[] getSelectedRows() {
        if (!this.isSelectionEmpty()) {
            int n = this.getMinSelectedRowIndex();
            int n2 = this.getMaxSelectedRowIndex();
            if (n == -1 || n2 == -1) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n2 - n)];
            int n3 = 0;
            for (int i = n; i <= n2; ++i) {
                if (!this.isRowSelected(i)) continue;
                nArray[n3++] = i;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }
        return new int[0];
    }

    @Override
    public int getSelectedRowCount() {
        int n = this.getMinSelectedRowIndex();
        int n2 = this.getMaxSelectedRowIndex();
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!this.isRowSelected(i)) continue;
            ++n3;
        }
        return n3;
    }

    @Override
    public boolean isRowSelected(int n) {
        if (this.isSelectionEmpty()) {
            return false;
        }
        for (int i = this._minColumnIndex; i <= this._maxColumnIndex; ++i) {
            ListSelectionModel listSelectionModel = this.getListSelectionModelAt(i);
            if (listSelectionModel == null || !listSelectionModel.isSelectedIndex(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isColumnSelected(int n) {
        if (this.isSelectionEmpty()) {
            return false;
        }
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n);
        return listSelectionModel != null && !listSelectionModel.isSelectionEmpty();
    }

    @Override
    public int getMinSelectedRowIndex() {
        return this.isSelectionEmpty() ? -1 : this._minRowIndex;
    }

    @Override
    public int getMaxSelectedRowIndex() {
        return this.isSelectionEmpty() ? -1 : this._maxRowIndex;
    }

    @Override
    public int getMinSelectedColumnIndex() {
        return this.isSelectionEmpty() ? -1 : this._minColumnIndex;
    }

    @Override
    public int getMaxSelectedColumnIndex() {
        return this.isSelectionEmpty() ? -1 : this._maxColumnIndex;
    }

    @Override
    public void columnAdded(int n) {
        this._listSelectionModels.add(n, new DefaultListSelectionModel());
    }

    @Override
    public void columnRemoved(int n) {
        if (n >= 0 && n < this._listSelectionModels.size()) {
            this._listSelectionModels.remove(n);
        }
    }

    @Override
    public void columnMoved(int n, int n2) {
        if (n != n2) {
            ListSelectionModel listSelectionModel = this._listSelectionModels.remove(n);
            this._listSelectionModels.add(n2, listSelectionModel);
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.columnAdded(tableColumnModelEvent.getToIndex());
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.columnRemoved(tableColumnModelEvent.getFromIndex());
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.columnMoved(tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }
}

