/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.SummaryCalculator;
import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.BooleanRange;
import com.jidesoft.range.IntegerRange;
import com.jidesoft.range.LongRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.StringRange;
import com.jidesoft.range.TimeRange;
import com.jidesoft.utils.BigDecimalMathUtils;
import com.jidesoft.utils.BooleanUtils;
import com.jidesoft.utils.DateUtils;
import com.jidesoft.utils.MathUtils;
import com.jidesoft.utils.StringUtils;
import com.jidesoft.utils.TypeUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class DefaultSummaryCalculator
implements SummaryCalculator,
Cloneable {
    private List<Number> _doubles = new Vector<Number>();
    private List<Date> _dates = new Vector<Date>();
    private List<Calendar> _calendars = new Vector<Calendar>();
    private List<BigDecimal> _bigDecimals = new Vector<BigDecimal>();
    private List<String> _strings = new Vector<String>();
    private List<Boolean> _booleans = new Vector<Boolean>();
    private MathContext _mathContext;
    private Class<?> _dataType;
    protected long _count = 0L;
    private boolean _biasCorrected = true;

    public Object clone() throws CloneNotSupportedException {
        DefaultSummaryCalculator defaultSummaryCalculator = (DefaultSummaryCalculator)super.clone();
        defaultSummaryCalculator._doubles = new Vector<Number>();
        defaultSummaryCalculator._dates = new Vector<Date>();
        defaultSummaryCalculator._calendars = new Vector<Calendar>();
        defaultSummaryCalculator._bigDecimals = new Vector<BigDecimal>();
        defaultSummaryCalculator._strings = new Vector<String>();
        defaultSummaryCalculator._booleans = new Vector<Boolean>();
        defaultSummaryCalculator._mathContext = new MathContext(8);
        return defaultSummaryCalculator;
    }

    @Override
    public void addValue(Object object) {
        if (object instanceof BigDecimal) {
            if (this._mathContext == null) {
                this._mathContext = new MathContext(8);
            }
            this._bigDecimals.add((BigDecimal)object);
            ++this._count;
        } else if (object instanceof Number) {
            this._doubles.add(((Number)object).doubleValue());
            this._dataType = object.getClass();
            ++this._count;
        } else if (object instanceof Date) {
            this._dates.add((Date)object);
            ++this._count;
        } else if (object instanceof Calendar) {
            this._calendars.add((Calendar)object);
            ++this._count;
        } else if (object instanceof String) {
            this._strings.add((String)object);
            ++this._count;
        } else if (object instanceof Boolean) {
            this._booleans.add((Boolean)object);
            ++this._count;
        } else if (object instanceof AbstractNumericRange) {
            this._doubles.add(((AbstractNumericRange)object).minimum());
            this._doubles.add(((AbstractNumericRange)object).maximum());
            if (object instanceof IntegerRange) {
                this._dataType = Integer.class;
            }
            if (object instanceof LongRange) {
                this._dataType = Long.class;
            } else if (object instanceof NumericRange) {
                this._dataType = Double.class;
            }
            ++this._count;
        } else if (object instanceof TimeRange) {
            this._dates.add(((TimeRange)object).lower());
            this._dates.add(((TimeRange)object).upper());
            this._dataType = Date.class;
            ++this._count;
        } else if (object instanceof StringRange) {
            this._strings.add(((StringRange)object).lower());
            this._strings.add(((StringRange)object).upper());
            this._dataType = String.class;
            ++this._count;
        } else if (object instanceof BooleanRange) {
            this._booleans.add(((BooleanRange)object).lower());
            this._booleans.add(((BooleanRange)object).upper());
            this._dataType = Boolean.class;
            ++this._count;
        }
    }

    @Override
    public void clear() {
        if (this._doubles != null) {
            this._doubles.clear();
        }
        if (this._dates != null) {
            this._dates.clear();
        }
        if (this._calendars != null) {
            this._calendars.clear();
        }
        if (this._bigDecimals != null) {
            this._bigDecimals.clear();
        }
        if (this._strings != null) {
            this._strings.clear();
        }
        if (this._booleans != null) {
            this._booleans.clear();
        }
        this._count = 0L;
    }

    @Override
    public long getCount() {
        return this._count;
    }

    @Override
    public int getNumberOfSummaries() {
        return 7;
    }

    @Override
    public String getSummaryName(Locale locale, int n) {
        switch (n) {
            case 0: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Sum");
            }
            case 1: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Max");
            }
            case 2: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Min");
            }
            case 3: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Mean");
            }
            case 4: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Var");
            }
            case 5: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.StdDev");
            }
            case 6: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Count");
            }
            case 7: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.Constant");
            }
            case -2: {
                return GridResource.getResourceBundle(locale).getString("SummaryType.None");
            }
        }
        return "";
    }

    @Override
    public Object getSummaryResult(int n) {
        if (n == 6) {
            return this.getCount();
        }
        if (n == -2) {
            return null;
        }
        if (this._doubles != null && this._doubles.size() > 0) {
            switch (n) {
                case 3: {
                    int n2 = this._doubles.size();
                    while ((long)n2 < this._count) {
                        this._doubles.add(0);
                        ++n2;
                    }
                    return MathUtils.mean(this._doubles);
                }
                case 2: {
                    double d = MathUtils.min(this._doubles);
                    if (this._dataType == Integer.TYPE || this._dataType == Integer.class) {
                        return (int)d;
                    }
                    if (this._dataType == Long.TYPE || this._dataType == Long.class) {
                        return (long)d;
                    }
                    if (this._dataType == Short.TYPE || this._dataType == Short.class) {
                        return (short)d;
                    }
                    if (this._dataType == Byte.TYPE || this._dataType == Byte.class) {
                        return (byte)d;
                    }
                    if (this._dataType == Float.TYPE || this._dataType == Float.class) {
                        return Float.valueOf((float)d);
                    }
                    return d;
                }
                case 1: {
                    double d = MathUtils.max(this._doubles);
                    if (this._dataType == Integer.TYPE || this._dataType == Integer.class) {
                        return (int)d;
                    }
                    if (this._dataType == Long.TYPE || this._dataType == Long.class) {
                        return (long)d;
                    }
                    if (this._dataType == Short.TYPE || this._dataType == Short.class) {
                        return (short)d;
                    }
                    if (this._dataType == Byte.TYPE || this._dataType == Byte.class) {
                        return (byte)d;
                    }
                    if (this._dataType == Float.TYPE || this._dataType == Float.class) {
                        return Float.valueOf((float)d);
                    }
                    return d;
                }
                case 0: {
                    return MathUtils.sum(this._doubles);
                }
                case 5: {
                    return MathUtils.stddev(this._doubles, this.isBiasCorrected());
                }
                case 4: {
                    return MathUtils.var(this._doubles, this.isBiasCorrected());
                }
                case 7: {
                    if (this._dataType == Integer.TYPE || this._dataType == Integer.class) {
                        return MathUtils.rangeInteger(this._doubles);
                    }
                    if (this._dataType == Long.TYPE || this._dataType == Long.class) {
                        return MathUtils.rangeLong(this._doubles);
                    }
                    return MathUtils.range(this._doubles);
                }
            }
            return MathUtils.sum(this._doubles);
        }
        if (this._dates != null && this._dates.size() > 0) {
            switch (n) {
                case 2: {
                    return DateUtils.minDates(this._dates);
                }
                case 1: {
                    return DateUtils.maxDates(this._dates);
                }
                case 7: {
                    return DateUtils.rangeDates(this._dates);
                }
            }
            return null;
        }
        if (this._calendars != null && this._calendars.size() > 0) {
            switch (n) {
                case 2: {
                    return DateUtils.minCalendars(this._calendars);
                }
                case 1: {
                    return DateUtils.maxCalendars(this._calendars);
                }
                case 7: {
                    return DateUtils.rangeCalendars(this._calendars);
                }
            }
            return null;
        }
        if (this._bigDecimals != null && this._bigDecimals.size() > 0) {
            switch (n) {
                case 3: {
                    int n3 = this._bigDecimals.size();
                    while ((long)n3 < this._count) {
                        this._bigDecimals.add(new BigDecimal(0));
                        ++n3;
                    }
                    return BigDecimalMathUtils.mean(this._bigDecimals, this.getMathContext());
                }
                case 2: {
                    return BigDecimalMathUtils.min(this._bigDecimals);
                }
                case 1: {
                    return BigDecimalMathUtils.max(this._bigDecimals);
                }
                case 0: {
                    return BigDecimalMathUtils.sum(this._bigDecimals);
                }
                case 5: {
                    return BigDecimalMathUtils.stddev(this._bigDecimals, this.isBiasCorrected(), this.getMathContext());
                }
                case 4: {
                    return BigDecimalMathUtils.var(this._bigDecimals, this.isBiasCorrected(), this.getMathContext());
                }
                case 7: {
                    return BigDecimalMathUtils.range(this._bigDecimals);
                }
            }
            return BigDecimalMathUtils.sum(this._bigDecimals);
        }
        if (this._strings != null && this._strings.size() > 0) {
            switch (n) {
                case 2: {
                    return StringUtils.min(this._strings);
                }
                case 1: {
                    return StringUtils.max(this._strings);
                }
                case 7: {
                    return StringUtils.range(this._strings);
                }
            }
            return null;
        }
        if (this._booleans != null && this._booleans.size() > 0) {
            switch (n) {
                case 2: {
                    return BooleanUtils.min(this._booleans);
                }
                case 1: {
                    return BooleanUtils.max(this._booleans);
                }
                case 7: {
                    return BooleanUtils.range(this._booleans);
                }
            }
            return null;
        }
        return null;
    }

    public boolean isBiasCorrected() {
        return this._biasCorrected;
    }

    public void setBiasCorrected(boolean bl) {
        this._biasCorrected = bl;
    }

    public MathContext getMathContext() {
        return this._mathContext;
    }

    public void setMathContext(MathContext mathContext) {
        this._mathContext = mathContext;
    }

    @Override
    public int[] getAllowedSummaries(Class<?> clazz) {
        return this.getAllowedSummaries(clazz, null);
    }

    @Override
    public int[] getAllowedSummaries(Class<?> clazz, ConverterContext converterContext) {
        if (clazz == null) {
            return new int[0];
        }
        if (TypeUtils.isNumericType(clazz)) {
            return ALLOWED_SUMMARIES_ALL;
        }
        if (TypeUtils.isStringType(clazz)) {
            return ALLOWED_SUMMARIES_MAX_MIN_COUNT;
        }
        if (TypeUtils.isBooleanType(clazz)) {
            return ALLOWED_SUMMARIES_MAX_MIN_COUNT;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return ALLOWED_SUMMARIES_MAX_MIN_COUNT;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return ALLOWED_SUMMARIES_MAX_MIN_COUNT;
        }
        return ALLOWED_SUMMARIES_COUNT;
    }
}

