/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.swing.CheckBoxListSelectionModel;

public class CustomValueFilterListSelectionModel
extends CheckBoxListSelectionModel {
    private static final long serialVersionUID = -8120496496796513826L;
    private int _indexAfterCustomFilter;
    private int _indexFirstValueItem;

    public CustomValueFilterListSelectionModel(int n, int n2) {
        this._indexAfterCustomFilter = n;
        this._indexFirstValueItem = n2;
        this.setAllEntryConsidered(false);
    }

    @Override
    public boolean isSelectedIndex(int n) {
        if ((this._indexAfterCustomFilter != 1 || this._indexAfterCustomFilter != this._indexFirstValueItem) && n >= this._indexAfterCustomFilter && n < this._indexFirstValueItem) {
            return super.isSelectedIndex(n);
        }
        return super.isSelectedIndex(0) || super.isSelectedIndex(n);
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        if ((this._indexAfterCustomFilter != 1 || this._indexAfterCustomFilter != this._indexFirstValueItem) && n >= this._indexAfterCustomFilter && n < this._indexFirstValueItem && n2 >= this._indexAfterCustomFilter && n2 < this._indexFirstValueItem) {
            super.clearSelection();
            super.setSelectionInterval(n, n2);
            return;
        }
        if (!this.selectAll(n, n2)) {
            super.setSelectionInterval(n, n2);
            this.selectAllIf();
        }
    }

    private void selectAllIf() {
        for (int i = this._indexFirstValueItem; i < this.getModel().getSize(); ++i) {
            if (this.isSelectedIndex(i)) continue;
            return;
        }
        super.addSelectionInterval(0, 0);
    }

    @Override
    public int getMinSelectionIndex() {
        if (super.isSelectedIndex(0)) {
            return 0;
        }
        int n = super.getMinSelectionIndex();
        return n == 0 ? 1 : n;
    }

    @Override
    public int getMaxSelectionIndex() {
        if (super.isSelectedIndex(0)) {
            return 0;
        }
        return super.getMaxSelectionIndex();
    }

    private boolean selectAll(int n, int n2) {
        if (n == 0 && n2 != this.getModel().getSize() - 1 || n2 == 0 && n != this.getModel().getSize() - 1) {
            super.setSelectionInterval(this._indexFirstValueItem, this.getModel().getSize() - 1);
            super.addSelectionInterval(0, 0);
            return true;
        }
        return false;
    }

    private boolean unselectAll(int n, int n2) {
        if ((this._indexAfterCustomFilter != 1 || this._indexAfterCustomFilter != this._indexFirstValueItem) && n >= this._indexAfterCustomFilter && n < this._indexFirstValueItem && n2 >= this._indexAfterCustomFilter && n2 < this._indexFirstValueItem) {
            super.removeSelectionInterval(n, n2);
            return true;
        }
        if (n == 0 || n2 == 0) {
            this.clearSelection();
            return true;
        }
        return false;
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        if ((this._indexAfterCustomFilter != 1 || this._indexAfterCustomFilter != this._indexFirstValueItem) && n >= this._indexAfterCustomFilter && n < this._indexFirstValueItem && n2 >= this._indexAfterCustomFilter && n2 < this._indexFirstValueItem && n != 0 && n2 != 0) {
            super.clearSelection();
            super.addSelectionInterval(n, n2);
            return;
        }
        if (!this.selectAll(n, n2)) {
            if (this._indexAfterCustomFilter != 1 || this._indexAfterCustomFilter != this._indexFirstValueItem) {
                this.removeSelectionInterval(Math.min(1, this._indexAfterCustomFilter - 1), this._indexFirstValueItem - 1);
            }
            super.addSelectionInterval(n, n2);
            this.selectAllIf();
        }
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        if ((this._indexAfterCustomFilter != 1 || this._indexAfterCustomFilter != this._indexFirstValueItem) && n >= this._indexAfterCustomFilter && n < this._indexFirstValueItem && n2 >= this._indexAfterCustomFilter && n2 < this._indexFirstValueItem) {
            super.removeSelectionInterval(n, n2);
            return;
        }
        if (!this.unselectAll(n, n2)) {
            super.removeSelectionInterval(0, 0);
            super.removeSelectionInterval(n, n2);
        }
    }
}

