/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CsvTableUtils;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.grid.ValueConverter;
import com.jidesoft.grid.ValueStringAdjustProvider;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.swing.StyledLabelBuilder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.swing.JLabel;
import javax.swing.JTable;

public class CsvTableScrollPaneUtils {
    public static boolean export(TableScrollPane tableScrollPane, String string) throws IOException {
        return CsvTableScrollPaneUtils.export(tableScrollPane, string, true);
    }

    public static boolean export(TableScrollPane tableScrollPane, String string, boolean bl) throws IOException {
        return CsvTableScrollPaneUtils.export(tableScrollPane, string, bl, null);
    }

    public static boolean export(TableScrollPane tableScrollPane, String string, boolean bl, ValueConverter valueConverter) throws IOException {
        return CsvTableScrollPaneUtils.export(tableScrollPane, string, bl, valueConverter, null);
    }

    public static boolean export(TableScrollPane tableScrollPane, String string, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableScrollPaneUtils.export(tableScrollPane, 0, 0, -1, -1, string, bl, valueConverter, stringConverter);
    }

    public static boolean export(TableScrollPane tableScrollPane, int n, int n2, int n3, int n4, String string, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableScrollPaneUtils.export(tableScrollPane, n, n2, n3, n4, string, bl, valueConverter, stringConverter, ',');
    }

    public static boolean export(TableScrollPane tableScrollPane, int n, int n2, int n3, int n4, String string, boolean bl, ValueConverter valueConverter, StringConverter stringConverter, char c) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        CsvTableScrollPaneUtils.exportToCsv(tableScrollPane, fileOutputStream, n, n2, n3, n4, bl, valueConverter, stringConverter, c, Charset.defaultCharset().name());
        fileOutputStream.close();
        return true;
    }

    private static void exportToCsv(TableScrollPane tableScrollPane, OutputStream outputStream, int n, int n2, int n3, int n4, boolean bl, ValueConverter valueConverter, StringConverter stringConverter, char c, String string) {
        JTable jTable;
        TableScrollPane.TablePosition tablePosition;
        int n5;
        int n6;
        int n7;
        StringBuffer stringBuffer = new StringBuffer();
        if (n4 == -1) {
            n4 = tableScrollPane.getColumnCount();
        }
        if (n3 == -1) {
            n3 = tableScrollPane.getRowCount();
        }
        if (bl) {
            n7 = CsvTableScrollPaneUtils.getMaxHeaderRowCount(tableScrollPane);
            for (n6 = 0; n6 < n7; ++n6) {
                for (n5 = 0; n5 < n4 && n2 + n5 < tableScrollPane.getColumnCount(); ++n5) {
                    Object object;
                    int n8;
                    tablePosition = tableScrollPane.getTableAtColumn(n2 + n5);
                    jTable = tablePosition.getTable();
                    if (jTable == null) continue;
                    NestedTableHeader nestedTableHeader = null;
                    if (jTable.getTableHeader() instanceof NestedTableHeader) {
                        nestedTableHeader = (NestedTableHeader)jTable.getTableHeader();
                        n8 = nestedTableHeader.getRowCount();
                    } else {
                        n8 = 1;
                    }
                    String string2 = n6 == n8 - 1 ? tableScrollPane.getColumnName(n2 + n5) : (n6 >= n8 ? "" : ((object = tableScrollPane.getTableAtColumn(n2 + n5)) != null ? "" + nestedTableHeader.getHeaderValueAt(n + n6, ((TableScrollPane.TablePosition)object).column) : ""));
                    object = StyledLabelBuilder.createStyledLabel(string2);
                    if (object != null) {
                        string2 = ((JLabel)object).getText();
                    }
                    CsvTableUtils.addCellValue(stringBuffer, stringConverter != null ? stringConverter.convert(string2) : string2, c);
                }
                CsvTableUtils.addLineBreak(stringBuffer);
            }
        }
        for (n7 = 0; n7 < n3 && n + n7 < tableScrollPane.getRowCount(); ++n7) {
            for (n6 = 0; n6 < n4; ++n6) {
                Object object;
                if (n2 + n6 >= tableScrollPane.getColumnCount() || (n5 = tableScrollPane.convertColumnIndexToModel(n2 + n6)) == -1 || (jTable = (tablePosition = tableScrollPane.getTableAtCell(n + n7, n2 + n6)).getTable()) == null) continue;
                if (jTable instanceof ValueStringAdjustProvider && ((ValueStringAdjustProvider)((Object)jTable)).needAdjustCellValueString(tablePosition.getRow(), tablePosition.getColumn())) {
                    object = ((ValueStringAdjustProvider)((Object)jTable)).getValueAtInString(tablePosition.getRow(), tablePosition.getColumn(), valueConverter);
                } else {
                    object = jTable.getModel().getValueAt(tablePosition.getRow(), n5);
                    if (valueConverter != null) {
                        object = valueConverter.convert(jTable, object, tablePosition.getRow(), tablePosition.getColumn());
                    }
                }
                CsvTableUtils.addCellValue(stringBuffer, object == null ? "" : object.toString(), c);
            }
            CsvTableUtils.addLineBreak(stringBuffer);
        }
        try {
            outputStream.write(stringBuffer.toString().getBytes(string));
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void exportToCsv(TableScrollPane tableScrollPane, OutputStream outputStream, CsvTableUtils.CsvTableExportConfig csvTableExportConfig) {
        int n = csvTableExportConfig.getFirstRow();
        int n2 = csvTableExportConfig.getFirstColumn();
        int n3 = csvTableExportConfig.getNumOfRows();
        int n4 = csvTableExportConfig.getNumOfColumns();
        boolean bl = csvTableExportConfig.isHeaderIncluded();
        ValueConverter valueConverter = csvTableExportConfig.getCellValueConverter();
        StringConverter stringConverter = csvTableExportConfig.getColumnNameConverter();
        char c = csvTableExportConfig.getSeparator();
        String string = csvTableExportConfig.getCharsetName();
        CsvTableScrollPaneUtils.exportToCsv(tableScrollPane, outputStream, n, n2, n3, n4, bl, valueConverter, stringConverter, c, string);
    }

    public static boolean export(TableScrollPane tableScrollPane, OutputStream outputStream) throws IOException {
        return CsvTableScrollPaneUtils.export(tableScrollPane, outputStream, true);
    }

    public static boolean export(TableScrollPane tableScrollPane, OutputStream outputStream, boolean bl) throws IOException {
        return CsvTableScrollPaneUtils.export(tableScrollPane, outputStream, bl, null);
    }

    public static boolean export(TableScrollPane tableScrollPane, OutputStream outputStream, boolean bl, ValueConverter valueConverter) throws IOException {
        return CsvTableScrollPaneUtils.export(tableScrollPane, outputStream, bl, valueConverter, null);
    }

    public static boolean export(TableScrollPane tableScrollPane, OutputStream outputStream, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableScrollPaneUtils.export(tableScrollPane, outputStream, 0, 0, -1, -1, bl, valueConverter, stringConverter);
    }

    public static boolean export(TableScrollPane tableScrollPane, OutputStream outputStream, int n, int n2, int n3, int n4, boolean bl, ValueConverter valueConverter, StringConverter stringConverter) throws IOException {
        return CsvTableScrollPaneUtils.export(tableScrollPane, outputStream, n, n2, n3, n4, bl, valueConverter, stringConverter, ',');
    }

    public static boolean export(TableScrollPane tableScrollPane, OutputStream outputStream, int n, int n2, int n3, int n4, boolean bl, ValueConverter valueConverter, StringConverter stringConverter, char c) throws IOException {
        CsvTableScrollPaneUtils.exportToCsv(tableScrollPane, outputStream, n, n2, n3, n4, bl, valueConverter, stringConverter, c, Charset.defaultCharset().name());
        return true;
    }

    public static boolean export(TableScrollPane tableScrollPane, OutputStream outputStream, CsvTableUtils.CsvTableExportConfig csvTableExportConfig) throws IOException {
        CsvTableScrollPaneUtils.exportToCsv(tableScrollPane, outputStream, csvTableExportConfig);
        return true;
    }

    private static int getMaxHeaderRowCount(TableScrollPane tableScrollPane) {
        int n;
        int n2 = 1;
        if (tableScrollPane.getRowHeaderTable() != null && tableScrollPane.getRowHeaderTable().getTableHeader() instanceof NestedTableHeader && (n = ((NestedTableHeader)tableScrollPane.getRowHeaderTable().getTableHeader()).getRowCount()) >= n2) {
            n2 = n;
        }
        if (tableScrollPane.getMainTable() != null && tableScrollPane.getMainTable().getTableHeader() instanceof NestedTableHeader && (n = ((NestedTableHeader)tableScrollPane.getMainTable().getTableHeader()).getRowCount()) >= n2) {
            n2 = n;
        }
        if (tableScrollPane.getRowFooterTable() != null && tableScrollPane.getRowFooterTable().getTableHeader() instanceof NestedTableHeader && (n = ((NestedTableHeader)tableScrollPane.getRowFooterTable().getTableHeader()).getRowCount()) >= n2) {
            n2 = n;
        }
        return n2;
    }
}

