/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ConverterContextSupport;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EditorContextSupport;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class ContextSensitiveCellRenderer
extends DefaultTableCellRenderer
implements ConverterContextSupport,
EditorContextSupport,
SwingConstants {
    public static EditorContext CONTEXT_SENSITIVE_CONTEXT = new EditorContext("ContextSensitiveCellRenderer");
    private ConverterContext _converterContext;
    private EditorContext _editorContext;
    private Class<?> _clazz;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

    public ContextSensitiveCellRenderer() {
    }

    public ContextSensitiveCellRenderer(Class<?> clazz) {
        this._clazz = clazz;
    }

    public ContextSensitiveCellRenderer(ConverterContext converterContext) {
        this._converterContext = converterContext;
    }

    public ContextSensitiveCellRenderer(Class<?> clazz, ConverterContext converterContext) {
        this._clazz = clazz;
        this._converterContext = converterContext;
    }

    @Override
    public Class<?> getType() {
        return this._clazz;
    }

    @Override
    public void setType(Class<?> clazz) {
        this._clazz = clazz;
    }

    void originalSetValue(Object object) {
        super.setValue(object);
    }

    @Override
    protected void setValue(Object object) {
        Class<?> clazz = this.getType();
        if (clazz != null) {
            super.setValue(ObjectConverterManager.toString(object, clazz, this.getConverterContext()));
        } else if (object != null) {
            super.setValue(ObjectConverterManager.toString(object, object.getClass(), this.getConverterContext()));
        } else {
            super.setValue("");
        }
    }

    @Override
    public void setConverterContext(ConverterContext converterContext) {
        this._converterContext = converterContext;
    }

    @Override
    public ConverterContext getConverterContext() {
        return this._converterContext;
    }

    @Override
    public EditorContext getEditorContext() {
        return this._editorContext;
    }

    @Override
    public void setEditorContext(EditorContext editorContext) {
        this._editorContext = editorContext;
    }

    public static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    public static void installColorFontAndBorder(JTable jTable, Component component, boolean bl, boolean bl2, int n, int n2) {
        if (jTable != null) {
            if (bl) {
                component.setForeground(jTable.getSelectionForeground());
                component.setBackground(jTable.getSelectionBackground());
            } else {
                component.setForeground(jTable.getForeground());
                component.setBackground(jTable.getBackground());
            }
            component.setFont(jTable.getFont());
            if (component instanceof JComponent) {
                if (bl2) {
                    Border border = null;
                    if (bl) {
                        border = UIDefaultsLookup.getBorder("Table.focusSelectedCellHighlightBorder");
                    }
                    if (border == null) {
                        border = UIDefaultsLookup.getBorder("Table.focusCellHighlightBorder");
                    }
                    ((JComponent)component).setBorder(border);
                    if (!bl && jTable.isCellEditable(n, n2)) {
                        Color color = UIDefaultsLookup.getColor("Table.focusCellForeground");
                        if (color != null) {
                            component.setForeground(color);
                        }
                        if ((color = UIDefaultsLookup.getColor("Table.focusCellBackground")) != null) {
                            component.setBackground(color);
                        }
                    }
                } else {
                    ((JComponent)component).setBorder(ContextSensitiveCellRenderer.getNoFocusBorder());
                }
            }
        }
    }
}

