/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class CompoundTableModelEvent
extends TableModelEvent {
    private static final long serialVersionUID = -5215107260235160375L;
    private List<TableModelEvent> _events;
    private TableModelEvent _originalEvent;
    private boolean _consumed;
    private boolean _debug;
    private List<StackTraceElement[]> _eventAddedStack;

    public CompoundTableModelEvent(TableModel tableModel) {
        super(tableModel);
    }

    public CompoundTableModelEvent(TableModel tableModel, int n) {
        super(tableModel, n);
    }

    public CompoundTableModelEvent(TableModel tableModel, int n, int n2) {
        super(tableModel, n, n2);
    }

    public CompoundTableModelEvent(TableModel tableModel, int n, int n2, int n3) {
        super(tableModel, n, n2, n3);
    }

    public CompoundTableModelEvent(TableModel tableModel, int n, int n2, int n3, int n4) {
        super(tableModel, n, n2, n3, n4);
    }

    public void addEvent(TableModelEvent tableModelEvent) {
        this.addEvent(-1, tableModelEvent);
    }

    public void addEvent(int n, TableModelEvent tableModelEvent) {
        if (this._events == null) {
            this._events = new ArrayList<TableModelEvent>();
        }
        if (n < 0 || n >= this._events.size()) {
            this._events.add(tableModelEvent);
        } else {
            this._events.add(n, tableModelEvent);
        }
        if (this._debug) {
            if (this._eventAddedStack == null) {
                this._eventAddedStack = new ArrayList<StackTraceElement[]>();
            }
            if (n < 0 || n >= this._eventAddedStack.size()) {
                this._eventAddedStack.add(Thread.getAllStackTraces().get(Thread.currentThread()));
            } else {
                this._eventAddedStack.add(n, Thread.getAllStackTraces().get(Thread.currentThread()));
            }
        }
    }

    public void removeEvent(int n) {
        if (this._events == null || n < 0 || n >= this._events.size()) {
            return;
        }
        this._events.remove(n);
        if (this._debug && this._eventAddedStack != null && n >= 0 && n < this._eventAddedStack.size()) {
            this._eventAddedStack.remove(n);
        }
    }

    public TableModelEvent[] getEvents() {
        if (this._events == null) {
            return new TableModelEvent[0];
        }
        return this._events.toArray(new TableModelEvent[this._events.size()]);
    }

    protected String printDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        TableModelEvent[] tableModelEventArray = this.getEvents();
        for (int i = 0; i < tableModelEventArray.length; ++i) {
            TableModelEvent tableModelEvent = tableModelEventArray[i];
            stringBuffer.append("TableModelEvent [type=").append(tableModelEvent.getType()).append(",first row=").append(tableModelEvent.getFirstRow()).append(",last row=").append(tableModelEvent.getLastRow()).append(",column=").append(tableModelEvent.getColumn());
            stringBuffer.append("] at: \r\n");
            if (this._eventAddedStack != null && i < this._eventAddedStack.size()) {
                StackTraceElement[] stackTraceElementArray = this._eventAddedStack.get(i);
                for (int j = 2; j < stackTraceElementArray.length; ++j) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[j];
                    if (stackTraceElement.toString().contains("CompoundTableModelEvent")) continue;
                    stringBuffer.append(stackTraceElement).append("\r\n");
                }
            } else {
                stringBuffer.append("Not Recorded. \r\n");
            }
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    public static void fireTableModelEvent(AbstractTableModel abstractTableModel, TableModelEvent tableModelEvent) {
        if (tableModelEvent.getSource() != abstractTableModel) {
            return;
        }
        if (tableModelEvent instanceof CompoundTableModelEvent) {
            TableModelEvent[] tableModelEventArray = ((CompoundTableModelEvent)tableModelEvent).getEvents();
            boolean bl = false;
            boolean bl2 = false;
            if (tableModelEventArray != null) {
                int n;
                Object object;
                if (tableModelEventArray.length <= 0) {
                    return;
                }
                if (tableModelEventArray.length == 1) {
                    TableModelEvent tableModelEvent2 = tableModelEventArray[0];
                    CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(abstractTableModel, tableModelEvent2.getFirstRow(), tableModelEvent2.getLastRow(), tableModelEvent2.getColumn(), tableModelEvent2.getType());
                    compoundTableModelEvent.setOriginalEvent(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent());
                    abstractTableModel.fireTableChanged(compoundTableModelEvent);
                    return;
                }
                int n2 = Integer.MIN_VALUE;
                for (TableModelEvent tableModelEvent3 : tableModelEventArray) {
                    if (tableModelEvent3 == null || tableModelEvent3.getFirstRow() == -1 && tableModelEvent3.getColumn() == -1 && tableModelEvent3.getType() == 0) {
                        bl = true;
                        break;
                    }
                    if (tableModelEvent3.getType() == 0 && tableModelEvent3.getFirstRow() == 0 && tableModelEvent3.getLastRow() == Integer.MAX_VALUE && tableModelEvent3.getColumn() == -1) {
                        bl2 = true;
                    }
                    if (tableModelEvent3.getType() == 1 || tableModelEvent3.getType() == -1) {
                        if (n2 == Integer.MIN_VALUE) {
                            n2 = tableModelEvent3.getType();
                            continue;
                        }
                        if (n2 == tableModelEvent3.getType()) continue;
                        n2 = Integer.MAX_VALUE;
                        continue;
                    }
                    n2 = Integer.MAX_VALUE;
                }
                if (!bl && !bl2 && tableModelEventArray.length >= 100) {
                    bl2 = true;
                }
                if (bl) {
                    object = new CompoundTableModelEvent(abstractTableModel, -1, -1, -1, 0);
                    ((CompoundTableModelEvent)object).setOriginalEvent(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent());
                    abstractTableModel.fireTableChanged((TableModelEvent)object);
                    return;
                }
                if (bl2) {
                    object = new CompoundTableModelEvent(abstractTableModel, 0, Integer.MAX_VALUE, -1, 0);
                    ((CompoundTableModelEvent)object).setOriginalEvent(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent());
                    abstractTableModel.fireTableChanged((TableModelEvent)object);
                    return;
                }
                if (n2 == 1) {
                    int n3 = -1;
                    n = -1;
                    for (TableModelEvent tableModelEvent4 : tableModelEventArray) {
                        if (tableModelEvent4.getType() != n2 || tableModelEvent4.getColumn() != -1 || tableModelEvent4.getFirstRow() < 0 || tableModelEvent4.getLastRow() < 0) {
                            n3 = -1;
                            break;
                        }
                        if (n3 == -1 && n == -1) {
                            n3 = tableModelEvent4.getFirstRow();
                            n = tableModelEvent4.getLastRow();
                            continue;
                        }
                        if (tableModelEvent4.getFirstRow() >= n3 && tableModelEvent4.getFirstRow() <= n + 1) {
                            n += tableModelEvent4.getLastRow() - tableModelEvent4.getFirstRow() + 1;
                            continue;
                        }
                        n3 = -1;
                        break;
                    }
                    if (n3 >= 0 && n >= n3) {
                        CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(abstractTableModel, n3, n, -1, 1);
                        compoundTableModelEvent.setOriginalEvent(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent());
                        abstractTableModel.fireTableChanged(compoundTableModelEvent);
                        return;
                    }
                } else if (n2 == -1) {
                    int n4 = -1;
                    n = -1;
                    for (int i = tableModelEventArray.length - 1; i >= 0; --i) {
                        TableModelEvent tableModelEvent3;
                        tableModelEvent3 = tableModelEventArray[i];
                        if (tableModelEvent3.getType() != n2 || tableModelEvent3.getColumn() != -1 || tableModelEvent3.getFirstRow() < 0 || tableModelEvent3.getLastRow() < 0) {
                            n4 = -1;
                            break;
                        }
                        if (n4 == -1 && n == -1) {
                            n4 = tableModelEvent3.getFirstRow();
                            n = tableModelEvent3.getLastRow();
                            continue;
                        }
                        if (tableModelEvent3.getFirstRow() >= n4 && tableModelEvent3.getFirstRow() <= n + 1) {
                            n += tableModelEvent3.getLastRow() - tableModelEvent3.getFirstRow() + 1;
                            continue;
                        }
                        n4 = -1;
                        break;
                    }
                    if (n4 >= 0 && n >= n4) {
                        CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(abstractTableModel, n4, n, -1, -1);
                        compoundTableModelEvent.setOriginalEvent(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent());
                        abstractTableModel.fireTableChanged(compoundTableModelEvent);
                        return;
                    }
                }
            }
            if (((CompoundTableModelEvent)tableModelEvent).isDebug()) {
                System.err.println(((CompoundTableModelEvent)tableModelEvent).printDebugInfo());
            }
        }
        abstractTableModel.fireTableChanged(tableModelEvent);
    }

    public boolean isOriginalChanged() {
        return this._originalEvent != null;
    }

    public TableModelEvent getOriginalEvent() {
        return this._originalEvent;
    }

    public void setOriginalEvent(TableModelEvent tableModelEvent) {
        this._originalEvent = tableModelEvent;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    void consume() {
        this._consumed = true;
    }

    boolean isConsumed() {
        return this._consumed;
    }
}

