/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;

public class ColorCellRenderer
extends ContextSensitiveCellRenderer {
    private boolean _colorValueVisible = true;
    private boolean _colorIconVisible = true;
    private boolean _crossBackGroundStyle = false;
    public static final String PROPERTY_COLOR_VALUE_VISIBLE = "colorValueVisible";
    public static final String PROPERTY_COLOR_ICON_VISIBLE = "colorIconVisible";

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component instanceof JLabel) {
            ColorIcon colorIcon = new ColorIcon();
            if (object instanceof Color) {
                colorIcon.setColor((Color)object);
            }
            if (this.isColorIconVisible()) {
                ((JLabel)component).setIcon(colorIcon);
            } else {
                ((JLabel)component).setIcon(null);
            }
            ((JLabel)component).setIconTextGap(8);
            if (!this.isColorValueVisible()) {
                ((JLabel)component).setText("");
            }
        }
        this.putClientProperty("AbstractComboBox.isTableCellRenderer", this);
        return this;
    }

    public boolean isColorValueVisible() {
        return this._colorValueVisible;
    }

    public void setColorValueVisible(boolean bl) {
        boolean bl2 = this._colorValueVisible;
        if (bl2 != bl) {
            this._colorValueVisible = bl;
            this.firePropertyChange(PROPERTY_COLOR_VALUE_VISIBLE, bl2, bl);
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isColorIconVisible() {
        return this._colorIconVisible;
    }

    public void setColorIconVisible(boolean bl) {
        boolean bl2 = this._colorIconVisible;
        if (bl2 != bl) {
            this._colorIconVisible = bl;
            this.firePropertyChange(PROPERTY_COLOR_ICON_VISIBLE, bl2, bl);
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isCrossBackGroundStyle() {
        return this._crossBackGroundStyle;
    }

    public void setCrossBackGroundStyle(boolean bl) {
        if (this._crossBackGroundStyle != bl) {
            this._crossBackGroundStyle = bl;
            this.repaint();
        }
    }

    public class ColorIcon
    implements Icon {
        private int _margin = 1;
        private static final double RATIO = 1.618;
        private Color _color;

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color color) {
            this._color = color;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = component.getHeight();
            this._margin = 2;
            if (!ColorCellRenderer.this.isColorIconVisible()) {
                return;
            }
            int n4 = ColorCellRenderer.this.isColorValueVisible() ? (int)((double)n3 * 1.618) : component.getWidth();
            Rectangle rectangle = new Rectangle(this._margin, this._margin, n4 - 2 * this._margin, n3 - 2 * this._margin - (component.getHeight() - n3 + 1) % 2);
            if (ColorCellRenderer.this.isCrossBackGroundStyle()) {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y);
            } else {
                graphics.setColor(new Color(204, 204, 204));
                int n5 = rectangle.x + rectangle.width;
                int n6 = rectangle.y + rectangle.height;
                int n7 = 4;
                int n8 = 4;
                boolean bl = false;
                for (int i = rectangle.y + 1; i <= n6; i += n8) {
                    int n9 = bl ? rectangle.x + 1 : rectangle.x + 1 + n7;
                    boolean bl2 = bl = !bl;
                    while (n9 <= n5) {
                        graphics.fillRect(n9, i, Math.min(n7, n5 - n9 + 1), Math.min(n8, n6 - i + 1));
                        n9 += 2 * n7;
                    }
                }
            }
            if (this.getColor() != null) {
                graphics.setColor(this.getColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            graphics.setColor(Color.gray);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        @Override
        public int getIconWidth() {
            return (int)((double)this.getIconHeight() * 1.618);
        }

        @Override
        public int getIconHeight() {
            return ColorCellRenderer.this.getHeight() - 4;
        }
    }
}

