/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AutoFilterUtils;
import com.jidesoft.grid.CellPainter;
import com.jidesoft.grid.CellRendererPaneEx;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.CellStyleCustomizer;
import com.jidesoft.grid.CellStyleProvider;
import com.jidesoft.grid.NavigableTable;
import com.jidesoft.grid.RendererWrapper;
import com.jidesoft.grid.RowStripeCellStyleProvider;
import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableStyleProvider;
import com.jidesoft.swing.AlignmentSupport;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SortedList;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CellStyleTable
extends NavigableTable {
    private CellStyleProvider _cellStyleProvider;
    private TableStyleProvider _tableStyleProvider;
    private List<CellStyleCustomizer> _cellStyleCustomizers;
    private Color _saveBackground = null;
    private Color _saveForeground = null;
    private Color _saveSelectedBackground = null;
    private Color _saveSelectedForeground = null;
    private Font _saveFont = null;
    private Border _saveBorder = null;
    private Icon _saveIcon = null;
    private int _saveHorizontalAlignment = -1;
    private int _saveVerticalAlignment = -1;
    private int _saveHorizontalTextPosition = -1;
    private int _saveVerticalTextPosition = -1;
    private String _saveText = null;
    private String _saveToolTipText = null;
    private boolean _fillsViewportWithStripe = true;
    private boolean _fillsSelection = true;
    private Map<String, Font> _fontCache = new WeakHashMap<String, Font>();
    private CellStyle _focusCellStyle;
    public static final String PROPERTY_FILLS_VIEWPORT_WITH_STRIPE = "fillsViewportWithStripe";
    public static final String PROPERTY_FILLS_SELECTION = "fillsSelection";
    protected final List<CellStyle> _cellStyleList = new SortedList<CellStyle>(new ArrayList(), new Comparator<CellStyle>(){

        @Override
        public int compare(CellStyle cellStyle, CellStyle cellStyle2) {
            int n;
            if (cellStyle == null) {
                return 1;
            }
            if (cellStyle2 == null) {
                return -1;
            }
            int n2 = cellStyle.getPriority();
            if (n2 < (n = cellStyle2.getPriority())) {
                return 1;
            }
            if (n2 > n) {
                return -1;
            }
            return 0;
        }
    });
    private transient boolean _componentSetOpaque = false;
    private transient CellStyle _cellStyle;

    public CellStyleTable() {
    }

    public CellStyleTable(int n, int n2) {
        super(n, n2);
    }

    public CellStyleTable(TableModel tableModel) {
        super(tableModel);
    }

    public CellStyleTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    public CellStyleTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
    }

    public CellStyleTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
    }

    public CellStyleTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    public TableModel getStyleModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof StyleModel) {
            return tableModel;
        }
        return TableModelWrapperUtils.getActualTableModel(tableModel, StyleModel.class);
    }

    public TableModel getNextStyleModel(TableModel tableModel) {
        if (tableModel instanceof TableModelWrapper) {
            return TableModelWrapperUtils.getActualTableModel(((TableModelWrapper)((Object)tableModel)).getActualModel(), StyleModel.class);
        }
        return null;
    }

    @Override
    public void paintCellUnderlay(Graphics graphics, Component component, int n, int n2, Rectangle rectangle) {
        CellPainter cellPainter;
        super.paintCellUnderlay(graphics, component, n, n2, rectangle);
        if (this._cellStyle != null && (cellPainter = this._cellStyle.getUnderlayCellPainter()) != null) {
            Color color;
            Color color2 = color = this.isCellSelected(n, n2) ? this._cellStyle.getSelectionBackground() : this._cellStyle.getBackground();
            if (color == null) {
                color = this.isCellSelected(n, n2) ? this.getSelectionBackground() : this.getBackground();
            }
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            cellPainter.paint(graphics, this, n, n2, rectangle, this.getValueAt(n, n2));
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
                this._componentSetOpaque = true;
            } else if (component instanceof CellRendererPaneEx) {
                ((CellRendererPaneEx)component).setPaintBackground(false);
                Component component2 = ((CellRendererPaneEx)component).getActualRenderer();
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).setOpaque(false);
                }
                this._componentSetOpaque = true;
            }
        }
    }

    @Override
    public void releaseRendererComponent(TableCellRenderer tableCellRenderer, int n, int n2, Component component) {
        super.releaseRendererComponent(tableCellRenderer, n, n2, component);
        if (this._componentSetOpaque) {
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(true);
                this._componentSetOpaque = false;
            } else if (component instanceof CellRendererPaneEx) {
                ((CellRendererPaneEx)component).setPaintBackground(true);
                Component component2 = ((CellRendererPaneEx)component).getActualRenderer();
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).setOpaque(true);
                }
                this._componentSetOpaque = false;
            }
        }
        if ("true".equals(this.getClientProperty("workaroundForDefaultTableCellRendererSetBackgroundBug")) && SystemInfo.isJdk6Above() && component.getBackground() instanceof UIResource) {
            component.setBackground(this.getBackground());
        }
        this._cellStyle = null;
    }

    @Override
    public void paintCellOverlay(Graphics graphics, Component component, int n, int n2, Rectangle rectangle) {
        super.paintCellOverlay(graphics, component, n, n2, rectangle);
        if (this._cellStyle != null) {
            CellPainter cellPainter;
            Border border = this._cellStyle.getOverlayBorder();
            if (border != null) {
                border.paintBorder(this, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if ((cellPainter = this._cellStyle.getOverlayCellPainter()) != null) {
                cellPainter.paint(graphics, this, n, n2, rectangle, this.getValueAt(n, n2));
            }
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        return this.configureRendererComponent(n, n2, component);
    }

    @Override
    Component prepareRendererForRowHeightCalculation(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRendererForRowHeightCalculation(tableCellRenderer, n, n2);
        CellStyle cellStyle = this.getCellStyleAt(n, n2);
        if (cellStyle != null) {
            this.internalCustomizeRendererComponent(n, n2, component, cellStyle, true);
        }
        return component;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component != null) {
            return this.configureEditorComponent(n, n2, component);
        }
        return component;
    }

    @Override
    void internalReleaseRendererComponent(TableCellRenderer tableCellRenderer, int n, int n2, Component component, boolean bl) {
        boolean bl2;
        Component component2 = component;
        boolean bl3 = false;
        if (component2 instanceof RendererWrapper) {
            if ((component2 = ((RendererWrapper)((Object)component2)).getActualRenderer()) != null) {
                bl3 = true;
            } else {
                component2 = component;
            }
        }
        boolean bl4 = bl2 = bl || this.isCellSelected(n, n2);
        if (bl2) {
            if (this._saveSelectedBackground != null) {
                component2.setBackground(null);
                if (bl3) {
                    component.setBackground(null);
                }
                this._saveSelectedBackground = null;
            }
            if (this._saveSelectedForeground != null) {
                component2.setForeground(null);
                if (bl3) {
                    component.setForeground(null);
                }
                this._saveSelectedForeground = null;
            }
        } else {
            if (this._saveBackground != null) {
                component2.setBackground(this._saveBackground == CellStyle.EMPTY_COLOR ? null : this._saveBackground);
                if (bl3) {
                    component.setBackground(this._saveBackground == CellStyle.EMPTY_COLOR ? null : this._saveBackground);
                }
                this._saveBackground = null;
            }
            if (this._saveForeground != null) {
                component2.setForeground(this._saveForeground);
                if (bl3) {
                    component.setForeground(this._saveForeground);
                }
                this._saveForeground = null;
            }
        }
        if (this._saveFont != null) {
            component2.setFont(this._saveFont == CellStyle.EMPTY_FONT ? null : this._saveFont);
            if (bl3) {
                component.setFont(this._saveFont == CellStyle.EMPTY_FONT ? null : this._saveFont);
            }
            this._saveFont = null;
        }
        if (this._saveBorder != null) {
            if (component2 instanceof JComponent) {
                ((JComponent)component2).setBorder(this._saveBorder == CellStyle.EMPTY_BORDER ? null : this._saveBorder);
            }
            if (bl3 && component instanceof JComponent) {
                ((JComponent)component).setBorder(this._saveBorder == CellStyle.EMPTY_BORDER ? null : this._saveBorder);
            }
            this._saveBorder = null;
        }
        if (component2 instanceof JLabel) {
            if (this._saveIcon != null) {
                ((JLabel)component2).setIcon(this._saveIcon == CellStyle.EMPTY_ICON ? null : this._saveIcon);
                this._saveIcon = null;
            }
            if (this._saveHorizontalAlignment != -1) {
                ((JLabel)component2).setHorizontalAlignment(this._saveHorizontalAlignment);
                this._saveHorizontalAlignment = -1;
            }
            if (this._saveVerticalAlignment != -1) {
                ((JLabel)component2).setVerticalAlignment(this._saveVerticalAlignment);
                this._saveVerticalAlignment = -1;
            }
            if (this._saveHorizontalTextPosition != -1) {
                ((JLabel)component2).setHorizontalTextPosition(this._saveHorizontalTextPosition);
                this._saveHorizontalTextPosition = -1;
            }
            if (this._saveVerticalTextPosition != -1) {
                ((JLabel)component2).setVerticalTextPosition(this._saveVerticalTextPosition);
                this._saveVerticalTextPosition = -1;
            }
            if (this._saveText != null) {
                ((JLabel)component2).setText("AN_EMPTY_STRING".equals(this._saveText) ? null : this._saveText);
                this._saveText = null;
            }
        } else if (component2 instanceof AbstractButton) {
            if (this._saveIcon != null) {
                ((AbstractButton)component2).setIcon(this._saveIcon == CellStyle.EMPTY_ICON ? null : this._saveIcon);
                this._saveIcon = null;
            }
            if (this._saveHorizontalAlignment != -1) {
                ((AbstractButton)component2).setHorizontalAlignment(this._saveHorizontalAlignment);
                this._saveHorizontalAlignment = -1;
            }
            if (this._saveVerticalAlignment != -1) {
                ((AbstractButton)component2).setVerticalAlignment(this._saveVerticalAlignment);
                this._saveVerticalAlignment = -1;
            }
            if (this._saveHorizontalTextPosition != -1) {
                ((AbstractButton)component2).setHorizontalTextPosition(this._saveHorizontalTextPosition);
                this._saveHorizontalTextPosition = -1;
            }
            if (this._saveVerticalTextPosition != -1) {
                ((AbstractButton)component2).setVerticalTextPosition(this._saveVerticalTextPosition);
                this._saveVerticalTextPosition = -1;
            }
            if (this._saveText != null) {
                ((AbstractButton)component2).setText("AN_EMPTY_STRING".equals(this._saveText) ? null : this._saveText);
                this._saveText = null;
            }
        } else if (component2 instanceof JTextField) {
            if (this._saveHorizontalAlignment != -1) {
                ((JTextField)component2).setHorizontalAlignment(this._saveHorizontalAlignment);
                this._saveHorizontalAlignment = -1;
            }
            if (this._saveText != null) {
                ((JTextField)component2).setText("AN_EMPTY_STRING".equals(this._saveText) ? null : this._saveText);
                this._saveText = null;
            }
        }
        if (this._saveToolTipText != null && component2 instanceof JComponent) {
            ((JComponent)component2).setToolTipText("AN_EMPTY_STRING".equals(this._saveToolTipText) ? null : this._saveToolTipText);
            this._saveToolTipText = null;
        }
        if (this._cellStyleCustomizers != null) {
            for (CellStyleCustomizer cellStyleCustomizer : this._cellStyleCustomizers) {
                cellStyleCustomizer.releaseRendererComponent(n, n2, component);
            }
        }
        super.internalReleaseRendererComponent(tableCellRenderer, n, n2, component, bl);
    }

    protected Component configureRendererComponent(int n, int n2, Component component) {
        this._cellStyle = this.getCellStyleAt(n, n2);
        if (this._cellStyle != null) {
            this.customizeRendererComponent(n, n2, component, this._cellStyle);
        }
        return component;
    }

    protected CellStyle mergeCellStyles(List<CellStyle> list) {
        CellStyle cellStyle = new CellStyle();
        for (CellStyle cellStyle2 : list) {
            if (cellStyle2 == null) continue;
            this.mergeCellStyle(cellStyle, cellStyle2);
        }
        return cellStyle;
    }

    protected void mergeCellStyle(CellStyle cellStyle, CellStyle cellStyle2) {
        CellStyle.mergeCellStyle(cellStyle, cellStyle2);
    }

    public void addCellStyleCustomizer(CellStyleCustomizer cellStyleCustomizer) {
        if (this._cellStyleCustomizers == null) {
            this._cellStyleCustomizers = new ArrayList<CellStyleCustomizer>();
        }
        if (!this._cellStyleCustomizers.contains(cellStyleCustomizer)) {
            this._cellStyleCustomizers.add(cellStyleCustomizer);
        }
    }

    public void removeCellStyleCustomizer(CellStyleCustomizer cellStyleCustomizer) {
        if (this._cellStyleCustomizers != null) {
            this._cellStyleCustomizers.remove(cellStyleCustomizer);
        }
    }

    public CellStyleCustomizer[] getCellStyleCustomizers() {
        if (this._cellStyleCustomizers == null) {
            return new CellStyleCustomizer[0];
        }
        return this._cellStyleCustomizers.toArray(new CellStyleCustomizer[this._cellStyleCustomizers.size()]);
    }

    public void clearCellStyleCustomizers() {
        if (this._cellStyleCustomizers != null) {
            this._cellStyleCustomizers.clear();
            this._cellStyleCustomizers = null;
        }
    }

    protected void customizeRendererComponent(int n, int n2, Component component, CellStyle cellStyle) {
        this.internalCustomizeRendererComponent(n, n2, component, cellStyle, false);
    }

    private void internalCustomizeRendererComponent(int n, int n2, Component component, CellStyle cellStyle, boolean bl) {
        Color color;
        Color color2;
        boolean bl2;
        Component component2 = component;
        boolean bl3 = false;
        if (component2 instanceof RendererWrapper) {
            if ((component2 = ((RendererWrapper)((Object)component2)).getActualRenderer()) != null) {
                bl3 = true;
            } else {
                component2 = component;
            }
        }
        boolean bl4 = bl2 = bl || this.isCellSelected(n, n2);
        if (bl2) {
            color2 = cellStyle.getSelectionBackground();
            color = cellStyle.getSelectionForeground();
        } else {
            color2 = cellStyle.getBackground();
            color = cellStyle.getForeground();
        }
        if (!(color2 == null || color2.equals(component2.getBackground()) && color2.equals(component.getBackground()))) {
            if (bl2) {
                if (this._saveSelectedBackground == null) {
                    this._saveSelectedBackground = component2.getBackground();
                    if (this._saveSelectedBackground == null) {
                        this._saveSelectedBackground = CellStyle.EMPTY_COLOR;
                    }
                }
            } else if (this._saveBackground == null) {
                this._saveBackground = component2.getBackground();
                if (this._saveBackground == null) {
                    this._saveBackground = CellStyle.EMPTY_COLOR;
                }
            }
            component2.setBackground(color2);
            if (bl3) {
                component.setBackground(color2);
            }
        }
        if (!(color == null || color.equals(component2.getForeground()) && color.equals(component.getForeground()))) {
            if (bl2) {
                if (this._saveSelectedForeground == null) {
                    this._saveSelectedForeground = component2.getForeground();
                }
            } else if (this._saveForeground == null && (this.getForeground() instanceof UIResource || !JideSwingUtilities.equals(this.getForeground(), component2.getForeground()))) {
                this._saveForeground = component2.getForeground();
            }
            component2.setForeground(color);
            if (bl3) {
                component.setForeground(color);
            }
        }
        if (!(cellStyle.getFont() == null || cellStyle.getFont().equals(component2.getFont()) && cellStyle.getFont().equals(component.getFont()))) {
            if (this._saveFont == null) {
                this._saveFont = component2.getFont();
                if (this._saveFont == null) {
                    this._saveFont = CellStyle.EMPTY_FONT;
                }
            }
            component2.setFont(cellStyle.getFont());
            if (bl3) {
                component.setFont(cellStyle.getFont());
            }
        } else if (cellStyle.getFontStyle() != -1 && cellStyle.getFontStyle() != (component2.getFont() == null ? 0 : component2.getFont().getStyle())) {
            Object object = null;
            if (this._saveFont == null) {
                this._saveFont = component2.getFont();
                object = this._saveFont;
                if (this._saveFont == null) {
                    this._saveFont = CellStyle.EMPTY_FONT;
                }
            }
            if (object != null) {
                int n3 = cellStyle.getFontStyle();
                Font font = this.createFontIfNecessary((Font)object, n3);
                component2.setFont(font);
                if (bl3) {
                    component.setFont(font);
                }
            }
        }
        if (cellStyle.getBorder() != null && component2 instanceof JComponent) {
            if (this._saveBorder == null) {
                this._saveBorder = ((JComponent)component2).getBorder();
                if (this._saveBorder == null) {
                    this._saveBorder = CellStyle.EMPTY_BORDER;
                }
            }
            if (!cellStyle.getBorder().equals(((JComponent)component2).getBorder())) {
                ((JComponent)component2).setBorder(cellStyle.getBorder());
            }
            if (bl3 && component instanceof JComponent) {
                ((JComponent)component).setBorder(cellStyle.getBorder());
            }
        }
        if (component2 instanceof JLabel) {
            if (cellStyle.getIcon() != null) {
                if (this._saveIcon == null) {
                    this._saveIcon = ((JLabel)component2).getIcon();
                    if (this._saveIcon == null) {
                        this._saveIcon = CellStyle.EMPTY_ICON;
                    }
                }
                ((JLabel)component2).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this._saveHorizontalAlignment == -1) {
                    this._saveHorizontalAlignment = ((JLabel)component2).getHorizontalAlignment();
                }
                ((JLabel)component2).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                if (this._saveVerticalAlignment == -1) {
                    this._saveVerticalAlignment = ((JLabel)component2).getVerticalAlignment();
                }
                ((JLabel)component2).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
            if (cellStyle.getHorizontalTextPosition() != -1) {
                if (this._saveHorizontalTextPosition == -1) {
                    this._saveHorizontalTextPosition = ((JLabel)component2).getHorizontalTextPosition();
                }
                ((JLabel)component2).setHorizontalTextPosition(cellStyle.getHorizontalTextPosition());
            }
            if (cellStyle.getVerticalTextPosition() != -1) {
                if (this._saveVerticalTextPosition == -1) {
                    this._saveVerticalTextPosition = ((JLabel)component2).getVerticalTextPosition();
                }
                ((JLabel)component2).setVerticalTextPosition(cellStyle.getVerticalTextPosition());
            }
            if (cellStyle.getText() != null) {
                this._saveText = ((JLabel)component2).getText();
                if (this._saveText == null) {
                    this._saveText = "AN_EMPTY_STRING";
                }
                ((JLabel)component2).setText(cellStyle.getText());
            }
        } else if (component2 instanceof AbstractButton) {
            if (cellStyle.getIcon() != null) {
                if (this._saveIcon == null) {
                    this._saveIcon = ((AbstractButton)component2).getIcon();
                    if (this._saveIcon == null) {
                        this._saveIcon = CellStyle.EMPTY_ICON;
                    }
                }
                ((AbstractButton)component2).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this._saveHorizontalAlignment == -1) {
                    this._saveHorizontalAlignment = ((AbstractButton)component2).getHorizontalAlignment();
                }
                ((AbstractButton)component2).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                if (this._saveVerticalAlignment == -1) {
                    this._saveVerticalAlignment = ((AbstractButton)component2).getVerticalAlignment();
                }
                ((AbstractButton)component2).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
            if (cellStyle.getHorizontalTextPosition() != -1) {
                if (this._saveHorizontalTextPosition == -1) {
                    this._saveHorizontalTextPosition = ((AbstractButton)component2).getHorizontalTextPosition();
                }
                ((AbstractButton)component2).setHorizontalTextPosition(cellStyle.getHorizontalTextPosition());
            }
            if (cellStyle.getVerticalTextPosition() != -1) {
                if (this._saveVerticalTextPosition == -1) {
                    this._saveVerticalTextPosition = ((AbstractButton)component2).getVerticalTextPosition();
                }
                ((AbstractButton)component2).setVerticalTextPosition(cellStyle.getVerticalTextPosition());
            }
            if (cellStyle.getText() != null) {
                this._saveText = ((AbstractButton)component2).getText();
                if (this._saveText == null) {
                    this._saveText = "AN_EMPTY_STRING";
                }
                ((AbstractButton)component2).setText(cellStyle.getText());
            }
        } else if (component2 instanceof JTextField) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this._saveHorizontalAlignment == -1) {
                    this._saveHorizontalAlignment = ((JTextField)component2).getHorizontalAlignment();
                }
                ((JTextField)component2).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getText() != null) {
                this._saveText = ((JTextField)component2).getText();
                if (this._saveText == null) {
                    this._saveText = "AN_EMPTY_STRING";
                }
                ((JTextField)component2).setText(cellStyle.getText());
            }
        } else if (component2 instanceof AlignmentSupport) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                if (this._saveHorizontalAlignment == -1) {
                    this._saveHorizontalAlignment = ((AlignmentSupport)((Object)component2)).getHorizontalAlignment();
                }
                ((AlignmentSupport)((Object)component2)).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                if (this._saveVerticalAlignment == -1) {
                    this._saveVerticalAlignment = ((AlignmentSupport)((Object)component2)).getVerticalAlignment();
                }
                ((AlignmentSupport)((Object)component2)).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
        }
        if (cellStyle.getToolTipText() != null && component2 instanceof JComponent) {
            this._saveToolTipText = ((JComponent)component2).getToolTipText();
            if (this._saveToolTipText == null) {
                this._saveToolTipText = "AN_EMPTY_STRING";
            }
            ((JComponent)component2).setToolTipText(cellStyle.getToolTipText());
        }
        if (this._cellStyleCustomizers != null) {
            for (CellStyleCustomizer cellStyleCustomizer : this._cellStyleCustomizers) {
                cellStyleCustomizer.customizeRendererComponent(n, n2, component, cellStyle);
            }
        }
    }

    private Font createFontIfNecessary(Font font, int n) {
        String string = font.getFontName() + ";" + font.getSize() + ";" + n;
        Font font2 = this._fontCache.get(string);
        if (font2 == null) {
            font2 = font.deriveFont(n);
            this._fontCache.put(string, font2);
        }
        return font2;
    }

    protected Component configureEditorComponent(int n, int n2, Component component) {
        CellStyle cellStyle = this.getCellStyleAt(n, n2);
        if (cellStyle != null) {
            this.customizeEditorComponent(n, n2, component, cellStyle);
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellStyle getCellStyleAt(int n, int n2) {
        List<CellStyle> list = this._cellStyleList;
        synchronized (list) {
            CellStyle cellStyle = null;
            this.collectCellStyles(n, n2);
            if (this._cellStyleList != null && this._cellStyleList.size() > 0) {
                if (this._cellStyleList.size() == 1) {
                    cellStyle = this._cellStyleList.get(0);
                } else if (this._cellStyleList.size() > 1) {
                    cellStyle = this.mergeCellStyles(this._cellStyleList);
                }
                this._cellStyleList.clear();
            }
            return cellStyle;
        }
    }

    public CellStyle[] getCellStyles(int n, int n2) {
        CellStyle cellStyle;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TableStyleProvider tableStyleProvider = this.getTableStyleProvider();
        if (tableStyleProvider != null && (object = tableStyleProvider.getCellStyleAt(this, n, n2)) != null) {
            arrayList.add(object);
        }
        if ((object = this.getCellStyleProvider()) != null && (cellStyle = object.getCellStyleAt(this.getModel(), this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2))) != null) {
            arrayList.add(cellStyle);
        }
        int n3 = this.convertColumnIndexToModel(n2);
        Object object2 = this.getStyleModel();
        while (object2 != null) {
            if (object2 instanceof StyleModel && ((StyleModel)object2).isCellStyleOn()) {
                int n4 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, (TableModel)object2);
                int n5 = TableModelWrapperUtils.getActualColumnAt(this.getModel(), n3, (TableModel)object2);
                if (n4 == -1 || n5 == -1) break;
                CellStyle cellStyle2 = ((StyleModel)object2).getCellStyleAt(n4, n5);
                if (cellStyle2 != null) {
                    arrayList.add(cellStyle2);
                }
            }
            object2 = this.getNextStyleModel((TableModel)object2);
        }
        if ((object2 = this.getFocusCellStyle()) != null && this.isCellFocused(n, n2)) {
            arrayList.add(object2);
        }
        return arrayList.toArray(new CellStyle[arrayList.size()]);
    }

    protected void collectCellStyles(int n, int n2) {
        CellStyle cellStyle;
        TableStyleProvider tableStyleProvider;
        CellStyle cellStyle2;
        CellStyle cellStyle3 = this.getFocusCellStyle();
        if (cellStyle3 != null && this.isCellFocused(n, n2)) {
            this._cellStyleList.add(cellStyle3);
        }
        int n3 = this.convertColumnIndexToModel(n2);
        ArrayList<CellStyle> arrayList = new ArrayList<CellStyle>();
        TableModel tableModel = this.getStyleModel();
        while (tableModel != null) {
            if (tableModel instanceof StyleModel && ((StyleModel)((Object)tableModel)).isCellStyleOn()) {
                int n4 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, tableModel);
                int n5 = TableModelWrapperUtils.getActualColumnAt(this.getModel(), n3, tableModel);
                if (n4 == -1 || n5 == -1) break;
                CellStyle cellStyle4 = ((StyleModel)((Object)tableModel)).getCellStyleAt(n4, n5);
                if (cellStyle4 != null) {
                    arrayList.add(cellStyle4);
                }
            }
            tableModel = this.getNextStyleModel(tableModel);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            this._cellStyleList.add((CellStyle)arrayList.get(i));
        }
        CellStyleProvider cellStyleProvider = this.getCellStyleProvider();
        if (cellStyleProvider != null && (cellStyle2 = cellStyleProvider.getCellStyleAt(this.getModel(), this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2))) != null) {
            this._cellStyleList.add(cellStyle2);
        }
        if ((tableStyleProvider = this.getTableStyleProvider()) != null && (cellStyle = tableStyleProvider.getCellStyleAt(this, n, n2)) != null) {
            this._cellStyleList.add(cellStyle);
        }
    }

    protected void customizeEditorComponent(int n, int n2, Component component, CellStyle cellStyle) {
        Object object;
        if (cellStyle.getSelectionBackground() != null) {
            component.setBackground(cellStyle.getSelectionBackground());
        }
        if (cellStyle.getSelectionForeground() != null) {
            component.setForeground(cellStyle.getSelectionForeground());
        }
        if (cellStyle.getFont() != null) {
            component.setFont(cellStyle.getFont());
        } else if (cellStyle.getFontStyle() != -1 && (object = component.getFont()) != null) {
            Font object2 = this.createFontIfNecessary((Font)object, cellStyle.getFontStyle());
            component.setFont(object2);
        }
        if (cellStyle.getBorder() != null && component instanceof JComponent) {
            ((JComponent)component).setBorder(cellStyle.getBorder());
        }
        if (component instanceof JLabel) {
            if (cellStyle.getIcon() != null) {
                ((JLabel)component).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((JLabel)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((JLabel)component).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
        } else if (component instanceof AbstractButton) {
            if (cellStyle.getIcon() != null) {
                ((AbstractButton)component).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((AbstractButton)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((AbstractButton)component).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
        } else if (component instanceof JTextField) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((JTextField)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
        } else if (component instanceof AlignmentSupport) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((AlignmentSupport)((Object)component)).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((AlignmentSupport)((Object)component)).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
        }
        if (this._cellStyleCustomizers != null) {
            for (CellStyleCustomizer cellStyleCustomizer : this._cellStyleCustomizers) {
                cellStyleCustomizer.customizeEditorComponent(n, n2, component, cellStyle);
            }
        }
    }

    public CellStyleProvider getCellStyleProvider() {
        return this._cellStyleProvider;
    }

    public void setCellStyleProvider(CellStyleProvider cellStyleProvider) {
        this._cellStyleProvider = cellStyleProvider;
        this.repaint();
    }

    public TableStyleProvider getTableStyleProvider() {
        return this._tableStyleProvider;
    }

    public void setTableStyleProvider(TableStyleProvider tableStyleProvider) {
        this._tableStyleProvider = tableStyleProvider;
        this.repaint();
    }

    public CellStyle getFocusCellStyle() {
        return this._focusCellStyle;
    }

    public void setFocusCellStyle(CellStyle cellStyle) {
        this._focusCellStyle = cellStyle;
    }

    public boolean isFillsViewportWithStripe() {
        return this._fillsViewportWithStripe;
    }

    public void setFillsViewportWithStripe(boolean bl) {
        if (this._fillsViewportWithStripe != bl) {
            boolean bl2 = this._fillsViewportWithStripe;
            this._fillsViewportWithStripe = bl;
            this.firePropertyChange(PROPERTY_FILLS_VIEWPORT_WITH_STRIPE, bl2, this._fillsViewportWithStripe);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.needPaintStripedBackground()) {
            Graphics graphics2 = graphics.create();
            this.paintStripedBackground(graphics2);
            graphics2.dispose();
        }
    }

    protected boolean needPaintStripedBackground() {
        boolean bl = false;
        if (this.isFillsViewportWithStripe() && (!SystemInfo.isJdk6Above() || this.getFillsViewportHeight())) {
            TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getModel(), StyleModel.class);
            while (tableModel instanceof StyleModel) {
                if (((StyleModel)((Object)tableModel)).isCellStyleOn()) {
                    bl = true;
                    break;
                }
                if (!(tableModel instanceof TableModelWrapper)) break;
                tableModel = TableModelWrapperUtils.getActualTableModel(((TableModelWrapper)((Object)tableModel)).getActualModel(), StyleModel.class);
            }
            if (!bl && (this.getCellStyleProvider() instanceof RowStripeCellStyleProvider || this.getTableStyleProvider() instanceof RowStripeTableStyleProvider)) {
                bl = true;
            }
        }
        return bl;
    }

    private void paintStripedBackground(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getRowCount();
        int n2 = rectangle.y;
        if (n > 0) {
            Rectangle rectangle2 = this.getCellRect(n - 1, 0, false);
            n2 = rectangle2.y + rectangle2.height + 1;
        }
        int n3 = this.getRowHeight();
        while (n2 < rectangle.y + rectangle.height) {
            int n4 = n2 + n3;
            graphics.setColor(this.getRowColor(n));
            graphics.fillRect(rectangle.x, n2, rectangle.width, n4 - (this instanceof AutoFilterUtils.AutoFilterRowTable ? 1 : 0));
            n2 = n4;
            ++n;
        }
    }

    Color getRowColor(int n) {
        if (n >= 0 && n < this.getRowCount() || this.isFillsViewportWithStripe()) {
            Color[] colorArray;
            if (this.isFillsSelection() && !this.isNonContiguousCellSelection() && this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed() && this.isRowSelected(n)) {
                return this.getSelectionBackground();
            }
            if (this.getTableStyleProvider() instanceof RowStripeTableStyleProvider && (colorArray = ((RowStripeTableStyleProvider)this.getTableStyleProvider()).getAlternativeBackgroundColors()) != null && colorArray.length >= 1) {
                return colorArray[n % colorArray.length];
            }
            if (this.getCellStyleProvider() instanceof RowStripeCellStyleProvider && (colorArray = ((RowStripeCellStyleProvider)this.getCellStyleProvider()).getAlternativeBackgroundColors()) != null && colorArray.length >= 1) {
                return colorArray[n % colorArray.length];
            }
            if (this.getModel() instanceof AutoFilterUtils.AutoFilterRowTableModel) {
                return ((AutoFilterUtils.AutoFilterRowTableModel)this.getModel()).getCellStyleAt(0, 0).getBackground();
            }
        }
        return this.getBackground();
    }

    public boolean isFillsSelection() {
        return this._fillsSelection;
    }

    public void setFillsSelection(boolean bl) {
        boolean bl2 = this._fillsSelection;
        if (bl2 != bl) {
            this._fillsSelection = bl;
            this.firePropertyChange(PROPERTY_FILLS_SELECTION, bl2, this._fillsSelection);
        }
    }
}

