/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.ColorExComboBox;
import com.jidesoft.combobox.FontExComboBox;
import com.jidesoft.combobox.ListExComboBox;
import com.jidesoft.converter.EnumConverter;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CellStyleEditor
extends JPanel {
    private CellStyle _style = new CellStyle();
    private JCheckBox _italicCheckBox;
    private JCheckBox _boldCheckBox;
    private ColorExComboBox _backgroundColorExComboBox;
    private ColorExComboBox _foregroundColorExComboBox;
    private FontExComboBox _fontExComboBox;
    private ListExComboBox _horizontalAlignmentComboBox;
    protected JRadioButton _fontStyleRadioButton;
    protected JRadioButton _fontRadioButton;
    private boolean _autoUpdate;
    public static String PROPERTY_STYLE = "style";

    public CellStyleEditor() {
        this.installComponents();
    }

    public void setAutoUpdate(boolean bl) {
        this._autoUpdate = bl;
    }

    public boolean isAutoUpdate() {
        return this._autoUpdate;
    }

    protected void installComponents() {
        this._boldCheckBox = new JCheckBox();
        this._italicCheckBox = new JCheckBox();
        this._foregroundColorExComboBox = new ColorExComboBox();
        this._backgroundColorExComboBox = new ColorExComboBox();
        this._fontExComboBox = new FontExComboBox();
        this._horizontalAlignmentComboBox = new ListExComboBox();
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = -3427833375790606717L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CellStyleEditor.this.isAutoUpdate()) {
                    CellStyleEditor.this.saveData();
                }
            }
        };
        this._boldCheckBox.addActionListener(abstractAction);
        this._italicCheckBox.addActionListener(abstractAction);
        this._foregroundColorExComboBox.addActionListener(abstractAction);
        this._backgroundColorExComboBox.addActionListener(abstractAction);
        this._fontExComboBox.addActionListener(abstractAction);
        this._horizontalAlignmentComboBox.addActionListener(abstractAction);
        this._boldCheckBox.setText(this.getResourceString("Settings.style.bold"));
        this._boldCheckBox.setMnemonic(this.getResourceString("Settings.style.bold.mnemonic").charAt(0));
        this._boldCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._boldCheckBox.setDisplayedMnemonicIndex(0);
        this._boldCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this._italicCheckBox.setText(this.getResourceString("Settings.style.italic"));
        this._italicCheckBox.setMnemonic(this.getResourceString("Settings.style.italic.mnemonic").charAt(0));
        this._italicCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._italicCheckBox.setDisplayedMnemonicIndex(0);
        this._italicCheckBox.setMargin(new Insets(0, 0, 0, 0));
        EnumConverter enumConverter = new EnumConverter("Horizontal Alignment", Integer.TYPE, new Integer[]{-1, 2, 0, 4}, new String[]{"", this.getResourceString("Settings.style.alignment.left"), this.getResourceString("Settings.style.alignment.center"), this.getResourceString("Settings.style.alignment.right")}, -1);
        this._horizontalAlignmentComboBox.setType(Integer.TYPE);
        this._horizontalAlignmentComboBox.setConverter(enumConverter);
        this._horizontalAlignmentComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<Object>(enumConverter.getObjects()));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 3, 6);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        this._fontStyleRadioButton = new JRadioButton(this.getResourceString("Settings.style.fontStyle"));
        this._fontStyleRadioButton.addActionListener(abstractAction);
        this._fontStyleRadioButton.setMnemonic(this.getResourceString("Settings.style.fontStyle.mnemonic").charAt(0));
        jPanel.add((Component)this._fontStyleRadioButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this._fontRadioButton = new JRadioButton(this.getResourceString("Settings.style.font"));
        this._fontRadioButton.addActionListener(abstractAction);
        this._fontRadioButton.setMnemonic(this.getResourceString("Settings.style.font.mnemonic").charAt(0));
        jPanel.add((Component)this._fontRadioButton, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._fontStyleRadioButton);
        buttonGroup.add(this._fontRadioButton);
        gridBagConstraints.gridy = 2;
        JLabel jLabel = new JLabel(this.getResourceString("Settings.style.background"));
        jLabel.setDisplayedMnemonic(this.getResourceString("Settings.style.background.mnemonic").charAt(0));
        jLabel.setLabelFor(this._backgroundColorExComboBox);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        JLabel jLabel2 = new JLabel(this.getResourceString("Settings.style.foreground"));
        jLabel2.setDisplayedMnemonic(this.getResourceString("Settings.style.foreground.mnemonic").charAt(0));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jLabel2.setLabelFor(this._foregroundColorExComboBox);
        gridBagConstraints.gridy = 4;
        JLabel jLabel3 = new JLabel(this.getResourceString("Settings.style.alignment"));
        jLabel3.setDisplayedMnemonic(this.getResourceString("Settings.style.alignment.mnemonic").charAt(0));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        jLabel3.setLabelFor(this._horizontalAlignmentComboBox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridy = 0;
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 0, 0));
        jPanel2.add(this._boldCheckBox);
        jPanel2.add(this._italicCheckBox);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._fontExComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this._backgroundColorExComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this._foregroundColorExComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this._horizontalAlignmentComboBox, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "First");
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = CellStyleEditor.this._fontStyleRadioButton.isSelected();
                CellStyleEditor.this._boldCheckBox.setEnabled(bl);
                CellStyleEditor.this._italicCheckBox.setEnabled(bl);
                boolean bl2 = CellStyleEditor.this._fontRadioButton.isSelected();
                CellStyleEditor.this._fontExComboBox.setEnabled(bl2);
            }
        };
        this._fontStyleRadioButton.addItemListener(itemListener);
        this._fontRadioButton.addItemListener(itemListener);
        this._fontStyleRadioButton.setSelected(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData() {
        if (this._style == null) {
            return;
        }
        int n = this._style.getFontStyle();
        if (n == -1) {
            n = 0;
        }
        boolean bl = this.isAutoUpdate();
        try {
            this.setAutoUpdate(false);
            this._boldCheckBox.setSelected((n & 1) != 0);
            Font font = this._style.getFont();
            if (font != null) {
                this._fontRadioButton.setSelected(true);
            } else {
                this._fontStyleRadioButton.setSelected(true);
            }
            this._fontExComboBox.setSelectedFont(font == CellStyle.EMPTY_FONT ? null : font);
            this._italicCheckBox.setSelected((n & 2) != 0);
            this._backgroundColorExComboBox.setSelectedColor(this._style.getBackground());
            this._foregroundColorExComboBox.setSelectedColor(this._style.getForeground());
            this._horizontalAlignmentComboBox.setSelectedItem(this._style.getHorizontalAlignment());
        }
        finally {
            this.setAutoUpdate(bl);
        }
    }

    public void saveData() {
        if (this._style == null) {
            return;
        }
        CellStyle cellStyle = new CellStyle(this._style);
        int n = (this._boldCheckBox.isSelected() ? 1 : 0) | (this._italicCheckBox.isSelected() ? 2 : 0);
        this._style.setFontStyle(n == 0 ? -1 : n);
        this._style.setBackground(this._backgroundColorExComboBox.getSelectedColor());
        this._style.setForeground(this._foregroundColorExComboBox.getSelectedColor());
        this._style.setFont(this._fontRadioButton.isSelected() ? this._fontExComboBox.getSelectedFont() : null);
        this._style.setHorizontalAlignment((Integer)this._horizontalAlignmentComboBox.getSelectedItem());
        this.firePropertyChange(PROPERTY_STYLE, cellStyle, this._style);
    }

    public CellStyle getStyle() {
        this.saveData();
        if (this._style.getBackground() == null && this._style.getForeground() == null && this._style.getFont() == CellStyle.EMPTY_FONT && this._style.getFontStyle() == -1 && this._style.getHorizontalAlignment() == -1) {
            return null;
        }
        return this._style;
    }

    public void setStyle(CellStyle cellStyle) {
        this.saveData();
        this._style = cellStyle == null ? new CellStyle() : cellStyle;
        this.loadData();
    }

    protected String getResourceString(String string) {
        return ResourceBundle.getBundle("com.jidesoft.grid.cellStyle", this.getLocale()).getString(string);
    }

    public static void main(String[] stringArray) {
        LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
        JDialog jDialog = new JDialog();
        jDialog.setDefaultCloseOperation(2);
        jDialog.add(new CellStyleEditor());
        jDialog.setLocationRelativeTo(null);
        jDialog.pack();
        jDialog.setVisible(true);
    }
}

