/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellPainter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Prioritized;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CellStyle
implements SwingConstants,
Prioritized,
Cloneable {
    private Border _border;
    private Color _background;
    private Color _foreground;
    private Color _selectionBackground;
    private Color _selectionForeground;
    private Font _font;
    private int _fontStyle = -1;
    private Icon _icon;
    private int _verticalAlignment = -1;
    private int _horizontalAlignment = -1;
    private int _verticalTextPosition = -1;
    private int _horizontalTextPosition = -1;
    private String _text = null;
    private String _toolTipText = null;
    private Border _overlayBorder = null;
    private CellPainter _overlayCellPainter = null;
    private CellPainter _underlayCellPainter = null;
    private transient int _priority;
    public static final Icon EMPTY_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    };
    public static final Color EMPTY_COLOR = new Color(0, 0, 0);
    public static final Font EMPTY_FONT = new Font("", 0, 0);
    public static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    public static final String EMPTY_STRING = "AN_EMPTY_STRING";
    public static final CellPainter EMPTY_CELL_PAINTER = new CellPainter(){

        @Override
        public void paint(Graphics graphics, Component component, int n, int n2, Rectangle rectangle, Object object) {
        }
    };

    public CellStyle() {
    }

    public CellStyle(CellStyle cellStyle) {
        this._border = cellStyle.getBorder();
        this._background = cellStyle.getBackground();
        this._foreground = cellStyle.getForeground();
        this._selectionBackground = cellStyle.getSelectionBackground();
        this._selectionForeground = cellStyle.getSelectionForeground();
        this._font = cellStyle.getFont();
        this._fontStyle = cellStyle.getFontStyle();
        this._icon = cellStyle.getIcon();
        this._verticalAlignment = cellStyle.getVerticalAlignment();
        this._horizontalAlignment = cellStyle.getHorizontalAlignment();
        this._verticalTextPosition = cellStyle.getVerticalTextPosition();
        this._horizontalTextPosition = cellStyle.getHorizontalTextPosition();
        this._text = cellStyle.getText();
        this._toolTipText = cellStyle.getToolTipText();
        this._overlayBorder = cellStyle.getOverlayBorder();
        this._overlayCellPainter = cellStyle.getOverlayCellPainter();
        this._underlayCellPainter = cellStyle.getUnderlayCellPainter();
    }

    public Border getBorder() {
        return this._border;
    }

    public void setBorder(Border border) {
        this._border = border;
    }

    public Color getBackground() {
        return this._background;
    }

    public void setBackground(Color color) {
        this._background = color;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void setForeground(Color color) {
        this._foreground = color;
    }

    public Color getSelectionBackground() {
        return this._selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        this._selectionBackground = color;
    }

    public Color getSelectionForeground() {
        return this._selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        this._selectionForeground = color;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font font) {
        this._font = font;
    }

    public int getFontStyle() {
        return this._fontStyle;
    }

    public void setFontStyle(int n) {
        this._fontStyle = n;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public int getVerticalAlignment() {
        return this._verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this._verticalAlignment = n;
    }

    public int getHorizontalAlignment() {
        return this._horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this._horizontalAlignment = n;
    }

    public int getVerticalTextPosition() {
        return this._verticalTextPosition;
    }

    public void setVerticalTextPosition(int n) {
        this._verticalTextPosition = n;
    }

    public int getHorizontalTextPosition() {
        return this._horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int n) {
        this._horizontalTextPosition = n;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String string) {
        this._text = string;
    }

    public String getToolTipText() {
        return this._toolTipText;
    }

    public void setToolTipText(String string) {
        this._toolTipText = string;
    }

    public Border getOverlayBorder() {
        return this._overlayBorder;
    }

    public void setOverlayBorder(Border border) {
        this._overlayBorder = border;
    }

    public CellPainter getOverlayCellPainter() {
        return this._overlayCellPainter;
    }

    public void setOverlayCellPainter(CellPainter cellPainter) {
        this._overlayCellPainter = cellPainter;
    }

    public CellPainter getUnderlayCellPainter() {
        return this._underlayCellPainter;
    }

    public void setUnderlayCellPainter(CellPainter cellPainter) {
        this._underlayCellPainter = cellPainter;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    public void setPriority(int n) {
        this._priority = n;
    }

    public boolean equalsForExporting(Object object) {
        if (!(object instanceof CellStyle)) {
            return false;
        }
        CellStyle cellStyle = (CellStyle)object;
        return JideSwingUtilities.equals(this.getBackground(), cellStyle.getBackground()) && JideSwingUtilities.equals(this.getFont(), cellStyle.getFont()) && JideSwingUtilities.equals(this.getFontStyle(), cellStyle.getFontStyle()) && JideSwingUtilities.equals(this.getForeground(), cellStyle.getForeground()) && JideSwingUtilities.equals(this.getHorizontalAlignment(), cellStyle.getHorizontalAlignment()) && JideSwingUtilities.equals(this.getVerticalAlignment(), cellStyle.getVerticalAlignment());
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellStyle)) {
            return false;
        }
        CellStyle cellStyle = (CellStyle)object;
        return JideSwingUtilities.equals(this.getBackground(), cellStyle.getBackground()) && JideSwingUtilities.equals(this.getBorder(), cellStyle.getBorder()) && JideSwingUtilities.equals(this.getFont(), cellStyle.getFont()) && JideSwingUtilities.equals(this.getFontStyle(), cellStyle.getFontStyle()) && JideSwingUtilities.equals(this.getForeground(), cellStyle.getForeground()) && JideSwingUtilities.equals(this.getHorizontalAlignment(), cellStyle.getHorizontalAlignment()) && JideSwingUtilities.equals(this.getHorizontalTextPosition(), cellStyle.getHorizontalTextPosition()) && JideSwingUtilities.equals(this.getIcon(), cellStyle.getIcon()) && JideSwingUtilities.equals(this.getOverlayBorder(), cellStyle.getOverlayBorder()) && JideSwingUtilities.equals(this.getOverlayCellPainter(), cellStyle.getOverlayCellPainter()) && JideSwingUtilities.equals(this.getUnderlayCellPainter(), cellStyle.getUnderlayCellPainter()) && JideSwingUtilities.equals(this.getSelectionBackground(), cellStyle.getSelectionBackground()) && JideSwingUtilities.equals(this.getSelectionForeground(), cellStyle.getSelectionForeground()) && JideSwingUtilities.equals(this.getText(), cellStyle.getText()) && JideSwingUtilities.equals(this.getToolTipText(), cellStyle.getToolTipText()) && JideSwingUtilities.equals(this.getVerticalAlignment(), cellStyle.getVerticalAlignment()) && JideSwingUtilities.equals(this.getVerticalTextPosition(), cellStyle.getVerticalTextPosition());
    }

    @Deprecated
    public boolean isShowIconOnly() {
        return "".equals(this.getText());
    }

    @Deprecated
    public void setShowIconOnly(boolean bl) {
        this.setText(bl ? "" : null);
    }

    public CellStyle clone() throws CloneNotSupportedException {
        return (CellStyle)super.clone();
    }

    public static void mergeCellStyle(CellStyle cellStyle, CellStyle cellStyle2) {
        CellPainter cellPainter;
        CellPainter cellPainter2;
        Border border;
        int n;
        int n2;
        String string;
        String string2;
        Color color;
        Color color2;
        Icon icon;
        int n3;
        int n4;
        Font font;
        int n5;
        Border border2;
        Color color3;
        Color color4;
        boolean bl;
        if (cellStyle == null || cellStyle2 == null) {
            return;
        }
        boolean bl2 = bl = cellStyle2.getPriority() > cellStyle.getPriority();
        if (bl) {
            cellStyle.setPriority(cellStyle2.getPriority());
        }
        if ((cellStyle.getBackground() == null || bl) && (color4 = cellStyle2.getBackground()) != null) {
            cellStyle.setBackground(color4);
        }
        if ((cellStyle.getForeground() == null || bl) && (color3 = cellStyle2.getForeground()) != null) {
            cellStyle.setForeground(color3);
        }
        if ((cellStyle.getBorder() == null || bl) && (border2 = cellStyle2.getBorder()) != null) {
            cellStyle.setBorder(border2);
        }
        if ((cellStyle.getFontStyle() == -1 || bl) && (n5 = cellStyle2.getFontStyle()) != -1) {
            cellStyle.setFontStyle(n5);
        }
        if ((cellStyle.getFont() == null || bl) && (font = cellStyle2.getFont()) != null) {
            cellStyle.setFont(font);
        }
        if ((cellStyle.getHorizontalAlignment() == -1 || bl) && (n4 = cellStyle2.getHorizontalAlignment()) != -1) {
            cellStyle.setHorizontalAlignment(n4);
        }
        if ((cellStyle.getHorizontalTextPosition() == -1 || bl) && (n3 = cellStyle2.getHorizontalTextPosition()) != -1) {
            cellStyle.setHorizontalTextPosition(n3);
        }
        if ((cellStyle.getIcon() == null || bl) && (icon = cellStyle2.getIcon()) != null) {
            cellStyle.setIcon(icon);
        }
        if ((cellStyle.getSelectionBackground() == null || bl) && (color2 = cellStyle2.getSelectionBackground()) != null) {
            cellStyle.setSelectionBackground(color2);
        }
        if ((cellStyle.getSelectionForeground() == null || bl) && (color = cellStyle2.getSelectionForeground()) != null) {
            cellStyle.setSelectionForeground(color);
        }
        if ((cellStyle.getText() == null || bl) && (string2 = cellStyle2.getText()) != null) {
            cellStyle.setText(string2);
        }
        if ((cellStyle.getToolTipText() == null || bl) && (string = cellStyle2.getToolTipText()) != null) {
            cellStyle.setToolTipText(string);
        }
        if ((cellStyle.getVerticalAlignment() == -1 || bl) && (n2 = cellStyle2.getVerticalAlignment()) != -1) {
            cellStyle.setVerticalAlignment(n2);
        }
        if ((cellStyle.getVerticalTextPosition() == -1 || bl) && (n = cellStyle2.getVerticalTextPosition()) != -1) {
            cellStyle.setVerticalTextPosition(n);
        }
        if ((cellStyle.getOverlayBorder() == null || bl) && (border = cellStyle2.getOverlayBorder()) != null) {
            cellStyle.setOverlayBorder(border);
        }
        if ((cellStyle.getOverlayCellPainter() == null || bl) && (cellPainter2 = cellStyle2.getOverlayCellPainter()) != null) {
            cellStyle.setOverlayCellPainter(cellPainter2);
        }
        if ((cellStyle.getUnderlayCellPainter() == null || bl) && (cellPainter = cellStyle2.getUnderlayCellPainter()) != null) {
            cellStyle.setUnderlayCellPainter(cellPainter);
        }
    }
}

