/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SortedList;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CellSpanTable
extends CellStyleTable {
    private static final String uiClassID = "CellSpanTableUI";
    private boolean _init;
    private boolean _keepRowAtPoint = false;
    private boolean _keepColumnAtPoint = false;
    private boolean _autoConvertCellSpan = true;
    private boolean _paintCellSpanAsSelected = true;
    public static final int AUTO_CELL_MERGE_OFF = 0;
    public static final int AUTO_CELL_MERGE_ROWS = 1;
    public static final int AUTO_CELL_MERGE_COLUMNS = 2;
    public static final int AUTO_CELL_MERGE_ROWS_LIMITED = 3;
    public static final int AUTO_CELL_MERGE_COLUMNS_LIMITED = 4;
    private int _autoCellMerge;
    public static final String PROPERTY_AUTO_CONVERT_CELL_SPAN = "autoConvertCellSpan";
    public static final String PROPERTY_PAINT_CELL_SPAN_AS_SELECTED = "paintCellSpanAsSelected";
    private List<CellSpan> _cache;
    private Set<Cell> _cacheEmpty;
    private boolean _cellSpanCacheEnabled = true;
    private Boolean _cellSpanOn = null;

    public CellSpanTable() {
        this.initializeTable();
    }

    public CellSpanTable(int n, int n2) {
        super(n, n2);
        this.initializeTable();
    }

    public CellSpanTable(TableModel tableModel) {
        super(tableModel);
        this.initializeTable();
    }

    public CellSpanTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initializeTable();
    }

    public CellSpanTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.initializeTable();
    }

    public CellSpanTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initializeTable();
    }

    public CellSpanTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initializeTable();
    }

    private void initializeTable() {
        if (!this._init) {
            this.muteDefaultKeyStroke();
            this._init = true;
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        super.columnAdded(tableColumnModelEvent);
        if (this.getAutoCellMerge() != 0) {
            this.invalidateCellSpanCache();
        }
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnRemoved(tableColumnModelEvent);
        if (this.getAutoCellMerge() != 0) {
            this.invalidateCellSpanCache();
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnMoved(tableColumnModelEvent);
        if (this.getAutoCellMerge() != 0) {
            this.invalidateCellSpanCache();
        }
    }

    @Override
    public String getActualUIClassID() {
        return uiClassID;
    }

    public TableModel getSpanModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof SpanModel) {
            return tableModel;
        }
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, SpanModel.class);
        if (tableModel2 != null) {
            return tableModel2;
        }
        return tableModel;
    }

    public CellSpan getCellSpanAt(SpanModel spanModel, int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        return spanModel.getCellSpanAt(TableModelWrapperUtils.getActualRowAt(this.getModel(), n, (TableModel)((Object)spanModel)), TableModelWrapperUtils.getActualColumnAt(this.getModel(), n2, (TableModel)((Object)spanModel)));
    }

    public CellSpan convertModelCellSpanToView(CellSpan cellSpan) {
        if (cellSpan == null) {
            return cellSpan;
        }
        TableModel tableModel = this.getSpanModel();
        if (!(tableModel instanceof SpanModel)) {
            return cellSpan;
        }
        int n = cellSpan.getRow();
        int n2 = cellSpan.getRow() + cellSpan.getRowSpan() - 1;
        int n3 = TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, n);
        int n4 = TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, n2);
        while (n3 < 0 && ++n <= n2) {
            n3 = TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, n);
        }
        while (n4 < 0 && n <= --n2) {
            n4 = TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, n2);
        }
        if (n3 < 0 || n4 < 0 || n3 > n4) {
            return null;
        }
        int n5 = n4 - n3 + 1;
        if (this.getModel().getColumnCount() == this.getColumnCount()) {
            if (cellSpan.getColumnSpan() == tableModel.getColumnCount()) {
                return n3 != cellSpan.getRow() || n5 != cellSpan.getRowSpan() ? new CellSpan(n3, cellSpan.getColumn(), n5, cellSpan.getColumnSpan()) : cellSpan;
            }
            return new CellSpan(n3, this.convertColumnIndexToView(cellSpan.getColumn()), n5, cellSpan.getColumnSpan());
        }
        if (cellSpan.getColumnSpan() == tableModel.getColumnCount()) {
            return new CellSpan(n3, cellSpan.getColumn(), cellSpan.getRowSpan(), this.getColumnCount());
        }
        int n6 = cellSpan.getColumn();
        int n7 = this.convertColumnIndexToView(n6);
        int n8 = cellSpan.getColumnSpan();
        for (int i = 0; i < cellSpan.getColumnSpan(); ++i) {
            int n9 = this.convertColumnIndexToView(cellSpan.getColumn() + i);
            if (n9 == -1) {
                --n8;
            }
            if (n7 != -1) continue;
            n7 = n9;
        }
        if (n8 == this.getColumnCount()) {
            n7 = 0;
        }
        if (n7 == -1 || n8 == 0) {
            return n3 != cellSpan.getRow() || n5 != cellSpan.getRowSpan() ? new CellSpan(n3, cellSpan.getColumn(), n5, cellSpan.getColumnSpan()) : cellSpan;
        }
        return new CellSpan(n3, n7, n5, n8);
    }

    public CellSpan convertViewCellSpanToModel(CellSpan cellSpan) {
        if (cellSpan == null) {
            return null;
        }
        int n = cellSpan.getColumn();
        int n2 = this.convertColumnIndexToModel(n);
        int n3 = this.convertColumnIndexToModel(cellSpan.getColumn() + cellSpan.getColumnSpan() - 1);
        return new CellSpan(cellSpan.getRow(), n2, cellSpan.getRowSpan(), n3 - n + 1);
    }

    public boolean isAutoConvertCellSpan() {
        return this._autoConvertCellSpan;
    }

    public void setAutoConvertCellSpan(boolean bl) {
        boolean bl2 = this._autoConvertCellSpan;
        if (bl2 != bl) {
            this._autoConvertCellSpan = bl;
            this.firePropertyChange(PROPERTY_AUTO_CONVERT_CELL_SPAN, bl2, bl);
        }
    }

    public boolean isPaintCellSpanAsSelected() {
        return this._paintCellSpanAsSelected;
    }

    public void setPaintCellSpanAsSelected(boolean bl) {
        boolean bl2 = this._paintCellSpanAsSelected;
        if (bl2 != bl) {
            this._paintCellSpanAsSelected = bl;
            this.firePropertyChange(PROPERTY_PAINT_CELL_SPAN_AS_SELECTED, bl2, bl);
        }
    }

    public boolean isKeepColumnAtPoint() {
        return this._keepColumnAtPoint;
    }

    public void setKeepColumnAtPoint(boolean bl) {
        this._keepColumnAtPoint = bl;
    }

    public boolean isKeepRowAtPoint() {
        return this._keepRowAtPoint;
    }

    public void setKeepRowAtPoint(boolean bl) {
        this._keepRowAtPoint = bl;
    }

    public Rectangle originalGetCellRect(int n, int n2, boolean bl) {
        return super.getCellRect(n, n2, bl);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (this.getRowCount() == 0) {
            if (1 == n) {
                int n3 = this.getRowHeight();
                return n3 > 0 ? Math.max(n3, rectangle.height / n3 * n3) : rectangle.height;
            }
            return rectangle.width;
        }
        if (!this.isVariousRowHeights() && 1 == n) {
            int n4 = this.rowAtPoint(rectangle.getLocation());
            assert (n4 != -1);
            int n5 = this.columnAtPoint(rectangle.getLocation());
            Rectangle rectangle2 = this.originalGetCellRect(n4, n5, true);
            if (rectangle2.y == rectangle.y) {
                int n6 = this.getRowHeight();
                assert (n6 > 0);
                return Math.max(n6, rectangle.height / n6 * n6);
            }
        }
        if (n2 < 0) {
            return this.getPreviousBlockIncrement(rectangle, n);
        }
        return this.getNextBlockIncrement(rectangle, n);
    }

    private int getLeadingRow(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x, rectangle.y) : new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        return this.rowAtPoint(point);
    }

    private int getLeadingCol(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x, rectangle.y) : new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        return this.columnAtPoint(point);
    }

    private int getTrailingRow(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x, rectangle.y + rectangle.height - 1) : new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        return this.rowAtPoint(point);
    }

    private int getTrailingCol(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x + rectangle.width - 1, rectangle.y) : new Point(rectangle.x, rectangle.y);
        return this.columnAtPoint(point);
    }

    private int leadingEdge(Rectangle rectangle, int n) {
        if (n == 1) {
            return rectangle.y;
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            return rectangle.x;
        }
        return rectangle.x + rectangle.width;
    }

    private int trailingEdge(Rectangle rectangle, int n) {
        if (n == 1) {
            return rectangle.y + rectangle.height;
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            return rectangle.x + rectangle.width;
        }
        return rectangle.x;
    }

    private int getNextBlockIncrement(Rectangle rectangle, int n) {
        boolean bl;
        int n2 = this.getTrailingRow(rectangle);
        int n3 = this.getTrailingCol(rectangle);
        int n4 = this.leadingEdge(rectangle, n);
        if (n == 1 && n2 < 0) {
            return rectangle.height;
        }
        if (n == 0 && n3 < 0) {
            return rectangle.width;
        }
        Rectangle rectangle2 = this.originalGetCellRect(n2, n3, true);
        int n5 = this.leadingEdge(rectangle2, n);
        int n6 = this.trailingEdge(rectangle2, n);
        if (n == 1 || this.getComponentOrientation().isLeftToRight()) {
            bl = n5 <= n4;
        } else {
            boolean bl2 = bl = n5 >= n4;
        }
        int n7 = bl ? n6 : (n6 == this.trailingEdge(rectangle, n) ? n6 : n5);
        return Math.abs(n7 - n4);
    }

    private int getPreviousBlockIncrement(Rectangle rectangle, int n) {
        int n2;
        Point point;
        int n3;
        int n4 = this.leadingEdge(rectangle, n);
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (n == 1) {
            n3 = n4 - rectangle.height;
            int n5 = rectangle.x + (bl ? 0 : rectangle.width);
            point = new Point(n5, n3);
        } else if (bl) {
            n3 = n4 - rectangle.width;
            point = new Point(n3, rectangle.y);
        } else {
            n3 = n4 + rectangle.width;
            point = new Point(n3 - 1, rectangle.y);
        }
        int n6 = this.rowAtPoint(point);
        int n7 = this.columnAtPoint(point);
        if (n == 1 & n6 < 0) {
            n2 = 0;
        } else if (n == 0 & n7 < 0) {
            n2 = bl ? 0 : this.getWidth();
        } else {
            Rectangle rectangle2 = this.originalGetCellRect(n6, n7, true);
            int n8 = this.leadingEdge(rectangle2, n);
            int n9 = this.trailingEdge(rectangle2, n);
            n2 = (n == 1 || bl) && n9 >= n4 ? n8 : (n == 0 && !bl && n9 <= n4 ? n8 : (n3 == n8 ? n8 : n9));
        }
        return Math.abs(n4 - n2);
    }

    @Override
    public Rectangle getCellRect(int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || this.getRowCount() <= n || this.getColumnCount() <= n2) {
            return super.getCellRect(n, n2, bl);
        }
        CellSpan cellSpan = this.getCellSpanAt(n, n2);
        if (cellSpan == null || this._pageNavigationKeyProcessing) {
            return super.getCellRect(n, n2, bl);
        }
        cellSpan = (CellSpan)cellSpan.clone();
        Rectangle rectangle = super.getCellRect(cellSpan.getRow(), cellSpan.getColumn(), bl);
        for (int i = Math.min(cellSpan.getRowSpan() - 1, this.getRowCount() - cellSpan.getRow() - 1); i >= 0; --i) {
            for (int j = Math.min(cellSpan.getColumnSpan() - 1, this.getColumnCount() - cellSpan.getColumn() - 1); j >= 0; --j) {
                Rectangle rectangle2 = super.getCellRect(cellSpan.getRow() + i, cellSpan.getColumn() + j, bl);
                if (rectangle2.getWidth() == 0.0 && rectangle2.getHeight() == 0.0) continue;
                if (rectangle2.getWidth() == 0.0 && rectangle2.x > rectangle.x) {
                    --rectangle2.x;
                }
                if (rectangle2.getHeight() == 0.0 && rectangle2.y > rectangle.y) {
                    --rectangle2.y;
                }
                rectangle = rectangle.union(rectangle2);
                return rectangle;
            }
        }
        return rectangle;
    }

    public int originalRowAtPoint(Point point) {
        return super.rowAtPoint(point);
    }

    public int originalColumnAtPoint(Point point) {
        return super.columnAtPoint(point);
    }

    @Override
    public int rowAtPoint(Point point) {
        if (!this.isKeepRowAtPoint() && this.isCellSpanOn() && !this._pageNavigationKeyProcessing) {
            int n;
            int n2 = super.rowAtPoint(point);
            CellSpan cellSpan = this.getCellSpanAt(n2, n = super.columnAtPoint(point));
            if (cellSpan != null) {
                return cellSpan.getRow();
            }
            return n2;
        }
        return super.rowAtPoint(point);
    }

    @Override
    public int columnAtPoint(Point point) {
        if (!this.isKeepColumnAtPoint() && this.isCellSpanOn()) {
            int n;
            int n2 = super.rowAtPoint(point);
            CellSpan cellSpan = this.getCellSpanAt(n2, n = super.columnAtPoint(point));
            if (cellSpan != null) {
                return cellSpan.getColumn();
            }
            return n;
        }
        return super.columnAtPoint(point);
    }

    @Override
    public boolean rolloverCellAt(int n, int n2) {
        CellSpan cellSpan = this.getCellSpanAt(n, n2);
        if (cellSpan != null) {
            return super.rolloverCellAt(cellSpan.getRow(), cellSpan.getColumn());
        }
        return super.rolloverCellAt(n, n2);
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        CellSpan cellSpan = this.getCellSpanAt(n, n2);
        if (cellSpan != null) {
            return super.editCellAt(cellSpan.getRow(), cellSpan.getColumn(), eventObject);
        }
        return super.editCellAt(n, n2, eventObject);
    }

    @Override
    protected boolean shouldCellBePaintedAsFocused(int n, int n2) {
        CellSpan cellSpan;
        CellSpan cellSpan2;
        if (!this.isPaintCellSpanAsSelected() && !this.isNonContiguousCellSelection() && !this.getCellSelectionEnabled() && (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed() ? (cellSpan2 = this.getCellSpanAt(n, n2)) != null && cellSpan2.getRowSpan() > 1 && cellSpan2.getColumnSpan() < this.getColumnCount() : this.getColumnSelectionAllowed() && !this.getRowSelectionAllowed() && (cellSpan = this.getCellSpanAt(n, n2)) != null && cellSpan.getColumnSpan() > 1 && cellSpan.getRowSpan() < this.getRowCount())) {
            return false;
        }
        return super.shouldCellBePaintedAsFocused(n, n2);
    }

    @Override
    protected boolean shouldCellBePaintedAsSelected(int n, int n2) {
        CellSpan cellSpan;
        CellSpan cellSpan2;
        if (!this.isPaintCellSpanAsSelected() && !this.isNonContiguousCellSelection() && !this.getCellSelectionEnabled() && (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed() ? (cellSpan2 = this.getCellSpanAt(n, n2)) != null && cellSpan2.getRowSpan() > 1 && cellSpan2.getColumnSpan() < this.getColumnCount() : this.getColumnSelectionAllowed() && !this.getRowSelectionAllowed() && (cellSpan = this.getCellSpanAt(n, n2)) != null && cellSpan.getColumnSpan() > 1 && cellSpan.getRowSpan() < this.getRowCount())) {
            return false;
        }
        return super.shouldCellBePaintedAsSelected(n, n2);
    }

    @Override
    public boolean isCellSelected(int n, int n2) {
        CellSpan cellSpan;
        if (this.isNonContiguousCellSelection()) {
            CellSpan cellSpan2 = this.getCellSpanAt(n, n2);
            if (cellSpan2 != null) {
                for (int i = cellSpan2.getRow(); i < cellSpan2.getRow() + cellSpan2.getRowSpan(); ++i) {
                    for (int j = cellSpan2.getColumn(); j < cellSpan2.getColumn() + cellSpan2.getColumnSpan(); ++j) {
                        if (!super.isCellSelected(i, j)) continue;
                        return true;
                    }
                }
                return false;
            }
        } else if (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed() || !this.getRowSelectionAllowed() && this.getColumnSelectionAllowed()) {
            CellSpan cellSpan3 = this.getCellSpanAt(n, n2);
            if (cellSpan3 != null) {
                if (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
                    for (int i = cellSpan3.getRow(); i < cellSpan3.getRow() + cellSpan3.getRowSpan(); ++i) {
                        if (!this.isRowSelected(i)) continue;
                        return true;
                    }
                } else if (!this.getRowSelectionAllowed() && this.getColumnSelectionAllowed()) {
                    for (int i = cellSpan3.getColumn(); i < cellSpan3.getColumn() + cellSpan3.getColumnSpan(); ++i) {
                        if (!this.isColumnSelected(i)) continue;
                        return true;
                    }
                }
            }
        } else if (this.getRowSelectionAllowed() && this.getColumnSelectionAllowed() && (cellSpan = this.getCellSpanAt(n, n2)) != null) {
            int n3;
            boolean bl = false;
            for (n3 = cellSpan.getRow(); n3 < cellSpan.getRow() + cellSpan.getRowSpan(); ++n3) {
                if (!this.isRowSelected(n3)) continue;
                bl = true;
                break;
            }
            n3 = 0;
            for (int i = cellSpan.getColumn(); i < cellSpan.getColumn() + cellSpan.getColumnSpan(); ++i) {
                if (!this.isColumnSelected(i)) continue;
                n3 = 1;
                break;
            }
            if (bl && n3 != 0) {
                return true;
            }
        }
        return super.isCellSelected(n, n2);
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        CellSpan cellSpan = this.getCellSpanAt(n, n2);
        if (cellSpan != null) {
            return super.getCellEditor(cellSpan.getRow(), cellSpan.getColumn());
        }
        return super.getCellEditor(n, n2);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        CellSpan cellSpan = this.getCellSpanAt(n, n2);
        if (cellSpan != null) {
            return super.getCellRenderer(cellSpan.getRow(), cellSpan.getColumn());
        }
        return super.getCellRenderer(n, n2);
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        CellSpan cellSpan = this.getCellSpanAt(n, n2);
        if (cellSpan != null) {
            return super.prepareEditor(tableCellEditor, cellSpan.getRow(), cellSpan.getColumn());
        }
        return super.prepareEditor(tableCellEditor, n, n2);
    }

    @Override
    protected boolean isCellFocused(int n, int n2) {
        CellSpan cellSpan = this.getCellSpanAt(n, n2);
        if (cellSpan != null) {
            int n3 = -1;
            int n4 = -1;
            if (this.isNonContiguousCellSelection()) {
                if (this.getTableSelectionModel() != null && !this.isTablePrinting()) {
                    n3 = this.getTableSelectionModel().getLeadRowIndex();
                    n4 = this.getTableSelectionModel().getLeadColumnIndex();
                }
            } else if (!SystemInfo.isJdk6Above() || !this.isPaintingForPrint()) {
                n3 = this.getSelectionModel().getLeadSelectionIndex();
                n4 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            }
            boolean bl = false;
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component != null && (component == this || component == this._lastFocusTable)) {
                bl = true;
            }
            return cellSpan.contains(n3, n4) && bl;
        }
        return super.isCellFocused(n, n2);
    }

    @Override
    protected Rectangle getDirtyRegion(int n, int n2, int n3, int n4) {
        Rectangle rectangle = super.getDirtyRegion(n, n2, n3, n4);
        if (!this.isCellSpanOn()) {
            return rectangle;
        }
        if (!this.isCellSpanCacheEnabled() || n3 - n >= 10) {
            return new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        int n5 = n2;
        int n6 = n + 1;
        while (n6 <= n3 - 1) {
            CellSpan cellSpan = this.getCellSpanAt(n6, n2);
            if (cellSpan == null) {
                ++n6;
                continue;
            }
            n6 = Math.max(n6 + 1, cellSpan.getRow() + cellSpan.getRowSpan());
            n5 = Math.min(cellSpan.getColumn(), n5);
        }
        n6 = n4;
        int n7 = n + 1;
        while (n7 <= n3 - 1) {
            CellSpan cellSpan = this.getCellSpanAt(n7, n4);
            if (cellSpan == null) {
                ++n7;
                continue;
            }
            n7 = Math.max(n7 + 1, cellSpan.getRow() + cellSpan.getRowSpan());
            n6 = Math.max(cellSpan.getColumn() + cellSpan.getColumnSpan() - 1, n6);
        }
        n7 = n;
        int n8 = n2 + 1;
        while (n8 <= n4 - 1) {
            CellSpan cellSpan = this.getCellSpanAt(n, n8);
            if (cellSpan == null) {
                ++n8;
                continue;
            }
            n8 = Math.max(n8 + 1, cellSpan.getColumn() + cellSpan.getColumnSpan());
            n7 = Math.min(cellSpan.getRow(), n7);
        }
        n8 = n3;
        int n9 = n2 + 1;
        while (n9 <= n4 - 1) {
            CellSpan cellSpan = this.getCellSpanAt(n3, n9);
            if (cellSpan == null) {
                ++n9;
                continue;
            }
            n9 = Math.max(n9 + 1, cellSpan.getColumn() + cellSpan.getColumnSpan());
            n8 = Math.max(cellSpan.getRow() + cellSpan.getRowSpan() - 1, n8);
        }
        if (n6 != n4 || n5 != n2 || n7 != n || n8 != n3) {
            rectangle = super.getDirtyRegion(n7, n5, n8, n6);
        }
        return rectangle;
    }

    public boolean isCellSpanOn() {
        if (this.getAutoCellMerge() != 0) {
            return true;
        }
        if (this.isCellSpanCacheEnabled() && this._cellSpanOn != null) {
            return this._cellSpanOn;
        }
        TableModel tableModel = this.getSpanModel();
        this._cellSpanOn = tableModel instanceof SpanModel && ((SpanModel)((Object)tableModel)).isCellSpanOn();
        return this._cellSpanOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellSpan getCellSpanAt(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.getRowCount() || n2 >= this.getColumnCount()) {
            return null;
        }
        if (!this.isCellSpanOn()) {
            return null;
        }
        int n3 = n2;
        if (this.isAutoConvertCellSpan() && n2 < this.getColumnModel().getColumnCount()) {
            n3 = this.convertColumnIndexToModel(n2);
        }
        boolean bl = this.getAutoCellMerge() != 0;
        List<CellSpan> list = this.getCache();
        Set<Cell> set = this.getCacheEmpty();
        if (this._cache == null) {
            this._cache = this.createCellSpanCache();
        }
        List<CellSpan> list2 = this._cache;
        synchronized (list2) {
            CellSpan cellSpan;
            if (this.isCellSpanCacheEnabled()) {
                if (set.size() > 0 && set.contains(new Cell(n, bl ? n2 : n3))) {
                    return null;
                }
                if (list.size() > 0) {
                    cellSpan = this.binarySearch(list, n, bl ? n2 : n3);
                    if (cellSpan == null) {
                        cellSpan = this.linearSearch(list, n, bl ? n2 : n3);
                    }
                    if (cellSpan != null) {
                        if (!bl && this.isAutoConvertCellSpan()) {
                            return this.convertModelCellSpanToView(cellSpan);
                        }
                        return cellSpan;
                    }
                }
            }
            cellSpan = null;
            if (bl) {
                cellSpan = this.getCellSpanFromAutoCellMerge(n, n2);
            }
            if (cellSpan == null) {
                cellSpan = this.getCellSpanFromSpanModel(n, n2);
            }
            if (this.isCellSpanCacheEnabled()) {
                if (cellSpan != null && (cellSpan.getRowSpan() > 1 || cellSpan.getColumnSpan() > 1)) {
                    list.add((CellSpan)cellSpan.clone());
                } else {
                    set.add(new Cell(n, bl ? n2 : n3));
                }
            }
            CellSpan cellSpan2 = bl || !this.isAutoConvertCellSpan() ? cellSpan : (cellSpan != null ? this.convertModelCellSpanToView(cellSpan) : null);
            return cellSpan2;
        }
    }

    protected List<CellSpan> createCellSpanCache() {
        return new SortedList<CellSpan>(new ArrayList(), new Comparator(){

            public int compare(Object object, Object object2) {
                if (!(object instanceof CellSpan) || !(object2 instanceof CellSpan)) {
                    return 0;
                }
                CellSpan cellSpan = (CellSpan)object;
                CellSpan cellSpan2 = (CellSpan)object2;
                if (cellSpan.getRow() < cellSpan2.getRow()) {
                    return -1;
                }
                if (cellSpan.getRow() > cellSpan2.getRow()) {
                    return 1;
                }
                if (cellSpan.getColumn() < cellSpan2.getColumn()) {
                    return -1;
                }
                if (cellSpan.getColumn() > cellSpan2.getColumn()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    protected CellSpan binarySearch(List<CellSpan> list, int n, int n2) {
        int n3 = 0;
        int n4 = list.size();
        int n5 = n4 / 2;
        while (n3 < n4) {
            CellSpan cellSpan = list.get(n5);
            if (cellSpan.contains(n, n2)) {
                return cellSpan;
            }
            if (n > cellSpan.getRow() || n == cellSpan.getRow() && n2 > cellSpan.getColumn()) {
                n3 = n5 + 1;
            } else {
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return null;
    }

    protected CellSpan linearSearch(List<CellSpan> list, int n, int n2) {
        for (CellSpan cellSpan : list) {
            if (!cellSpan.contains(n, n2)) continue;
            return cellSpan;
        }
        return null;
    }

    protected CellSpan getCellSpanFromAutoCellMerge(int n, int n2) {
        if (this.getAutoCellMerge() == 1) {
            int n3;
            Object object = this.getValueAt(n, n2);
            int n4 = n;
            for (n3 = n; n3 > 0 && JideSwingUtilities.equals(object, this.getValueAt(n3 - 1, n2)); --n3) {
            }
            while (n4 < this.getRowCount() - 1 && JideSwingUtilities.equals(object, this.getValueAt(n4 + 1, n2))) {
                ++n4;
            }
            if (n3 != n4) {
                return new CellSpan(n3, n2, n4 - n3 + 1, 1);
            }
            return null;
        }
        if (this.getAutoCellMerge() == 3) {
            int n5;
            Object object;
            int n6 = 0;
            int n7 = this.getRowCount() - 1;
            if (n2 > 0) {
                object = this.getCellSpanAt(n, n2 - 1);
                if (object != null) {
                    n6 = ((CellSpan)object).getRow();
                    n7 = ((CellSpan)object).getRow() + ((CellSpan)object).getRowSpan() - 1;
                } else {
                    n6 = n;
                    n7 = n;
                }
            }
            object = this.getValueAt(n, n2);
            int n8 = n;
            for (n5 = n; n5 > n6 && JideSwingUtilities.equals(object, this.getValueAt(n5 - 1, n2)); --n5) {
            }
            while (n8 < n7 && JideSwingUtilities.equals(object, this.getValueAt(n8 + 1, n2))) {
                ++n8;
            }
            if (n5 != n8) {
                return new CellSpan(n5, n2, n8 - n5 + 1, 1);
            }
            return null;
        }
        if (this.getAutoCellMerge() == 2) {
            int n9;
            Object object = this.getValueAt(n, n2);
            int n10 = n2;
            for (n9 = n2; n9 > 0 && JideSwingUtilities.equals(object, this.getValueAt(n, n9 - 1)); --n9) {
            }
            while (n10 < this.getColumnCount() - 1 && JideSwingUtilities.equals(object, this.getValueAt(n, n10 + 1))) {
                ++n10;
            }
            if (n9 != n10) {
                return new CellSpan(n, n9, 1, n10 - n9 + 1);
            }
            return null;
        }
        if (this.getAutoCellMerge() == 4) {
            int n11;
            Object object;
            int n12 = 0;
            int n13 = this.getColumnCount() - 1;
            if (n > 0) {
                object = this.getCellSpanAt(n - 1, n2);
                if (object != null) {
                    n12 = ((CellSpan)object).getColumn();
                    n13 = ((CellSpan)object).getColumn() + ((CellSpan)object).getColumnSpan() - 1;
                } else {
                    n12 = n2;
                    n13 = n2;
                }
            }
            object = this.getValueAt(n, n2);
            int n14 = n2;
            for (n11 = n2; n11 > n12 && JideSwingUtilities.equals(object, this.getValueAt(n, n11 - 1)); --n11) {
            }
            while (n14 < n13 && JideSwingUtilities.equals(object, this.getValueAt(n, n14 + 1))) {
                ++n14;
            }
            if (n11 != n14) {
                return new CellSpan(n, n11, 1, n14 - n11 + 1);
            }
            return null;
        }
        return null;
    }

    protected CellSpan getCellSpanFromSpanModel(int n, int n2) {
        return this.isCellSpanOn() ? this.getCellSpanAt((SpanModel)((Object)this.getSpanModel()), n, this.convertColumnIndexToModel(n2)) : null;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (!this.isCellSpanOn()) {
            super.valueChanged(listSelectionEvent);
            return;
        }
        if (this.isRowAutoResizes()) {
            this.repaint();
            return;
        }
        int n2 = listSelectionEvent.getFirstIndex();
        int n3 = listSelectionEvent.getLastIndex();
        if (n2 == -1 && n3 == -1) {
            this.repaint();
        }
        Rectangle rectangle = this.getCellRect(n2, 0, false);
        int n4 = this.getColumnCount();
        int n5 = n2;
        for (n = 0; n < n4; ++n) {
            rectangle.add(this.getCellRect(n5, n, false));
        }
        n5 = n3;
        for (n = 0; n < n4; ++n) {
            rectangle.add(this.getCellRect(n5, n, false));
        }
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.invalidateCellSpanCache();
        super.tableChanged(tableModelEvent);
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0 || tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE && tableModelEvent.getColumn() == -1) {
            this._cellSpanOn = null;
        }
        this.invalidateCellSpanCache();
    }

    public void invalidateCellSpanCache() {
        if (this._cache != null) {
            this._cache.clear();
        }
        if (this._cacheEmpty != null) {
            this._cacheEmpty.clear();
        }
    }

    protected void muteDefaultKeyStroke() {
        this.replaceAction(KeyStroke.getKeyStroke(9, 0));
        this.replaceAction(KeyStroke.getKeyStroke(9, 1));
        this.replaceAction(KeyStroke.getKeyStroke(37, 0));
        this.replaceAction(KeyStroke.getKeyStroke(37, 1));
        this.replaceAction(KeyStroke.getKeyStroke(39, 0));
        this.replaceAction(KeyStroke.getKeyStroke(39, 1));
        this.replaceAction(KeyStroke.getKeyStroke(38, 0));
        this.replaceAction(KeyStroke.getKeyStroke(38, 1));
        this.replaceAction(KeyStroke.getKeyStroke(40, 0));
        this.replaceAction(KeyStroke.getKeyStroke(40, 1));
    }

    protected Action createDelegateAction(Action action, KeyStroke keyStroke) {
        return new DelegateAction(action, keyStroke);
    }

    public boolean isCellSpanCacheEnabled() {
        return this._cellSpanCacheEnabled;
    }

    public void setCellSpanCacheEnabled(boolean bl) {
        this._cellSpanCacheEnabled = bl;
        if (!this._cellSpanCacheEnabled) {
            this.invalidateCellSpanCache();
        }
    }

    protected void replaceAction(KeyStroke keyStroke) {
        this.replaceAction(keyStroke, 1);
    }

    protected void replaceAction(KeyStroke keyStroke, int n) {
        Object object = this.getInputMap(n).get(keyStroke);
        if (object != null) {
            Action action = this.getActionMap().get(object);
            this.getActionMap().put(object, this.createDelegateAction(action, keyStroke));
        } else {
            this.registerKeyboardAction(this.createDelegateAction(null, keyStroke), keyStroke, n);
        }
    }

    protected void restoreAction(KeyStroke keyStroke) {
        this.restoreAction(keyStroke, 1);
    }

    protected void restoreAction(KeyStroke keyStroke, int n) {
        ActionListener actionListener = this.getActionForKeyStroke(keyStroke);
        if (actionListener instanceof DelegateAction) {
            this.registerKeyboardAction(((DelegateAction)actionListener).getDefaultAction(), keyStroke, n);
        }
    }

    public void calculateRowHeights() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.calculateRowHeight(i, false);
        }
    }

    public void calculateRowHeight(int n, boolean bl) {
        if (n < 0 || n > this.getRowCount() - 1) {
            return;
        }
        int n2 = this.getColumnCount();
        if (bl) {
            int n3;
            int n4 = n;
            int n5 = n4 + 1;
            if (this.isCellSpanOn()) {
                for (n3 = 0; n3 < n2; ++n3) {
                    CellSpan cellSpan = this.getCellSpanAt(n, n3);
                    if (cellSpan == null) continue;
                    n4 = Math.min(n4, cellSpan.getRow());
                    n5 = Math.max(n5, cellSpan.getRow() + cellSpan.getRowSpan());
                }
            }
            for (n3 = n4; n3 < n5; ++n3) {
                this.calculateRowHeight(n3, false);
            }
        } else {
            int n6 = this.calculateRowHeight(n);
            if (n6 != this.getRowHeight(n)) {
                this.setRowHeight(n, n6);
            }
        }
    }

    @Override
    protected int calculateRowHeight(int n) {
        if (n < 0 || n > this.getRowCount() - 1) {
            return -1;
        }
        int n2 = this.getColumnCount();
        int n3 = 0;
        HashMap hashMap = new HashMap();
        int n4 = 0;
        while (n4 < n2) {
            CellSpan cellSpan = this.getCellSpanAt(n, n4);
            if (cellSpan != null && cellSpan.getRowSpan() > 1) {
                int n5 = cellSpan.getRow();
                int n6 = cellSpan.getRowSpan();
                Integer n7 = this.getPreferredHeight(n5, cellSpan.getColumn());
                n7 = (int)Math.ceil((n7 + n6 - 1) / n6);
                n3 = Math.max(n3, n7);
            } else {
                n3 = Math.max(n3, super.getPreferredHeight(n, n4));
            }
            if (cellSpan == null) {
                ++n4;
                continue;
            }
            n4 = cellSpan.getColumn() + cellSpan.getColumnSpan();
        }
        if (this.getIntercellSpacing() != null) {
            n3 += this.getIntercellSpacing().height;
        }
        return n3;
    }

    public static boolean verifyCellSpan(SpanModel spanModel) {
        try {
            if (spanModel instanceof TableModel) {
                CellSpan cellSpan;
                int n;
                int n2;
                TableModel tableModel = (TableModel)((Object)spanModel);
                CellSpan[][] cellSpanArray = new CellSpan[tableModel.getRowCount()][tableModel.getColumnCount()];
                int[][] nArray = new int[tableModel.getRowCount()][tableModel.getColumnCount()];
                for (n2 = 0; n2 < tableModel.getColumnCount(); ++n2) {
                    for (n = 0; n < tableModel.getRowCount(); ++n) {
                        cellSpan = spanModel.getCellSpanAt(n, n2);
                        cellSpanArray[n][n2] = cellSpan == null ? new CellSpan(n, n2, 1, 1) : (CellSpan)cellSpan.clone();
                    }
                }
                for (n2 = 0; n2 < tableModel.getRowCount(); ++n2) {
                    for (n = 0; n < tableModel.getColumnCount(); ++n) {
                        cellSpan = cellSpanArray[n2][n];
                        if (cellSpan == null) continue;
                        if (nArray[n2][n] == 0) {
                            nArray[n2][n] = 1;
                        }
                        for (int i = 0; i < cellSpan.getRowSpan(); ++i) {
                            for (int j = 0; j < cellSpan.getColumnSpan(); ++j) {
                                int n3 = cellSpan.getRow();
                                int n4 = cellSpan.getColumn();
                                String string = "(" + n3 + ", " + n4 + ")";
                                try {
                                    CellSpan cellSpan2 = cellSpanArray[n3 + i][n4 + j];
                                    String string2 = "(" + (n3 + i) + ", " + (n4 + j) + ")";
                                    if (cellSpan.equals(cellSpan2) || cellSpan2 == null) {
                                        if (nArray[n3 + i][n4 + j] != 0) continue;
                                        nArray[n3 + i][n4 + j] = 1;
                                        continue;
                                    }
                                    if (nArray[n3 + i][n4 + j] == 0) {
                                        nArray[n3 + i][n4 + j] = -1;
                                    }
                                    System.out.println("Cell at " + string2 + " has a different cell span from that of the anchor cell " + string);
                                    System.out.println("\t" + string + "-> " + cellSpan);
                                    System.out.println("\t" + string2 + "-> " + cellSpan2);
                                    continue;
                                }
                                catch (Exception exception) {
                                    System.out.println(exception.getClass().getName() + " " + exception.getLocalizedMessage());
                                    System.out.println("\tcell span is " + cellSpan + ", cell is (" + n2 + "," + n + ") wrong cell is (" + (n2 + i) + "," + (n + j) + ")");
                                }
                            }
                        }
                    }
                }
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static boolean verifyCellSpan(CellSpanTable cellSpanTable) {
        try {
            if (cellSpanTable instanceof CellSpanTable) {
                CellSpan cellSpan;
                int n;
                int n2;
                CellSpan[][] cellSpanArray = new CellSpan[cellSpanTable.getRowCount()][cellSpanTable.getColumnCount()];
                int[][] nArray = new int[cellSpanTable.getRowCount()][cellSpanTable.getColumnCount()];
                for (n2 = 0; n2 < cellSpanTable.getColumnCount(); ++n2) {
                    for (n = 0; n < cellSpanTable.getRowCount(); ++n) {
                        cellSpan = cellSpanTable.getCellSpanAt(n, n2);
                        cellSpanArray[n][n2] = cellSpan == null ? new CellSpan(n, n2, 1, 1) : (CellSpan)cellSpan.clone();
                    }
                }
                for (n2 = 0; n2 < cellSpanTable.getRowCount(); ++n2) {
                    for (n = 0; n < cellSpanTable.getColumnCount(); ++n) {
                        cellSpan = cellSpanArray[n2][n];
                        if (cellSpan == null) continue;
                        if (nArray[n2][n] == 0) {
                            nArray[n2][n] = 1;
                        }
                        for (int i = 0; i < cellSpan.getRowSpan(); ++i) {
                            for (int j = 0; j < cellSpan.getColumnSpan(); ++j) {
                                int n3 = cellSpan.getRow();
                                int n4 = cellSpan.getColumn();
                                String string = "(" + n3 + ", " + n4 + ")";
                                try {
                                    CellSpan cellSpan2 = cellSpanArray[n3 + i][n4 + j];
                                    String string2 = "(" + (n3 + i) + ", " + (n4 + j) + ")";
                                    if (cellSpan.equals(cellSpan2) || cellSpan2 == null) {
                                        if (nArray[n3 + i][n4 + j] != 0) continue;
                                        nArray[n3 + i][n4 + j] = 1;
                                        continue;
                                    }
                                    if (nArray[n3 + i][n4 + j] == 0) {
                                        nArray[n3 + i][n4 + j] = -1;
                                    }
                                    System.out.println("Cell at " + string2 + " has a different cell span from that of the anchor cell " + string);
                                    System.out.println("\t" + string + "-> " + cellSpan);
                                    System.out.println("\t" + string2 + "-> " + cellSpan2);
                                    continue;
                                }
                                catch (Exception exception) {
                                    System.out.println(exception.getClass().getName() + " " + exception.getLocalizedMessage());
                                    System.out.println("\tcell span is " + cellSpan + ", cell is (" + n2 + "," + n + ") wrong cell is (" + (n2 + i) + "," + (n + j) + ")");
                                }
                            }
                        }
                    }
                }
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            int n3 = this.originalRowAtPoint(rectangle.getLocation());
            return n3 < 0 || n3 >= this.getRowCount() ? this.getRowHeight() : this.getActualRowHeight(n3);
        }
        return super.getScrollableUnitIncrement(rectangle, n, n2);
    }

    public int getActualRowHeight(int n) {
        return this.getRowHeight(n);
    }

    protected List<CellSpan> getCache() {
        if (this._cache == null) {
            this._cache = this.createCellSpanCache();
        }
        return this._cache;
    }

    protected Set<Cell> getCacheEmpty() {
        if (this._cacheEmpty == null) {
            this._cacheEmpty = Collections.synchronizedSet(new HashSet());
        }
        return this._cacheEmpty;
    }

    public int getAutoCellMerge() {
        return this._autoCellMerge;
    }

    public void setAutoCellMerge(int n) {
        this._autoCellMerge = n;
        this.invalidateCellSpanCache();
        this.repaint();
    }

    private static class Cell {
        int x;
        int y;

        private Cell(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Cell cell = (Cell)object;
            return this.x == cell.x && this.y == cell.y;
        }

        public int hashCode() {
            int n = this.x;
            n = 31 * n + this.y;
            return n;
        }
    }

    protected static class DelegateAction
    extends AbstractAction {
        protected KeyStroke _keyStroke;
        protected Action _defaultAction;
        private static final long serialVersionUID = -3494274276033219168L;

        public DelegateAction(Action action, KeyStroke keyStroke) {
            this._defaultAction = action;
            this._keyStroke = keyStroke;
        }

        public Action getDefaultAction() {
            return this._defaultAction;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            CellSpan cellSpan;
            CellSpanTable cellSpanTable = (CellSpanTable)actionEvent.getSource();
            if (cellSpanTable.isCellSpanOn() && (cellSpan = cellSpanTable.getCellSpanAt(n2 = cellSpanTable.getSelectionModel().getLeadSelectionIndex(), n = cellSpanTable.getColumnModel().getSelectionModel().getLeadSelectionIndex())) != null && cellSpan.contains(n2, n)) {
                int n3 = this._keyStroke.getModifiers();
                switch (this._keyStroke.getKeyCode()) {
                    case 9: {
                        if (cellSpan.getColumnSpan() <= 1) break;
                        if (cellSpanTable.isEditing() && !cellSpanTable.getCellEditor().stopCellEditing()) {
                            return;
                        }
                        if ((n3 & 1) != 0) {
                            this.selectPreviousCell(cellSpanTable, cellSpan, n2);
                        } else {
                            this.selectNextCell(cellSpanTable, cellSpan, n2);
                        }
                        return;
                    }
                    case 39: {
                        if (cellSpan.getColumnSpan() <= 1) break;
                        if (cellSpanTable.isEditing() && !cellSpanTable.getCellEditor().stopCellEditing()) {
                            return;
                        }
                        this.selectNextCellInRow(cellSpanTable, cellSpan, n2, (n3 & 1) != 0);
                        return;
                    }
                    case 37: {
                        if (cellSpan.getColumnSpan() <= 1) break;
                        if (cellSpanTable.isEditing() && !cellSpanTable.getCellEditor().stopCellEditing()) {
                            return;
                        }
                        this.selectPreviousCellInRow(cellSpanTable, cellSpan, n2, (n3 & 1) != 0);
                        return;
                    }
                    case 40: {
                        if (cellSpan.getRowSpan() <= 1) break;
                        if (cellSpanTable.isEditing() && !cellSpanTable.getCellEditor().stopCellEditing()) {
                            return;
                        }
                        this.selectNextRow(cellSpanTable, cellSpan, n, (n3 & 1) != 0);
                        return;
                    }
                    case 38: {
                        if (cellSpan.getRowSpan() <= 1) break;
                        if (cellSpanTable.isEditing() && !cellSpanTable.getCellEditor().stopCellEditing()) {
                            return;
                        }
                        this.selectPreviousRow(cellSpanTable, cellSpan, n, (n3 & 1) != 0);
                        return;
                    }
                }
            }
            if (this._defaultAction != null) {
                this._defaultAction.actionPerformed(actionEvent);
            }
        }

        private void selectPreviousRow(CellSpanTable cellSpanTable, CellSpan cellSpan, int n, boolean bl) {
            int n2 = cellSpan.getRow() - 1;
            CellSpan cellSpan2 = cellSpanTable.getCellSpanAt(n2, n);
            if (cellSpan2 != null && cellSpan2.getRowSpan() > 1) {
                n2 = cellSpan2.getRow();
            }
            cellSpanTable.changeSelection(n2, n, false, bl);
        }

        private void selectNextRow(CellSpanTable cellSpanTable, CellSpan cellSpan, int n, boolean bl) {
            int n2 = cellSpan.getRow() + cellSpan.getRowSpan();
            if (n2 >= cellSpanTable.getRowCount()) {
                n2 = cellSpanTable.getRowCount() - 1;
            }
            cellSpanTable.changeSelection(n2, n, false, bl);
        }

        private void selectPreviousCellInRow(CellSpanTable cellSpanTable, CellSpan cellSpan, int n, boolean bl) {
            int n2 = cellSpan.getColumn() - 1;
            CellSpan cellSpan2 = cellSpanTable.getCellSpanAt(n, n2);
            if (cellSpan2 != null && cellSpan2.getColumnSpan() > 1) {
                n2 = cellSpan2.getColumn();
            }
            cellSpanTable.changeSelection(n, n2, false, bl);
        }

        private void selectNextCellInRow(CellSpanTable cellSpanTable, CellSpan cellSpan, int n, boolean bl) {
            int n2 = cellSpan.getColumn() + cellSpan.getColumnSpan();
            if (n2 >= cellSpanTable.getColumnCount()) {
                n2 = cellSpanTable.getColumnCount() - 1;
            }
            cellSpanTable.changeSelection(n, n2, false, bl);
        }

        private void selectPreviousCell(CellSpanTable cellSpanTable, CellSpan cellSpan, int n) {
            int n2 = cellSpan.getColumn() - 1;
            if (n2 < 0) {
                n2 = cellSpanTable.getColumnCount() - 1;
                if (--n < 0) {
                    n = cellSpanTable.getRowCount() - 1;
                }
            }
            cellSpanTable.changeSelection(n, n2, false, false);
        }

        private void selectNextCell(CellSpanTable cellSpanTable, CellSpan cellSpan, int n) {
            int n2 = cellSpan.getColumn() + cellSpan.getColumnSpan();
            if (n2 >= cellSpanTable.getColumnCount()) {
                n2 = 0;
                if (++n >= cellSpanTable.getRowCount()) {
                    n = 0;
                }
            }
            cellSpanTable.changeSelection(n, n2, false, false);
        }
    }
}

