/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

public class CellSpan
implements Cloneable {
    private int _row;
    private int _rowSpan;
    private int _column;
    private int _columnSpan;

    public CellSpan(int n, int n2, int n3, int n4) {
        this._row = n;
        this._column = n2;
        if (n3 <= 0) {
            throw new IllegalArgumentException("rowSpan must be a positive integer.");
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("columnSpan must be a positive integer.");
        }
        this._rowSpan = n3;
        this._columnSpan = n4;
    }

    public CellSpan(CellSpan cellSpan) {
        this._row = cellSpan.getRow();
        this._column = cellSpan.getColumn();
        this._rowSpan = cellSpan.getRowSpan();
        this._columnSpan = cellSpan.getColumnSpan();
    }

    public int getRow() {
        return this._row;
    }

    public void setRow(int n) {
        this._row = n;
    }

    public int getColumn() {
        return this._column;
    }

    public void setColumn(int n) {
        this._column = n;
    }

    public int getRowSpan() {
        return this._rowSpan;
    }

    public void setRowSpan(int n) {
        this._rowSpan = n;
    }

    public int getColumnSpan() {
        return this._columnSpan;
    }

    public void setColumnSpan(int n) {
        this._columnSpan = n;
    }

    public boolean contains(int n, int n2) {
        int n3 = this.getColumn();
        if (n2 < n3) {
            return false;
        }
        int n4 = this.getRow();
        if (n < n4) {
            return false;
        }
        int n5 = this.getColumnSpan();
        if (n5 < 0 || n5 + n3 <= n2) {
            return false;
        }
        int n6 = this.getRowSpan();
        return n6 >= 0 && n6 + n4 > n;
    }

    public String toString() {
        return "CellSpan(" + this._row + ", " + this._column + ", " + this._rowSpan + ", " + this._columnSpan + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CellSpan cellSpan = (CellSpan)object;
        if (this._column != cellSpan._column) {
            return false;
        }
        if (this._columnSpan != cellSpan._columnSpan) {
            return false;
        }
        if (this._row != cellSpan._row) {
            return false;
        }
        return this._rowSpan == cellSpan._rowSpan;
    }

    public int hashCode() {
        int n = this._row;
        n = 29 * n + this._rowSpan;
        n = 29 * n + this._column;
        n = 29 * n + this._columnSpan;
        return n;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new CellSpan(this._row, this._column, this._rowSpan, this._columnSpan);
        }
    }
}

