/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CategorizedTable
extends CellSpanTable {
    private boolean _init;
    public static final ImageIcon DEFAULT_ASCENDING_ICON = JideIconsFactory.getImageIcon("jide/direction_up.gif");
    public static final ImageIcon DEFAULT_DESCENDING_ICON = JideIconsFactory.getImageIcon("jide/direction_down.gif");
    private Icon _ascendingIcon = null;
    private Icon _descendingIcon = null;
    private Color _disabledBackground;
    private Color _disabledForeground;
    private Icon _expandedIcon;
    private Icon _collapsedIcon;
    private Icon _categoryExpandedIcon;
    private Icon _categoryCollapsedIcon;
    private Color _marginBackground;
    private boolean _paintMarginBackground = true;
    private boolean _useTableRendererForCategoryRow = false;
    public static final String PROPERTY_EXPAND_ICON_VISIBLE = "EXPAND_ICON_VISIBLE";
    private boolean _expandIconVisible = true;
    private boolean _useLnfDefaultSortIcon = true;

    public CategorizedTable() {
        this.initializeTable();
    }

    public CategorizedTable(TableModel tableModel) {
        super(tableModel);
        this.initializeTable();
    }

    public CategorizedTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initializeTable();
    }

    public CategorizedTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initializeTable();
    }

    public CategorizedTable(int n, int n2) {
        super(n, n2);
        this.initializeTable();
    }

    public CategorizedTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.initializeTable();
    }

    public CategorizedTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initializeTable();
    }

    private void initializeTable() {
        if (!this._init) {
            this.adjustGridColor();
            this.setAutoscrolls(true);
            this._init = true;
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.adjustGridColor();
    }

    private void adjustGridColor() {
        if (this.getGridColor() instanceof UIResource) {
            Color color = UIDefaultsLookup.getColor("CategorizedTable.gridLine");
            if (color == null) {
                Color color2;
                Color color3 = UIDefaultsLookup.getColor("Label.background");
                color = JideSwingUtilities.equals(color3, color2 = UIDefaultsLookup.getColor("Table.background")) ? UIDefaultsLookup.getColor("Table.gridLine") : color3;
            }
            if (color != null && !Color.BLACK.equals(color)) {
                this.setGridColor(color);
            }
        }
    }

    public Color getDisabledBackground() {
        if (this._disabledBackground != null) {
            return this._disabledBackground;
        }
        return this.getBackground();
    }

    public void setDisabledBackground(Color color) {
        this._disabledBackground = color;
    }

    public Color getDisabledForeground() {
        if (this._disabledForeground != null) {
            return this._disabledForeground;
        }
        return UIDefaultsLookup.getColor("textInactiveText");
    }

    public void setDisabledForeground(Color color) {
        this._disabledForeground = color;
    }

    public Icon getCategoryExpandedIcon() {
        if (this._categoryExpandedIcon != null) {
            return this._categoryExpandedIcon;
        }
        Icon icon = UIDefaultsLookup.getIcon("CategorizedTable.categoryExpandedIcon");
        if (icon != null) {
            return icon;
        }
        return UIDefaultsLookup.getIcon("Tree.expandedIcon");
    }

    public void setCategoryExpandedIcon(Icon icon) {
        this._categoryExpandedIcon = icon;
        this.repaint();
    }

    public Icon getCategoryCollapsedIcon() {
        if (this._categoryCollapsedIcon != null) {
            return this._categoryCollapsedIcon;
        }
        Icon icon = UIDefaultsLookup.getIcon("CategorizedTable.categoryCollapsedIcon");
        if (icon != null) {
            return icon;
        }
        return UIDefaultsLookup.getIcon("Tree.collapsedIcon");
    }

    public void setCategoryCollapsedIcon(Icon icon) {
        this._categoryCollapsedIcon = icon;
        this.repaint();
    }

    public Icon getExpandedIcon() {
        if (this._expandedIcon != null) {
            return this._expandedIcon;
        }
        Icon icon = UIDefaultsLookup.getIcon("CategorizedTable.expandedIcon");
        if (icon != null) {
            return icon;
        }
        return UIDefaultsLookup.getIcon("Tree.expandedIcon");
    }

    public Icon getExpandedIcon(int n) {
        return this.getExpandedIcon();
    }

    public Icon getCollapsedIcon(int n) {
        return this.getCollapsedIcon();
    }

    public void setExpandedIcon(Icon icon) {
        this._expandedIcon = icon;
        this.repaint();
    }

    public Icon getCollapsedIcon() {
        if (this._collapsedIcon != null) {
            return this._collapsedIcon;
        }
        Icon icon = UIDefaultsLookup.getIcon("CategorizedTable.collapsedIcon");
        if (icon != null) {
            return icon;
        }
        return UIDefaultsLookup.getIcon("Tree.collapsedIcon");
    }

    public void setCollapsedIcon(Icon icon) {
        this._collapsedIcon = icon;
        this.repaint();
    }

    public Icon getAscendingIcon() {
        if (this._ascendingIcon == null) {
            Icon icon;
            if (this.isUseLnfDefaultSortIcon() && (icon = UIDefaultsLookup.getIcon("Table.ascendingSortIcon")) != null) {
                return icon;
            }
            return DEFAULT_ASCENDING_ICON;
        }
        return this._ascendingIcon;
    }

    public void setAscendingIcon(Icon icon) {
        this._ascendingIcon = icon;
    }

    public Icon getDescendingIcon() {
        if (this._descendingIcon == null) {
            Icon icon;
            if (this.isUseLnfDefaultSortIcon() && (icon = UIDefaultsLookup.getIcon("Table.descendingSortIcon")) != null) {
                return icon;
            }
            return DEFAULT_DESCENDING_ICON;
        }
        return this._descendingIcon;
    }

    public void setDescendingIcon(Icon icon) {
        this._descendingIcon = icon;
    }

    public boolean isUseTableRendererForCategoryRow() {
        return this._useTableRendererForCategoryRow;
    }

    public void setUseTableRendererForCategoryRow(boolean bl) {
        this._useTableRendererForCategoryRow = bl;
        this.repaint();
    }

    public boolean isPaintMarginBackground() {
        return this._paintMarginBackground;
    }

    public void setPaintMarginBackground(boolean bl) {
        this._paintMarginBackground = bl;
        this.repaint();
    }

    public Color getMarginBackground() {
        if (this._marginBackground == null) {
            return this.getGridColor();
        }
        return this._marginBackground;
    }

    public void setMarginBackground(Color color) {
        this._marginBackground = color;
    }

    public boolean isExpandIconVisible() {
        return this._expandIconVisible;
    }

    public void setExpandIconVisible(boolean bl) {
        boolean bl2 = this._expandIconVisible;
        if (bl != this._expandIconVisible) {
            this._expandIconVisible = bl;
            this.firePropertyChange(PROPERTY_EXPAND_ICON_VISIBLE, bl2, this._expandIconVisible);
            this.repaint();
        }
    }

    public boolean isUseLnfDefaultSortIcon() {
        return this._useLnfDefaultSortIcon;
    }

    public void setUseLnfDefaultSortIcon(boolean bl) {
        this._useLnfDefaultSortIcon = bl;
        this.getTableHeader().revalidate();
        this.getTableHeader().repaint();
    }
}

