/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.grid.AddCalculatedColumnDialog;
import com.jidesoft.grid.CalculatedColumn;
import com.jidesoft.grid.CalculatedTableModel;
import com.jidesoft.grid.CalculatedTableModelResource;
import com.jidesoft.grid.ExpressionCalculatedColumn;
import com.jidesoft.list.DefaultDualListModel;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTitledBorder;
import com.jidesoft.swing.PartialEtchedBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class CalculatedTableModelColumnEditor
extends AbstractDialogPage {
    private TableModel _originalTableModel;
    private CalculatedTableModel _calculatedTableModel;
    private DefaultDualListModel _originalColumns;
    private JList _list;
    private JButton _editColumnButton;
    private ExpressionCalculatedColumn _editingColumn;
    public JButton _removeColumnButton;

    public CalculatedTableModelColumnEditor(TableModel tableModel) {
        this._originalTableModel = tableModel;
        this._calculatedTableModel = new CalculatedTableModel(this._originalTableModel);
        this._calculatedTableModel.addAllColumns();
        this._originalColumns = new DefaultDualListModel();
        int n = this._originalTableModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this._originalColumns.addElement(this._calculatedTableModel.getCalculatedColumnAt(i));
        }
    }

    @Override
    public void lazyInitialize() {
        this.initComponents();
    }

    protected void initComponents() {
        this._list = new JList(this._originalColumns);
        this._list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CalculatedColumn calculatedColumn;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = CalculatedTableModelColumnEditor.this._list.getSelectedIndex();
                if (n != -1 && (calculatedColumn = CalculatedTableModelColumnEditor.this._calculatedTableModel.getCalculatedColumnAt(n)) instanceof ExpressionCalculatedColumn) {
                    CalculatedTableModelColumnEditor.this._editColumnButton.setEnabled(true);
                    CalculatedTableModelColumnEditor.this._removeColumnButton.setEnabled(true);
                    CalculatedTableModelColumnEditor.this._editingColumn = (ExpressionCalculatedColumn)calculatedColumn;
                    return;
                }
                CalculatedTableModelColumnEditor.this._editColumnButton.setEnabled(false);
                CalculatedTableModelColumnEditor.this._removeColumnButton.setEnabled(false);
                CalculatedTableModelColumnEditor.this._editingColumn = null;
            }
        });
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent((JList<?>)jList, ((CalculatedColumn)object).getColumnName() + (object instanceof ExpressionCalculatedColumn ? " (" + ((ExpressionCalculatedColumn)object).getExpressionString() + ")" : ""), n, bl, bl2);
            }
        };
        this._list.setCellRenderer(defaultListCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this._list);
        final String string = this.getResourceString("AddCalculatedColumn.addColumn.text");
        JButton jButton = new JButton(new AbstractAction(string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Window window = JideSwingUtilities.getWindowForComponent(CalculatedTableModelColumnEditor.this);
                AddCalculatedColumnDialog addCalculatedColumnDialog = window instanceof Frame ? new AddCalculatedColumnDialog((Frame)window, string, "", "") : (window instanceof Dialog ? new AddCalculatedColumnDialog((Dialog)window, string, "", "") : new AddCalculatedColumnDialog((Frame)null, string, "", ""));
                addCalculatedColumnDialog.pack();
                addCalculatedColumnDialog.setLocationRelativeTo(CalculatedTableModelColumnEditor.this);
                addCalculatedColumnDialog.setVisible(true);
                if (addCalculatedColumnDialog.getDialogResult() == 0) {
                    String string3 = addCalculatedColumnDialog.getExpression();
                    String string2 = addCalculatedColumnDialog.getColumnName();
                    if (string3 != null && string3.trim().length() > 0) {
                        ExpressionCalculatedColumn expressionCalculatedColumn = new ExpressionCalculatedColumn((TableModel)CalculatedTableModelColumnEditor.this._calculatedTableModel, string2, string3);
                        CalculatedTableModelColumnEditor.this._calculatedTableModel.addColumn(expressionCalculatedColumn);
                        CalculatedTableModelColumnEditor.this._originalColumns.addElement(expressionCalculatedColumn);
                    }
                }
            }
        });
        jButton.setMnemonic(this.getResourceString("AddCalculatedColumn.addColumn.mnemonic").charAt(0));
        final String string2 = this.getResourceString("AddCalculatedColumn.editColumn.text");
        this._editColumnButton = new JButton(new AbstractAction(string2){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Window window = JideSwingUtilities.getWindowForComponent(CalculatedTableModelColumnEditor.this);
                AddCalculatedColumnDialog addCalculatedColumnDialog = window instanceof Frame ? new AddCalculatedColumnDialog((Frame)window, string2, "", "") : (window instanceof Dialog ? new AddCalculatedColumnDialog((Dialog)window, string2, "", "") : new AddCalculatedColumnDialog((Frame)null, string2, "", ""));
                addCalculatedColumnDialog.setColumnName(CalculatedTableModelColumnEditor.this._editingColumn.getColumnName());
                addCalculatedColumnDialog.setExpression(CalculatedTableModelColumnEditor.this._editingColumn.getExpressionString());
                addCalculatedColumnDialog.pack();
                addCalculatedColumnDialog.setLocationRelativeTo(CalculatedTableModelColumnEditor.this);
                addCalculatedColumnDialog.setVisible(true);
                if (addCalculatedColumnDialog.getDialogResult() == 0) {
                    String string = addCalculatedColumnDialog.getExpression();
                    String string22 = addCalculatedColumnDialog.getColumnName();
                    if (string != null && string.trim().length() > 0) {
                        CalculatedTableModelColumnEditor.this._editingColumn.setExpressionString(string);
                        CalculatedTableModelColumnEditor.this._editingColumn.setColumnName(string22);
                        CalculatedTableModelColumnEditor.this._list.repaint();
                    }
                }
            }
        });
        this._editColumnButton.setMnemonic(this.getResourceString("AddCalculatedColumn.editColumn.mnemonic").charAt(0));
        this._editColumnButton.setEnabled(false);
        String string3 = this.getResourceString("AddCalculatedColumn.removeColumn.text");
        this._removeColumnButton = new JButton(new AbstractAction(string3){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CalculatedTableModelColumnEditor.this._editingColumn != null) {
                    CalculatedTableModelColumnEditor.this._calculatedTableModel.removeColumn(CalculatedTableModelColumnEditor.this._editingColumn);
                    CalculatedTableModelColumnEditor.this._originalColumns.removeElement(CalculatedTableModelColumnEditor.this._editingColumn);
                    CalculatedTableModelColumnEditor.this._list.repaint();
                }
            }
        });
        this._removeColumnButton.setMnemonic(this.getResourceString("AddCalculatedColumn.removeColumn.mnemonic").charAt(0));
        this._removeColumnButton.setEnabled(false);
        ButtonPanel buttonPanel = new ButtonPanel(1);
        buttonPanel.addButton(jButton);
        buttonPanel.addButton(this._editColumnButton);
        buttonPanel.addButton(this._removeColumnButton);
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        jPanel.setBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), "Available Columns"));
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)buttonPanel, "After");
        this.setLayout(new BorderLayout(2, 2));
        this.add(jPanel);
    }

    public TableModel getCalculatedTableModel() {
        boolean bl = false;
        if (this._calculatedTableModel.getColumnCount() == this._originalTableModel.getColumnCount()) {
            for (int i = 0; i < this._calculatedTableModel.getColumnCount(); ++i) {
                if (JideSwingUtilities.equals(this._calculatedTableModel.getColumnName(i), this._originalTableModel.getColumnName(i))) continue;
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        return bl ? this._calculatedTableModel : this._originalTableModel;
    }

    protected String getResourceString(String string) {
        return this.getResourceBundle().getString(string);
    }

    public ResourceBundle getResourceBundle() {
        return CalculatedTableModelResource.getResourceBundle(this.getLocale());
    }
}

