/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CalculatedColumn;
import com.jidesoft.grid.CalculatedRowColumn;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.DefaultColumnTableModelWrapper;
import com.jidesoft.grid.DefaultWrappedRow;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SingleColumn;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class CalculatedTableModel
extends DefaultColumnTableModelWrapper {
    private List<CalculatedColumn> _columns = new ArrayList<CalculatedColumn>();
    private static final long serialVersionUID = -15725516731854441L;

    public CalculatedTableModel(TableModel tableModel) {
        super(tableModel);
    }

    public CalculatedColumn getCalculatedColumnAt(int n) {
        return n >= 0 && n < this._columns.size() ? this._columns.get(n) : null;
    }

    private boolean checkRange(int n) {
        return n >= 0 && n < this._columns.size();
    }

    @Override
    public int getActualColumnAt(int n) {
        if (!this.checkRange(n)) {
            return -1;
        }
        CalculatedColumn calculatedColumn = this.getCalculatedColumnAt(n);
        if (calculatedColumn instanceof SingleColumn && ((SingleColumn)calculatedColumn).getObjectGrouper() == null) {
            return ((SingleColumn)calculatedColumn).getColumnIndex();
        }
        return -1;
    }

    @Override
    public final int getVisualColumnAt(int n) {
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            CalculatedColumn calculatedColumn = this.getCalculatedColumnAt(i);
            if (!(calculatedColumn instanceof SingleColumn) || ((SingleColumn)calculatedColumn).getObjectGrouper() != null || ((SingleColumn)calculatedColumn).getColumnIndex() != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        CalculatedColumn calculatedColumn = this.getCalculatedColumnAt(n2);
        return calculatedColumn == null ? null : calculatedColumn.getValueAt(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        CalculatedColumn calculatedColumn = this.getCalculatedColumnAt(n2);
        if (calculatedColumn instanceof SingleColumn) {
            ((SingleColumn)calculatedColumn).setValueAt(object, n);
        }
    }

    @Override
    public int getColumnCount() {
        return this._columns.size();
    }

    @Override
    public String getColumnName(int n) {
        if (!this.checkRange(n)) {
            return "" + n;
        }
        return this.getCalculatedColumnAt(n).getColumnName();
    }

    @Override
    public Object getColumnIdentifier(int n) {
        if (!this.checkRange(n)) {
            return "" + n;
        }
        CalculatedColumn calculatedColumn = this.getCalculatedColumnAt(n);
        return calculatedColumn.getColumnIdentifier();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (!this.checkRange(n)) {
            return Object.class;
        }
        return this.getCalculatedColumnAt(n).getColumnClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        CalculatedColumn calculatedColumn = this.getCalculatedColumnAt(n2);
        return calculatedColumn instanceof SingleColumn && ((SingleColumn)calculatedColumn).isCellEditable(n);
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        if (!this.checkRange(n2)) {
            return Object.class;
        }
        CalculatedColumn calculatedColumn = this.getCalculatedColumnAt(n2);
        if (calculatedColumn != null) {
            return calculatedColumn.getCellClass(n);
        }
        return super.getCellClassAt(n, n2);
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        if (!this.checkRange(n2)) {
            return null;
        }
        CalculatedColumn calculatedColumn = this.getCalculatedColumnAt(n2);
        if (calculatedColumn != null) {
            return calculatedColumn.getConverterContext(n);
        }
        return super.getConverterContextAt(n, n2);
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        if (!this.checkRange(n2)) {
            return null;
        }
        CalculatedColumn calculatedColumn = this.getCalculatedColumnAt(n2);
        if (calculatedColumn != null) {
            return calculatedColumn.getEditorContext(n);
        }
        return super.getEditorContextAt(n, n2);
    }

    @Override
    public final int[] getIndexes() {
        throw new IllegalArgumentException("This method should not be used");
    }

    @Override
    public final void setIndexes(int[] nArray) {
        throw new IllegalArgumentException("This method should not be used");
    }

    protected int[] getDependingColumnsOf(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block0: for (int i = 0; i < this._columns.size(); ++i) {
            int[] nArray;
            CalculatedColumn calculatedColumn = this._columns.get(i);
            for (int n2 : nArray = calculatedColumn.getDependingColumns()) {
                if (n != n2) continue;
                arrayList.add(i);
                continue block0;
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    @Override
    protected void tableDataChanged(CompoundTableModelEvent compoundTableModelEvent) {
        if (compoundTableModelEvent == null || compoundTableModelEvent.getEvents() == null || compoundTableModelEvent.getEvents().length <= 0) {
            this.tableDataChanged();
            return;
        }
        CompoundTableModelEvent compoundTableModelEvent2 = this.createCompoundTableModelEvent();
        block5: for (TableModelEvent tableModelEvent : compoundTableModelEvent.getEvents()) {
            switch (tableModelEvent.getType()) {
                case 1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, 1));
                    continue block5;
                }
                case -1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, -1));
                    continue block5;
                }
                case 0: {
                    int[] nArray;
                    if (tableModelEvent.getFirstRow() == -1) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this, -1));
                        continue block5;
                    }
                    if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this));
                        continue block5;
                    }
                    if (tableModelEvent.getColumn() == -1) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, 0));
                        continue block5;
                    }
                    for (int n : nArray = this.getDependingColumnsOf(tableModelEvent.getColumn())) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n, 0));
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Embedded TableModelEvent type: " + tableModelEvent.getType());
                }
            }
        }
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent2);
    }

    @Override
    public void tableCellsUpdated(int n, int n2, int n3) {
        int[] nArray = this.getDependingColumnsOf(n);
        if (nArray != null && nArray.length == 1) {
            int n4 = nArray[0];
            super.fireTableCellsUpdated(n2, n3, n4);
        } else {
            super.fireTableRowsUpdated(n2, n3);
        }
    }

    public void addAllColumns() {
        TableModel tableModel = this.getActualModel();
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            SingleColumn singleColumn = new SingleColumn(tableModel, i);
            if (tableModel instanceof ColumnIdentifierTableModel) {
                singleColumn.setIdentifier(((ColumnIdentifierTableModel)((Object)tableModel)).getColumnIdentifier(i));
            }
            this._columns.add(singleColumn);
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(CalculatedColumn calculatedColumn) {
        this._columns.add(calculatedColumn);
        this.fireTableStructureChanged();
    }

    public void addColumns(Collection<CalculatedColumn> collection) {
        this._columns.addAll(collection);
        this.fireTableStructureChanged();
    }

    public void removeColumn(CalculatedColumn calculatedColumn) {
        this._columns.remove(calculatedColumn);
        this.fireTableStructureChanged();
    }

    public void removeColumns(Collection<CalculatedColumn> collection) {
        this._columns.removeAll(collection);
        this.fireTableStructureChanged();
    }

    @Override
    protected Row createWrappedRow(final ExpandableRow expandableRow) {
        return new DefaultWrappedRow(this, expandableRow){

            @Override
            public Object getValueAt(int n) {
                CalculatedColumn calculatedColumn = CalculatedTableModel.this.getCalculatedColumnAt(n);
                if (calculatedColumn instanceof CalculatedRowColumn) {
                    return ((CalculatedRowColumn)((Object)calculatedColumn)).getValueAt(expandableRow);
                }
                return super.getValueAt(n);
            }
        };
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(CalculatedTableModel.class.getName(), 4);
        }
    }
}

