/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.CheckBoxListChooserPanel;
import com.jidesoft.combobox.ListChooserPanel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.DefaultArrayConverter;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.filter.CustomFilterEditor;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.FilterFactoryManager;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.grid.AbstractDynamicTableFilter;
import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.CustomFilterEditorDialog;
import com.jidesoft.grid.CustomValueFilterListSelectionModel;
import com.jidesoft.grid.DynamicTableFilter;
import com.jidesoft.grid.FilterEditor;
import com.jidesoft.grid.FilterListCellRenderer;
import com.jidesoft.grid.FilterableTableModelEvent;
import com.jidesoft.grid.FilterableTableModelListener;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.GroupableTableModel;
import com.jidesoft.grid.HeaderLineWrapModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.SingleValueFilter;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortListener;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableCustomFilterEditor;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grouper.GrouperContext;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.grouper.ObjectGrouperManager;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import com.jidesoft.swing.ClickThroughLabel;
import com.jidesoft.swing.ClickThroughStyledLabel;
import com.jidesoft.swing.HeaderBox;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.ListSearchable;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SwingWorker;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class AutoFilterBox
extends HeaderBox
implements SortListener,
FilterableTableModelListener,
MouseListener,
MouseMotionListener {
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_SORT_ARROW_VISIBLE = "sortArrowVisible";
    public static final String PROPERTY_FILTER_INDICATOR_VISIBLE = "filterIndicatorVisible";
    public static final String PROPERTY_FILTER_BUTTON_VISIBLE = "filterButtonVisible";
    public static final String PROPERTY_ASCENDING = "ascending";
    public static final String PROPERTY_SORTED = "sorted";
    public static final String PROPERTY_POSSIBLE_VALUES = "possibleValues";
    protected JLabel _label;
    protected StyledLabel _sortArrow;
    protected AbstractButton _filterButton;
    private ListCellRenderer _listCellRenderer;
    private Object _headerValue;
    private Icon _descendingIcon = null;
    private Icon _ascendingIcon = null;
    private boolean _sortArrowVisible = true;
    private boolean _filterIndicatorVisible = true;
    private boolean _filterButtonVisible = true;
    private TableModel _tableModel;
    private IFilterableTableModel _filterableTableModel;
    protected int _filterableTableModelColumnIndex;
    private ISortableTableModel _sortableTableModel;
    private int _sortableTableModelColumnIndex;
    private GroupableTableModel _groupableTableModel;
    private int _groupableTableModelColumnIndex;
    private TableModel _actualTableModel;
    private int _actualTableModelColumnIndex;
    private int _tableColumnIndex;
    private int _modelColumnIndex;
    private Object[] _possibleValues;
    private PropertyChangeListener _propertyChangeListener;
    private boolean _showFilterName = false;
    private boolean _showFilterNameAsToolTip = false;
    private boolean _showFilterIcon = false;
    private boolean _showSortArrow = true;
    private boolean _allowMultipleValues = false;
    private boolean _allowCustomFilter = true;
    private boolean _preferSelectedValues = false;
    private boolean _multiLineMode = false;
    protected JComponent _filterField;
    private MouseInputListener _fieldMouseListener;
    private int _searchingDelay = 0;
    protected JPanel _labelPanel;
    protected JPanel _filterPanel;
    private MouseListener _filterPanelMouseListener;
    private boolean _useTableCellRenderer;
    private boolean _cellEditor;
    private StringConverter _titleConverter;
    private FilterTitleFormatter _filterTitleFormatter;
    protected Object HIDE_POPUP_KEY = null;
    private PopupPanel _popupPanel;
    private JidePopup _popup;
    private List<DynamicTableFilter> _dynamicFilters;
    private Component _target;

    public AutoFilterBox() {
        this.setHorizontalAlignment(10);
        this.setVerticalAlignment(0);
        this.initComponents("", null, false, false, false);
    }

    public void setTableModel(TableModel tableModel, int n, boolean bl) {
        this.setTableModel(tableModel, n, bl, false);
    }

    public void setTableModel(TableModel tableModel, int n, boolean bl, boolean bl2) {
        EventListener[] eventListenerArray;
        this.setCellEditor(bl);
        this._tableModel = tableModel;
        if (!bl2) {
            this._tableColumnIndex = n;
            this._modelColumnIndex = this.getTable().convertColumnIndexToModel(this._tableColumnIndex);
        } else {
            this._modelColumnIndex = n;
            this._tableColumnIndex = this.getTable().convertColumnIndexToView(this._modelColumnIndex);
        }
        this._actualTableModel = TableModelWrapperUtils.getActualTableModel(tableModel);
        this._actualTableModelColumnIndex = TableModelWrapperUtils.getActualColumnAt(tableModel, this._modelColumnIndex);
        if (this._filterableTableModel == null) {
            this._filterableTableModel = (IFilterableTableModel)TableModelWrapperUtils.getActualTableModel(tableModel, IFilterableTableModel.class);
        }
        this._filterableTableModelColumnIndex = TableModelWrapperUtils.getActualColumnAt(tableModel, this._modelColumnIndex, this._filterableTableModel);
        this._sortableTableModel = (ISortableTableModel)TableModelWrapperUtils.getActualTableModel(tableModel, ISortableTableModel.class);
        this._sortableTableModelColumnIndex = TableModelWrapperUtils.getActualColumnAt(tableModel, this._modelColumnIndex, this._sortableTableModel);
        this._groupableTableModel = (GroupableTableModel)TableModelWrapperUtils.getActualTableModel(tableModel, GroupableTableModel.class);
        this._groupableTableModelColumnIndex = TableModelWrapperUtils.getActualColumnAt(tableModel, this._modelColumnIndex, this._groupableTableModel);
        if (this._filterableTableModel != null) {
            eventListenerArray = this._filterableTableModel.getFilterableTableModelListeners();
            for (EventListener eventListener : eventListenerArray) {
                if (!(eventListener instanceof AutoFilterBox)) continue;
                this._filterableTableModel.removeFilterableTableModelListener((FilterableTableModelListener)eventListener);
            }
            this._filterableTableModel.addFilterableTableModelListener(this);
        }
        if (bl && this._sortableTableModel != null) {
            eventListenerArray = this._sortableTableModel.getSortListeners();
            for (EventListener eventListener : eventListenerArray) {
                if (!(eventListener instanceof AutoFilterBox)) continue;
                this._sortableTableModel.removeSortListener((SortListener)eventListener);
            }
            this._sortableTableModel.addSortListener(this);
        }
        boolean bl3 = this._filterableTableModel != null && this._filterableTableModelColumnIndex >= 0 && this._filterableTableModelColumnIndex < this._filterableTableModel.getColumnCount() && this._filterableTableModel.isColumnAutoFilterable(this._filterableTableModelColumnIndex);
        this.initComponents(this.internalGetText(this.getText()), null, this._sortableTableModel != null, bl3, bl);
    }

    @Override
    public void sortChanging(SortEvent sortEvent) {
    }

    @Override
    public void sortChanged(SortEvent sortEvent) {
        this.updateSortArrow();
    }

    @Override
    public void filterableTableModelChanged(FilterableTableModelEvent filterableTableModelEvent) {
        this.updateFilterIndicator(this._filterableTableModel);
    }

    public int getTableColumnIndex() {
        return this._tableColumnIndex;
    }

    public int getModelColumnIndex() {
        return this._modelColumnIndex;
    }

    private void updateSortArrow() {
        if (this._sortableTableModel != null) {
            if (this.isShowSortArrow()) {
                int n = this._sortableTableModelColumnIndex;
                boolean bl = this._sortableTableModel.isColumnSorted(n);
                if (bl) {
                    boolean bl2 = this._sortableTableModel.isColumnAscending(n);
                    int n2 = this._sortableTableModel.getColumnSortRank(n);
                    if (this._sortArrow != null) {
                        this.setSortArrowVisible(true);
                        this._sortArrow.setIcon(bl2 ? this.getAscendingIcon() : this.getDescendingIcon());
                        if (this._sortableTableModel.getSortingColumns().size() > 1) {
                            this._sortArrow.setText("" + (n2 + 1));
                            StyleRange styleRange = new StyleRange(0, 32, 1.1f);
                            this._sortArrow.addStyleRange(styleRange);
                        } else {
                            this._sortArrow.setText("");
                        }
                    }
                } else if (this._sortArrow != null) {
                    this.setSortArrowVisible(false);
                }
            } else if (this._sortArrow != null) {
                this.setSortArrowVisible(false);
            }
        }
    }

    protected void updateFilterIndicator(IFilterableTableModel iFilterableTableModel) {
        if (iFilterableTableModel != null) {
            Filter[] filterArray;
            int n = this._filterableTableModelColumnIndex;
            if (this.isShowFilterName()) {
                filterArray = iFilterableTableModel.getFilters(n);
                this.setText(this.formatColumnTitle(this.internalGetText(this.getText()), filterArray));
            } else {
                this.setText(this.internalGetText(this.getText()));
            }
            if (this.isShowFilterNameAsToolTip()) {
                filterArray = iFilterableTableModel.getFilters(n);
                this.setToolTipText(this.formatColumnTitle(this.internalGetText(this.getText()), filterArray));
            }
            if ((filterArray = this.internalGetIcon()) != null) {
                this.setIcon((Icon)filterArray);
            } else if (this.isFilterIconVisible()) {
                this.setIcon(iFilterableTableModel.getFilterIcon(n));
            } else {
                this.setIcon(null);
            }
        }
    }

    protected String formatColumnTitle(String string, Filter[] filterArray) {
        FilterTitleFormatter filterTitleFormatter = this.getFilterTitleFormatter();
        if (filterTitleFormatter != null) {
            return filterTitleFormatter.formatColumnTitle(string, filterArray);
        }
        if (filterArray == null || filterArray.length == 0) {
            return string;
        }
        if (filterArray[0] instanceof AutoFilterBoxFilterField.InternalFieldFilter) {
            return string + ": " + ((AutoFilterBoxFilterField.InternalFieldFilter)filterArray[0]).getSearchingText();
        }
        if (filterArray[0] instanceof NotFilter && ((NotFilter)filterArray[0]).getFilter() instanceof MultipleValuesFilter) {
            return string + ": ~" + ((NotFilter)filterArray[0]).getFilter().getName();
        }
        return string + ": " + filterArray[0].getName();
    }

    public FilterTitleFormatter getFilterTitleFormatter() {
        return this._filterTitleFormatter;
    }

    public void setFilterTitleFormatter(FilterTitleFormatter filterTitleFormatter) {
        this._filterTitleFormatter = filterTitleFormatter;
    }

    public boolean isMultiLineMode() {
        return this._multiLineMode;
    }

    public void setMultiLineMode(boolean bl) {
        if (this._multiLineMode != bl) {
            this._multiLineMode = bl;
            this.initComponents(this.internalGetText(this.getText()), null, this._sortableTableModel != null, this._filterableTableModel != null && this._filterableTableModel.isColumnAutoFilterable(this._filterableTableModelColumnIndex), this.isCellEditor());
        }
    }

    public boolean isUseTableCellRenderer() {
        return this._useTableCellRenderer;
    }

    public void setUseTableCellRenderer(boolean bl) {
        this._useTableCellRenderer = bl;
    }

    protected boolean isFiltered() {
        Filter[] filterArray;
        return this._filterableTableModel != null && (filterArray = this.getCurrentFilters()) != null && filterArray.length > 0;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (!(!this.isMultiLineMode() || this._labelPanel == null || SystemInfo.isJdk15Above() && this.isPreferredSizeSet())) {
            Insets insets = this.getInsets();
            return new Dimension(this._labelPanel.getPreferredSize().width + (insets == null ? 0 : insets.left + insets.right), dimension.height);
        }
        return dimension;
    }

    protected void initComponents(String string, Icon icon, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        this.removeAll();
        if (this._label == null) {
            this._label = new ClickThroughStyledLabel(string, icon, 10);
        } else {
            this._label.setText(string);
            this._label.setIcon(icon);
        }
        ((StyledLabel)this._label).setLineWrap(false);
        ((StyledLabel)this._label).setRows(-1);
        ((StyledLabel)this._label).setMaxRows(-1);
        ((StyledLabel)this._label).setMinRows(-1);
        ((StyledLabel)this._label).setPreferredWidth(-1);
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._tableModel, HeaderLineWrapModel.class);
        if (tableModel instanceof HeaderLineWrapModel) {
            int n = TableModelWrapperUtils.getActualColumnAt(this._tableModel, this._modelColumnIndex, tableModel);
            ((StyledLabel)this._label).setLineWrap(true);
            ((StyledLabel)this._label).setRows(((HeaderLineWrapModel)((Object)tableModel)).getPreferredRows(n));
            ((StyledLabel)this._label).setMaxRows(((HeaderLineWrapModel)((Object)tableModel)).getMaximumRows(n));
            ((StyledLabel)this._label).setMinRows(((HeaderLineWrapModel)((Object)tableModel)).getMinimumRows(n));
            ((StyledLabel)this._label).setPreferredWidth(((HeaderLineWrapModel)((Object)tableModel)).getPreferredWidth(n));
        }
        this._label.setHorizontalAlignment(this.getHorizontalAlignment());
        this._label.setVerticalAlignment(this.getVerticalAlignment());
        this._label.setForeground(this.getForeground());
        if (this._label instanceof ClickThroughLabel) {
            ((ClickThroughLabel)this._label).setTarget(this);
        }
        if (this._label instanceof ClickThroughStyledLabel) {
            ((ClickThroughStyledLabel)this._label).setTarget(this);
        }
        this._label.setOpaque(false);
        this._label.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        if (this._sortArrow == null) {
            this._sortArrow = new ClickThroughStyledLabel(this.getAscendingIcon());
        }
        this._sortArrow.setForeground(this.getForeground());
        if (this._sortArrow instanceof ClickThroughStyledLabel) {
            ((ClickThroughStyledLabel)this._sortArrow).setTarget(this);
        }
        this._sortArrow.setOpaque(false);
        this._sortArrow.setVerticalAlignment(0);
        this._sortArrow.setVisible(bl);
        if (this._filterButton == null) {
            this._filterButton = this.createDefaultButton();
        }
        if (bl3) {
            object = this._filterButton.getClientProperty("AutoFilterBox.MouseMotionAdapter");
            if (object == null) {
                MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent mouseEvent) {
                        AutoFilterBox.this.getModel().setRollover(true);
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        if (AutoFilterBox.this.isPopupVisible()) {
                            AutoFilterBox.this.hidePopup();
                        } else {
                            Object[] objectArray;
                            boolean bl = true;
                            int n = AutoFilterBox.this._filterableTableModelColumnIndex;
                            Comparator comparator = AutoFilterBox.this._sortableTableModel instanceof SortableTableModel ? ObjectComparatorManager.getComparator(AutoFilterBox.this._sortableTableModel.getColumnClass(AutoFilterBox.this._sortableTableModelColumnIndex), ((SortableTableModel)AutoFilterBox.this._sortableTableModel).getColumnComparatorContext(AutoFilterBox.this._sortableTableModelColumnIndex)) : ObjectComparatorManager.getComparator(AutoFilterBox.this._filterableTableModel.getColumnClass(n));
                            if (SystemInfo.isJdk15Above()) {
                                try {
                                    objectArray = Class.forName("com.jidesoft.grid.AutoFilterBox$DropDownSwingWorker");
                                    Class[] classArray = new Class[]{AutoFilterBox.class, IFilterableTableModel.class, Integer.TYPE, Comparator.class};
                                    Constructor constructor = objectArray.getConstructor(classArray);
                                    Object[] objectArray2 = new Object[]{AutoFilterBox.this, AutoFilterBox.this._filterableTableModel, n, comparator};
                                    Object t = constructor.newInstance(objectArray2);
                                    Method method = objectArray.getMethod("execute", null);
                                    method.invoke(t, null);
                                    bl = false;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            if (bl && (objectArray = !AutoFilterBox.this._filterableTableModel.isSameConverterAt(n) ? AutoFilterBox.this._filterableTableModel.getPossibleValuesAndConverters(n, comparator) : AutoFilterBox.this._filterableTableModel.getPossibleValues(n, comparator)) != null) {
                                AutoFilterBox.this.setPossibleValues(objectArray);
                                AutoFilterBox.this.showPopupPanelAsPopup();
                            }
                        }
                        mouseEvent.consume();
                    }
                };
                this._filterButton.addMouseMotionListener(mouseInputAdapter);
                this._filterButton.addMouseListener(mouseInputAdapter);
                this._filterButton.putClientProperty("AutoFilterBox.MouseMotionAdapter", mouseInputAdapter);
            }
        } else {
            object = this._filterButton.getClientProperty("AutoFilterBox.MouseMotionAdapter");
            if (object != null) {
                if (object instanceof MouseListener) {
                    this._filterButton.removeMouseListener((MouseListener)object);
                }
                if (object instanceof MouseMotionListener) {
                    this._filterButton.removeMouseMotionListener((MouseMotionListener)object);
                }
                this._filterButton.putClientProperty("AutoFilterBox.MouseMotionAdapter", null);
            }
        }
        if (bl3) {
            this.installListeners();
        }
        this.updateSortArrow();
        this.updateFilterIndicator(this._filterableTableModel);
        if (!this.isMultiLineMode() || this._tableColumnIndex < 0) {
            this.setBorder(BorderFactory.createEmptyBorder(1, 6, 1, 6));
            this.setBorderPainted(false);
            if (!(this.getLayout() instanceof JideBoxLayout)) {
                this.setLayout(new JideBoxLayout(this, 0, 2));
            }
            if (this._label.getParent() != this) {
                this.add(this._label);
            }
            if (this._sortArrow.getParent() != this) {
                this.add((Component)this._sortArrow, "fix");
            }
            if (this._filterButton.getParent() == null || this._filterButton.getParent().getParent() != this) {
                object = new JPanel();
                ((JComponent)object).setOpaque(false);
                ((Container)object).setLayout(new JideBoxLayout((Container)object, 1, 0));
                ((Container)object).add(Box.createGlue(), "flexible");
                ((Container)object).add((Component)this._filterButton, "fix");
                this.add((Component)object, "fix");
            }
            this._filterButton.setVisible(bl2 && this._tableColumnIndex >= 0);
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
            this.setBorderPainted(false);
            this.setLayout(new BorderLayout(3, 3));
            if (this._labelPanel == null) {
                this._labelPanel = new JPanel(new BorderLayout(3, 3));
            }
            if (this._label.getParent() != this._labelPanel) {
                this._labelPanel.add((Component)this._label, "Center");
            }
            if (this._sortArrow.getParent() != this._labelPanel) {
                this._labelPanel.add((Component)this._sortArrow, "After");
            }
            this._labelPanel.setOpaque(false);
            this.add((Component)this._labelPanel, "Center");
            this._filterPanel = new JPanel(new BorderLayout(3, 3));
            if (this._filterPanelMouseListener == null) {
                this._filterPanelMouseListener = new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, AutoFilterBox.this);
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, AutoFilterBox.this);
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, AutoFilterBox.this);
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, AutoFilterBox.this);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, AutoFilterBox.this);
                    }
                };
            }
            if (!JideSwingUtilities.isMouseListenerRegistered(this._filterPanel, this._filterPanelMouseListener)) {
                this._filterPanel.addMouseListener(this._filterPanelMouseListener);
            }
            this._filterPanel.setOpaque(false);
            if (this._filterField == null) {
                this._filterField = this.createFilterField();
            }
            if (this._filterField instanceof AutoFilterBoxFilterField) {
                ((AutoFilterBoxFilterField)this._filterField).setSearchingColumnIndices(new int[]{this._filterableTableModelColumnIndex});
                ((AutoFilterBoxFilterField)this._filterField).setSearchingDelay(this.getSearchingDelay());
            }
            if (this._fieldMouseListener == null) {
                this._fieldMouseListener = new MouseInputListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, AutoFilterBox.this);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseDragged(MouseEvent mouseEvent) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, AutoFilterBox.this);
                    }

                    @Override
                    public void mouseMoved(MouseEvent mouseEvent) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, AutoFilterBox.this);
                    }
                };
            }
            if (!JideSwingUtilities.isMouseListenerRegistered(this._filterField, this._fieldMouseListener)) {
                this._filterField.addMouseListener(this._fieldMouseListener);
            }
            if (!JideSwingUtilities.isMouseMotionListenerRegistered(this._filterField, this._fieldMouseListener)) {
                this._filterField.addMouseMotionListener(this._fieldMouseListener);
            }
            if (this._filterField.getParent() != this._filterPanel) {
                this._filterPanel.add((Component)this._filterField, "Center");
            }
            if (this._filterButton.getParent() != this._filterPanel) {
                this._filterPanel.add((Component)this._filterButton, "After");
            }
            if (this._filterPanel.getParent() != this) {
                this.add((Component)this._filterPanel, "Last");
            }
            if (bl3 && this.isRequestFocusForTextField()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AutoFilterBox.this._filterField instanceof AutoFilterBoxFilterField) {
                            ((AutoFilterBoxFilterField)AutoFilterBox.this._filterField).getTextField().requestFocusInWindow();
                        }
                    }
                });
            }
            this._filterField.setVisible(this._filterableTableModel.isColumnAutoFilterable(this._filterableTableModelColumnIndex));
            this._filterButton.setVisible(bl2 && this._filterableTableModel.isValuePredetermined(this._filterableTableModelColumnIndex));
            this._filterableTableModel.setAndMode(true);
            if (!this._filterButton.isVisible() && !this._filterField.isVisible()) {
                object = new JPanel();
                ((JComponent)object).setOpaque(false);
                ((JComponent)object).setPreferredSize(new Dimension(0, Math.max(this._filterButton.getPreferredSize().height, this._filterField.getPreferredSize().height)));
                this._filterPanel.add((Component)object, "After");
                if (!JideSwingUtilities.isMouseListenerRegistered(this._filterPanel, this._fieldMouseListener)) {
                    this._filterPanel.addMouseListener(this._fieldMouseListener);
                }
                if (!JideSwingUtilities.isMouseMotionListenerRegistered(this._filterPanel, this._fieldMouseListener)) {
                    this._filterPanel.addMouseMotionListener(this._fieldMouseListener);
                }
            }
        }
        this.customizeFilterField(this._filterField);
        this.updateFilterField(this._filterField);
    }

    protected JComponent createFilterField() {
        return new AutoFilterBoxFilterField(this._filterableTableModel);
    }

    protected void customizeFilterField(JComponent jComponent) {
    }

    protected void updateFilterField(JComponent jComponent) {
        if (this._filterableTableModel != null) {
            Filter[] filterArray = this.getCurrentFilters();
            if (jComponent instanceof AutoFilterBoxFilterField) {
                ((AutoFilterBoxFilterField)jComponent).uninstallListeners();
                boolean bl = false;
                for (Filter filter : filterArray) {
                    if (filter instanceof QuickTableFilterField.FieldTableFilter) {
                        String string = ((QuickTableFilterField.FieldTableFilter)filter).getSearchingText();
                        ((AutoFilterBoxFilterField)jComponent).setSearchingText(string);
                        bl = true;
                        break;
                    }
                    if (filter instanceof SingleValueFilter) {
                        ((AutoFilterBoxFilterField)jComponent).setSearchingText(this.convertElementToString(((SingleValueFilter)filter).getValue(), false, ((SingleValueFilter)filter).getObjectGrouper()));
                        bl = true;
                        break;
                    }
                    if (filter instanceof MultipleValuesFilter) {
                        ((AutoFilterBoxFilterField)jComponent).setSearchingText(this.convertElementToString(((MultipleValuesFilter)filter).getValues(), true, ((MultipleValuesFilter)filter).getObjectGrouper()));
                        bl = true;
                        break;
                    }
                    if (!(filter instanceof NotFilter) || !(((NotFilter)filter).getFilter() instanceof MultipleValuesFilter)) continue;
                    ((AutoFilterBoxFilterField)jComponent).setText(GridResource.getResourceBundle(this.getLocale()).getString("Filter.exclude") + this.convertElementToString(((MultipleValuesFilter)((NotFilter)filter).getFilter()).getValues(), true, ((MultipleValuesFilter)((NotFilter)filter).getFilter()).getObjectGrouper()));
                    bl = true;
                    break;
                }
                if (!bl) {
                    ((AutoFilterBoxFilterField)jComponent).setSearchingText("");
                }
                ((AutoFilterBoxFilterField)jComponent).installListeners();
            } else if (jComponent instanceof JTextField) {
                boolean bl = false;
                for (Filter filter : filterArray) {
                    if (filter instanceof SingleValueFilter) {
                        ((JTextField)jComponent).setText(this.convertElementToString(((SingleValueFilter)filter).getValue(), false, ((SingleValueFilter)filter).getObjectGrouper()));
                        bl = true;
                        break;
                    }
                    if (filter instanceof MultipleValuesFilter) {
                        ((JTextField)jComponent).setText(this.convertElementToString(((MultipleValuesFilter)filter).getValues(), true, ((MultipleValuesFilter)filter).getObjectGrouper()));
                        bl = true;
                        break;
                    }
                    if (!(filter instanceof NotFilter) || !(((NotFilter)filter).getFilter() instanceof MultipleValuesFilter)) continue;
                    ((JTextField)jComponent).setText(GridResource.getResourceBundle(this.getLocale()).getString("Filter.exclude") + this.convertElementToString(((MultipleValuesFilter)((NotFilter)filter).getFilter()).getValues(), true, ((MultipleValuesFilter)((NotFilter)filter).getFilter()).getObjectGrouper()));
                    bl = true;
                    break;
                }
                if (!bl) {
                    ((JTextField)jComponent).setText("");
                }
            }
        }
    }

    protected Filter[] getCurrentFilters() {
        if (this._filterableTableModel == null) {
            return new Filter[0];
        }
        return this._filterableTableModel.getFilters(this._filterableTableModelColumnIndex);
    }

    protected void installListeners() {
        if (!JideSwingUtilities.isMouseListenerRegistered(this, this)) {
            this.addMouseListener(this);
        }
        if (!JideSwingUtilities.isMouseMotionListenerRegistered(this, this)) {
            this.addMouseMotionListener(this);
        }
        if (this._propertyChangeListener != null) {
            this._propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (AutoFilterBox.PROPERTY_ASCENDING.equals(propertyChangeEvent.getPropertyName())) {
                        if (AutoFilterBox.this._sortArrow != null) {
                            AutoFilterBox.this._sortArrow.setIcon(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) ? AutoFilterBox.this.getAscendingIcon() : AutoFilterBox.this.getDescendingIcon());
                        }
                    } else if (AutoFilterBox.PROPERTY_SORTED.equals(propertyChangeEvent.getPropertyName())) {
                        if (AutoFilterBox.this._sortArrow != null) {
                            AutoFilterBox.this.setSortArrowVisible(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                        }
                    } else if ("horizontalAlignment".equals(propertyChangeEvent.getPropertyName())) {
                        AutoFilterBox.this._label.setHorizontalAlignment(AutoFilterBox.this.getHorizontalAlignment());
                    } else if ("verticalAlignment".equals(propertyChangeEvent.getPropertyName())) {
                        AutoFilterBox.this._label.setVerticalAlignment(AutoFilterBox.this.getVerticalAlignment());
                    }
                }
            };
        }
        if (!JideSwingUtilities.isListenerRegistered(this, PropertyChangeListener.class, (EventListener)this._propertyChangeListener)) {
            this.addPropertyChangeListener(this._propertyChangeListener);
        }
    }

    void uninstallListeners() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        if (this._propertyChangeListener != null) {
            this.removePropertyChangeListener(this._propertyChangeListener);
        }
        if (this._filterPanel != null && this._filterPanelMouseListener != null) {
            this._filterPanel.removeMouseListener(this._filterPanelMouseListener);
        }
        if (this._filterField != null && this._fieldMouseListener != null) {
            this._filterField.removeMouseListener(this._fieldMouseListener);
            this._filterField.removeMouseMotionListener(this._fieldMouseListener);
        }
        if (this._filterPanel != null && this._fieldMouseListener != null) {
            this._filterPanel.removeMouseListener(this._fieldMouseListener);
            this._filterPanel.removeMouseMotionListener(this._fieldMouseListener);
        }
    }

    public boolean isFilterIconVisible() {
        return this.isShowFilterIcon() && this.isFiltered();
    }

    public boolean isSortArrowVisible() {
        return this._sortArrowVisible;
    }

    public void setSortArrowVisible(boolean bl) {
        boolean bl2 = this._sortArrowVisible;
        if (bl2 != bl) {
            this._sortArrowVisible = bl;
            this.firePropertyChange(PROPERTY_SORT_ARROW_VISIBLE, bl2, this._sortArrowVisible);
        }
        this._sortArrow.setVisible(this._sortArrowVisible);
    }

    @Deprecated
    public boolean isFilterIndicatorVisible() {
        return this._filterIndicatorVisible;
    }

    @Deprecated
    public void setFilterIndicatorVisible(boolean bl) {
        boolean bl2 = this._filterIndicatorVisible;
        if (bl2 != bl) {
            this._filterIndicatorVisible = bl;
            this.firePropertyChange(PROPERTY_FILTER_INDICATOR_VISIBLE, bl2, this._filterIndicatorVisible);
        }
    }

    public boolean isFilterButtonVisible() {
        return this._filterButtonVisible;
    }

    Component getFilterButton() {
        return this._filterButton;
    }

    public void setFilterButtonVisible(boolean bl) {
        boolean bl2 = this._filterButtonVisible;
        if (bl2 != bl) {
            this._filterButtonVisible = bl;
            this.firePropertyChange(PROPERTY_FILTER_BUTTON_VISIBLE, bl2, bl);
        }
        this._filterButton.setVisible(this._filterButtonVisible);
    }

    @Override
    public void setText(String string) {
        if (this._label != null) {
            this._label.setText(string);
        } else {
            super.setText(string);
        }
    }

    @Override
    public void setFont(Font font) {
        if (this._label != null) {
            this._label.setFont(font);
        } else {
            super.setFont(font);
        }
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
    }

    private String internalGetText(String string) {
        StringConverter stringConverter = this.getTitleConverter();
        return stringConverter != null ? stringConverter.convert(string) : string;
    }

    private Icon internalGetIcon() {
        int n;
        JTable jTable = this.getTable();
        if (jTable != null && (n = this.getTableColumnIndex()) >= 0 && n < jTable.getColumnModel().getColumnCount()) {
            Object object = jTable.getColumnModel().getColumn(n).getHeaderValue();
            return object instanceof Icon ? (Icon)object : null;
        }
        return null;
    }

    void setHeaderValue(Object object) {
        this._headerValue = object;
    }

    @Override
    public String getText() {
        JTable jTable = this.getTable();
        if (jTable != null || this.getTableColumnIndex() < 0) {
            int n = this.getTableColumnIndex();
            if (n >= 0 && jTable != null && n < jTable.getColumnModel().getColumnCount()) {
                Object object = jTable.getColumnModel().getColumn(n).getHeaderValue();
                return object != null && !(object instanceof Icon) ? "" + object : "";
            }
            if (this._headerValue != null) {
                return this._headerValue.toString();
            }
            return null;
        }
        int n = this.getModelColumnIndex();
        return this._tableModel != null && n >= 0 && n < this._tableModel.getColumnCount() ? this._tableModel.getColumnName(n) : null;
    }

    @Override
    public void setIcon(Icon icon) {
        if (this._label != null) {
            this._label.setIcon(icon);
        }
    }

    public boolean isAscending() {
        if (this._sortableTableModel != null) {
            return this._sortableTableModel.isColumnAscending(this._sortableTableModelColumnIndex);
        }
        return false;
    }

    public void toggleSortOrder() {
        if (this._sortableTableModel != null) {
            this._sortableTableModel.toggleSortOrder(this._sortableTableModelColumnIndex, false);
        }
    }

    public void toggleSortOrder(boolean bl) {
        if (this._sortableTableModel != null) {
            this._sortableTableModel.toggleSortOrder(this._sortableTableModelColumnIndex, bl);
        }
    }

    public void setAscending(boolean bl) {
        boolean bl2 = this.isAscending();
        if (bl2 != bl && this._sortableTableModel != null) {
            int n = this._sortableTableModelColumnIndex;
            if (bl != this._sortableTableModel.isColumnAscending(n)) {
                this._sortableTableModel.sortColumn(n, true, bl);
            }
            this.firePropertyChange(PROPERTY_ASCENDING, bl2, bl);
        }
    }

    public boolean isSorted() {
        if (this._sortableTableModel != null) {
            this._sortableTableModel.isColumnSorted(this._sortableTableModelColumnIndex);
        }
        return false;
    }

    public void setSorted(boolean bl) {
        boolean bl2 = this.isSorted();
        if (bl2 != bl && this._sortableTableModel != null) {
            int n = this._sortableTableModelColumnIndex;
            boolean bl3 = this._sortableTableModel.isColumnSorted(n);
            if (bl && !bl3) {
                this._sortableTableModel.sortColumn(n);
            } else if (!bl && bl3) {
                this._sortableTableModel.unsortColumn(n);
            }
            this.firePropertyChange(PROPERTY_SORTED, bl2, bl);
        }
    }

    public Object[] getPossibleValues() {
        return this._possibleValues;
    }

    public void setPossibleValues(Object[] objectArray) {
        Object[] objectArray2 = this._possibleValues;
        this._possibleValues = objectArray;
        this.firePropertyChange(PROPERTY_POSSIBLE_VALUES, objectArray2, objectArray);
        if (this._filterButton != null) {
            this._filterButton.setEnabled(this._possibleValues != null);
        }
    }

    protected void applyFilters(Filter[] filterArray, int n) {
        this.applyFilters(filterArray, n, true);
    }

    protected void applyFilters(Filter[] filterArray, int n, boolean bl) {
        if (filterArray != null && filterArray.length == 1) {
            this.applyFilter(filterArray[0], n, bl);
            return;
        }
        JTable jTable = this.getTable();
        TableUtils.stopCellEditingForAll(jTable);
        if (this._filterableTableModel != null) {
            Filter[] filterArray2;
            if (bl && (filterArray2 = this._filterableTableModel.getFilters(n)) != null) {
                Filter[] filterArray3 = filterArray2;
                int n2 = filterArray3.length;
                for (int i = 0; i < n2; ++i) {
                    Filter filter = filterArray3[i];
                    if (filter instanceof SingleValueFilter) {
                        this._filterableTableModel.removeFilter(n, filter);
                        continue;
                    }
                    if (filter instanceof MultipleValuesFilter) {
                        this._filterableTableModel.removeFilter(n, filter);
                        continue;
                    }
                    if (filter instanceof NotFilter && ((NotFilter)filter).getFilter() instanceof MultipleValuesFilter) {
                        this._filterableTableModel.removeFilter(n, filter);
                        continue;
                    }
                    if (filter instanceof DynamicTableFilter) {
                        this._filterableTableModel.removeFilter(n, filter);
                        continue;
                    }
                    if (filter.getFilterFactory() == null) continue;
                    this._filterableTableModel.removeFilter(n, filter);
                }
            }
            if (filterArray != null) {
                for (Filter filter : filterArray) {
                    if (filter == null) continue;
                    this._filterableTableModel.addFilter(n, filter);
                }
            }
            this._filterableTableModel.setFiltersApplied(true);
            if (jTable != null) {
                TableUtils.ensureRowSelectionVisible(jTable);
            }
        }
        this.updateFilterField(this._filterField);
    }

    protected void applyFilter(Filter filter, int n) {
        this.applyFilter(filter, n, true);
    }

    protected void applyFilter(Filter filter, int n, boolean bl) {
        JTable jTable = this.getTable();
        TableUtils.stopCellEditingForAll(jTable);
        if (this._filterableTableModel != null) {
            Filter[] filterArray;
            if (bl && (filterArray = this._filterableTableModel.getFilters(n)) != null) {
                for (Filter filter2 : filterArray) {
                    if (filter2 instanceof SingleValueFilter) {
                        this._filterableTableModel.removeFilter(n, filter2);
                        continue;
                    }
                    if (filter2 instanceof MultipleValuesFilter) {
                        this._filterableTableModel.removeFilter(n, filter2);
                        continue;
                    }
                    if (filter2 instanceof NotFilter && ((NotFilter)filter2).getFilter() instanceof MultipleValuesFilter) {
                        this._filterableTableModel.removeFilter(n, filter2);
                        continue;
                    }
                    if (filter2 instanceof DynamicTableFilter) {
                        this._filterableTableModel.removeFilter(n, filter2);
                        continue;
                    }
                    if (filter2 instanceof AutoFilterBoxFilterField.InternalFieldFilter) {
                        this._filterableTableModel.removeFilter(n, filter2);
                        continue;
                    }
                    if (filter2.getFilterFactory() == null) continue;
                    this._filterableTableModel.removeFilter(n, filter2);
                }
            }
            if (filter != null) {
                this._filterableTableModel.addFilter(n, filter);
            }
            this._filterableTableModel.setFiltersApplied(true);
            if (jTable != null) {
                TableUtils.ensureRowSelectionVisible(jTable);
            }
        }
        this.updateFilterField(this._filterField);
    }

    protected JTable getTable() {
        if (this.getTarget() instanceof JTableHeader) {
            return ((JTableHeader)this.getTarget()).getTable();
        }
        return null;
    }

    protected AbstractButton createDefaultButton() {
        int n;
        Object object;
        JComponent jComponent;
        boolean bl;
        AbstractButton abstractButton = null;
        boolean bl2 = !UIDefaultsLookup.getBoolean("AbstractComboBox.useJButton");
        boolean bl3 = bl = LookAndFeelFactory.isLnfInstalled("apple.laf.AquaLookAndFeel") && LookAndFeelFactory.isLnfInUse("apple.laf.AquaLookAndFeel") || LookAndFeelFactory.isLnfInstalled("com.apple.laf.AquaLookAndFeel") && LookAndFeelFactory.isLnfInUse("com.apple.laf.AquaLookAndFeel");
        if (!bl) {
            try {
                jComponent = new JComboBox();
                ((JComboBox)jComponent).setEnabled(this.isEnabled());
                ((JComboBox)jComponent).setEditable(true);
                jComponent.doLayout();
                Component[] componentArray = object = jComponent.getComponents();
                int n2 = componentArray.length;
                for (n = 0; n < n2; ++n) {
                    MouseListener[] mouseListenerArray;
                    Component component = componentArray[n];
                    if (!(component instanceof AbstractButton)) continue;
                    abstractButton = (AbstractButton)component;
                    abstractButton.setBorder(BorderFactory.createEmptyBorder());
                    Dimension dimension = abstractButton.getPreferredSize();
                    int n3 = jComponent.getPreferredSize().height;
                    Insets insets = jComponent.getInsets();
                    int n4 = n3 - (insets != null ? insets.top + insets.bottom : 0);
                    if (dimension.height < 16) {
                        dimension.height = n4;
                    }
                    if (dimension.width < 16) {
                        dimension.width = n4;
                    }
                    abstractButton.setPreferredSize(dimension);
                    abstractButton.setMaximumSize(dimension);
                    for (MouseListener mouseListener : mouseListenerArray = abstractButton.getMouseListeners()) {
                        if (mouseListener instanceof BasicButtonListener) continue;
                        abstractButton.removeMouseListener(mouseListener);
                    }
                    abstractButton.setRequestFocusEnabled(false);
                    abstractButton.setFocusable(false);
                    this.HIDE_POPUP_KEY = abstractButton.getClientProperty("doNotCancelPopup");
                    abstractButton.putClientProperty("doNotCancelPopup", null);
                    break;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (!bl2 || abstractButton == null) {
            jComponent = bl ? new JideButton(JideIconsFactory.getImageIcon("jide/direction_down.gif")) : new JButton(JideIconsFactory.getImageIcon("jide/direction_down.gif"));
            jComponent.setRequestFocusEnabled(false);
            jComponent.setFocusable(false);
            jComponent.putClientProperty("doNotCancelPopup", null);
            ((AbstractButton)jComponent).setMargin(abstractButton != null ? abstractButton.getMargin() : new Insets(0, 0, 0, 0));
            if (abstractButton != null) {
                object = abstractButton.getPreferredSize();
                if (object.height < 16) {
                    int n5 = this.getHeight();
                    Insets insets = this.getInsets();
                    object.height = n = n5 - (insets.top + insets.bottom);
                    object.width = n;
                }
                jComponent.setPreferredSize((Dimension)object);
                jComponent.setMaximumSize((Dimension)object);
            } else {
                jComponent.setPreferredSize(new Dimension(16, 16));
                jComponent.setMaximumSize(jComponent.getPreferredSize());
            }
            ((AbstractButton)jComponent).setEnabled(this.isEnabled());
            return jComponent;
        }
        return abstractButton;
    }

    protected JidePopup createPopupWindow() {
        JidePopup jidePopup = JidePopupFactory.getSharedInstance().createPopup();
        jidePopup.setDetached(false);
        jidePopup.setResizable(false);
        if (!LookAndFeelFactory.isLnfInUse("com.apple.laf.AquaLookAndFeel") && !LookAndFeelFactory.isLnfInUse("apple.laf.AquaLookAndFeel")) {
            jidePopup.setPopupBorder(UIDefaultsLookup.getBorder("PopupMenu.border"));
        }
        return jidePopup;
    }

    private void showPopupPanelAsPopup() {
        Object object;
        Object[] objectArray = this.getPossibleValues();
        if (objectArray == null) {
            return;
        }
        this._popupPanel = this.createPopupPanel(this._tableModel, this.getModelColumnIndex(), objectArray);
        JideSwingUtilities.putClientPropertyRecursively(this._popupPanel, "doNotCancelPopup", this.HIDE_POPUP_KEY);
        this._popup = this.createPopupWindow();
        Container container = SwingUtilities.getAncestorOfClass(JTableHeader.class, this._filterButton);
        this._popup.setOwner(container != null ? container : this._filterButton);
        this._popup.removeExcludedComponent(container);
        this._popup.addExcludedComponent(this._filterButton);
        this._popup.add(this._popupPanel);
        if (this._popupPanel.isStretchToFit() && this._popupPanel.getActualPreferredSize().width != this.getWidth()) {
            object = this._popup.getPopupBorder();
            int n = 0;
            if (object != null) {
                Insets insets = object.getBorderInsets(this._popupPanel);
                n = insets.left + insets.right;
            }
            int n2 = Math.max(this._popupPanel.getActualPreferredSize().width, this.getWidth() - n);
            this._popupPanel.setPreferredSize(new Dimension(n2, this._popupPanel.getPreferredSize().height));
        }
        if (!this._popup.isPopupVisible()) {
            object = this.calculatePopupLocation();
            if (this._popupPanel.getDefaultFocusComponent() != null) {
                this._popup.setDefaultFocusComponent(this._popupPanel.getDefaultFocusComponent());
            }
            this._popup.setResizable(this._popupPanel.isResizable());
            try {
                this._popup.showPopup(((Point)object).x, ((Point)object).y);
                if (this._popupPanel.isResizable()) {
                    this._popup.setupResizeCorner(this._popupPanel.getResizableCorners());
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {}
        } else {
            this.hidePopup();
            this._popup = null;
        }
    }

    public Object[] getPossibleValues(ObjectGrouper objectGrouper, Object[] objectArray, Comparator comparator) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        boolean bl = false;
        for (Object object2 : objectArray) {
            object = objectGrouper.getValue(object2);
            if (object != null) {
                hashSet.add(object);
                continue;
            }
            bl = true;
        }
        Iterator iterator = hashSet.iterator();
        Object[] objectArray2 = new Object[bl ? hashSet.size() + 1 : hashSet.size()];
        int n = 0;
        if (bl) {
            objectArray2[n] = null;
            ++n;
        }
        boolean bl2 = true;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (bl2 && comparator == null && !(object instanceof Comparable)) {
                bl2 = false;
            }
            objectArray2[n++] = object;
        }
        if (bl2) {
            try {
                if (objectArray2.length >= 2) {
                    if (bl) {
                        Arrays.sort(objectArray2, 1, objectArray2.length, comparator);
                    } else {
                        Arrays.sort(objectArray2, comparator);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectArray2;
    }

    protected PopupPanel createPopupPanel(TableModel tableModel, int n, Object[] objectArray) {
        Object object;
        Object[] objectArray2;
        ObjectGrouper objectGrouper;
        GrouperContext grouperContext;
        GrouperContext grouperContext2 = grouperContext = this._groupableTableModel != null && this._groupableTableModelColumnIndex >= 0 ? this._groupableTableModel.getGrouperContext(this._groupableTableModelColumnIndex) : null;
        ObjectGrouper objectGrouper2 = grouperContext != null && !grouperContext.isUseOnAutoFilter() ? null : (objectGrouper = this._groupableTableModel != null && this._groupableTableModelColumnIndex >= 0 ? ObjectGrouperManager.getGrouper(this._groupableTableModel.getColumnClass(this._groupableTableModelColumnIndex), grouperContext) : null);
        if (objectArray != null && objectArray.length > 1 && objectArray[objectArray.length - 1] instanceof ConverterContext) {
            objectArray2 = new Object[objectArray.length >> 1];
            object = new Object[objectArray.length >> 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
            System.arraycopy(objectArray, objectArray2.length, object, 0, ((DynamicTableFilter[])object).length);
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = ObjectConverterManager.toString(objectArray2[i], tableModel.getColumnClass(n), object[i] instanceof ConverterContext ? (ConverterContext)((Object)object[i]) : null);
            }
        } else if (objectGrouper != null) {
            object = ObjectComparatorManager.getComparator(objectGrouper.getType(), objectGrouper.getComparatorContext());
            objectArray2 = this.getPossibleValues(objectGrouper, objectArray, (Comparator)object);
        } else {
            objectArray2 = objectArray;
        }
        object = this.getDynamicTableFilters();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray2);
        int n2 = this.isAllowCustomFilter() ? 2 : 1;
        defaultComboBoxModel.insertElementAt("(All)", 0);
        if (this.isAllowCustomFilter()) {
            defaultComboBoxModel.insertElementAt("(Custom...)", 1);
        }
        for (int i = 0; i < ((DynamicTableFilter[])object).length; ++i) {
            DynamicTableFilter dynamicTableFilter = object[i];
            defaultComboBoxModel.insertElementAt(dynamicTableFilter, i + n2);
        }
        PopupPanel popupPanel = this.isAllowMultipleValues() ? this.createCheckBoxListChooserPanel(tableModel, n, objectArray, objectGrouper, defaultComboBoxModel) : this.createListChooserPanel(tableModel, n, objectArray, objectGrouper, defaultComboBoxModel);
        popupPanel.setResizable(true);
        popupPanel.setResizableCorners(16);
        return popupPanel;
    }

    protected PopupPanel createListChooserPanel(final TableModel tableModel, final int n, final Object[] objectArray, final ObjectGrouper objectGrouper, final DefaultComboBoxModel defaultComboBoxModel) {
        boolean bl;
        boolean bl2 = bl = objectArray != null && objectArray.length > 1 && objectArray[objectArray.length - 1] instanceof ConverterContext;
        ListChooserPanel listChooserPanel = new ListChooserPanel(defaultComboBoxModel, bl ? String.class : (objectGrouper != null ? objectGrouper.getType() : tableModel.getColumnClass(n))){

            @Override
            protected JList createList(ComboBoxModel comboBoxModel) {
                Object object;
                ListCellRenderer listCellRenderer;
                JList jList = super.createList(comboBoxModel);
                jList.setLocale(AutoFilterBox.this.getLocale());
                SearchableUtils.installSearchable(jList);
                ConverterContext converterContext = null;
                if (!bl && tableModel instanceof ContextSensitiveTableModel) {
                    converterContext = ((ContextSensitiveTableModel)tableModel).getConverterContextAt(0, n);
                }
                if ((listCellRenderer = AutoFilterBox.this.getListCellRenderer()) != null) {
                    this.setRenderer(listCellRenderer);
                } else if (!bl) {
                    object = new FilterListCellRenderer(objectGrouper != null ? objectGrouper.getType() : tableModel.getColumnClass(n), objectGrouper != null ? objectGrouper.getConverterContext() : converterContext);
                    this.setRenderer((ListCellRenderer)object);
                    if (tableModel instanceof ContextSensitiveTableModel && AutoFilterBox.this.isUseTableCellRenderer()) {
                        ((FilterListCellRenderer)object).setEditorContext(((ContextSensitiveTableModel)tableModel).getEditorContextAt(0, n));
                        ((FilterListCellRenderer)object).setTable(AutoFilterBox.this.getTable());
                        ((FilterListCellRenderer)object).setColumnIndex(AutoFilterBox.this.getTableColumnIndex());
                    }
                }
                AutoFilterBox.this.customizeList(jList);
                object = AutoFilterBox.this.getCurrentFilters();
                if (((Filter[])object).length == 0) {
                    jList.setSelectedIndex(0);
                } else if (object[0] instanceof SingleValueFilter) {
                    SingleValueFilter singleValueFilter = (SingleValueFilter)object[0];
                    singleValueFilter.setObjectGrouper(objectGrouper);
                    if (!bl) {
                        jList.setSelectedValue(singleValueFilter.getValue(), true);
                    } else {
                        Object t = singleValueFilter.getValue();
                        if (t != null) {
                            for (int i = 0; i < objectArray.length >> 1; ++i) {
                                if (!t.equals(objectArray[i])) continue;
                                jList.setSelectedIndex(i + (AutoFilterBox.this.isAllowCustomFilter() ? 2 : 1));
                                break;
                            }
                        }
                    }
                } else if (object[0] instanceof DynamicTableFilter) {
                    jList.setSelectedValue(object[0], true);
                } else if (object[0] != null && object[0].getFilterFactory() != null) {
                    jList.setSelectedIndex(1);
                }
                return jList;
            }
        };
        if (this.getTable() != null) {
            listChooserPanel.setLocale(this.getTable().getLocale());
        }
        listChooserPanel.setMaximumRowCount(8);
        listChooserPanel.setDefaultFocusComponent(listChooserPanel.getList());
        listChooserPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Object object = itemEvent.getItem();
                    if ("(All)".equals(object)) {
                        AutoFilterBox.this.applyFilter(null, AutoFilterBox.this._filterableTableModelColumnIndex);
                    } else if ("(Custom...)".equals(object)) {
                        AutoFilterBox.this.showCustomFilterEditor(AutoFilterBox.this._filterableTableModel, AutoFilterBox.this._filterableTableModelColumnIndex, objectArray);
                    } else if (object instanceof DynamicTableFilter) {
                        DynamicTableFilter dynamicTableFilter = (DynamicTableFilter)object;
                        if (AutoFilterBox.this._actualTableModelColumnIndex >= 0 && dynamicTableFilter.initializeFilter(AutoFilterBox.this._actualTableModel, AutoFilterBox.this._actualTableModelColumnIndex, AutoFilterBox.this.getPossibleValues())) {
                            AutoFilterBox.this.applyFilter(dynamicTableFilter, AutoFilterBox.this._filterableTableModelColumnIndex);
                        } else {
                            AutoFilterBox.this.applyFilter(null, AutoFilterBox.this._filterableTableModelColumnIndex);
                        }
                    } else {
                        int n;
                        SingleValueFilter singleValueFilter = null;
                        if (objectGrouper != null) {
                            singleValueFilter = AutoFilterBox.this._filterableTableModel.createSingleValueFilter(object);
                            singleValueFilter.setObjectGrouper(objectGrouper);
                            singleValueFilter.setName(ObjectConverterManager.toString(object, objectGrouper.getType(), objectGrouper.getConverterContext()));
                        } else if (objectArray != null && objectArray.length > 0 && (n = defaultComboBoxModel.getIndexOf(object) - defaultComboBoxModel.getIndexOf(objectArray[0])) >= 0 && n < objectArray.length) {
                            object = objectArray[n];
                            singleValueFilter = AutoFilterBox.this._filterableTableModel.createSingleValueFilter(object);
                            if (!bl || n >= objectArray.length >> 1) {
                                singleValueFilter.setName(AutoFilterBox.this.convertElementToString(object));
                            } else {
                                Object object2 = objectArray[n + (objectArray.length >> 1)];
                                singleValueFilter.setName(object2 == null || object2 instanceof ConverterContext ? AutoFilterBox.this.convertElementToString(object, (ConverterContext)object2) : AutoFilterBox.this.convertElementToString(object));
                            }
                        }
                        if (singleValueFilter != null) {
                            AutoFilterBox.this.applyFilter(singleValueFilter, AutoFilterBox.this._filterableTableModelColumnIndex);
                        }
                    }
                    AutoFilterBox.this.hidePopup();
                    AutoFilterBox.this.updateFilterIndicator(AutoFilterBox.this._filterableTableModel);
                }
            }
        });
        return listChooserPanel;
    }

    protected void showCustomFilterEditor(IFilterableTableModel iFilterableTableModel, int n, Object[] objectArray) {
        Object object;
        ObjectGrouper objectGrouper;
        GrouperContext grouperContext;
        Class<?> clazz = iFilterableTableModel instanceof ContextSensitiveTableModel ? ((ContextSensitiveTableModel)((Object)iFilterableTableModel)).getCellClassAt(-1, n) : iFilterableTableModel.getColumnClass(n);
        ConverterContext converterContext = iFilterableTableModel instanceof ContextSensitiveTableModel ? ((ContextSensitiveTableModel)((Object)iFilterableTableModel)).getConverterContextAt(-1, n) : null;
        GrouperContext grouperContext2 = grouperContext = this._groupableTableModel != null && this._groupableTableModelColumnIndex >= 0 ? this._groupableTableModel.getGrouperContext(this._groupableTableModelColumnIndex) : null;
        ObjectGrouper objectGrouper2 = grouperContext != null && !grouperContext.isUseOnCustomFilter() ? null : (objectGrouper = this._groupableTableModel != null && this._groupableTableModelColumnIndex >= 0 ? ObjectGrouperManager.getGrouper(this._groupableTableModel.getColumnClass(this._groupableTableModelColumnIndex), grouperContext) : null);
        if (!(objectArray != null && objectArray.length > 1 && objectArray[objectArray.length - 1] instanceof ConverterContext || objectGrouper == null)) {
            clazz = objectGrouper.getType();
            object = ObjectComparatorManager.getComparator(clazz, objectGrouper.getComparatorContext());
            converterContext = objectGrouper.getConverterContext();
            objectArray = this.getPossibleValues(objectGrouper, objectArray, (Comparator)object);
        }
        if ((object = this.getFilterFactoryManager()) == null) {
            return;
        }
        FilterEditor filterEditor = this.createCustomFilterEditor((FilterFactoryManager)object, clazz, converterContext, objectArray);
        if (!(filterEditor instanceof JComponent)) {
            return;
        }
        if (filterEditor instanceof TableCustomFilterEditor) {
            ((TableCustomFilterEditor)filterEditor).setColumnIndices(new int[]{n});
            ((TableCustomFilterEditor)filterEditor).setVisibleButtons(252);
        }
        ((JComponent)((Object)filterEditor)).setLocale(this.getLocale());
        Filter[] filterArray = iFilterableTableModel.getFilters(n);
        filterEditor.setFilters(filterArray);
        ((JComponent)((Object)filterEditor)).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Container container = this.getTopLevelAncestor();
        String string = MessageFormat.format(GridResource.getResourceBundle(this.getLocale()).getString("Filter.customFilterTitle"), iFilterableTableModel.getColumnName(n));
        StandardDialog standardDialog = this.createCustomFilterEditorDialog(container, string, (JComponent)((Object)filterEditor));
        if (standardDialog != null) {
            Filter[] filterArray2;
            standardDialog.setLocationRelativeTo(this);
            standardDialog.pack();
            standardDialog.setVisible(true);
            if (standardDialog.getDialogResult() == 0 && !JideSwingUtilities.equals(filterArray2 = filterEditor.getFilters(), filterArray, true)) {
                this.applyFilters(filterArray2, n);
            }
        }
    }

    protected FilterFactoryManager getFilterFactoryManager() {
        Object object = null;
        if (this.getTarget() instanceof JTableHeader) {
            object = ((JTableHeader)this.getTarget()).getClientProperty("filterFactoryManager");
        }
        FilterFactoryManager filterFactoryManager = object != null && object instanceof FilterFactoryManager ? (FilterFactoryManager)object : FilterFactoryManager.getDefaultInstance();
        return filterFactoryManager;
    }

    protected StandardDialog createCustomFilterEditorDialog(Container container, String string, JComponent jComponent) {
        CustomFilterEditorDialog customFilterEditorDialog = container instanceof Frame ? new CustomFilterEditorDialog((Frame)container, string, jComponent) : (container instanceof Dialog ? new CustomFilterEditorDialog((Dialog)container, string, jComponent) : new CustomFilterEditorDialog((Frame)null, string, jComponent));
        return customFilterEditorDialog;
    }

    protected FilterEditor createCustomFilterEditor(FilterFactoryManager filterFactoryManager, Class<?> clazz, ConverterContext converterContext, Object[] objectArray) {
        if (this.getTarget() instanceof AutoFilterTableHeader && "TableCustomFilterEditor".equals(((AutoFilterTableHeader)this.getTarget()).getClientProperty("customFilterEditorType"))) {
            return new TableCustomFilterEditor(this._actualTableModel, 0);
        }
        return new CustomFilterEditor(filterFactoryManager, clazz, converterContext, objectArray);
    }

    protected PopupPanel createCheckBoxListChooserPanel(final TableModel tableModel, final int n, final Object[] objectArray, final ObjectGrouper objectGrouper, final DefaultComboBoxModel defaultComboBoxModel) {
        final boolean bl = objectArray != null && objectArray.length > 1 && objectArray[objectArray.length - 1] instanceof ConverterContext;
        final boolean bl2 = this.isAllowCustomFilter();
        final DynamicTableFilter[] dynamicTableFilterArray = this.getDynamicTableFilters();
        final int n2 = bl2 ? 2 : 1;
        final int n3 = n2 + (dynamicTableFilterArray != null ? dynamicTableFilterArray.length : 0);
        CheckBoxListChooserPanel checkBoxListChooserPanel = new CheckBoxListChooserPanel(defaultComboBoxModel, bl ? String.class : (objectGrouper != null ? objectGrouper.getType() : tableModel.getColumnClass(n))){

            @Override
            protected void setupList(final JList jList) {
                Object object;
                ListCellRenderer listCellRenderer;
                super.setupList(jList);
                jList.setLocale(AutoFilterBox.this.getLocale());
                ConverterContext converterContext = null;
                if (!bl && tableModel instanceof ContextSensitiveTableModel) {
                    converterContext = ((ContextSensitiveTableModel)tableModel).getConverterContextAt(0, n);
                }
                if ((listCellRenderer = AutoFilterBox.this.getListCellRenderer()) != null) {
                    this.setRenderer(listCellRenderer);
                } else if (!bl) {
                    object = new FilterListCellRenderer(objectGrouper != null ? objectGrouper.getType() : tableModel.getColumnClass(n), objectGrouper != null ? objectGrouper.getConverterContext() : converterContext);
                    this.setRenderer((ListCellRenderer)object);
                    if (tableModel instanceof ContextSensitiveTableModel && AutoFilterBox.this.isUseTableCellRenderer()) {
                        ((FilterListCellRenderer)object).setEditorContext(((ContextSensitiveTableModel)tableModel).getEditorContextAt(0, n));
                        ((FilterListCellRenderer)object).setTable(AutoFilterBox.this.getTable());
                        ((FilterListCellRenderer)object).setColumnIndex(AutoFilterBox.this.getTableColumnIndex());
                    }
                }
                AutoFilterBox.this.customizeList(jList);
                object = AutoFilterBox.this.getCurrentFilters();
                if (jList instanceof CheckBoxList) {
                    CustomValueFilterListSelectionModel customValueFilterListSelectionModel = new CustomValueFilterListSelectionModel(n2, n3);
                    ((CheckBoxList)jList).setCheckBoxListSelectionModel(customValueFilterListSelectionModel);
                    ((CheckBoxList)jList).clearCheckBoxListSelection();
                    if (((Filter[])object).length == 0) {
                        ((CheckBoxList)jList).addCheckBoxListSelectedIndex(0);
                    } else if (!bl) {
                        for (Object object2 : object) {
                            if (object2 instanceof MultipleValuesFilter) {
                                ((MultipleValuesFilter)object2).setObjectGrouper(objectGrouper);
                                ((CheckBoxList)jList).addCheckBoxListSelectedValues(((MultipleValuesFilter)object2).getValues());
                                continue;
                            }
                            if (object2 instanceof NotFilter && ((NotFilter)object2).getFilter() instanceof MultipleValuesFilter) {
                                ((MultipleValuesFilter)((NotFilter)object2).getFilter()).setObjectGrouper(objectGrouper);
                                ((CheckBoxList)jList).selectAll();
                                if (bl2) {
                                    ((CheckBoxList)jList).removeCheckBoxListSelectedIndex(1);
                                }
                                ((CheckBoxList)jList).removeCheckBoxListSelectedValues(((MultipleValuesFilter)((NotFilter)object2).getFilter()).getValues());
                                continue;
                            }
                            if (object2 instanceof AbstractDynamicTableFilter && dynamicTableFilterArray != null) {
                                int n5;
                                for (n5 = 0; n5 < dynamicTableFilterArray.length && !JideSwingUtilities.equals(dynamicTableFilterArray[n5], object2); ++n5) {
                                }
                                if (n5 >= dynamicTableFilterArray.length) continue;
                                int n22 = n5 + n2;
                                ((CheckBoxListSelectionModel)customValueFilterListSelectionModel).addSelectionInterval(n22, n22);
                                continue;
                            }
                            if (!bl2 || object2 == null || object2.getFilterFactory() == null) continue;
                            ((CheckBoxListSelectionModel)customValueFilterListSelectionModel).addSelectionInterval(1, 1);
                        }
                    } else {
                        for (Object object3 : object) {
                            int n6;
                            if (object3 instanceof MultipleValuesFilter) {
                                T[] TArray;
                                block3: for (Object t : TArray = ((MultipleValuesFilter)object3).getValues()) {
                                    if (t == null) continue;
                                    for (n6 = 0; n6 < objectArray.length >> 1; ++n6) {
                                        if (!t.equals(objectArray[n6])) continue;
                                        ((CheckBoxList)jList).addCheckBoxListSelectedIndex(n6 + 1);
                                        continue block3;
                                    }
                                }
                                continue;
                            }
                            if (object3 instanceof NotFilter && ((NotFilter)object3).getFilter() instanceof MultipleValuesFilter) {
                                T[] TArray;
                                ((CheckBoxList)jList).selectAll();
                                block5: for (Object t : TArray = ((MultipleValuesFilter)((NotFilter)object3).getFilter()).getValues()) {
                                    if (t == null) continue;
                                    for (n6 = 0; n6 < objectArray.length >> 1; ++n6) {
                                        if (!t.equals(objectArray[n6])) continue;
                                        ((CheckBoxList)jList).removeCheckBoxListSelectedIndex(n6 + 1);
                                        continue block5;
                                    }
                                }
                                continue;
                            }
                            if (object3 instanceof AbstractDynamicTableFilter && dynamicTableFilterArray != null) {
                                int n32;
                                for (n32 = 0; n32 < dynamicTableFilterArray.length && !JideSwingUtilities.equals(dynamicTableFilterArray[n32], object3); ++n32) {
                                }
                                if (n32 >= dynamicTableFilterArray.length) continue;
                                int n4 = n32 + n2;
                                ((CheckBoxListSelectionModel)customValueFilterListSelectionModel).addSelectionInterval(n4, n4);
                                continue;
                            }
                            if (!bl2 || object3 == null || object3.getFilterFactory() == null) continue;
                            ((CheckBoxListSelectionModel)customValueFilterListSelectionModel).addSelectionInterval(1, 1);
                        }
                    }
                    JideSwingUtilities.insertMouseListener(jList, new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent mouseEvent) {
                            if (bl2 && jList.getCellBounds(1, 1).contains(mouseEvent.getPoint())) {
                                mouseEvent.consume();
                            }
                            if (dynamicTableFilterArray != null && dynamicTableFilterArray.length > 0) {
                                int n = n2;
                                int n2 = jList.getModel().getSize();
                                for (int i = 0; i < dynamicTableFilterArray.length && n < n2; ++i, ++n) {
                                    if (!jList.getCellBounds(n, n).contains(mouseEvent.getPoint())) continue;
                                    mouseEvent.consume();
                                    break;
                                }
                            }
                        }

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            if (bl2 && jList.getCellBounds(1, 1).contains(mouseEvent.getPoint())) {
                                AutoFilterBox.this.showCustomFilterEditor(AutoFilterBox.this._filterableTableModel, AutoFilterBox.this._filterableTableModelColumnIndex, objectArray);
                                mouseEvent.consume();
                            }
                            if (dynamicTableFilterArray != null && dynamicTableFilterArray.length > 0) {
                                int n = jList.getModel().getSize();
                                int n2 = n2;
                                for (int i = 0; i < dynamicTableFilterArray.length && n2 < n; ++i, ++n2) {
                                    if (!jList.getCellBounds(n2, n2).contains(mouseEvent.getPoint())) continue;
                                    DynamicTableFilter dynamicTableFilter = dynamicTableFilterArray[i];
                                    if (AutoFilterBox.this._actualTableModelColumnIndex >= 0 && dynamicTableFilter.initializeFilter(AutoFilterBox.this._actualTableModel, AutoFilterBox.this._actualTableModelColumnIndex, AutoFilterBox.this.getPossibleValues())) {
                                        AutoFilterBox.this.applyFilter(dynamicTableFilter, AutoFilterBox.this._filterableTableModelColumnIndex, true);
                                    } else {
                                        AutoFilterBox.this.applyFilter(null, AutoFilterBox.this._filterableTableModelColumnIndex, true);
                                    }
                                    AutoFilterBox.this.hidePopup();
                                    mouseEvent.consume();
                                    break;
                                }
                            }
                        }
                    }, 0);
                    jList.addKeyListener(new KeyListener(){

                        @Override
                        public void keyTyped(KeyEvent keyEvent) {
                        }

                        @Override
                        public void keyPressed(KeyEvent keyEvent) {
                            if (keyEvent.getKeyCode() == 10) {
                                int n = jList.getSelectedIndex();
                                if (bl2 && n == 1) {
                                    AutoFilterBox.this.showCustomFilterEditor(AutoFilterBox.this._filterableTableModel, AutoFilterBox.this._filterableTableModelColumnIndex, objectArray);
                                    keyEvent.consume();
                                }
                                if (dynamicTableFilterArray != null && dynamicTableFilterArray.length > 0 && n >= n2 && n < n3) {
                                    DynamicTableFilter dynamicTableFilter = dynamicTableFilterArray[n - n2];
                                    if (AutoFilterBox.this._actualTableModelColumnIndex >= 0 && dynamicTableFilter.initializeFilter(AutoFilterBox.this._actualTableModel, AutoFilterBox.this._actualTableModelColumnIndex, AutoFilterBox.this.getPossibleValues())) {
                                        AutoFilterBox.this.applyFilter(dynamicTableFilter, AutoFilterBox.this._filterableTableModelColumnIndex, true);
                                    } else {
                                        AutoFilterBox.this.applyFilter(null, AutoFilterBox.this._filterableTableModelColumnIndex, true);
                                    }
                                    AutoFilterBox.this.hidePopup();
                                    keyEvent.consume();
                                }
                            }
                        }

                        @Override
                        public void keyReleased(KeyEvent keyEvent) {
                        }
                    });
                }
            }
        };
        if (this.getTable() != null) {
            checkBoxListChooserPanel.setLocale(this.getTable().getLocale());
        }
        checkBoxListChooserPanel.setMaximumRowCount(8);
        checkBoxListChooserPanel.setDefaultFocusComponent(checkBoxListChooserPanel.getList());
        checkBoxListChooserPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int n;
                    Object object = itemEvent.getItem();
                    Object[] objectArray2 = null;
                    if (object != null && object.getClass().isArray()) {
                        objectArray2 = new Object[Array.getLength(object)];
                        for (n = 0; n < objectArray2.length; ++n) {
                            objectArray2[n] = Array.get(object, n);
                        }
                    }
                    if (objectArray2 == null) {
                        return;
                    }
                    if (objectArray2.length == 1 && defaultComboBoxModel.getIndexOf(objectArray2[0]) == 0 || objectArray2.length >= defaultComboBoxModel.getSize() - 1) {
                        AutoFilterBox.this.applyFilter(null, AutoFilterBox.this._filterableTableModelColumnIndex, true);
                    } else if (objectGrouper != null) {
                        MultipleValuesFilter multipleValuesFilter = AutoFilterBox.this._filterableTableModel.createMultipleValuesFilter(objectArray2);
                        multipleValuesFilter.setObjectGrouper(objectGrouper);
                        AutoFilterBox.this.applyFilter(multipleValuesFilter, AutoFilterBox.this._filterableTableModelColumnIndex);
                    } else if (AutoFilterBox.this.isPreferSelectedValues()) {
                        if (bl) {
                            for (n = 0; n < objectArray2.length; ++n) {
                                int n2 = defaultComboBoxModel.getIndexOf(objectArray2[n]) - 1;
                                if (n2 < 0 || n2 >= objectArray.length) continue;
                                objectArray2[n] = objectArray[n2];
                            }
                        }
                        MultipleValuesFilter multipleValuesFilter = AutoFilterBox.this._filterableTableModel.createMultipleValuesFilter(objectArray2);
                        AutoFilterBox.this.applyFilter(multipleValuesFilter, AutoFilterBox.this._filterableTableModelColumnIndex);
                    } else {
                        if (bl) {
                            for (n = 0; n < objectArray2.length; ++n) {
                                int n3 = defaultComboBoxModel.getIndexOf(objectArray2[n]) - 1;
                                if (n3 < 0 || n3 >= objectArray.length) continue;
                                objectArray2[n] = objectArray[n3];
                            }
                        }
                        HashSet<Object> hashSet = new HashSet<Object>();
                        if (!bl) {
                            hashSet.addAll(Arrays.asList(objectArray));
                        } else {
                            hashSet.addAll(Arrays.asList(objectArray).subList(0, objectArray.length >> 1));
                        }
                        hashSet.removeAll(Arrays.asList(objectArray2));
                        MultipleValuesFilter multipleValuesFilter = AutoFilterBox.this._filterableTableModel.createMultipleValuesFilter(hashSet.toArray(new Object[hashSet.size()]));
                        AutoFilterBox.this.applyFilter(new NotFilter(multipleValuesFilter), AutoFilterBox.this._filterableTableModelColumnIndex);
                    }
                    AutoFilterBox.this.hidePopup();
                    AutoFilterBox.this.updateFilterIndicator(AutoFilterBox.this._filterableTableModel);
                }
            }
        });
        checkBoxListChooserPanel.setCancelAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.cancelButtonText")){
            private static final long serialVersionUID = -2103769237293141438L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoFilterBox.this.hidePopup();
            }
        });
        return checkBoxListChooserPanel;
    }

    protected void customizeList(JList jList) {
        ListSearchable listSearchable = SearchableUtils.installSearchable(jList);
        listSearchable.setUseRendererAsConverter(true);
    }

    protected String convertElementToString(Object object, boolean bl, ObjectGrouper objectGrouper) {
        if (objectGrouper == null) {
            if (!bl) {
                return this.convertElementToString(object);
            }
            if (this._actualTableModel instanceof ContextSensitiveTableModel && this._actualTableModelColumnIndex >= 0) {
                int n = this._actualTableModelColumnIndex;
                if (ObjectConverterManager.getConverter(object.getClass()) == null) {
                    ObjectConverterManager.registerConverter(object.getClass(), new DefaultArrayConverter("; ", ((ContextSensitiveTableModel)this._actualTableModel).getCellClassAt(0, n)));
                }
                return ObjectConverterManager.toString(object, object.getClass());
            }
            return "" + object;
        }
        if (!bl) {
            return ObjectConverterManager.toString(object, object.getClass(), objectGrouper.getConverterContext());
        }
        ObjectConverter objectConverter = ObjectConverterManager.getConverter(object.getClass(), objectGrouper.getConverterContext());
        if (objectConverter == null || !(objectConverter instanceof DefaultArrayConverter) || ((DefaultArrayConverter)objectConverter).getElementClass() != objectGrouper.getType()) {
            ObjectConverterManager.registerConverter(object.getClass(), new DefaultArrayConverter("; ", objectGrouper.getType()), objectGrouper.getConverterContext());
        }
        return ObjectConverterManager.toString(object, object.getClass(), objectGrouper.getConverterContext());
    }

    protected String convertElementToString(Object object) {
        if (this._actualTableModel instanceof ContextSensitiveTableModel && this._actualTableModelColumnIndex >= 0) {
            int n = this._actualTableModelColumnIndex;
            return ObjectConverterManager.toString(object, ((ContextSensitiveTableModel)this._actualTableModel).getCellClassAt(0, n), ((ContextSensitiveTableModel)this._actualTableModel).getConverterContextAt(0, n));
        }
        return "" + object;
    }

    protected String convertElementToString(Object object, ConverterContext converterContext) {
        if (this._actualTableModel instanceof ContextSensitiveTableModel && this._actualTableModelColumnIndex >= 0) {
            int n = this._actualTableModelColumnIndex;
            return ObjectConverterManager.toString(object, ((ContextSensitiveTableModel)this._actualTableModel).getCellClassAt(0, n), converterContext);
        }
        return "" + object;
    }

    protected Point calculatePopupLocation() {
        Cloneable cloneable;
        Border border = this._popup.getPopupBorder();
        int n = 0;
        int n2 = 0;
        if (border != null) {
            cloneable = border.getBorderInsets(this._popupPanel);
            n = ((Insets)cloneable).left + ((Insets)cloneable).right;
            n2 = ((Insets)cloneable).top + ((Insets)cloneable).bottom;
        }
        try {
            cloneable = this.getLocationOnScreen();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            cloneable = this.getLocation();
        }
        cloneable.y += this.getHeight();
        Dimension dimension = this._popupPanel.getPreferredSize();
        cloneable.x -= dimension.width - this.getWidth() + n;
        int n3 = cloneable.y + dimension.height;
        Rectangle rectangle = PortingUtils.getContainingScreenBounds(new Rectangle((Point)cloneable, dimension), true);
        if (n3 > rectangle.y + rectangle.height) {
            cloneable.y = cloneable.y - dimension.height - this.getHeight() - n2;
        }
        Rectangle rectangle2 = PortingUtils.containsInScreenBounds(this, new Rectangle((Point)cloneable, dimension));
        cloneable.x = rectangle2.x;
        cloneable.y = rectangle2.y;
        return cloneable;
    }

    public void hidePopup() {
        if (this.isPopupVisible()) {
            this._popup.hidePopup();
        }
    }

    public boolean isPopupVisible() {
        return this._popup != null && this._popup.isPopupVisible();
    }

    private void initializeDynamicTableFilters() {
        if (this._dynamicFilters == null) {
            this._dynamicFilters = new ArrayList<DynamicTableFilter>();
        }
    }

    public void addDynamicTableFilter(DynamicTableFilter dynamicTableFilter) {
        this.initializeDynamicTableFilters();
        this._dynamicFilters.add(dynamicTableFilter);
    }

    public void removeDynamicTableFilter(DynamicTableFilter dynamicTableFilter) {
        this.initializeDynamicTableFilters();
        this._dynamicFilters.remove(dynamicTableFilter);
    }

    public DynamicTableFilter[] getDynamicTableFilters() {
        this.initializeDynamicTableFilters();
        if (this._dynamicFilters.size() == 0) {
            return this._filterableTableModel.getDynamicTableFilters(this._filterableTableModelColumnIndex);
        }
        return this._dynamicFilters.toArray(new DynamicTableFilter[this._dynamicFilters.size()]);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintFilterIndicator(graphics);
    }

    protected void paintFilterIndicator(Graphics graphics) {
    }

    public boolean isShowFilterName() {
        return this._showFilterName;
    }

    public void setShowFilterName(boolean bl) {
        if (this._showFilterName != bl) {
            this._showFilterName = bl;
            this.updateFilterIndicator(this._filterableTableModel);
        }
    }

    public boolean isShowFilterNameAsToolTip() {
        return this._showFilterNameAsToolTip;
    }

    public void setShowFilterNameAsToolTip(boolean bl) {
        if (this._showFilterNameAsToolTip != bl) {
            this._showFilterNameAsToolTip = bl;
            this.updateFilterIndicator(this._filterableTableModel);
        }
    }

    public boolean isShowFilterIcon() {
        return this._showFilterIcon;
    }

    public void setShowFilterIcon(boolean bl) {
        if (this._showFilterIcon != bl) {
            this._showFilterIcon = bl;
            this.updateFilterIndicator(this._filterableTableModel);
        }
    }

    public boolean isShowSortArrow() {
        return this._showSortArrow;
    }

    public void setShowSortArrow(boolean bl) {
        if (this._showSortArrow != bl) {
            this._showSortArrow = bl;
            this.updateSortArrow();
        }
    }

    public Component getTarget() {
        return this._target;
    }

    public void setTarget(Component component) {
        this._target = component;
        if (this._target instanceof AutoFilterTableHeader) {
            this._filterableTableModel = ((AutoFilterTableHeader)this._target).getFilterableTableModel(this);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Serializable serializable;
            Serializable serializable2;
            JComponent jComponent = this.getFilterField();
            if (jComponent instanceof AutoFilterBoxFilterField && jComponent.isVisible()) {
                serializable2 = ((AutoFilterBoxFilterField)jComponent).getButton();
                serializable = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), jComponent);
                Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), (Component)serializable2);
                if (((Point)serializable).x >= 0 && ((Point)serializable).y >= 0 && ((Point)serializable).x < jComponent.getWidth() && ((Point)serializable).y < jComponent.getHeight()) {
                    if (point.x >= 0 && point.y >= 0 && point.x < ((JComponent)serializable2).getWidth() && point.y < ((JComponent)serializable2).getHeight()) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, (Component)serializable2);
                    } else {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, jComponent);
                    }
                    mouseEvent.consume();
                    return;
                }
            }
            if (this._filterButton != null && this._filterButton.isVisible()) {
                serializable2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), this._filterButton);
                if (((Point)serializable2).x >= 0 && ((Point)serializable2).y >= 0 && ((Point)serializable2).x < this._filterButton.getWidth() && ((Point)serializable2).y < this._filterButton.getHeight()) {
                    JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this._filterButton);
                    mouseEvent.consume();
                    return;
                }
            }
            boolean bl = true;
            serializable = null;
            if (this.getTarget() instanceof JTableHeader && (serializable = ((JTableHeader)this.getTarget()).getTable()) instanceof SortableTable) {
                if (!((SortableTable)serializable).isSortable()) {
                    bl = false;
                }
                if (!((SortableTable)serializable).isSortingEnabled()) {
                    bl = false;
                }
            }
            if (bl) {
                boolean bl2 = JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent);
                this.toggleSortOrder(bl2);
                mouseEvent.consume();
                if (serializable != null && (!(serializable instanceof SortableTable) || ((SortableTable)serializable).isEnsureSelectedRowVisibleOnTogglingSort())) {
                    TableUtils.ensureRowSelectionVisible(serializable);
                }
            }
        }
        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this.getTarget());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Serializable serializable;
            JComponent jComponent = this.getFilterField();
            if (jComponent instanceof AutoFilterBoxFilterField && jComponent.isVisible()) {
                serializable = ((AutoFilterBoxFilterField)jComponent).getButton();
                Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), jComponent);
                Point point2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), (Component)serializable);
                if (point.x >= 0 && point.y >= 0 && point.x < jComponent.getWidth() && point.y < jComponent.getHeight()) {
                    if (point2.x >= 0 && point2.y >= 0 && point2.x < ((JComponent)serializable).getWidth() && point2.y < ((JComponent)serializable).getHeight()) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, (Component)serializable);
                    } else {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, jComponent);
                    }
                    mouseEvent.consume();
                    return;
                }
            }
            if (this._filterButton != null && this._filterButton.isVisible()) {
                serializable = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), this._filterButton);
                if (((Point)serializable).x >= 0 && ((Point)serializable).y >= 0 && ((Point)serializable).x < this._filterButton.getWidth() && ((Point)serializable).y < this._filterButton.getHeight()) {
                    JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this._filterButton);
                    mouseEvent.consume();
                    return;
                }
            }
        }
        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this.getTarget());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Serializable serializable;
            JComponent jComponent = this.getFilterField();
            if (jComponent instanceof AutoFilterBoxFilterField && jComponent.isVisible()) {
                serializable = ((AutoFilterBoxFilterField)jComponent).getButton();
                Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), jComponent);
                Point point2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), (Component)serializable);
                if (point.x >= 0 && point.y >= 0 && point.x < jComponent.getWidth() && point.y < jComponent.getHeight()) {
                    if (point2.x >= 0 && point2.y >= 0 && point2.x < ((JComponent)serializable).getWidth() && point2.y < ((JComponent)serializable).getHeight()) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, (Component)serializable);
                    } else {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, jComponent);
                    }
                    mouseEvent.consume();
                    return;
                }
            }
            if (this._filterButton != null && this._filterButton.isVisible()) {
                serializable = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), this._filterButton);
                if (((Point)serializable).x >= 0 && ((Point)serializable).y >= 0 && ((Point)serializable).x < this._filterButton.getWidth() && ((Point)serializable).y < this._filterButton.getHeight()) {
                    JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this._filterButton);
                    mouseEvent.consume();
                    return;
                }
            }
        }
        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this.getTarget());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this.getTarget());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this.getTarget());
    }

    public boolean isAllowMultipleValues() {
        return this._allowMultipleValues;
    }

    public void setAllowMultipleValues(boolean bl) {
        boolean bl2 = this._allowMultipleValues;
        if (bl2 != bl) {
            this._allowMultipleValues = bl;
        }
    }

    public boolean isAllowCustomFilter() {
        return this._allowCustomFilter && !this.isMultiLineMode();
    }

    public void setAllowCustomFilter(boolean bl) {
        boolean bl2 = this._allowCustomFilter;
        if (bl2 != bl) {
            this._allowCustomFilter = bl;
        }
    }

    @Override
    public void setVerticalAlignment(int n) {
        super.setVerticalAlignment(n);
        if (this._label != null) {
            this._label.setVerticalAlignment(n);
        }
    }

    @Override
    public void setHorizontalAlignment(int n) {
        super.setHorizontalAlignment(n);
        if (this._label != null) {
            this._label.setHorizontalAlignment(n);
        }
    }

    public Icon getDescendingIcon() {
        if (this._descendingIcon == null) {
            return new ArrowIcon(5);
        }
        return this._descendingIcon;
    }

    public void setDescendingIcon(Icon icon) {
        this._descendingIcon = icon;
        this.updateSortArrow();
    }

    public Icon getAscendingIcon() {
        if (this._ascendingIcon == null) {
            return new ArrowIcon(1);
        }
        return this._ascendingIcon;
    }

    public void setAscendingIcon(Icon icon) {
        this._ascendingIcon = icon;
        this.updateSortArrow();
    }

    public ListCellRenderer getListCellRenderer() {
        return this._listCellRenderer;
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this._listCellRenderer = listCellRenderer;
    }

    public boolean isCellEditor() {
        return this._cellEditor;
    }

    public void setCellEditor(boolean bl) {
        this._cellEditor = bl;
    }

    public StringConverter getTitleConverter() {
        return this._titleConverter;
    }

    public void setTitleConverter(StringConverter stringConverter) {
        if (this._titleConverter != stringConverter) {
            this._titleConverter = stringConverter;
            this.updateFilterIndicator(this._filterableTableModel);
        }
    }

    public boolean isPreferSelectedValues() {
        return this._preferSelectedValues;
    }

    public void setPreferSelectedValues(boolean bl) {
        this._preferSelectedValues = bl;
    }

    public JComponent getFilterField() {
        return this._filterField;
    }

    public int getSearchingDelay() {
        return this._searchingDelay;
    }

    public void setSearchingDelay(int n) {
        this._searchingDelay = n;
        if (this._filterField instanceof AutoFilterBoxFilterField) {
            ((AutoFilterBoxFilterField)this._filterField).setSearchingDelay(this.getSearchingDelay());
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this._label != null) {
            this._label.setForeground(color);
        }
    }

    protected boolean isRequestFocusForTextField() {
        return true;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(AutoFilterBox.class.getName(), 4);
        }
    }

    protected class AutoFilterBoxFilterField
    extends QuickTableFilterField {
        public AutoFilterBoxFilterField(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        protected JLabel createLabel() {
            return null;
        }

        @Override
        protected JTextField createTextField() {
            JTextField jTextField = super.createTextField();
            jTextField.setName("CompactField");
            return jTextField;
        }

        @Override
        protected IFilterableTableModel createFilterableTableModel(TableModel tableModel) {
            return AutoFilterBox.this._filterableTableModel;
        }

        @Override
        public void applyFilter() {
            String string;
            this._searchingText = string = this.getSearchingText();
            if (this._filter != null && this._filter instanceof InternalFieldFilter) {
                ((InternalFieldFilter)this._filter).setSearchingText(this._searchingText);
            }
            this.applyFilter(string);
        }

        @Override
        protected Filter createFilter() {
            return new InternalFieldFilter();
        }

        @Override
        protected void changeFilter() {
            Filter[] filterArray;
            for (Filter filter : filterArray = AutoFilterBox.this.getCurrentFilters()) {
                if (!(filter instanceof QuickTableFilterField.FieldTableFilter) && !(filter instanceof SingleValueFilter) && !(filter instanceof MultipleValuesFilter) && (!(filter instanceof NotFilter) || !(((NotFilter)filter).getFilter() instanceof MultipleValuesFilter))) continue;
                AutoFilterBox.this._filterableTableModel.removeFilter(AutoFilterBox.this._filterableTableModelColumnIndex, filter);
            }
            AutoFilterBox.this._filterableTableModel.addFilter(AutoFilterBox.this._filterableTableModelColumnIndex, this.getFilter());
        }

        @Override
        public void setSearchingText(String string) {
            super.setSearchingText(string);
            if (this._button != null) {
                this._button.setIcon(this.getSearchingText().length() == 0 ? null : this.getResetIcon());
                this._button.setRolloverIcon(this.getSearchingText().length() == 0 ? null : this.getResetRolloverIcon());
            }
        }

        private class InternalFieldFilter
        extends QuickTableFilterField.FieldTableFilter {
            private static final long serialVersionUID = 1105330962171466958L;

            private InternalFieldFilter() {
                super(AutoFilterBoxFilterField.this);
            }
        }
    }

    public class ArrowIcon
    implements Icon {
        private int _direction = 1;

        public ArrowIcon(int n) {
            this._direction = n;
        }

        @Override
        public int getIconWidth() {
            return 7;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(new Color(172, 168, 153));
            switch (this._direction) {
                case 1: {
                    for (int i = 0; i < 7; ++i) {
                        graphics.drawLine(n + i, n2 + Math.abs(3 - i), n + i, n2 + Math.abs(3 - i) + 1);
                    }
                    graphics.drawLine(n + 3, n2, n + 3, n2 + this.getIconHeight());
                    break;
                }
                case 5: {
                    for (int i = 0; i < 7; ++i) {
                        graphics.drawLine(n + i, n2 + 8 - Math.abs(3 - i), n + i, n2 + 8 - Math.abs(3 - i) + 1);
                    }
                    graphics.drawLine(n + 3, n2, n + 3, n2 + this.getIconHeight());
                }
            }
        }
    }

    class DropDownSwingWorker
    extends SwingWorker<Object[], Object> {
        private IFilterableTableModel _filterableTableModel;
        private int _tableColumnIndex;
        private Comparator _comparator;

        public DropDownSwingWorker(IFilterableTableModel iFilterableTableModel, int n, Comparator comparator) {
            this._filterableTableModel = iFilterableTableModel;
            this._tableColumnIndex = n;
            this._comparator = comparator;
        }

        @Override
        protected Object[] doInBackground() throws Exception {
            if (!this._filterableTableModel.isSameConverterAt(this._tableColumnIndex)) {
                return this._filterableTableModel.getPossibleValuesAndConverters(this._tableColumnIndex, this._comparator);
            }
            return this._filterableTableModel.getPossibleValues(this._tableColumnIndex, this._comparator);
        }

        @Override
        protected void done() {
            try {
                Object[] objectArray = (Object[])this.get();
                if (objectArray != null) {
                    AutoFilterBox.this.setPossibleValues(objectArray);
                    AutoFilterBox.this.showPopupPanelAsPopup();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface FilterTitleFormatter {
        public String formatColumnTitle(String var1, Filter[] var2);
    }
}

