/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.grid.RolloverTableUtils;
import com.jidesoft.grid.TableCellEditorRenderer;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;

public abstract class AbstractTableCellEditorRenderer
extends ContextSensitiveCellEditor
implements TableCellEditorRenderer {
    private static final long serialVersionUID = 4756970611988199318L;
    protected Component _rendererComponent;
    protected Component _editorComponent;
    private MouseAdapter _cancelMouseListener;

    public AbstractTableCellEditorRenderer() {
    }

    public AbstractTableCellEditorRenderer(ConverterContext converterContext) {
        super(converterContext);
    }

    @Override
    public Component getTableCellEditorComponent(final JTable jTable, Object object, boolean bl, int n, int n2) {
        this._editorComponent = this.createTableCellEditorRendererComponent(jTable, n, n2);
        if (this._editorComponent != null) {
            if (this._cancelMouseListener == null) {
                this._cancelMouseListener = new MouseAdapter(){

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        RolloverTableUtils.cancelRollover(jTable, mouseEvent);
                    }
                };
            }
            if (!JideSwingUtilities.isMouseListenerRegistered(this._editorComponent, this._cancelMouseListener)) {
                this._editorComponent.addMouseListener(this._cancelMouseListener);
            }
        }
        this.configureTableCellEditorRendererComponent(jTable, this._editorComponent, false, object, bl, true, n, n2);
        return this._editorComponent;
    }

    @Override
    public boolean stopCellEditing() {
        boolean bl = super.stopCellEditing();
        if (bl) {
            this._editorComponent = null;
        }
        return bl;
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
        this._editorComponent = null;
    }

    public void resetRendererComponent() {
        this._rendererComponent = null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this._rendererComponent == null) {
            this._rendererComponent = this.createTableCellEditorRendererComponent(jTable, n, n2);
        }
        this.configureTableCellEditorRendererComponent(jTable, this._rendererComponent, true, object, bl, bl2, n, n2);
        return this._rendererComponent;
    }
}

