/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AbstractNode;
import com.jidesoft.grid.Cacheable;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.Node;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TreeTableModel;
import com.jidesoft.grid.TreeTableUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;

public abstract class AbstractExpandable
extends AbstractNode
implements Expandable {
    protected boolean _expanded = false;
    protected boolean _expandable = true;
    private boolean _adjusting = false;

    @Override
    public boolean isExpanded() {
        return this._expanded;
    }

    @Override
    public void setExpanded(boolean bl) {
        if (this._expanded != bl) {
            boolean bl2 = this._expanded;
            this._expanded = bl;
            if (this._expanded && this instanceof Cacheable) {
                ((Cacheable)((Object)this)).invalidateCache();
            }
            this.firePropertyChange("expanded", bl2, bl);
        }
    }

    @Override
    public boolean isExpandable() {
        return this._expandable;
    }

    @Override
    public void setExpandable(boolean bl) {
        if (this._expandable != bl) {
            boolean bl2 = this._expandable;
            this._expandable = bl;
            this.firePropertyChange("expandable", bl2, bl);
        }
    }

    @Override
    public boolean hasChildren() {
        List<?> list = this.getChildren();
        return list != null && list.size() > 0;
    }

    @Override
    public void removeAllChildren() {
        List<?> list = this.getChildren();
        ArrayList arrayList = new ArrayList();
        if (list != null) {
            arrayList.addAll(list);
        }
        this.removeChildren(arrayList);
    }

    @Override
    public int getNumberOfVisibleExpandable() {
        int n = 1;
        if (!this.isExpanded()) {
            return n;
        }
        if (this.hasChildren()) {
            int n2 = this.getChildrenCount();
            IExpandableTreeTableModel iExpandableTreeTableModel = this.getTreeTableModel(this);
            for (int i = 0; i < n2; ++i) {
                Object object = this.getChildAt(i);
                if (object instanceof Property && ((Property)object).isHidden() || iExpandableTreeTableModel instanceof TreeTableModel && ((TreeTableModel)iExpandableTreeTableModel).shouldBeFiltered((Row)object)) continue;
                if (object instanceof Expandable) {
                    n += ((Expandable)object).getNumberOfVisibleExpandable();
                    continue;
                }
                ++n;
            }
        }
        return n;
    }

    public int getNumberOfVisibleChildren() {
        int n = 0;
        if (this.hasChildren()) {
            int n2 = this.getChildrenCount();
            for (int i = 0; i < n2; ++i) {
                Object object = this.getChildAt(i);
                if (object instanceof Property && ((Property)object).isHidden()) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean hasVisibleChildren() {
        if (this.hasChildren()) {
            int n = this.getChildrenCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.getChildAt(i);
                if (object instanceof Property && ((Property)object).isHidden()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getChildrenCount() {
        List<?> list = this.getChildren();
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    @Deprecated
    public int getAllVisibleChildrenCount() {
        List<?> list = this.getChildren();
        if (list == null) {
            return 0;
        }
        int n = 0;
        for (Object obj : list) {
            if (!(obj instanceof Expandable) || !((Expandable)obj).hasChildren()) {
                if (obj instanceof Cacheable) {
                    Cacheable cacheable = (Cacheable)obj;
                    if (cacheable.isCacheValid() && cacheable.getCachedValue() != null) continue;
                    ++n;
                    continue;
                }
                ++n;
                continue;
            }
            n += ((Expandable)obj).getAllVisibleChildrenCount();
        }
        return n;
    }

    public int getAllChildrenCount(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            Object object = this.getChildAt(i);
            if (object instanceof Expandable) {
                if (!bl) {
                    ++n;
                }
                n += ((Expandable)object).getChildrenCount();
                continue;
            }
            ++n;
        }
        return n;
    }

    @Override
    public Object addChild(Object object) {
        return this.addChild(this.getChildrenCount(), object);
    }

    @Override
    public Object addChild(int n, Object object) {
        List<?> list = this.getChildren();
        if (list == null) {
            list = new ArrayList();
            this.setChildren(list);
        }
        if (n < 0 || n >= list.size()) {
            list.add(object);
        } else {
            list.add(n, object);
        }
        if (object instanceof Node) {
            ((Node)object).setParent(this);
        }
        TreeTableModel treeTableModel = this.getTreeTableModel();
        if (!this.isAdjusting() && treeTableModel != null) {
            int n2 = this.findChildVisualIndex(this, object);
            this.notifyChildInserted(object, n2);
            if ((!(treeTableModel instanceof TreeTableModel) || treeTableModel.isAutoExpand(this)) && this.isExpandable() && !this.isExpanded() && this instanceof ExpandableRow) {
                treeTableModel.expandRow((ExpandableRow)((Object)this), true);
            }
        }
        return object;
    }

    private int findChildVisualIndexForRow(Expandable expandable, Object object) {
        IExpandableTreeTableModel iExpandableTreeTableModel = this.getTreeTableModel(this);
        if (!(expandable instanceof Row) || iExpandableTreeTableModel == null) {
            return -1;
        }
        int n = iExpandableTreeTableModel.getRowIndex((Row)((Object)expandable));
        if (n < 0 && expandable != iExpandableTreeTableModel.getRoot()) {
            return -1;
        }
        for (int i = expandable.getChildIndex(object) - 1; i >= 0; --i) {
            Object object2 = expandable.getChildAt(i);
            if (!(object2 instanceof Row)) {
                return -1;
            }
            int n2 = iExpandableTreeTableModel.getRowIndex((Row)object2);
            if (n2 < 0) continue;
            return n < 0 ? n2 + 1 : (n2 += TableModelWrapperUtils.getVisibleChildrenCount((TableModel)((Object)iExpandableTreeTableModel), (Row)object2)) - n;
        }
        return 0;
    }

    private int findChildVisualIndex(Expandable expandable, Object object) {
        Object object2;
        int n = this.findChildVisualIndexForRow(expandable, object);
        if (n >= 0) {
            return n;
        }
        n = 0;
        IExpandableTreeTableModel iExpandableTreeTableModel = this.getTreeTableModel(this);
        int n2 = expandable.getChildrenCount();
        for (int i = 0; i < n2 && (object2 = expandable.getChildAt(i)) != object; ++i) {
            if (object2 instanceof Property && ((Property)object2).isHidden() || iExpandableTreeTableModel instanceof TreeTableModel && ((TreeTableModel)iExpandableTreeTableModel).shouldBeFiltered((Row)object2)) continue;
            if (object2 instanceof Expandable) {
                n += ((Expandable)object2).getNumberOfVisibleExpandable();
                continue;
            }
            ++n;
        }
        return n;
    }

    @Override
    public void addChildren(int n, List<? extends Row> list) {
        if (list == null) {
            return;
        }
        List<?> list2 = this.getChildren();
        if (list2 == null) {
            list2 = new ArrayList();
            this.setChildren(list2);
        }
        if (n < 0) {
            list2.addAll(list);
        } else {
            list2.addAll(n, list);
        }
        for (Row row : list) {
            if (!(row instanceof Node)) continue;
            ((Node)row).setParent(this);
        }
        TreeTableModel treeTableModel = this.getTreeTableModel();
        if (!this.isAdjusting() && treeTableModel != null && list.size() > 0) {
            int n2;
            if (this instanceof Row && treeTableModel.getRowIndex((Row)((Object)this)) < 0 && this != treeTableModel.getRoot()) {
                return;
            }
            int n22 = -1;
            if (n >= 0) {
                n2 = this.findChildVisualIndex(this, list.get(0));
            }
            this.notifyChildrenInserted(list, n2);
            if ((!(treeTableModel instanceof TreeTableModel) || ((TreeTableModel)treeTableModel).isAutoExpand(this)) && this.isExpandable() && !this.isExpanded() && this instanceof ExpandableRow) {
                treeTableModel.expandRow((ExpandableRow)((Object)this), true);
            }
        }
    }

    @Override
    public boolean removeChild(Object object) {
        List<?> list = this.getChildren();
        if (list == null) {
            return false;
        }
        boolean bl = list.remove(object);
        if (!this.isAdjusting() & this.getTreeTableModel() != null && bl) {
            this.notifyChildDeleted(object);
        }
        if (object instanceof Node) {
            ((Node)object).setParent(null);
        }
        return bl;
    }

    @Override
    public boolean removeChildren(List<? extends Row> list) {
        List<? extends Row> list2 = this.getChildren();
        if (list2 == null || list == null) {
            return false;
        }
        boolean bl = list2.removeAll(list);
        if (!this.isAdjusting() & this.getTreeTableModel() != null && bl) {
            this.notifyChildrenDeleted(list);
        }
        for (Row row : list) {
            if (!(row instanceof Node)) continue;
            ((Node)row).setParent(null);
        }
        return bl;
    }

    @Override
    public Object getChildAt(int n) {
        List<?> list = this.getChildren();
        if (list == null) {
            return null;
        }
        if (n < 0 || n >= list.size()) {
            return null;
        }
        Object obj = list.get(n);
        if (obj instanceof Expandable && ((Expandable)obj).getParent() == null) {
            ((Expandable)obj).setParent(this);
        }
        return obj;
    }

    @Override
    public int getChildIndex(Object object) {
        List<?> list = this.getChildren();
        if (list == null || list.size() == 0) {
            return -1;
        }
        return list.indexOf(object);
    }

    @Override
    public boolean moveUpChild(Object object) {
        List<?> list = this.getChildren();
        if (list == null || list.size() == 0) {
            return false;
        }
        int n = this.getChildIndex(object);
        if (n == -1) {
            return false;
        }
        if (n == 0) {
            return false;
        }
        this.removeChild(object);
        this.addChild(--n, object);
        return true;
    }

    @Override
    public boolean moveDownChild(Object object) {
        List<?> list = this.getChildren();
        if (list == null || list.size() == 0) {
            return false;
        }
        int n = this.getChildIndex(object);
        if (n == -1) {
            return false;
        }
        if (n == this.getChildren().size() - 1) {
            return false;
        }
        this.removeChild(object);
        this.addChild(++n, object);
        return true;
    }

    @Override
    public void notifyChildInserted(Object object, int n) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (!this.isExpanded()) {
            if (expandable != null) {
                expandable.notifyChildUpdated(this);
            }
        } else if (expandable != null) {
            int n2 = 1;
            n2 += this.findChildVisualIndex(expandable, this);
            if (n == -1) {
                n = expandable.getChildrenCount();
            }
            expandable.notifyChildInserted(object, n2 + n);
            expandable.notifyChildUpdated(this);
        }
    }

    @Override
    public void notifyChildrenInserted(List list, int n) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (expandable == null) {
            return;
        }
        if (this.isExpanded()) {
            int n2 = 1;
            n2 += this.findChildVisualIndex(expandable, this);
            if (n == -1 && this instanceof Row) {
                n = TreeTableUtils.getDescendantCount(this.getTreeTableModel(), (Row)((Object)this), false, false);
            }
            if (list.size() == 1) {
                expandable.notifyChildInserted(list.get(0), n2 + n);
            } else {
                expandable.notifyChildrenInserted(list, n2 + n);
            }
        }
        expandable.notifyChildUpdated(this);
    }

    @Override
    public void notifyChildDeleted(Object object) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (!this.isExpanded()) {
            if (expandable != null) {
                expandable.notifyChildUpdated(this);
            }
        } else if (expandable != null) {
            expandable.notifyChildDeleted(object);
            expandable.notifyChildUpdated(this);
        }
    }

    @Override
    public void notifyChildrenDeleted(List<? extends Row> list) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (expandable == null || list == null) {
            return;
        }
        if (this.isExpanded()) {
            expandable.notifyChildrenDeleted(list);
        }
        expandable.notifyChildUpdated(this);
    }

    @Override
    public void notifyChildUpdated(Object object) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (!this.isExpanded()) {
            if (expandable != null) {
                expandable.notifyChildUpdated(this);
            }
        } else if (expandable != null) {
            expandable.notifyChildUpdated(object);
        }
    }

    @Override
    public void notifyChildrenUpdated(List<? extends Row> list) {
        Expandable expandable = this.getParent();
        if (this instanceof Property && ((Property)this).isHidden()) {
            return;
        }
        if (expandable == null || list == null) {
            return;
        }
        if (!this.isExpanded()) {
            expandable.notifyChildUpdated(this);
        } else {
            for (Row row : list) {
                this.notifyChildUpdated(row);
            }
        }
    }

    public TreeTableModel getTreeTableModel() {
        IExpandableTreeTableModel iExpandableTreeTableModel = this.getExpandableTreeTableModel();
        if (iExpandableTreeTableModel instanceof TreeTableModel) {
            return (TreeTableModel)iExpandableTreeTableModel;
        }
        return null;
    }

    public IExpandableTreeTableModel getExpandableTreeTableModel() {
        return this.getTreeTableModel(this.getParent());
    }

    private IExpandableTreeTableModel getTreeTableModel(Expandable expandable) {
        if (expandable instanceof RootExpandableRow) {
            return ((RootExpandableRow)expandable).getTreeTableModel();
        }
        if (expandable == null) {
            return null;
        }
        return this.getTreeTableModel(expandable.getParent());
    }

    public boolean isAdjusting() {
        return this._adjusting;
    }

    public void setAdjusting(boolean bl) {
        if (bl != this._adjusting) {
            boolean bl2 = this._adjusting;
            this._adjusting = bl;
            this.firePropertyChange("adjusting", bl2, this._adjusting);
        }
    }
}

