/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.gauge.Dial;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class Pivot
implements Drawable,
ZOrder,
Serializable {
    private Dial dial;
    private double fromAngle = 0.0;
    private double toAngle = 360.0;
    private Paint fill;
    private double outerRadius = 0.2;
    private double innerRadius = 0.0;
    private int zOrder = -1;
    private int outlineWidth = 0;
    private Color outlineColor = Color.black;
    private boolean visible = true;
    private double offsetRadius = 0.0;
    private double offsetAngle = 0.0;

    public Pivot(Dial dial, double d, Paint paint) {
        this.dial = dial;
        this.outerRadius = d;
        this.fill = paint;
    }

    public Pivot(Dial dial, double d, double d2, double d3, Paint paint) {
        this.dial = dial;
        this.outerRadius = d;
        this.fromAngle = d2;
        this.toAngle = d3;
        this.fill = paint;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        this.fill = paint;
    }

    public double getFromAngle() {
        return this.fromAngle;
    }

    public void setFromAngle(double d) {
        this.fromAngle = d;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double d) {
        this.innerRadius = d;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double d) {
        this.outerRadius = d;
    }

    public double getToAngle() {
        return this.toAngle;
    }

    public void setToAngle(double d) {
        this.toAngle = d;
    }

    @Override
    public int getZOrder() {
        return this.zOrder;
    }

    @Override
    public void setZOrder(int n) {
        this.zOrder = n;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(int n) {
        this.outlineWidth = n;
    }

    public double getOffsetAngle() {
        return this.offsetAngle;
    }

    public void setOffsetAngle(double d) {
        this.offsetAngle = d;
    }

    public double getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(double d) {
        this.offsetRadius = d;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    protected Point2D getCenter() {
        float f = this.dial.getRadius();
        int n = this.dial.getPivotX();
        int n2 = this.dial.getPivotY();
        double d = Math.toRadians(this.offsetAngle);
        double d2 = (double)n + (double)f * this.offsetRadius * Math.cos(d);
        double d3 = (double)n2 - (double)f * this.offsetRadius * Math.sin(d);
        return new Point2D.Double(d2, d3);
    }

    @Override
    public void draw(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D point2D = this.getCenter();
        double d = point2D.getX();
        double d2 = point2D.getY();
        float f = this.dial.getRadius();
        double d3 = Math.toRadians(this.fromAngle);
        double d4 = Math.toRadians(this.toAngle);
        GeneralPath generalPath = new GeneralPath();
        double d5 = this.innerRadius * (double)f;
        double d6 = this.outerRadius * (double)f;
        Point2D.Double double_ = new Point2D.Double(d + d5 * Math.cos(d3), d2 - d5 * Math.sin(d3));
        Point2D.Double double_2 = new Point2D.Double(d + d6 * Math.cos(d4), d2 - d6 * Math.sin(d4));
        generalPath.moveTo(((Point2D)double_).getX(), ((Point2D)double_).getY());
        Arc2D.Double double_3 = new Arc2D.Double(d - d5, d2 - d5, d5 * 2.0, d5 * 2.0, this.fromAngle, this.toAngle - this.fromAngle, 0);
        generalPath.append(double_3, true);
        generalPath.lineTo(((Point2D)double_2).getX(), ((Point2D)double_2).getY());
        Arc2D.Double double_4 = new Arc2D.Double(d - d6, d2 - d6, d6 * 2.0, d6 * 2.0, this.toAngle, this.fromAngle - this.toAngle, 0);
        generalPath.append(double_4, true);
        generalPath.lineTo(((Point2D)double_).getX(), ((Point2D)double_).getY());
        generalPath.closePath();
        graphics2D.setPaint(this.fill);
        graphics2D.fill(generalPath);
        if (this.outlineWidth > 0) {
            graphics2D.setStroke(new BasicStroke(this.outlineWidth));
            graphics2D.setColor(this.outlineColor);
            if (Math.abs(this.toAngle - this.fromAngle - 360.0) < 1.0) {
                Ellipse2D.Double double_5 = new Ellipse2D.Double(d - d6, d2 - d6, d6 * 2.0, d6 * 2.0);
                graphics2D.draw(double_5);
            } else {
                graphics2D.draw(generalPath);
            }
        }
    }
}

