/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.gauge.MarkerShapeFactory;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public enum MarkerShape implements MarkerShapeFactory
{
    DOWN_TRIANGLE,
    UP_TRIANGLE,
    ELLIPSE,
    RECTANGLE;

    private static final double root_3;

    @Override
    public Shape createShape(double d, double d2, double d3, double d4) {
        switch (this) {
            case DOWN_TRIANGLE: {
                return MarkerShape.createDownTriangle2D(d, d2, d3, d4);
            }
            case UP_TRIANGLE: {
                return MarkerShape.createUpTriangle2D(d, d2, d3, d4);
            }
            case ELLIPSE: {
                return new Ellipse2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
            }
            case RECTANGLE: {
                return new Rectangle2D.Double(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }

    private static Shape createDownTriangle2D(double d, double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(d - d3 / 2.0), (float)(d2 - d4 / 2.0));
        generalPath.lineTo((float)(d + d3 / 2.0), (float)(d2 - d4 / 2.0));
        generalPath.lineTo((float)d, (float)(d2 + d4 / 2.0));
        generalPath.closePath();
        return generalPath;
    }

    private static Shape createUpTriangle2D(double d, double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(d - d3 / 2.0), (float)(d2 + d4 / 2.0));
        generalPath.lineTo((float)(d + d3 / 2.0), (float)(d2 + d4 / 2.0));
        generalPath.lineTo((float)d, (float)(d2 - d4 / 2.0));
        generalPath.closePath();
        return generalPath;
    }

    static {
        root_3 = Math.sqrt(3.0);
    }
}

