/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Drawable;
import com.jidesoft.gauge.Dial;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.UIManager;

public class DialLabel
implements Drawable {
    private Dial dial;
    private double radius;
    private double angle;
    private String label;
    private boolean resizeFonts = true;
    private Dimension fontComparisonSize = null;
    private float fontSizeRatio = 1.0f;
    private Color color = Color.black;
    private Font font = UIManager.getFont("Label.font");

    public DialLabel(Dial dial, double d, double d2, String string) {
        this.dial = dial;
        this.setRadius(d);
        this.setAngle(d2);
        this.setLabel(string);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    @Override
    public void draw(Graphics graphics) {
        float f;
        if (this.label == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Font font = this.font;
        Dimension dimension = this.dial.getSize();
        if (this.fontComparisonSize == null && dimension != null && dimension.width > 0 && dimension.height > 0) {
            this.fontComparisonSize = dimension;
            this.fontSizeRatio = 1.0f;
        }
        if (this.resizeFonts && dimension != null && dimension.height > 0 && this.fontComparisonSize != null) {
            f = (float)dimension.height / (float)this.fontComparisonSize.height;
            float f2 = (float)dimension.width / (float)this.fontComparisonSize.width;
            this.fontSizeRatio = Math.min(f, f2);
        }
        if (this.fontSizeRatio > 0.0f && this.fontSizeRatio != 1.0f) {
            f = this.font.getSize2D() * this.fontSizeRatio;
            font = this.font.deriveFont(f);
        }
        graphics2D.setColor(this.color);
        graphics2D.setFont(font);
        double d = this.radius * (double)this.dial.getRadius();
        int n = this.dial.getPivotX();
        int n2 = this.dial.getPivotY();
        float f3 = (float)((double)n + d * Math.cos(Math.toRadians(this.angle)));
        float f4 = (float)((double)n2 - d * Math.sin(Math.toRadians(this.angle)));
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n3 = fontMetrics.stringWidth(this.label);
        graphics2D.drawString(this.label, f3 - (float)n3 / 2.0f, f4 + (float)fontMetrics.getAscent() / 2.0f);
        graphics2D.dispose();
    }
}

