/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.util.Point2DPool;
import com.jidesoft.gauge.Dial;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DialConicalPaint
implements Paint {
    private WeakReference<Dial> dialRef;
    private double[] fractionAngles;
    private double[] redFraction;
    private double[] greenFraction;
    private double[] blueFraction;
    private double[] alphaFraction;
    private Color[] colors;

    public DialConicalPaint(Dial dial, float[] fArray, Color[] colorArray) {
        if (fArray.length != colorArray.length) {
            throw new IllegalArgumentException("Angles and colors must have the same length");
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(fArray.length);
        for (float f : fArray) {
            arrayList.add(Float.valueOf(this.normalize(f) / 360.0f));
        }
        Object object = new ArrayList(colorArray.length);
        object.addAll(Arrays.asList(colorArray));
        this.init(dial, arrayList, (List<Color>)object);
    }

    private float normalize(float f) {
        while (f < 0.0f) {
            f += 360.0f;
        }
        while (f >= 360.0f) {
            f -= 360.0f;
        }
        return f;
    }

    private void init(Dial dial, List<Float> list, List<Color> list2) {
        int n;
        TreeMap<Float, Color> treeMap = new TreeMap<Float, Color>();
        for (int i = 0; i < list.size(); ++i) {
            treeMap.put(list.get(i), list2.get(i));
        }
        list.clear();
        list2.clear();
        for (Map.Entry entry : treeMap.entrySet()) {
            list.add((Float)entry.getKey());
            list2.add((Color)entry.getValue());
        }
        this.dialRef = new WeakReference<Dial>(dial);
        this.colors = list2.toArray(new Color[list2.size()]);
        int n2 = list2.size() + 1;
        this.fractionAngles = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.fractionAngles[n] = n == list.size() ? (double)(360.0f + list.get(0).floatValue() * 360.0f) : (double)(list.get(n).floatValue() * 360.0f);
        }
        this.redFraction = new double[n2];
        this.greenFraction = new double[n2];
        this.blueFraction = new double[n2];
        this.alphaFraction = new double[n2];
        for (n = 0; n < n2; ++n) {
            Color color = n < this.colors.length ? this.colors[n] : this.colors[n - this.colors.length];
            Color color2 = n + 1 < this.colors.length ? this.colors[n + 1] : this.colors[n + 1 - this.colors.length];
            double d = this.fractionAngles[n];
            double d2 = n + 1 < this.fractionAngles.length ? this.fractionAngles[n + 1] : 360.0 + this.fractionAngles[n + 1 - this.fractionAngles.length];
            double d3 = d2 - d;
            this.redFraction[n] = (double)((float)(color2.getRed() - color.getRed()) / 255.0f) / d3;
            this.greenFraction[n] = (double)((float)(color2.getGreen() - color.getGreen()) / 255.0f) / d3;
            this.blueFraction[n] = (double)((float)(color2.getBlue() - color.getBlue()) / 255.0f) / d3;
            this.alphaFraction[n] = (double)((float)(color2.getAlpha() - color.getAlpha()) / 255.0f) / d3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        Point2D point2D;
        Dial dial = (Dial)this.dialRef.get();
        assert (dial != null);
        Point2D point2D2 = null;
        try {
            point2D2 = Point2DPool.instance().borrow(dial.getPivotX(), dial.getPivotY());
            point2D = affineTransform.transform(point2D2, null);
            Point2DPool.instance().replace(point2D2);
        }
        catch (Throwable throwable) {
            Point2DPool.instance().replace(point2D2);
            throw throwable;
        }
        return new DialPaintContext(point2D);
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    private final class DialPaintContext
    implements PaintContext {
        private final Point2D center;

        public DialPaintContext(Point2D point2D) {
            this.center = new Point2D.Double(point2D.getX(), point2D.getY());
        }

        @Override
        public void dispose() {
        }

        @Override
        public DirectColorModel getColorModel() {
            return (DirectColorModel)ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            double d = (double)(-n) + this.center.getX();
            double d2 = (double)(-n2) + this.center.getY();
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            int[] nArray = new int[n3 * n4 * 4];
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n5;
                    double d7 = (double)j - d;
                    double d8 = (double)i - d2;
                    double d9 = Math.sqrt(d7 * d7 + d8 * d8);
                    if (d9 == 0.0) {
                        d9 = 1.0;
                    }
                    double d10 = Math.abs(Math.toDegrees(Math.acos(d7 / d9)));
                    if (!(d8 <= 0.0)) {
                        if (d7 >= 0.0 && d8 >= 0.0) {
                            d10 = 360.0 - d10;
                        } else if (d7 <= 0.0 && d8 >= 0.0) {
                            d10 = 360.0 - d10;
                        }
                    }
                    if (d10 < DialConicalPaint.this.fractionAngles[0]) {
                        d10 += 360.0;
                    }
                    for (n5 = 0; n5 < DialConicalPaint.this.fractionAngles.length; ++n5) {
                        if (!(d10 >= DialConicalPaint.this.fractionAngles[n5])) continue;
                        Color color = n5 == DialConicalPaint.this.colors.length ? DialConicalPaint.this.colors[0] : DialConicalPaint.this.colors[n5];
                        float[] fArray = color.getRGBComponents(null);
                        d3 = (double)fArray[0] + (d10 - DialConicalPaint.this.fractionAngles[n5]) * DialConicalPaint.this.redFraction[n5];
                        d4 = (double)fArray[1] + (d10 - DialConicalPaint.this.fractionAngles[n5]) * DialConicalPaint.this.greenFraction[n5];
                        d5 = (double)fArray[2] + (d10 - DialConicalPaint.this.fractionAngles[n5]) * DialConicalPaint.this.blueFraction[n5];
                        d6 = (double)fArray[3] + (d10 - DialConicalPaint.this.fractionAngles[n5]) * DialConicalPaint.this.alphaFraction[n5];
                    }
                    n5 = (i * n3 + j) * 4;
                    nArray[n5] = (int)(d3 * 255.0);
                    nArray[n5 + 1] = (int)(d4 * 255.0);
                    nArray[n5 + 2] = (int)(d5 * 255.0);
                    nArray[n5 + 3] = (int)(d6 * 255.0);
                }
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            return writableRaster;
        }
    }
}

