/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.axis.DefaultNumericTickCalculator;
import com.jidesoft.chart.axis.NumericTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.gauge.Dial;
import com.jidesoft.gauge.DialAxis;
import com.jidesoft.gauge.DialTickStyle;
import com.jidesoft.gauge.NeedleEndShape;
import com.jidesoft.gauge.NeedleStyle;
import com.jidesoft.gauge.Pivot;
import com.jidesoft.range.Range;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Calendar;
import javax.swing.Timer;

public class Clock
extends Dial {
    private TimeListener timeListener = new TimeListener();
    private Pivot pivot;
    private NeedleStyle hourHandStyle;
    private NeedleStyle minuteHandStyle;
    private NeedleStyle secondHandStyle;
    private boolean running = true;

    public Clock() {
        this.setStartAngle(0.0);
        this.setEndAngle(360.0);
        ClockAxis clockAxis = new ClockAxis();
        clockAxis.setStartAngle(90.0);
        clockAxis.setEndAngle(-270.0);
        clockAxis.setInnerRadius(0.9);
        clockAxis.setOuterRadius(0.95);
        clockAxis.setLabelRadius(0.78);
        DialTickStyle dialTickStyle = new DialTickStyle();
        dialTickStyle.setTickColor(Color.black);
        dialTickStyle.setTickWidth(1.0);
        DialTickStyle dialTickStyle2 = new DialTickStyle();
        dialTickStyle2.setTickColor(Color.black);
        dialTickStyle2.setTickLength(0.5);
        dialTickStyle2.setTickWidth(1.0);
        Color color = new Color(50, 50, 50);
        clockAxis.setTickLabelColor(color);
        clockAxis.setTickLabelFont(new Font("Microsoft Sans Serif", 1, 26));
        clockAxis.setMajorTickStyle(dialTickStyle);
        clockAxis.setMinorTickStyle(dialTickStyle2);
        this.setAxis(clockAxis);
        this.hourHandStyle = new NeedleStyle();
        this.hourHandStyle.setOutlineColor(color.brighter());
        this.hourHandStyle.setFillPaint(color);
        this.hourHandStyle.setHeadLength(0.5);
        this.hourHandStyle.setHeadWidth(0.05);
        this.hourHandStyle.setHeadShape(NeedleEndShape.TRIANGULAR);
        this.hourHandStyle.setTailLength(0.0);
        this.hourHandStyle.setTailWidth(0.05);
        this.hourHandStyle.setTailShape(NeedleEndShape.ROUND);
        this.addNeedle("hours", this.hourHandStyle);
        this.setValue("hours", 55.5, false);
        this.minuteHandStyle = new NeedleStyle();
        this.minuteHandStyle.setOutlineColor(color.brighter());
        this.minuteHandStyle.setFillPaint(color);
        this.minuteHandStyle.setHeadLength(0.71);
        this.minuteHandStyle.setHeadWidth(0.035);
        this.minuteHandStyle.setHeadShape(NeedleEndShape.TRIANGULAR);
        this.minuteHandStyle.setTailLength(0.0);
        this.minuteHandStyle.setTailWidth(0.05);
        this.minuteHandStyle.setTailShape(NeedleEndShape.ROUND);
        this.addNeedle("minutes", this.minuteHandStyle);
        this.setValue("minutes", 13.0, false);
        this.secondHandStyle = new NeedleStyle();
        this.secondHandStyle.setOutlineColor(Color.red.darker());
        this.secondHandStyle.setFillPaint(Color.red);
        this.secondHandStyle.setHeadLength(0.73);
        this.secondHandStyle.setBaseWidth(0.01);
        this.secondHandStyle.setHeadWidth(0.01);
        this.secondHandStyle.setHeadShape(NeedleEndShape.FLAT);
        this.secondHandStyle.setTailLength(0.3);
        this.secondHandStyle.setTailWidth(0.02);
        this.secondHandStyle.setTailShape(NeedleEndShape.FLAT);
        this.addNeedle("seconds", this.secondHandStyle);
        this.setValue("seconds", 6.9, true);
        this.pivot = new Pivot(this, 0.03, new Color(170, 0, 0));
        this.pivot.setZOrder(100);
        this.addDrawable(this.pivot);
        this.updateTime();
    }

    public void setHourHandStyle(NeedleStyle needleStyle) {
        this.hourHandStyle = needleStyle;
        this.setNeedleStyle("hours", needleStyle);
    }

    public void setMinuteHandStyle(NeedleStyle needleStyle) {
        this.minuteHandStyle = needleStyle;
        this.setNeedleStyle("minutes", needleStyle);
    }

    public void setSecondHandStyle(NeedleStyle needleStyle) {
        this.secondHandStyle = needleStyle;
        this.setNeedleStyle("seconds", needleStyle);
    }

    public NeedleStyle getSecondHandStyle() {
        return this.secondHandStyle;
    }

    public NeedleStyle getHourHandStyle() {
        return this.hourHandStyle;
    }

    public NeedleStyle getMinuteHandStyle() {
        return this.minuteHandStyle;
    }

    public void setPivot(Pivot pivot) {
        if (this.pivot != null) {
            this.removeDrawable(this.pivot);
        }
        this.pivot = pivot;
        this.addDrawable(pivot);
    }

    public Pivot getPivot() {
        return this.pivot;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean bl) {
        this.running = bl;
        if (bl) {
            this.updateTime();
        }
    }

    private void updateTime() {
        long l = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(13);
        double d = (double)calendar.get(12) + (double)(15 * (n / 15)) / 60.0;
        int n2 = calendar.get(10);
        this.setValue("hours", 5.0 * ((double)n2 + d / 60.0), false);
        this.setValue("minutes", d, false);
        this.setValue("seconds", n, true);
        calendar.set(14, 0);
        calendar.add(13, 1);
        long l2 = calendar.getTimeInMillis() - System.currentTimeMillis();
        Timer timer = new Timer((int)l2, this.timeListener);
        timer.setRepeats(false);
        timer.start();
    }

    static class ClockTickCalculator
    extends DefaultNumericTickCalculator {
        ClockTickCalculator() {
        }

        @Override
        public Tick[] calculateTicks(Range<Double> range) {
            Tick[] tickArray = new Tick[60];
            for (int i = 0; i <= 59; ++i) {
                boolean bl;
                boolean bl2 = bl = i % 5 == 0;
                if (bl) {
                    int n = i == 0 ? 12 : i / 5;
                    tickArray[i] = new Tick((double)i, Integer.toString(n));
                    continue;
                }
                tickArray[i] = new Tick(i);
            }
            return tickArray;
        }
    }

    static class ClockAxis
    extends DialAxis {
        ClockAxis() {
            super(0.0, 60.0);
        }

        @Override
        protected NumericTickCalculator createTickCalculator(double d, double d2, double d3, double d4) {
            return new ClockTickCalculator();
        }
    }

    class TimeListener
    implements ActionListener,
    Serializable {
        TimeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Clock.this.isRunning()) {
                Clock.this.updateTime();
            }
        }
    }
}

