/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.ChartableMap;
import com.jidesoft.chart.render.BarRenderer2D;
import com.jidesoft.gauge.Bullet;
import com.jidesoft.gauge.BulletAxis;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class BulletBarRenderer
extends Bullet
implements BarRenderer2D {
    private BulletAxis axis;
    private Dimension size;

    public BulletBarRenderer() {
        this.setOpaque(false);
        this.setBulletBackground(null);
        this.axis = new BulletAxis();
        this.axis.setVisible(false);
        this.setAxis(this.axis);
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public int getMinimumBreadth() {
        return 0;
    }

    @Override
    public Shape renderBar(Graphics graphics, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4) {
        return null;
    }

    @Override
    public Shape renderBar(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        Range<?> range;
        Orientation orientation = this.getOrientation();
        if (orientation == Orientation.horizontal) {
            range = chart.getXAxis().getRange();
            d7 = chart.getAnimationPosition() * (double)chart.getChartWidth();
            int n = (int)Math.rint(d4);
            this.setBreadthProportion((double)n / d7);
            this.size = new Dimension((int)d7, n);
            d6 = d;
            d5 = d2;
        } else {
            range = chart.getYAxis().getRange();
            d7 = chart.getAnimationPosition() * (double)chart.getChartHeight();
            this.setBreadthProportion(d3 / d7);
            this.size = new Dimension((int)Math.rint(d3), (int)d7);
            d6 = d;
            d5 = d2 + d4 - d7;
        }
        this.axis.setRange(range.minimum(), range.maximum());
        this.setSize(this.size);
        ChartableMap chartableMap = (ChartableMap)chartable;
        for (String string : chartableMap.getValues()) {
            Positionable positionable = chartableMap.getValue(string);
            if (positionable == null) continue;
            double d8 = positionable.position();
            this.setValue(string, range.minimum() + chart.getAnimationPosition() * (d8 - range.minimum()));
        }
        graphics2D.translate(d6, d5);
        super.paintComponent(graphics2D);
        graphics2D.translate(-d6, -d5);
        return new Rectangle2D.Double(d, d2, d3, d4);
    }
}

