/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.BarLabelPlacement;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.gauge.AbstractIndicatorRenderer;
import com.jidesoft.gauge.Bullet;
import com.jidesoft.gauge.BulletAxis;
import com.jidesoft.gauge.IndicatorStyle;
import com.jidesoft.swing.ShadowRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class BarIndicatorRenderer
extends AbstractIndicatorRenderer<Bullet> {
    private double barBreadth = 0.33;
    private Border border = null;
    private BarLabelPlacement labelPlacement = BarLabelPlacement.BAR_CENTER;
    private double barPosition = 0.5;

    public BarLabelPlacement getLabelPlacement() {
        return this.labelPlacement;
    }

    public void setLabelPlacement(BarLabelPlacement barLabelPlacement) {
        this.labelPlacement = barLabelPlacement;
    }

    public double getBarBreadth() {
        return this.barBreadth;
    }

    public void setBarBreadth(double d) {
        this.barBreadth = d;
    }

    public double getBarPosition() {
        return this.barPosition;
    }

    public void setBarPosition(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The barPosition property must be a value between 0 and 1");
        }
        this.barPosition = d;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    @Override
    protected Shape calculateShape(Bullet bullet, Double d) {
        int n;
        int n2;
        double d2;
        double d3;
        if (d == null) {
            return null;
        }
        double d4 = bullet.getMidY();
        double d5 = bullet.getMidX();
        double d6 = bullet.getBulletBreadth();
        double d7 = this.barBreadth * d6;
        BulletAxis bulletAxis = bullet.getAxis();
        double d8 = bullet.calculatePixelCoordinate(bulletAxis, bulletAxis.minimum());
        double d9 = bullet.calculatePixelCoordinate(bulletAxis, d);
        Orientation orientation = bullet.getOrientation();
        if (orientation == Orientation.horizontal) {
            double d10 = d4 + (this.barPosition - 0.5) * d6;
            d3 = (int)(d10 - d7 / 2.0);
            double d11 = (int)(d10 + d7 / 2.0);
            double d12 = (int)d9;
            d2 = (int)d8;
            n2 = (int)(d12 - d2);
            if (n2 == 0) {
                n2 = 1;
            }
            n = (int)(d11 - d3 + 1.0);
        } else {
            double d13 = d5 + (this.barPosition - 0.5) * d6;
            d3 = (int)Math.round(d9);
            double d14 = (int)Math.round(d8);
            d2 = (int)(d13 - d7 / 2.0);
            double d15 = (int)(d13 + d7 / 2.0);
            n2 = (int)(d15 - d2 + 1.0);
            n = (int)(d14 - d3);
            if (n == 0) {
                n = 1;
            }
        }
        return new Rectangle2D.Double(d2, d3, n2, n);
    }

    @Override
    protected void drawIndicator(Graphics2D graphics2D, Bullet bullet, Shape shape, IndicatorStyle indicatorStyle) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        Rectangle rectangle = shape.getBounds();
        double d = bullet.getBulletBreadth();
        graphics2D2.setPaint(indicatorStyle.getFill());
        Object object = graphics2D2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle rectangle2 = graphics2D2.getClipBounds();
        graphics2D2.fill(rectangle);
        graphics2D2.draw(rectangle);
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D2.setClip(rectangle2);
        if (this.border == null) {
            Color color = indicatorStyle.getOutline();
            if (color != null) {
                float f = indicatorStyle.getOutlineWidth();
                float f2 = (float)((double)f * d / 100.0);
                if (f2 < 1.0f) {
                    f2 = 1.0f;
                }
                BasicStroke basicStroke = new BasicStroke(f2);
                Stroke stroke = graphics2D2.getStroke();
                graphics2D2.setStroke(basicStroke);
                graphics2D2.setColor(color);
                graphics2D2.draw(rectangle);
                graphics2D2.setStroke(stroke);
            }
        } else {
            this.border.paintBorder(bullet, graphics2D2, rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        }
        graphics2D2.dispose();
    }

    @Override
    public void paintLabel(Graphics2D graphics2D, Bullet bullet, Double d, IndicatorStyle indicatorStyle) {
        String string = this.generateLabel(d);
        if (string != null && this.labelVisible) {
            double d2;
            double d3;
            double d4;
            double d5;
            int n = bullet.getYStart();
            int n2 = bullet.getYEnd();
            int n3 = bullet.getXStart();
            int n4 = bullet.getXEnd();
            double d6 = bullet.getMidY();
            double d7 = bullet.getMidX();
            BulletAxis bulletAxis = bullet.getAxis();
            double d8 = bullet.calculatePixelCoordinate(bulletAxis, bulletAxis.minimum());
            double d9 = bullet.getBulletBreadth();
            double d10 = this.barBreadth * d9;
            Orientation orientation = bullet.getOrientation();
            double d11 = bullet.calculatePixelCoordinate(bulletAxis, d);
            if (orientation == Orientation.horizontal) {
                d5 = d6 - d10 / 2.0;
                d4 = d6 + d10 / 2.0;
                d3 = d8;
                d2 = d11;
            } else {
                d5 = d11;
                d4 = d8;
                d3 = d7 - d10 / 2.0;
                d2 = d7 + d10 / 2.0;
            }
            Font font = this.getLabelFont() == null ? UIManager.getFont("Label.font") : this.getLabelFont();
            Dimension dimension = bullet.getFontComparisonSize();
            Font font2 = ChartUtils.deriveResizedFont(font, dimension, bullet);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
            int n5 = fontMetrics.stringWidth(string);
            int n6 = fontMetrics.charWidth('o');
            graphics2D.setColor(this.getLabelColor());
            graphics2D.setFont(font2);
            if (orientation == Orientation.horizontal) {
                float f;
                double d12 = d6 + (this.barPosition - 0.5) * d9;
                float f2 = (float)(d12 + (double)(fontMetrics.getAscent() + fontMetrics.getDescent()) / 2.0 - (double)fontMetrics.getDescent());
                if (this.labelPlacement == BarLabelPlacement.START) {
                    f = (float)((double)n3 + (double)n6 / 2.0);
                } else if (this.labelPlacement == BarLabelPlacement.BAR_CENTER) {
                    f = (float)((d3 + d2) / 2.0 - (double)n5 / 2.0);
                } else if (this.labelPlacement == BarLabelPlacement.CENTER) {
                    f = (float)(d7 - (double)n5 / 2.0);
                } else if (this.labelPlacement == BarLabelPlacement.BEFORE_BAR_END) {
                    f = (float)(d11 - (double)n5 - (double)n6 / 2.0);
                } else if (this.labelPlacement == BarLabelPlacement.AFTER_BAR_END) {
                    f = (float)(d11 + (double)n6 / 2.0);
                } else if (this.labelPlacement == BarLabelPlacement.END) {
                    f = (float)((double)(n4 - n5) - (double)n6 / 2.0);
                } else {
                    throw new IllegalArgumentException("Unexpected value for labelPlacement: " + (Object)((Object)this.labelPlacement));
                }
                graphics2D.drawString(string, f, f2);
            } else if (orientation == Orientation.vertical) {
                float f;
                double d13 = d7 + (this.barPosition - 0.5) * d9;
                float f3 = (float)(d13 - (double)n5 / 2.0);
                if (this.labelPlacement == BarLabelPlacement.START) {
                    f = (float)n - (float)fontMetrics.getDescent();
                } else if (this.labelPlacement == BarLabelPlacement.BAR_CENTER) {
                    float f4 = (float)((d5 + d4) / 2.0);
                    f = (float)((double)f4 + (double)(fontMetrics.getAscent() + fontMetrics.getDescent()) / 2.0 - (double)fontMetrics.getDescent());
                } else if (this.labelPlacement == BarLabelPlacement.CENTER) {
                    float f5 = (float)d6;
                    f = (float)((double)f5 + (double)(fontMetrics.getAscent() + fontMetrics.getDescent()) / 2.0 - (double)fontMetrics.getDescent());
                } else if (this.labelPlacement == BarLabelPlacement.BEFORE_BAR_END) {
                    f = (float)d5 + (float)fontMetrics.getAscent();
                } else if (this.labelPlacement == BarLabelPlacement.AFTER_BAR_END) {
                    f = (float)d5 - (float)fontMetrics.getDescent();
                } else if (this.labelPlacement == BarLabelPlacement.END) {
                    f = (float)n2 + (float)fontMetrics.getAscent();
                } else {
                    throw new IllegalArgumentException("Unexpected value for labelPlacement: " + (Object)((Object)this.labelPlacement));
                }
                graphics2D.drawString(string, f3, f);
            }
        }
    }

    @Override
    public Shape paintLegendItem(Graphics graphics, Bullet bullet, IndicatorStyle indicatorStyle, int n, int n2) {
        Object object;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Paint paint = indicatorStyle.getFill();
        graphics2D.setPaint(paint);
        double d = 0.75 * (double)n2;
        Rectangle rectangle = new Rectangle(4, (int)Math.ceil((double)n2 * 0.25 / 2.0), n - 8, (int)Math.ceil(d));
        graphics2D.fill(rectangle);
        Color color = indicatorStyle.getOutline();
        if (color != null) {
            float f = indicatorStyle.getOutlineWidth();
            object = new BasicStroke(f);
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(color);
            graphics2D.draw(rectangle);
        }
        ShadowRenderer shadowRenderer = this.getShadowRenderer();
        if (bullet.isShadowVisible()) {
            object = shadowRenderer.createShadow(bufferedImage);
            graphics.drawImage((Image)object, 0, 0, bullet);
        }
        graphics.drawImage(bufferedImage, 0, 0, bullet);
        graphics2D.dispose();
        return null;
    }
}

