/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.ResizableComponent;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.chart.util.GraphicsUtilities;
import com.jidesoft.gauge.AbstractNumericGaugeAxis;
import com.jidesoft.gauge.GaugeModel;
import com.jidesoft.gauge.GaugeModelEvent;
import com.jidesoft.gauge.GaugeModelListener;
import com.jidesoft.range.Positionable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractGauge<AxisType>
extends JComponent
implements GaugeModelListener,
ResizableComponent {
    private static final long serialVersionUID = 5552949099443915213L;
    public static final String DEFAULT_NEEDLE_NAME = "default";
    public static final String PROPERTY_BACKGROUND_PAINT = "Background Paint";
    public static final String PROPERTY_RESIZE_FONTS = "Resize Fonts";
    private boolean shadowVisible = false;
    private transient Paint backgroundPaint;
    private boolean resizeFonts = true;
    private transient GaugeModel model;
    private Dimension fontComparisonSize = null;
    private float fontSizeRatio = 1.0f;
    private boolean allowTickLabelOverlap = false;

    @Override
    public void gaugeChanged(GaugeModelEvent gaugeModelEvent) {
        this.repaint();
    }

    public GaugeModel getModel() {
        return this.model;
    }

    public void setModel(GaugeModel gaugeModel) {
        if (this.model != null) {
            this.model.removeGaugeModelListener(this);
        }
        this.model = gaugeModel;
        if (gaugeModel != null) {
            gaugeModel.addGaugeModelListener(this);
        }
    }

    public Double getValue() {
        return this.getValue(DEFAULT_NEEDLE_NAME);
    }

    public Double getValue(String string) {
        Positionable positionable = this.model.getValue(string);
        return positionable == null ? null : Double.valueOf(positionable.position());
    }

    protected Positionable createPositionable(Double d) {
        return d == null ? null : new RealPosition(d);
    }

    public void setValue(int n) {
        this.setValue(DEFAULT_NEEDLE_NAME, this.createPositionable(Double.valueOf(n)));
    }

    public void setValue(Double d) {
        this.setValue(DEFAULT_NEEDLE_NAME, this.createPositionable(d));
    }

    public void setValue(String string, Double d) {
        this.setValue(string, this.createPositionable(d));
    }

    public void setValue(String string, int n) {
        this.setValue(string, this.createPositionable(Double.valueOf(n)));
    }

    public void setValue(String string, Positionable positionable) {
        this.setValue(string, positionable, true);
    }

    public void setValue(String string, double d, boolean bl) {
        this.setValue(string, this.createPositionable(d), bl);
    }

    public abstract void setValue(String var1, Positionable var2, boolean var3);

    protected abstract Point2D calculatePixelPoint2D(AxisType var1, double var2);

    public boolean isShadowVisible() {
        return this.shadowVisible;
    }

    public void setShadowVisible(boolean bl) {
        this.shadowVisible = bl;
        this.repaint();
    }

    public void setResizeFonts(boolean bl) {
        boolean bl2 = this.resizeFonts;
        this.resizeFonts = bl;
        this.firePropertyChange(PROPERTY_RESIZE_FONTS, bl2, bl);
    }

    @Override
    public boolean isResizeFonts() {
        return this.resizeFonts;
    }

    public Dimension getFontComparisonSize() {
        return this.fontComparisonSize;
    }

    public void setFontComparisonSize(Dimension dimension) {
        this.fontComparisonSize = dimension;
    }

    public float getFontSizeRatio() {
        return this.fontSizeRatio;
    }

    protected void setFontSizeRatio(float f) {
        this.fontSizeRatio = f;
    }

    public Font tickLabelFontForAxis(AbstractNumericGaugeAxis abstractNumericGaugeAxis) {
        Font font = abstractNumericGaugeAxis.getTickLabelFont();
        if (this.isResizeFonts()) {
            Dimension dimension = this.getFontComparisonSize();
            return ChartUtils.deriveResizedFont(font, dimension, this);
        }
        return font;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint == null ? this.getBackground() : this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        Paint paint2 = this.getBackgroundPaint();
        this.backgroundPaint = paint;
        this.repaint();
        this.firePropertyChange(PROPERTY_BACKGROUND_PAINT, paint2, paint);
    }

    protected Color getAncestorBackground() {
        return AbstractGauge.getAncestorBackground(this);
    }

    private static Color getAncestorBackground(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        Color color = container.getBackground();
        if (color == null) {
            return AbstractGauge.getAncestorBackground(container);
        }
        return color;
    }

    protected String longestTickLabel(Collection<Tick> collection, FontMetrics fontMetrics) {
        int n = 0;
        String string = "";
        for (Tick tick : collection) {
            String string2 = tick.getLabel();
            if (string2 == null || fontMetrics.stringWidth(string2) <= n) continue;
            n = fontMetrics.stringWidth(string2);
            string = string2;
        }
        return string;
    }

    protected boolean drawStringIfWithinBounds(Graphics2D graphics2D, String string, float f, float f2) {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
        Rectangle2D rectangle2D = GraphicsUtilities.calculateStringBounds(graphics2D, string, f, f2);
        if (GraphicsUtilities.rectangleWithinBounds(rectangle2D, rectangle2)) {
            this.paintLabel(graphics2D, string, f, f2, rectangle2D);
            return true;
        }
        return false;
    }

    private void paintLabel(Graphics2D graphics2D, String string, float f, float f2, Rectangle2D rectangle2D) {
        graphics2D.drawString(string, f, f2);
    }

    protected boolean drawRotatedStringIfWithinBounds(Graphics graphics, Font font, String string, float f, float f2, double d) {
        Rectangle rectangle = this.getBounds();
        Container container = this.getParent();
        Rectangle rectangle2 = container == null ? null : SwingUtilities.convertRectangle(container, rectangle, this);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (string == null || "".equals(string)) {
            return false;
        }
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getDescent();
        float f3 = f + (float)n / 2.0f;
        double d2 = Math.abs((double)n * Math.cos(d));
        double d3 = Math.abs((double)n * Math.sin(d));
        double d4 = (double)f3 - d2 / 2.0;
        double d5 = (double)f3 + d2 / 2.0;
        double d6 = (double)f2 - d3 / 2.0;
        double d7 = (double)f2 + d3 / 2.0;
        if (rectangle2 == null || d4 >= rectangle2.getMinX() && d5 < rectangle2.getMaxX() && d6 >= rectangle2.getMinY() && d7 < rectangle2.getMaxY()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.translate(f3, f2);
            graphics2D.rotate(-d);
            graphics2D.drawString(string, (float)(-n) / 2.0f, (float)n2);
            graphics2D.rotate(d);
            graphics2D.translate(-f3, -f2);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            return true;
        }
        return false;
    }

    public boolean isAllowTickLabelOverlap() {
        return this.allowTickLabelOverlap;
    }

    public void setAllowTickLabelOverlap(boolean bl) {
        this.allowTickLabelOverlap = bl;
    }
}

