/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.DefaultGanttEntryRenderer;
import com.jidesoft.gantt.GanttChartPane;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.GanttEntryRelationEvent;
import com.jidesoft.gantt.GanttEntryRelationListener;
import com.jidesoft.gantt.GanttEntryRenderer;
import com.jidesoft.gantt.GanttLabelRenderer;
import com.jidesoft.gantt.GanttModel;
import com.jidesoft.gantt.GanttModelEvent;
import com.jidesoft.gantt.GanttModelListener;
import com.jidesoft.gantt.GanttResources;
import com.jidesoft.gantt.PeriodBackgroundPainter;
import com.jidesoft.gantt.SubEntryGanttEntry;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.plaf.GanttChartUI;
import com.jidesoft.plaf.GanttEntryRelationPainter;
import com.jidesoft.plaf.GanttUIDefaultsCustomizer;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicGanttChartUI;
import com.jidesoft.range.Range;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.scale.ScaleModel;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SizeSequence;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.JTableHeader;

public class GanttChart<T, S extends GanttEntry<T>>
extends JComponent
implements Scrollable,
GanttModelListener,
GanttEntryRelationListener,
ListSelectionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -9094319801088118704L;
    private static final String uiClassID = "GanttChartUI";
    public static final String PROPERTY_SCALE_AREA = "scaleArea";
    public static final String PROPERTY_GANTT_MODEL = "ganttModel";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_VIEW_MODE = "viewMode";
    public static final String PROPERTY_ROW_HEIGHT = "rowHeight";
    public static final String PROPERTY_ROW_MARGIN = "rowMargin";
    public static final String PROPERTY_GRID_COLOR = "gridColor";
    public static final String PROPERTY_SHOW_GRID = "showGrid";
    public static final String PROPERTY_LABEL_POSITION = "labelPosition";
    public static final String PROPERTY_LABEL_ENTRY_GAP = "labelEntryGap";
    public static final int VIEW_MODE_EDITING = 0;
    public static final int VIEW_MODE_PANNING = 1;
    private static final int VIEW_MODE_LASSO_SELECTION = 2;
    private static final int AREA_SIZE_RESIZE = 4;
    private final Map<Integer, GanttEntryRelationPainter> _painters = new HashMap<Integer, GanttEntryRelationPainter>();
    private final List<PeriodBackgroundPainter<T>> _backgroundPainters = new ArrayList<PeriodBackgroundPainter<T>>();
    private ScaleArea<T> _scaleArea;
    private GanttModel<T, S> _model;
    private SizeSequence _rowModel;
    private ListSelectionModel _selectionModel;
    private Color _selectionForeground;
    private Color _selectionBackground;
    private int _rowHeight;
    private int _rowMargin;
    private boolean _showGrid;
    private Color _gridColor;
    private boolean _isRowHeightSet;
    private Dimension _preferredScrollableViewportSize;
    private boolean _editable = true;
    private int _viewMode;
    private GanttEntryRenderer _defaultEntryRenderer = new DefaultGanttEntryRenderer();
    private GanttLabelRenderer _defaultLabelRenderer;
    private int _labelPosition = 11;
    private int _labelEntryGap = 8;
    private boolean _allowMoveEntry = true;
    private boolean _allowMouseWheelZoom = true;
    private int _resizeAreaWidth = 4;
    private static final Insets _ganttEntryPadding;
    private boolean rowSelectionAdjusting;

    public GanttChart() {
        this(new ScaleArea());
    }

    public GanttChart(GanttModel<T, S> ganttModel) {
        this(ganttModel, new ScaleArea());
    }

    public GanttChart(ScaleArea<T> scaleArea) {
        this(null, scaleArea);
    }

    public GanttChart(GanttModel<T, S> ganttModel, ScaleArea<T> scaleArea) {
        this.setScaleArea(scaleArea);
        this.setModel(ganttModel);
        this.setRowHeight(16);
        this.setAutoscrolls(true);
        this.setSelectionModel(this.createDefaultSelectionModel());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.updateUI();
    }

    public void setScaleArea(ScaleArea<T> scaleArea) {
        Container container;
        ScaleArea<T> scaleArea2 = this._scaleArea;
        if (scaleArea2 == scaleArea) {
            return;
        }
        if (this._scaleArea != null) {
            this._scaleArea.removePropertyChangeListener(this);
        }
        this._scaleArea = scaleArea;
        if (this._scaleArea != null) {
            this._scaleArea.removePropertyChangeListener(this);
            this._scaleArea.addPropertyChangeListener(this);
        }
        if (this._scaleArea != null && this._model != null) {
            this._scaleArea.setScaleModel(this._model.getScaleModel());
        }
        this.updateRange();
        this.configureEnclosingScrollPane();
        for (container = this.getParent(); container != null && !(container instanceof GanttChartPane); container = container.getParent()) {
        }
        if (container != null && ((GanttChartPane)container).getTreeTable() != null) {
            JTableHeader jTableHeader = ((GanttChartPane)container).getTreeTable().getTableHeader();
            for (container = jTableHeader.getParent(); container != null && !(container instanceof JViewport); container = container.getParent()) {
            }
            if (container != null) {
                container.invalidate();
                container.repaint();
                container.doLayout();
            }
        }
        this.firePropertyChange(PROPERTY_SCALE_AREA, scaleArea2, this._scaleArea);
        this.resizeAndRepaint();
    }

    public ScaleArea<T> getScaleArea() {
        return this._scaleArea;
    }

    public GanttModel<T, S> getModel() {
        return this._model;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean bl) {
        if (this._editable != bl) {
            this._editable = bl;
            this.firePropertyChange(PROPERTY_EDITABLE, !bl, bl);
        }
    }

    @Override
    public void ganttEntryRelationChanged(GanttEntryRelationEvent ganttEntryRelationEvent) {
        this.resizeAndRepaint();
    }

    @Override
    public void ganttChartChanged(GanttModelEvent ganttModelEvent) {
        if (ganttModelEvent.getFirstRow() == -2 || ganttModelEvent.getLastRow() == -2) {
            this.updateScaleAreaRange();
        }
        this.resizeAndRepaint();
    }

    private void updateScaleAreaRange() {
        if (this._scaleArea != null) {
            Rectangle rectangle;
            Range<T> range = this._model.getRange();
            T t = this._scaleArea.getStart();
            if (!t.equals(range.lower())) {
                rectangle = this._scaleArea.getVisibleRect();
                boolean bl = rectangle.contains(this._scaleArea.getX(range.lower()), rectangle.y);
                this._scaleArea.setStart(range.lower());
                if (bl) {
                    this.scrollSpanToVisible(range.lower(), range.upper());
                }
            }
            if (!((Object)(rectangle = this._scaleArea.getEnd())).equals(range.upper())) {
                Rectangle rectangle2 = this.getVisibleRect();
                int n = this._scaleArea.getX(range.upper());
                boolean bl = rectangle2.contains(n, rectangle2.y);
                this._scaleArea.setEnd(range.upper());
                if (bl) {
                    this.scrollRectToVisible(new Rectangle(n, rectangle2.y, rectangle2.width, rectangle2.height));
                }
            }
        }
    }

    public void setModel(GanttModel<T, S> ganttModel) {
        GanttModel<T, S> ganttModel2 = this._model;
        if (this._model != null) {
            this._model.removeGanttModelListener(this);
            this._model.getGanttEntryRelationModel().removeGanttEntryRelationListener(this);
        }
        this._model = ganttModel;
        if (this._model != null) {
            this._model.addGanttModelListener(this);
            this._model.getGanttEntryRelationModel().addGanttEntryRelationListener(this);
            if (this._scaleArea != null) {
                this._scaleArea.setScaleModel(this._model.getScaleModel());
            }
        } else if (this._scaleArea != null) {
            this._scaleArea.setScaleModel(null);
        }
        this.updateRange();
        this.firePropertyChange(PROPERTY_GANTT_MODEL, ganttModel2, this._model);
        this.resizeAndRepaint();
    }

    private void updateRange() {
        if (this._scaleArea != null) {
            if (this._model != null) {
                Range<T> range = this._model.getRange();
                if (range != null) {
                    this._scaleArea.setStart(range.lower());
                    this._scaleArea.setEnd(range.upper());
                }
            } else if (this._scaleArea.getScaleModel() != null) {
                ScaleModel<T> scaleModel = this._scaleArea.getScaleModel();
                this._scaleArea.setStart(scaleModel.getDefaultStart());
                this._scaleArea.setEnd(scaleModel.getDefaultEnd());
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this._preferredScrollableViewportSize != null) {
            return this._preferredScrollableViewportSize;
        }
        GanttChartUI ganttChartUI = this.getUI();
        if (ganttChartUI != null) {
            return ganttChartUI.getPreferredScrollableViewportSize(this);
        }
        int n = 400;
        if (this._scaleArea != null) {
            n = this._scaleArea.getPreferredPeriodSize().width * this._scaleArea.getVisiblePeriodCount();
        }
        return new Dimension(n, 400);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width;
        }
        if (this._scaleArea != null && this._scaleArea.getTreeTable() != null) {
            return this._scaleArea.getTreeTable().getScrollableBlockIncrement(rectangle, n, n2);
        }
        return rectangle.height;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && this.getParent().getWidth() > this.getPreferredSize().width;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 0: {
                if (this._scaleArea != null) {
                    return this._scaleArea.getPreferredPeriodSize().width;
                }
                return Math.max(1, rectangle.width / 100);
            }
        }
        if (this._scaleArea != null && this._scaleArea.getTreeTable() != null) {
            return this._scaleArea.getTreeTable().getScrollableUnitIncrement(rectangle, n, n2);
        }
        if (this.isRowHeightSet()) {
            return this.getRowHeight();
        }
        return Math.max(1, rectangle.height / 100);
    }

    protected void setUI(GanttChartUI ganttChartUI) {
        super.setUI(ganttChartUI);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public GanttChartUI getUI() {
        return (GanttChartUI)this.ui;
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
            new GanttUIDefaultsCustomizer().customize(UIManager.getLookAndFeelDefaults());
        }
        this.setUI((GanttChartUI)UIManager.getUI(this));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            ScaleArea<T> scaleArea = this.getScaleArea();
            if (scaleArea != null) {
                jScrollPane.setColumnHeaderView(scaleArea);
            }
        }
    }

    public int getEntryCount() {
        GanttModel<T, S> ganttModel = this.getModel();
        if (ganttModel != null) {
            return ganttModel.getEntryCount();
        }
        return 0;
    }

    public S getEntryAt(Point point) {
        int n = this.rowAtPoint(point);
        int n2 = -1;
        if (n != -1 && this.getUI() instanceof BasicGanttChartUI) {
            n2 = ((BasicGanttChartUI)this.getUI()).getSubEntryIndex(n, point);
        }
        S s = this.getEntryAt(n, n2);
        Rectangle rectangle = this.getEntryRect((GanttEntry<T>)s, n);
        if (s != null && n2 < 0 && rectangle != null && !rectangle.contains(point)) {
            s = null;
        }
        return s;
    }

    public S getEntryAt(int n) {
        GanttModel<T, S> ganttModel = this.getModel();
        if (ganttModel != null) {
            return ganttModel.getEntryAt(n);
        }
        return null;
    }

    public S getEntryAt(int n, int n2) {
        if (n2 < 0) {
            return this.getEntryAt(n);
        }
        GanttModel<T, S> ganttModel = this.getModel();
        if (ganttModel != null) {
            List list;
            S s = ganttModel.getEntryAt(n);
            if (s instanceof SubEntryGanttEntry && (list = ((SubEntryGanttEntry)s).getSubEntries()) != null && n2 >= 0 && n2 < list.size()) {
                return (S)list.get(n2);
            }
            return s;
        }
        return null;
    }

    public int getIndexOf(S s) {
        GanttModel<T, S> ganttModel = this.getModel();
        if (ganttModel != null) {
            return ganttModel.getIndexOf(s);
        }
        return -1;
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        int n2 = this._rowHeight;
        this._rowHeight = n;
        this._rowModel = null;
        this._isRowHeightSet = true;
        this.resizeAndRepaint();
        this.firePropertyChange(PROPERTY_ROW_HEIGHT, n2, n);
    }

    public boolean isRowHeightSet() {
        return this._isRowHeightSet;
    }

    public int getRowHeight() {
        return this._rowHeight;
    }

    public int getTotalRowHeight() {
        if (this.isRowHeightSet()) {
            return this.getEntryCount() * this.getRowHeight();
        }
        return this.sum(this._rowModel.getSizes());
    }

    private int sum(int ... nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    private SizeSequence getRowModel() {
        if (this._rowModel == null) {
            this._rowModel = new SizeSequence(this.getEntryCount(), this.getRowHeight());
        }
        return this._rowModel;
    }

    public void setRowHeight(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        this.getRowModel().setSize(n, n2);
        this.resizeAndRepaint();
    }

    public int getRowHeight(int n) {
        return this._rowModel == null ? this.getRowHeight() : this._rowModel.getSize(n);
    }

    public void setRowMargin(int n) {
        int n2 = this._rowMargin;
        this._rowMargin = n;
        this.resizeAndRepaint();
        this.firePropertyChange(PROPERTY_ROW_MARGIN, n2, n);
    }

    public int getRowMargin() {
        return this._rowMargin;
    }

    public void setGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("New color is null");
        }
        Color color2 = this._gridColor;
        this._gridColor = color;
        this.firePropertyChange(PROPERTY_GRID_COLOR, color2, color);
        this.repaint();
    }

    public Color getGridColor() {
        return this._gridColor;
    }

    public void setShowGrid(boolean bl) {
        boolean bl2 = this._showGrid;
        this._showGrid = bl;
        this.firePropertyChange(PROPERTY_SHOW_GRID, bl2, bl);
        this.repaint();
    }

    public boolean isShowGrid() {
        return this._showGrid;
    }

    public void setViewMode(int n) {
        if (n != this._viewMode) {
            int n2 = this._viewMode;
            this._viewMode = n;
            this.firePropertyChange(PROPERTY_VIEW_MODE, n2, this._viewMode);
        }
    }

    public int getViewMode() {
        return this._viewMode;
    }

    public int rowAtPoint(Point point) {
        int n;
        int n2 = point.y;
        int n3 = n = this._rowModel == null ? n2 / this.getRowHeight() : this._rowModel.getIndex(n2);
        if (n < 0) {
            return -1;
        }
        if (n >= this.getEntryCount()) {
            return -1;
        }
        return n;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        if (n != -1) {
            Rectangle rectangle;
            GanttEntryRenderer ganttEntryRenderer;
            Component component;
            int n2 = -1;
            if (this.getUI() instanceof BasicGanttChartUI) {
                n2 = ((BasicGanttChartUI)this.getUI()).getSubEntryIndex(n, point);
            }
            if ((component = this.prepareRenderer(ganttEntryRenderer = this.getEntryRenderer(n, n2), n, n2, _ganttEntryPadding)) instanceof JComponent && (rectangle = this.getEntryRect(n)) != null) {
                if (rectangle.width == 0) {
                    rectangle.x -= 2;
                    rectangle.width += 4;
                }
                point.translate(-rectangle.x, -rectangle.y);
                if (point.x >= 0 && point.y >= 0 && point.x < rectangle.width && point.y < rectangle.height) {
                    MouseEvent mouseEvent2 = SystemInfo.isJdk6Above() ? new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0) : new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
                    string = ((JComponent)component).getToolTipText(mouseEvent2);
                }
            }
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public Rectangle getEntryRect(int n) {
        S s = this.getEntryAt(n);
        return this.getEntryRect((GanttEntry<T>)s, n);
    }

    public Rectangle getEntryRect(GanttEntry<T> ganttEntry, int n) {
        if (ganttEntry != null) {
            int n2;
            int n3;
            Range<T> range = ganttEntry.getRange();
            if (!this.validRange(range)) {
                return null;
            }
            if (this._rowModel != null) {
                n3 = this._rowModel.getPosition(n);
                n2 = this.getRowHeight(n);
            } else {
                n2 = this.getRowHeight();
                n3 = n * n2;
            }
            ScaleArea<T> scaleArea = this.getScaleArea();
            int n4 = scaleArea.getX(range.lower());
            int n5 = scaleArea.getX(range.upper());
            if (n4 > n5) {
                int n6 = n5;
                n5 = n4;
                n4 = n6;
            }
            return new Rectangle(n4, n3, n5 - n4, n2);
        }
        return null;
    }

    public Rectangle getRowRect(int n, boolean bl) {
        int n2;
        int n3;
        if (this._rowModel != null) {
            n3 = this._rowModel.getPosition(n);
            n2 = this.getRowHeight(n);
        } else {
            n2 = this.getRowHeight();
            n3 = n * n2;
        }
        int n4 = this.getRowMargin();
        if (bl) {
            return new Rectangle(0, n3, this.getWidth(), n2);
        }
        return new Rectangle(0, n3, this.getWidth(), n2 - n4);
    }

    public void autoResizePeriods(boolean bl) {
        if (this._scaleArea != null && this._scaleArea.getScaleModel() != null) {
            ScaleModel scaleModel = this.getScaleArea().getScaleModel();
            T t = scaleModel.getDefaultStart();
            T t2 = scaleModel.getDefaultEnd();
            if (bl && this.getEntryCount() > 0) {
                Rectangle rectangle = this.getVisibleRect();
                Point point = rectangle.getLocation();
                int n = this.rowAtPoint(point);
                point.x += rectangle.width;
                point.y += rectangle.height;
                int n2 = this.rowAtPoint(point);
                if (n2 == -1) {
                    n2 = this.getEntryCount() - 1;
                }
                long l = Long.MAX_VALUE;
                long l2 = Long.MIN_VALUE;
                for (int i = n; i <= n2; ++i) {
                    Range range = this.getEntryAt(i).getRange();
                    if (!this.validRange(range)) continue;
                    Object t3 = range.lower();
                    long l3 = scaleModel.getPosition(t3);
                    if (l3 < l) {
                        l = l3;
                        t = t3;
                    }
                    if ((l3 = scaleModel.getPosition(t3 = range.upper())) <= l2) continue;
                    l2 = l3;
                    t2 = t3;
                }
            } else {
                Range<T> range = this._model.getRange();
                if (this.validRange(range)) {
                    t = range.lower();
                    t2 = range.upper();
                }
            }
            this.zoomPeriods(t, t2);
        }
    }

    private boolean validRange(Range<T> range) {
        return range != null && range.lower() != null && range.upper() != null;
    }

    public void zoomPeriods(T t, T t2) {
        ScaleArea<T> scaleArea = this.getScaleArea();
        if (scaleArea != null) {
            int n = this.getVisibleRect().width;
            if (n <= 0) {
                n = this.getPreferredScrollableViewportSize().width;
            }
            scaleArea.setVisiblePeriodsToFit(t, t2, n);
            this.resizeAndRepaint();
            this.scrollSpanToVisible(t, t2);
        }
    }

    public void zoomInPeriods() {
        this.zoomPeriods(1.2);
    }

    public void zoomOutPeriods() {
        this.zoomPeriods(0.8);
    }

    public void zoomPeriods(double d) {
        ScaleArea<T> scaleArea = this.getScaleArea();
        if (scaleArea != null) {
            scaleArea.zoomPeriodWidth(d);
            this.resizeAndRepaint();
            this.scrollRowToVisible(this.getSelectedRow());
        }
    }

    public void scrollSpanToVisible(Range<T> range) {
        this.scrollSpanToVisible(range.lower(), range.upper());
    }

    public void scrollSpanToVisible(T t, T t2) {
        if (this._scaleArea != null) {
            int n;
            int n2;
            Rectangle rectangle = this.getVisibleRect();
            int n3 = this._scaleArea.getX(t);
            if (n3 > (n2 = this._scaleArea.getX(t2))) {
                n = n2;
                n2 = n3;
                n3 = n;
            }
            n = rectangle.width;
            int n4 = this._scaleArea.getPeriodMargin();
            int n5 = n3 - n4;
            int n6 = n2 - n3 + n4 * 2;
            if (n6 < n) {
                n5 = Math.max(0, n5 - (n - n6) / 2);
                n6 = n;
            }
            this.scrollRectToVisible(new Rectangle(n5, rectangle.y, n6, rectangle.height));
        }
    }

    public void scrollRowToVisible(int n) {
        Rectangle rectangle;
        if (n >= 0 && n < this.getEntryCount() && (rectangle = this.getEntryRect(n)) != null) {
            int n2 = this.getRowHeight(n);
            rectangle.y = Math.max(0, rectangle.y - n2);
            rectangle.height = Math.min(this.getHeight(), rectangle.height + n2 * 2);
            if (this._scaleArea != null) {
                int n3 = this._scaleArea.getPeriodMargin();
                rectangle.x -= n3;
                rectangle.width += n3 * 2;
            }
            this.scrollRectToVisible(rectangle);
        }
    }

    public GanttEntryRenderer getEntryRenderer(int n) {
        return this.getDefaultEntryRenderer();
    }

    public GanttEntryRenderer getEntryRenderer(int n, int n2) {
        return this.getEntryRenderer(n);
    }

    public GanttEntryRenderer getDefaultEntryRenderer() {
        return this._defaultEntryRenderer;
    }

    public void setDefaultEntryRenderer(GanttEntryRenderer ganttEntryRenderer) {
        this._defaultEntryRenderer = ganttEntryRenderer;
    }

    public GanttLabelRenderer getLabelRenderer(int n) {
        return this.getDefaultLabelRenderer();
    }

    public GanttLabelRenderer getLabelRenderer(int n, int n2) {
        return this.getDefaultLabelRenderer();
    }

    public GanttLabelRenderer getDefaultLabelRenderer() {
        return this._defaultLabelRenderer;
    }

    public void setDefaultLabelRenderer(GanttLabelRenderer ganttLabelRenderer) {
        this._defaultLabelRenderer = ganttLabelRenderer;
    }

    public int getLabelPosition() {
        return this._labelPosition;
    }

    public void setLabelPosition(int n) {
        int n2 = this._labelPosition;
        if (n2 != n) {
            this._labelPosition = n;
            this.firePropertyChange(PROPERTY_LABEL_POSITION, n2, this._labelPosition);
        }
    }

    public int getLabelEntryGap() {
        return this._labelEntryGap;
    }

    public void setLabelEntryGap(int n) {
        int n2 = this._labelEntryGap;
        if (n2 != n) {
            this._labelEntryGap = n;
            this.firePropertyChange(PROPERTY_LABEL_ENTRY_GAP, n2, this._labelEntryGap);
        }
    }

    @Deprecated
    public Component prepareRenderer(GanttEntryRenderer ganttEntryRenderer, int n, Insets insets) {
        return this.prepareRenderer(ganttEntryRenderer, n, -1, insets);
    }

    public Component prepareRenderer(GanttEntryRenderer ganttEntryRenderer, int n, int n2, Insets insets) {
        S s = this.getEntryAt(n, n2);
        boolean bl = false;
        boolean bl2 = false;
        if (!this.isPaintingForPrint()) {
            bl = this.isRowSelected(n);
            boolean bl3 = this.getSelectionModel().getLeadSelectionIndex() == n;
            bl2 = bl3 && this.isFocusOwner();
        }
        return ganttEntryRenderer.getGanttEntryRendererComponent(this, (GanttEntry<?>)s, bl, bl2, n, n2, insets);
    }

    public Component prepareLabelRenderer(GanttLabelRenderer ganttLabelRenderer, int n) {
        return this.prepareLabelRenderer(ganttLabelRenderer, n, -1);
    }

    public Component prepareLabelRenderer(GanttLabelRenderer ganttLabelRenderer, int n, int n2) {
        S s = this.getEntryAt(n, n2);
        boolean bl = false;
        boolean bl2 = false;
        if (!this.isPaintingForPrint()) {
            bl = this.isRowSelected(n);
            boolean bl3 = this.getSelectionModel().getLeadSelectionIndex() == n;
            bl2 = bl3 && this.isFocusOwner();
        }
        return ganttLabelRenderer.getGanttLabelRendererComponent(this, (GanttEntry<?>)s, bl, bl2, n, n2);
    }

    public GanttEntryRelationPainter getRelationPainter(int n) {
        return this._painters.get(n);
    }

    public void setRelationPainter(int n, GanttEntryRelationPainter ganttEntryRelationPainter) {
        this._painters.put(n, ganttEntryRelationPainter);
    }

    public List<PeriodBackgroundPainter<T>> getPeriodBackgroundPainters() {
        return this._backgroundPainters;
    }

    public void addPeriodBackgroundPainter(PeriodBackgroundPainter<T> periodBackgroundPainter) {
        this.addPeriodBackgroundPainter(this._backgroundPainters.size(), periodBackgroundPainter);
    }

    public void addPeriodBackgroundPainter(int n, PeriodBackgroundPainter<T> periodBackgroundPainter) {
        this._backgroundPainters.add(Math.min(n, this._backgroundPainters.size()), periodBackgroundPainter);
    }

    public void removePeriodBackgroundPainter(PeriodBackgroundPainter<T> periodBackgroundPainter) {
        this._backgroundPainters.remove(periodBackgroundPainter);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public ListSelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel listSelectionModel2 = this._selectionModel;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this._selectionModel = listSelectionModel;
            this._selectionModel.addListSelectionListener(this);
            this.firePropertyChange("selectionModel", listSelectionModel2, this._selectionModel);
            this.repaint();
        }
    }

    public void setSelectionMode(int n) {
        this.clearSelection();
        this.getSelectionModel().setSelectionMode(n);
    }

    public void clearSelection() {
        this._selectionModel.clearSelection();
    }

    private void clearSelectionAndLeadAnchor() {
        this._selectionModel.setValueIsAdjusting(true);
        this.clearSelection();
        this._selectionModel.setAnchorSelectionIndex(-1);
        this._selectionModel.setLeadSelectionIndex(-1);
        this._selectionModel.setValueIsAdjusting(false);
    }

    private int getAdjustedIndex(int n) {
        int n2 = this.getEntryCount();
        return n < n2 ? n : -1;
    }

    public void selectAll() {
        if (this.getEntryCount() > 0) {
            ListSelectionModel listSelectionModel = this._selectionModel;
            listSelectionModel.setValueIsAdjusting(true);
            this.setSelectionInterval(0, this.getEntryCount() - 1);
            listSelectionModel.setValueIsAdjusting(false);
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    private int boundRow(int n) throws IllegalArgumentException {
        if (n < 0 || n >= this.getEntryCount()) {
            throw new IllegalArgumentException("Entry index out of range");
        }
        return n;
    }

    public void setSelectedIndex(int n) {
        if (n >= this.getEntryCount()) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(n, n);
    }

    public void setSelectionInterval(int n, int n2) {
        this._selectionModel.setSelectionInterval(this.boundRow(n), this.boundRow(n2));
    }

    public void addSelectionInterval(int n, int n2) {
        this._selectionModel.addSelectionInterval(this.boundRow(n), this.boundRow(n2));
    }

    public void removeSelectionInterval(int n, int n2) {
        this._selectionModel.removeSelectionInterval(this.boundRow(n), this.boundRow(n2));
    }

    public int getSelectedRow() {
        return this._selectionModel.getMinSelectionIndex();
    }

    public int[] getSelectedRows() {
        int n = this._selectionModel.getMinSelectionIndex();
        int n2 = this._selectionModel.getMaxSelectionIndex();
        if (n == -1 || n2 == -1) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!this._selectionModel.isSelectedIndex(i)) continue;
            nArray[n3++] = i;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public int getSelectedRowCount() {
        int n = this._selectionModel.getMinSelectionIndex();
        int n2 = this._selectionModel.getMaxSelectionIndex();
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!this._selectionModel.isSelectedIndex(i)) continue;
            ++n3;
        }
        return n3;
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public void setValueIsAdjusting(boolean bl) {
        this.getSelectionModel().setValueIsAdjusting(bl);
    }

    public boolean getValueIsAdjusting() {
        return this.getSelectionModel().getValueIsAdjusting();
    }

    public boolean isRowSelected(int n) {
        return this._selectionModel.isSelectedIndex(n);
    }

    private void changeSelectionModel(ListSelectionModel listSelectionModel, int n, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        if (bl2) {
            if (bl) {
                if (bl4) {
                    listSelectionModel.addSelectionInterval(n2, n);
                } else {
                    listSelectionModel.removeSelectionInterval(n2, n);
                    if (Boolean.TRUE == this.getClientProperty("Table.isFileList")) {
                        listSelectionModel.addSelectionInterval(n, n);
                        listSelectionModel.setAnchorSelectionIndex(n2);
                    }
                }
            } else {
                listSelectionModel.setSelectionInterval(n2, n);
            }
        } else if (bl) {
            if (bl3) {
                listSelectionModel.removeSelectionInterval(n, n);
            } else {
                listSelectionModel.addSelectionInterval(n, n);
            }
        } else {
            listSelectionModel.setSelectionInterval(n, n);
        }
    }

    public void changeSelection(int n, boolean bl, boolean bl2) {
        Rectangle rectangle;
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n2 = this.getAdjustedIndex(listSelectionModel.getAnchorSelectionIndex());
        boolean bl3 = true;
        if (n2 == -1) {
            if (this.getEntryCount() > 0) {
                n2 = 0;
            }
            bl3 = false;
        }
        boolean bl4 = this.isRowSelected(n);
        bl3 = bl3 && this.isRowSelected(n2);
        this.changeSelectionModel(listSelectionModel, n, bl, bl2, bl4, n2, bl3);
        if (this.getAutoscrolls() && (rectangle = this.getRowRect(n, false)) != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public Color getSelectionForeground() {
        return this._selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this._selectionForeground;
        this._selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
        if (!color.equals(color2)) {
            this.repaint();
        }
    }

    public Color getSelectionBackground() {
        return this._selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this._selectionBackground;
        this._selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
        if (!color.equals(color2)) {
            this.repaint();
        }
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    private int limit(int n, int n2, int n3) {
        return Math.min(n3, Math.max(n, n2));
    }

    public void ensureRowIsVisible(int n) {
        Rectangle rectangle = this.getRowRect(n, true);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        super.repaint(l, n, n2, n3, n4);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (this.rowSelectionAdjusting && !bl) {
            this.rowSelectionAdjusting = false;
            return;
        }
        this.rowSelectionAdjusting = bl;
        if (this.getEntryCount() <= 0) {
            return;
        }
        int n = this.limit(listSelectionEvent.getFirstIndex(), 0, this.getEntryCount() - 1);
        int n2 = this.limit(listSelectionEvent.getLastIndex(), 0, this.getEntryCount() - 1);
        Rectangle rectangle = this.getRowRect(n, !this.isShowGrid());
        Rectangle rectangle2 = this.getRowRect(n2, !this.isShowGrid());
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3);
    }

    public String getResourceString(String string) {
        return GanttResources.getResourceBundle(this.getLocale()).getString(string);
    }

    public boolean isAllowMoveEntry() {
        return this._allowMoveEntry;
    }

    public void setAllowMoveEntry(boolean bl) {
        this._allowMoveEntry = bl;
    }

    public boolean isAllowMouseWheelZoom() {
        return this._allowMouseWheelZoom;
    }

    public void setAllowMouseWheelZoom(boolean bl) {
        this._allowMouseWheelZoom = bl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("treeTable".equals(propertyChangeEvent.getPropertyName())) {
            FocusListener[] focusListenerArray;
            for (FocusListener focusListener : focusListenerArray = this.getFocusListeners()) {
                if (!(focusListener instanceof KeyListener) || !(focusListener instanceof TreeWillExpandListener) || !(focusListener instanceof TreeExpansionListener) || !(focusListener instanceof PropertyChangeListener)) continue;
                if (propertyChangeEvent.getOldValue() instanceof TreeTable) {
                    ((TreeTable)propertyChangeEvent.getOldValue()).removeTreeExpansionListener((TreeExpansionListener)((Object)focusListener));
                    ((TreeTable)propertyChangeEvent.getOldValue()).removeTreeWillExpandListener((TreeWillExpandListener)((Object)focusListener));
                }
                if (!(propertyChangeEvent.getNewValue() instanceof TreeTable)) break;
                ((TreeTable)propertyChangeEvent.getNewValue()).addTreeExpansionListener((TreeExpansionListener)((Object)focusListener));
                ((TreeTable)propertyChangeEvent.getNewValue()).addTreeWillExpandListener((TreeWillExpandListener)((Object)focusListener));
                break;
            }
        }
    }

    public int getResizeAreaWidth() {
        return this._resizeAreaWidth;
    }

    public void setResizeAreaWidth(int n) {
        this._resizeAreaWidth = n;
    }

    public boolean isResizeWestArea(Point point, Rectangle rectangle) {
        return point.x < rectangle.x;
    }

    public boolean isResizeEastArea(Point point, Rectangle rectangle) {
        return point.x >= rectangle.x + rectangle.width;
    }

    public boolean isAllowResizeEntry(GanttEntry<T> ganttEntry, T t, T t2) {
        return true;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(8192)) {
            Lm.showInvalidProductMessage(GanttChart.class.getName(), 8192);
        }
        _ganttEntryPadding = UIDefaultsLookup.getInsets("TaskBar.padding");
    }
}

