/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.filter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ConverterContextSupport;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.AbstractFilter;
import com.jidesoft.filter.Filter;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.swing.JideSwingUtilities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class RegexFilter<T>
extends AbstractFilter<T>
implements ConverterContextSupport {
    private static final long serialVersionUID = -7552125704543013824L;
    private String _pattern;
    protected Pattern _regex;
    private boolean _caseSensitive = false;
    protected boolean _beginWith = true;
    private boolean _endWith = true;
    private static final transient HashMap<String, List> _conditionMeasures = new HashMap();
    private ConverterContext _converterContext;
    private Class<?> _type;

    public RegexFilter() {
    }

    public RegexFilter(String string) {
        this.setPattern(string);
    }

    @Override
    public boolean isValueFiltered(T t) {
        String string;
        if (this._regex == null) {
            this._regex = this.createRegexPattern();
        }
        return !this._regex.matcher(string = this.convertElementToString(t)).find();
    }

    protected Pattern createRegexPattern() {
        return Pattern.compile((this.isBeginWith() ? "^" : "") + this.convertFromPatternToRegex(this.getPattern()) + (this.isEndWith() ? "$" : ""), this.isCaseSensitive() ? 0 : 2);
    }

    protected String convertElementToString(T t) {
        if (t == null) {
            return "";
        }
        Class<?> clazz = this.getType();
        ObjectGrouper objectGrouper = this.getObjectGrouper();
        if (objectGrouper == null) {
            return ObjectConverterManager.toString(t, clazz == null ? (t != null ? t.getClass() : null) : clazz, this.getConverterContext());
        }
        Object object = objectGrouper.getValue(t);
        return ObjectConverterManager.toString(object, objectGrouper.getType() != null ? objectGrouper.getType() : object.getClass(), objectGrouper.getConverterContext());
    }

    protected String convertFromPatternToRegex(String string) {
        return string;
    }

    public void setPattern(String string) {
        this._pattern = string;
        this._regex = null;
    }

    public String getPattern() {
        return this._pattern;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
        this._regex = null;
    }

    public boolean isBeginWith() {
        return this._beginWith;
    }

    public void setBeginWith(boolean bl) {
        this._beginWith = bl;
    }

    public boolean isEndWith() {
        return this._endWith;
    }

    public void setEndWith(boolean bl) {
        this._endWith = bl;
    }

    @Override
    public boolean stricterThan(Filter filter) {
        if (this.getClass() != filter.getClass()) {
            return false;
        }
        String string = ((RegexFilter)filter).getPattern();
        if (string == null) {
            return true;
        }
        if (this.getPattern() == null) {
            return false;
        }
        int n = this.getPattern().indexOf(string);
        if (n < 0) {
            return false;
        }
        if (n == 0) {
            if (_conditionMeasures.get(this.getFilterFactoryName()) != null) {
                return !_conditionMeasures.get(this.getFilterFactoryName()).contains(filter.getFilterFactoryName());
            }
            return this.getFilterFactoryName() != null && filter.getFilterFactoryName() != null && JideSwingUtilities.equals(this.getFilterFactoryName(), filter.getFilterFactoryName());
        }
        String string2 = this.getPattern().substring(0, n);
        return !string2.contains("*");
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && this.isBeginWith() == ((RegexFilter)object).isBeginWith() && this.isCaseSensitive() == ((RegexFilter)object).isCaseSensitive() && this.isEndWith() == ((RegexFilter)object).isEndWith() && JideSwingUtilities.equals(this.getPattern(), ((RegexFilter)object).getPattern(), true);
    }

    @Override
    public String getPreference(Class<?> clazz, ConverterContext converterContext) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPattern()).append("\t");
        stringBuffer.append(this.isCaseSensitive() ? "1" : "0").append("\t");
        stringBuffer.append(this.isBeginWith() ? "1" : "0").append("\t");
        stringBuffer.append(this.isEndWith() ? "1" : "0");
        if (this.getObjectGrouperName() != null) {
            stringBuffer.append("\t").append(this.getObjectGrouperName());
        }
        return stringBuffer.toString();
    }

    @Override
    public Object[] setPreference(String string, Class<?> clazz, ConverterContext converterContext) {
        String[] stringArray = string.split("\t");
        if (stringArray.length >= 4) {
            this.setPattern(stringArray[0]);
            this.setCaseSensitive("1".equals(stringArray[1]));
            this.setBeginWith("1".equals(stringArray[2]));
            this.setEndWith("1".equals(stringArray[3]));
            if (stringArray.length >= 5) {
                this.setObjectGrouperName(stringArray[4]);
            }
        }
        return new Object[]{this.getPattern()};
    }

    @Override
    public ConverterContext getConverterContext() {
        return this._converterContext;
    }

    @Override
    public void setConverterContext(ConverterContext converterContext) {
        this._converterContext = converterContext;
    }

    @Override
    public Class<?> getType() {
        return this._type;
    }

    @Override
    public void setType(Class<?> clazz) {
        this._type = clazz;
    }

    static {
        _conditionMeasures.put("not.empty", Arrays.asList("contain", "beginWith", "endWith", "is"));
        _conditionMeasures.put("contain", Arrays.asList("beginWith", "endWith", "is"));
        _conditionMeasures.put("beginWith", Arrays.asList("is"));
        _conditionMeasures.put("endWith", Arrays.asList("is"));
        _conditionMeasures.put("is", Arrays.asList(""));
        _conditionMeasures.put("not.contain", Arrays.asList("isEmpty"));
    }
}

