/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.tokenmarker;

import com.jidesoft.editor.KeywordMap;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import javax.swing.text.Segment;

public class VHDLTokenMarker
extends TokenMarker {
    public static final int AS_IS = 0;
    public static final int LOWER_CASE = 1;
    public static final int UPPER_CASE = 2;
    private static KeywordMap vhdlKeywords;
    private KeywordMap keywords = VHDLTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;
    private int keywordCase = 0;
    private boolean allLowerCase = false;

    @Override
    public byte markTokensImpl(byte by, Segment segment, int n) {
        int n2;
        char[] cArray = segment.array;
        this.lastOffset = n2 = segment.offset;
        this.lastKeyword = n2;
        int n3 = segment.count + n2;
        boolean bl = false;
        block20: for (int i = n2; i < n3; ++i) {
            int n4 = i + 1;
            char c = cArray[i];
            if (c == '\\') {
                bl = !bl;
                continue;
            }
            switch (by) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (!bl) continue block20;
                            bl = false;
                            break;
                        }
                        case '\"': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == n2) {
                                if (this.doKeyword(segment, i, c)) break;
                                bl = false;
                                this.addToken(n4 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = n4;
                                break;
                            }
                            if (!this.doKeyword(segment, i, c)) continue block20;
                            break;
                        }
                        case '-': {
                            bl = false;
                            this.doKeyword(segment, i, c);
                            if (n3 - i <= 1) continue block20;
                            switch (cArray[n4]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, by);
                                    this.lastOffset = this.lastKeyword = i;
                                    by = 1;
                                    break;
                                }
                                case '-': {
                                    this.addToken(i - this.lastOffset, by);
                                    this.addToken(n3 - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = n3;
                                    break block20;
                                }
                            }
                            continue block20;
                        }
                        default: {
                            bl = false;
                            if (Character.isLetterOrDigit(c) || c == '_') continue block20;
                            this.doKeyword(segment, i, c);
                            break;
                        }
                    }
                    continue block20;
                }
                case 1: 
                case 2: {
                    bl = false;
                    if (c != '*' || n3 - i <= 1 || cArray[n4] != '/') continue block20;
                    this.addToken(++i + 1 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block20;
                }
                case 3: {
                    if (bl) {
                        bl = false;
                        continue block20;
                    }
                    if (c != '\"') continue block20;
                    this.addToken(n4 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block20;
                }
                case 4: {
                    if (bl) {
                        bl = false;
                        continue block20;
                    }
                    if (c != '\'') continue block20;
                    this.addToken(n4 - this.lastOffset, (byte)3);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block20;
                }
                default: {
                    throw new InternalError("Invalid state: " + by);
                }
            }
        }
        if (by == 0) {
            this.doKeyword(segment, n3, '\u0000');
        }
        switch (by) {
            case 3: 
            case 4: {
                this.addToken(n3 - this.lastOffset, (byte)10);
                by = 0;
                break;
            }
            case 7: {
                this.addToken(n3 - this.lastOffset, by);
                if (!bl) {
                    by = 0;
                }
            }
            default: {
                this.addToken(n3 - this.lastOffset, by);
            }
        }
        return by;
    }

    public static KeywordMap getKeywords() {
        if (vhdlKeywords == null) {
            vhdlKeywords = new KeywordMap(true);
            vhdlKeywords.add("character", (byte)8);
            vhdlKeywords.add("double", (byte)8);
            vhdlKeywords.add("real", (byte)8);
            vhdlKeywords.add("integer", (byte)8);
            vhdlKeywords.add("natural", (byte)8);
            vhdlKeywords.add("text", (byte)8);
            vhdlKeywords.add("boolean", (byte)8);
            vhdlKeywords.add("line", (byte)8);
            vhdlKeywords.add("string", (byte)8);
            vhdlKeywords.add("positive", (byte)8);
            vhdlKeywords.add("bit", (byte)8);
            vhdlKeywords.add("bit_vector", (byte)8);
            vhdlKeywords.add("std_logic", (byte)8);
            vhdlKeywords.add("std_logic_vector", (byte)8);
            vhdlKeywords.add("if", (byte)6);
            vhdlKeywords.add("then", (byte)6);
            vhdlKeywords.add("elsif", (byte)6);
            vhdlKeywords.add("else", (byte)6);
            vhdlKeywords.add("begin", (byte)6);
            vhdlKeywords.add("end", (byte)6);
            vhdlKeywords.add("for", (byte)6);
            vhdlKeywords.add("while", (byte)6);
            vhdlKeywords.add("loop", (byte)6);
            vhdlKeywords.add("when", (byte)6);
            vhdlKeywords.add("after", (byte)6);
            vhdlKeywords.add("wait", (byte)6);
            vhdlKeywords.add("function", (byte)6);
            vhdlKeywords.add("procedure", (byte)6);
            vhdlKeywords.add("case", (byte)6);
            vhdlKeywords.add("default", (byte)6);
            vhdlKeywords.add("transport", (byte)6);
            vhdlKeywords.add("and", (byte)6);
            vhdlKeywords.add("or", (byte)6);
            vhdlKeywords.add("not", (byte)6);
            vhdlKeywords.add("xor", (byte)6);
            vhdlKeywords.add("entity", (byte)6);
            vhdlKeywords.add("architecture", (byte)6);
            vhdlKeywords.add("port", (byte)6);
            vhdlKeywords.add("in", (byte)6);
            vhdlKeywords.add("out", (byte)6);
            vhdlKeywords.add("inout", (byte)6);
            vhdlKeywords.add("map", (byte)6);
            vhdlKeywords.add("component", (byte)6);
            vhdlKeywords.add("of", (byte)6);
            vhdlKeywords.add("on", (byte)6);
            vhdlKeywords.add("is", (byte)6);
            vhdlKeywords.add("process", (byte)6);
            vhdlKeywords.add("return", (byte)6);
            vhdlKeywords.add("to", (byte)6);
            vhdlKeywords.add("downto", (byte)6);
            vhdlKeywords.add("alias", (byte)6);
            vhdlKeywords.add("variable", (byte)6);
            vhdlKeywords.add("signal", (byte)6);
            vhdlKeywords.add("constant", (byte)6);
            vhdlKeywords.add("generic", (byte)6);
            vhdlKeywords.add("range", (byte)6);
            vhdlKeywords.add("event", (byte)6);
            vhdlKeywords.add("file", (byte)6);
            vhdlKeywords.add("time", (byte)6);
            vhdlKeywords.add("all", (byte)6);
            vhdlKeywords.add("package", (byte)6);
            vhdlKeywords.add("use", (byte)6);
            vhdlKeywords.add("library", (byte)6);
            vhdlKeywords.add("true", (byte)4);
            vhdlKeywords.add("false", (byte)4);
            vhdlKeywords.add("NULL", (byte)4);
        }
        return vhdlKeywords;
    }

    private boolean doKeyword(Segment segment, int n, char c) {
        int n2 = n + 1;
        int n3 = n - this.lastKeyword;
        int n4 = this.lastKeyword;
        int n5 = n;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n3);
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, by);
            this.lastOffset = n;
            if (this.keywordCase == 1 || this.allLowerCase) {
                char[] cArray = segment.array;
                for (int i = n4; i < n5; ++i) {
                    cArray[i] = Character.toLowerCase(cArray[i]);
                }
            } else if (this.keywordCase == 2) {
                char[] cArray = segment.array;
                for (int i = n4; i < n5; ++i) {
                    cArray[i] = Character.toUpperCase(cArray[i]);
                }
            }
        }
        this.lastKeyword = n2;
        return false;
    }

    public void setKeywordCase(int n) {
        this.keywordCase = n;
    }

    public int getKeywordCase() {
        return this.keywordCase;
    }

    public void setAllLowerCase(boolean bl) {
        this.allLowerCase = bl;
    }

    public boolean getAllLowerCase() {
        return this.allLowerCase;
    }
}

