/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.tokenmarker;

import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.tokenmarker.Token;
import javax.swing.text.Segment;

public abstract class TokenMarker {
    private SyntaxDocument _document;
    @Deprecated
    protected Token firstToken;
    @Deprecated
    protected Token lastToken;
    protected final Token[] _tokens = new Token[2];
    @Deprecated
    protected LineInfo[] lineInfo;
    protected byte[] _lineInfoToken;
    protected Object[] _lineInfoExtended;
    protected int length;
    protected int lastLine = -1;
    protected boolean nextLineRequested;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token markTokens(Segment segment, int n) {
        Token[] tokenArray = this._tokens;
        synchronized (this._tokens) {
            byte by;
            if (n >= this.length) {
                throw new IllegalArgumentException("Tokenizing invalid line: " + n);
            }
            this._tokens[1] = null;
            byte by2 = n == 0 ? (byte)0 : this._lineInfoToken[n - 1];
            byte by3 = this._lineInfoToken[n];
            this._lineInfoToken[n] = by = this.markTokensImpl(by2, segment, n);
            if (this.lastLine != n || !this.nextLineRequested) {
                this.nextLineRequested = by3 != by;
            }
            this.lastLine = n;
            this.addToken(0, (byte)127);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.cloneTokens(this._tokens[0]);
        }
    }

    private Token cloneTokens(Token token) {
        Token token2;
        if (token == null) {
            return null;
        }
        Token token3 = token2 = new Token(token.length, token.id);
        while (token != null && token.id != 127) {
            Token token4;
            token = token.next;
            token2.next = token4 = new Token(token.length, token.id);
            token2 = token4;
        }
        return token3;
    }

    public byte getLastToken(int n) {
        if (n >= this.length) {
            throw new IllegalArgumentException("Tokenizing invalid line: " + n);
        }
        return this._lineInfoToken[n];
    }

    protected abstract byte markTokensImpl(byte var1, Segment var2, int var3);

    public boolean supportsMultilineTokens() {
        return true;
    }

    public void insertLines(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        this.length += n2;
        this.ensureCapacity(this.length - 1);
        int n3 = n + n2;
        System.arraycopy(this._lineInfoToken, n, this._lineInfoToken, n3, this._lineInfoToken.length - n3);
        for (int i = n + n2 - 1; i >= n; --i) {
            this._lineInfoToken[i] = 0;
        }
    }

    public void deleteLines(int n, int n2) {
        if (n2 <= 0 || n >= this.length) {
            return;
        }
        if (n + n2 > this.length) {
            n2 = this.length - n;
        }
        int n3 = n + n2;
        this.length -= n2;
        System.arraycopy(this._lineInfoToken, n3, this._lineInfoToken, n, this._lineInfoToken.length - n3);
    }

    public int getLineCount() {
        return this.length;
    }

    public boolean isNextLineRequested() {
        return this.nextLineRequested;
    }

    protected TokenMarker() {
    }

    protected void ensureCapacity(int n) {
        if (this._lineInfoToken == null) {
            this._lineInfoToken = new byte[n + 1];
        } else if (this._lineInfoToken.length <= n) {
            int n2 = Math.min(n + 1, 4096);
            byte[] byArray = new byte[n + 1 + n2];
            System.arraycopy(this._lineInfoToken, 0, byArray, 0, this._lineInfoToken.length);
            this._lineInfoToken = byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToken(int n, byte by) {
        if (by >= 100 && by <= 126) {
            throw new InternalError("Invalid id: " + by);
        }
        if (n == 0 && by != 127) {
            return;
        }
        Token[] tokenArray = this._tokens;
        synchronized (this._tokens) {
            if (this._tokens[0] == null) {
                this._tokens[0] = new Token(n, by);
                this._tokens[1] = this._tokens[0];
            } else if (this._tokens[1] == null) {
                this._tokens[1] = this._tokens[0];
                this._tokens[0].length = n;
                this._tokens[0].id = by;
            } else if (this._tokens[1].next == null) {
                this._tokens[1] = this._tokens[1].next = new Token(n, by);
            } else {
                this._tokens[1] = this._tokens[1].next;
                this._tokens[1].length = n;
                this._tokens[1].id = by;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public SyntaxDocument getDocument() {
        return this._document;
    }

    public void setDocument(SyntaxDocument syntaxDocument) {
        this._document = syntaxDocument;
    }

    @Deprecated
    public class LineInfo {
        public byte token;
        public Object obj;

        public LineInfo() {
        }

        public LineInfo(byte by, Object object) {
            this.token = by;
            this.obj = object;
        }
    }
}

