/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.tokenmarker;

import com.jidesoft.editor.KeywordMap;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import javax.swing.text.Segment;

public class SQLTokenMarker
extends TokenMarker {
    private int offset;
    private int lastOffset;
    private int lastKeyword;
    private int length;
    protected boolean isTSQL = false;
    private KeywordMap keywords;

    public SQLTokenMarker(KeywordMap keywordMap) {
        this(keywordMap, false);
    }

    public SQLTokenMarker(KeywordMap keywordMap, boolean bl) {
        this.keywords = keywordMap;
        this.isTSQL = bl;
    }

    @Override
    public void insertLines(int n, int n2) {
        super.insertLines(n, n2);
        if (n2 <= 0) {
            return;
        }
        int n3 = n + n2;
        System.arraycopy(this._lineInfoExtended, n, this._lineInfoExtended, n3, this._lineInfoExtended.length - n3);
        for (int i = n + n2 - 1; i >= n; --i) {
            this._lineInfoExtended[i] = null;
        }
    }

    @Override
    public void deleteLines(int n, int n2) {
        super.deleteLines(n, n2);
        if (n2 <= 0 || n >= this.length) {
            return;
        }
        if (n + n2 > this.length) {
            n2 = this.length - n;
        }
        int n3 = n + n2;
        System.arraycopy(this._lineInfoExtended, n3, this._lineInfoExtended, n, this._lineInfoExtended.length - n3);
    }

    @Override
    protected void ensureCapacity(int n) {
        super.ensureCapacity(n);
        if (this._lineInfoExtended == null) {
            this._lineInfoExtended = new Object[n + 1];
        } else if (this._lineInfoExtended.length <= n) {
            int n2 = Math.min(n + 1, 4096);
            Object[] objectArray = new Object[n + 1 + n2];
            System.arraycopy(this._lineInfoExtended, 0, objectArray, 0, this._lineInfoExtended.length);
            this._lineInfoExtended = objectArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public byte markTokensImpl(byte by, Segment segment, int n) {
        this.lastOffset = this.lastKeyword = segment.offset;
        this.offset = this.lastKeyword;
        this.length = segment.count + this.offset;
        char c = n > 0 && this._lineInfoExtended != null && this._lineInfoExtended.length > n && this._lineInfoExtended[n - 1] instanceof Character ? ((Character)this._lineInfoExtended[n - 1]).charValue() : (char)'\u0000';
        block13: for (int i = this.offset; i < this.length; ++i) {
            switch (segment.array[i]) {
                case '*': {
                    if (by == 1 && this.length - i >= 1 && segment.array[i + 1] == '/') {
                        by = 0;
                        this.addToken(++i + 1 - this.lastOffset, (byte)1);
                        this.lastOffset = i + 1;
                        break;
                    }
                    if (by != 0) break;
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '[': {
                    if (by != 0) break;
                    this.searchBack(segment, i);
                    by = (byte)3;
                    c = '[';
                    this.lastOffset = i;
                    break;
                }
                case ']': {
                    if (by != 3 || c != '[') break;
                    by = 0;
                    c = '\u0000';
                    this.addToken(i + 1 - this.lastOffset, (byte)3);
                    this.lastOffset = i + 1;
                    break;
                }
                case '(': 
                case ')': 
                case ',': 
                case '.': {
                    if (by != 0) break;
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)0);
                    this.lastOffset = i + 1;
                    break;
                }
                case '%': 
                case '&': 
                case '+': 
                case '<': 
                case '=': 
                case '>': 
                case '^': 
                case '|': 
                case '~': {
                    if (by != 0) break;
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (by != 0) break;
                    this.searchBack(segment, i, false);
                    break;
                }
                case ':': {
                    if (by != 0) break;
                    this.addToken(i + 1 - this.lastOffset, (byte)5);
                    this.lastOffset = i + 1;
                    break;
                }
                case '/': {
                    if (by != 0) break;
                    if (this.length - i >= 2 && segment.array[i + 1] == '*') {
                        this.searchBack(segment, i);
                        by = 1;
                        this.lastOffset = i++;
                        break;
                    }
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '-': {
                    if (by != 0) break;
                    if (this.length - i >= 2 && segment.array[i + 1] == '-') {
                        this.searchBack(segment, i);
                        this.addToken(this.length - i, (byte)1);
                        this.lastOffset = this.length;
                        break block13;
                    }
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '!': {
                    if (!this.isTSQL || by != 0 || this.length - i < 2 || segment.array[i + 1] != '=' && segment.array[i + 1] != '<' && segment.array[i + 1] != '>') break;
                    this.searchBack(segment, i);
                    this.addToken(1, (byte)9);
                    this.lastOffset = i + 1;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (by == 0) {
                        by = (byte)3;
                        c = segment.array[i];
                        this.addToken(i - this.lastOffset, (byte)0);
                        this.lastOffset = i;
                        break;
                    }
                    if (by != 3 || c != segment.array[i]) break;
                    by = 0;
                    c = '\u0000';
                    this.addToken(i + 1 - this.lastOffset, (byte)3);
                    this.lastOffset = i + 1;
                }
            }
        }
        if (by == 0) {
            this.searchBack(segment, this.length, false);
        }
        if (this.lastOffset != this.length) {
            this.addToken(this.length - this.lastOffset, by);
        }
        this._lineInfoExtended[n] = Character.valueOf(c);
        return by;
    }

    private void searchBack(Segment segment, int n) {
        this.searchBack(segment, n, true);
    }

    private void searchBack(Segment segment, int n, boolean bl) {
        int n2 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n2);
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n2, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n + 1;
        if (bl && this.lastOffset < n) {
            this.addToken(n - this.lastOffset, (byte)0);
        }
    }
}

