/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.settings;

import com.jidesoft.combobox.FontListCellRenderer;
import com.jidesoft.editor.CodeEditorResource;
import com.jidesoft.swing.SearchableUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class FontPanel
extends JPanel {
    private String _fontName;
    private int _fontSize;
    private JComboBox _fontNameComboBox;
    private JSpinner _fontSizeSpinner;

    public FontPanel() {
        this.installComponents();
        this.installModel();
    }

    protected void installComponents() {
        this._fontNameComboBox = new JComboBox();
        this._fontNameComboBox.setPrototypeDisplayValue("AAAA AAAA AAAA AAAA AAAA");
        this._fontNameComboBox.setMaximumRowCount(10);
        this._fontNameComboBox.setRenderer(new FontListCellRenderer(this._fontNameComboBox.getRenderer()));
        SearchableUtils.installSearchable(this._fontNameComboBox);
        this._fontSizeSpinner = new JSpinner();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 3, 6);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(this.getResourceString("Settings.font.name"));
        jLabel.setDisplayedMnemonic(this.getResourceString("Settings.font.name.mnemonic").charAt(0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setLabelFor(this._fontNameComboBox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this._fontNameComboBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        JLabel jLabel2 = new JLabel(this.getResourceString("Settings.font.size"));
        jLabel2.setDisplayedMnemonic(this.getResourceString("Settings.font.size.mnemonic").charAt(0));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jLabel2.setLabelFor(this._fontSizeSpinner);
        gridBagConstraints.insets = new Insets(3, 0, 3, 6);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this._fontSizeSpinner, gridBagConstraints);
        this.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Before");
    }

    protected void installModel() {
        this._fontNameComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                String[] stringArray;
                DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
                for (String string : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                    defaultComboBoxModel.addElement(string);
                }
                FontPanel.this._fontNameComboBox.setModel(defaultComboBoxModel);
                if (FontPanel.this._fontName != null) {
                    FontPanel.this._fontNameComboBox.setSelectedItem(FontPanel.this._fontName);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this._fontSizeSpinner.setModel(new SpinnerNumberModel(12, 5, 40, 1));
    }

    public void loadData() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (int i = 0; i < 10; ++i) {
            defaultComboBoxModel.addElement(this._fontName);
        }
        this._fontNameComboBox.setModel(defaultComboBoxModel);
        this._fontNameComboBox.setSelectedItem(this._fontName);
        this._fontSizeSpinner.setValue(this._fontSize);
    }

    public void saveData() {
        this._fontName = "" + this._fontNameComboBox.getSelectedItem();
        this._fontSize = (Integer)this._fontSizeSpinner.getValue();
    }

    public String getFontName() {
        return this._fontName;
    }

    public void setFontName(String string) {
        this._fontName = string;
    }

    public int getFontSize() {
        return this._fontSize;
    }

    public void setFontSize(int n) {
        this._fontSize = n;
    }

    protected String getResourceString(String string) {
        return CodeEditorResource.getResourceBundle(this.getLocale()).getString(string);
    }
}

