/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.marker;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorMarkerSupport;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.marker.MarkerEye;
import com.jidesoft.editor.marker.MarkerStripe;
import com.jidesoft.marker.MarkerStripePainter;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JScrollBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class MarkerArea
extends com.jidesoft.marker.MarkerArea {
    private CodeEditor _codeEditor;
    private Handler _listener;

    public MarkerArea(CodeEditor codeEditor) {
        super(new CodeEditorMarkerSupport(codeEditor));
        this._codeEditor = codeEditor;
        this._codeEditor.setMarkerArea(this);
        this._listener = new Handler();
        codeEditor.getDocument().addDocumentListener(this._listener);
        codeEditor.getFoldingModel().addFoldingSpanListener(this._listener);
        ((MarkerStripe)this._stripe).setCodeEditor(this._codeEditor);
        ((MarkerEye)this._eye).setCodeEditor(this._codeEditor);
    }

    @Override
    protected MarkerStripe createMarkerStripe() {
        return new MarkerStripe(this);
    }

    @Override
    protected MarkerEye createMarkerEye() {
        return new MarkerEye(this);
    }

    @Override
    public void setStripePainter(MarkerStripePainter markerStripePainter) {
        this._stripePainter = markerStripePainter;
        this._stripe.setPainter(this._stripePainter);
    }

    public CodeEditor getCodeEditor() {
        return this._codeEditor;
    }

    public void setCodeEditor(CodeEditor codeEditor) {
        this._codeEditor = codeEditor;
    }

    public int getVisualLineCount() {
        return Math.max(this._codeEditor.getVisualLineCount(), this._codeEditor.getVisibleLines());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getCodeEditor().getDocument().removeDocumentListener(this._listener);
        this.getCodeEditor().getFoldingModel().removeFoldingSpanListener(this._listener);
        this._listener = null;
    }

    @Deprecated
    public Color getColor(int n) {
        return this.getMarkerColor(n);
    }

    @Override
    public void updateMarkerAreaHeight(int n) {
        Component component;
        JScrollBar jScrollBar;
        JScrollBar jScrollBar2 = this._codeEditor.getHorizontalScrollBar();
        if (jScrollBar2 != null && jScrollBar2.isVisible()) {
            n += jScrollBar2.getPreferredSize().height;
        }
        if ((jScrollBar = this._codeEditor.getVerticalScrollBar()) != null && jScrollBar.isVisible() && (component = jScrollBar.getComponentAt(1, jScrollBar.getHeight() - 2)) != null) {
            n += component.getPreferredSize().height;
        }
        super.updateMarkerAreaHeight(n);
    }

    private class Handler
    implements DocumentListener,
    FoldingSpanListener {
        private Handler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            try {
                String string = documentEvent.getDocument().getText(documentEvent.getOffset(), documentEvent.getLength());
                if (string.indexOf(10) != -1) {
                    MarkerArea.this.repaint();
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            MarkerArea.this.repaint();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
            if (!foldingSpanEvent.isAdjusting()) {
                MarkerArea.this.repaint();
            }
        }
    }
}

