/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.margin.AbstractLineMargin;
import com.jidesoft.margin.MarginSupport;
import com.jidesoft.margin.RowMarginSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class LineNumberMargin
extends AbstractLineMargin {
    private static Color DEFAULT_FOREGROUND = new Color(128, 0, 0);
    private transient int _width;
    private boolean _showTooltip = false;
    private transient int _oldCount = -1;

    public LineNumberMargin(CodeEditor codeEditor) {
        super(codeEditor);
        this.setForeground(DEFAULT_FOREGROUND);
        this._oldCount = codeEditor.getLineCount();
    }

    @Override
    public void paintLineMargin(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = this._editor.viewToModelLine(n) + 1;
        if (n2 <= this._editor.getLineCount()) {
            String string = "" + n2;
            graphics.setColor(this.getForeground());
            graphics.drawString(string, rectangle.x + rectangle.width - this._editor.getPainter().getFontMetrics().stringWidth(string) - 3, rectangle.y + this._editor.getPainter().getFontMetrics().getAscent());
        }
    }

    @Override
    public int getPreferredWidth() {
        String string = "" + this._editor.getLineCount();
        this._width = string.length();
        return this._editor.getPainter().getFontMetrics().stringWidth(string) + 6;
    }

    @Override
    public String getToolTipText(int n) {
        if (!this.isShowTooltip()) {
            return null;
        }
        if ((n = this._editor.viewToModelLine(n)) >= this._editor.getLineCount()) {
            return null;
        }
        return "" + (n + 1);
    }

    public boolean isShowTooltip() {
        return this._showTooltip;
    }

    public void setShowTooltip(boolean bl) {
        this._showTooltip = bl;
    }

    @Override
    protected MarginSupport.ModelChangedCallback createModelChangedCallback() {
        return new MarginSupport.ModelChangedCallback(){

            @Override
            public void modelChanged(Object object) {
                int n = ((RowMarginSupport)LineNumberMargin.this._marginSupport).getRowCount();
                if (LineNumberMargin.this._oldCount == -1 || n != LineNumberMargin.this._oldCount && (int)Math.log10(n) != (int)Math.log10(LineNumberMargin.this._oldCount)) {
                    LineNumberMargin.this.revalidate();
                }
                LineNumberMargin.this._oldCount = n;
            }
        };
    }
}

