/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.language;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;

public class LanguageSpec {
    private String _name;
    private List<String> _suffixes;
    private Icon _icon;
    private TokenMarker _tokenMarker;
    private String _nonwordDelimiters;
    private String _lineComment;
    private String _blockCommentStart;
    private String _blockCommentEnd;
    public static final String PROPERTY_NONWORD_DELIMITERS = "nonwordDelimiters";
    public static final String PROPERTY_LINE_COMMENT = "lineComment";
    public static final String PROPERTY_BLOCK_COMMENT_START = "blockCommentStart";
    public static final String PROPERTY_BLOCK_COMMENT_END = "blockCommentEnd";

    public LanguageSpec(String string, String string2, TokenMarker tokenMarker, String string3, String string4) {
        this(string, string2, tokenMarker, string3, string4, null, null);
    }

    public LanguageSpec(String string, String string2, TokenMarker tokenMarker, String string3, String string4, String string5, String string6) {
        this._name = string;
        this._tokenMarker = tokenMarker;
        this._nonwordDelimiters = string3;
        this._lineComment = string4;
        this._blockCommentStart = string5;
        this._blockCommentEnd = string6;
        this._suffixes = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "; ");
        while (stringTokenizer.hasMoreTokens()) {
            this._suffixes.add(stringTokenizer.nextToken());
        }
    }

    public String getName() {
        return this._name;
    }

    public List<String> getSuffixes() {
        return this._suffixes;
    }

    public void addSuffix(String string) {
        this._suffixes.add(string);
    }

    public void addSuffixes(String[] stringArray) {
        for (String string : stringArray) {
            this._suffixes.add(string);
        }
    }

    public void removeSuffix(String string) {
        this._suffixes.remove(string);
    }

    public void clearSuffixes() {
        this._suffixes.clear();
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public TokenMarker getTokenMarker() {
        return this._tokenMarker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        this._tokenMarker = tokenMarker;
    }

    public String getNonwordDelimiters() {
        return this._nonwordDelimiters;
    }

    public void setNonwordDelimiters(String string) {
        this._nonwordDelimiters = string;
    }

    public String getLineComment() {
        return this._lineComment;
    }

    public void setLineComment(String string) {
        this._lineComment = string;
    }

    public String getBlockCommentStart() {
        return this._blockCommentStart;
    }

    public void setBlockCommentStart(String string) {
        this._blockCommentStart = string;
    }

    public String getBlockCommentEnd() {
        return this._blockCommentEnd;
    }

    public void setBlockCommentEnd(String string) {
        this._blockCommentEnd = string;
    }

    public void configureCodeEditor(CodeEditor codeEditor) {
        codeEditor.setTokenMarker(this.getTokenMarker());
        codeEditor.getDocument().putProperty(PROPERTY_NONWORD_DELIMITERS, this.getNonwordDelimiters());
        codeEditor.getDocument().putProperty(PROPERTY_LINE_COMMENT, this.getLineComment());
        codeEditor.getDocument().putProperty(PROPERTY_BLOCK_COMMENT_START, this.getBlockCommentStart());
        codeEditor.getDocument().putProperty(PROPERTY_BLOCK_COMMENT_END, this.getBlockCommentEnd());
    }

    public String toString() {
        return this.getClass().getName() + " [name: " + this._name + "]";
    }
}

