/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.caret;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretEvent;
import com.jidesoft.editor.caret.CaretListener;
import com.jidesoft.editor.caret.CaretModel;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.folding.DefaultFoldingModel;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.selection.SelectionModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DefaultCaretModel
implements CaretModel {
    private EventListenerList _listenerList = null;
    private CaretPosition _modelPosition;
    private CaretPosition _viewPosition;
    private CodeEditor _editor;
    private static final Logger LOGGER_EVENT = Logger.getLogger(CaretEvent.class.getName());

    public DefaultCaretModel(CodeEditor codeEditor) {
        this._editor = codeEditor;
        this._modelPosition = new CaretPosition(0, 0);
        this._viewPosition = new CaretPosition(0, 0);
    }

    @Override
    public CaretPosition getModelPosition() {
        return this._modelPosition;
    }

    @Override
    public void setModelPosition(CaretPosition caretPosition) {
        int n = Math.max(caretPosition.line, 0);
        int n2 = Math.max(caretPosition.column, 0);
        int n3 = Math.max(this._editor.getLineCount() - 1, 0);
        if (n > n3) {
            n = n3;
        }
        CaretPosition caretPosition2 = this._modelPosition;
        this._modelPosition = new CaretPosition(n, n2);
        CaretPosition caretPosition3 = this._viewPosition;
        this.updateViewPosition();
        this.fireCaretEvent(1, caretPosition3, this._viewPosition);
        this.fireCaretEvent(0, caretPosition2, this._modelPosition);
    }

    @Override
    public CaretPosition getViewPosition() {
        return this._viewPosition;
    }

    @Override
    public void setViewPosition(CaretPosition caretPosition) {
        int n = Math.max(caretPosition.line, 0);
        int n2 = Math.max(caretPosition.column, 0);
        int n3 = Math.max(this._editor.getLineCount() - 1, 0);
        if (n > n3) {
            n = n3;
        }
        CaretPosition caretPosition2 = this._viewPosition;
        this._viewPosition = new CaretPosition(n, n2);
        CaretPosition caretPosition3 = this._modelPosition;
        this._modelPosition = this._editor.viewToModelPosition(this._viewPosition);
        this.fireCaretEvent(1, caretPosition2, this._viewPosition);
        this.fireCaretEvent(0, caretPosition3, this._modelPosition);
    }

    @Override
    public void setOffset(int n) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            LOGGER_EVENT.fine("Caret Offset " + n);
        }
        CaretPosition caretPosition = this._editor.offsetToModelPosition(n);
        this.setModelPosition(caretPosition);
    }

    @Override
    public int getOffset() {
        return this._editor.modelPositionToOffset(this._modelPosition);
    }

    @Override
    public synchronized void addCaretListener(CaretListener caretListener) {
        if (this._listenerList == null) {
            this._listenerList = new EventListenerList();
        }
        this._listenerList.add(CaretListener.class, caretListener);
    }

    @Override
    public synchronized void removeCaretListener(CaretListener caretListener) {
        this._listenerList.remove(CaretListener.class, caretListener);
    }

    @Override
    public CaretListener[] getCaretListeners() {
        return (CaretListener[])this._listenerList.getListeners(CaretListener.class);
    }

    protected void fireCaretEvent(int n, CaretPosition caretPosition, CaretPosition caretPosition2) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 1: {
                    LOGGER_EVENT.fine("Caret View Position " + caretPosition + " => " + caretPosition2);
                    break;
                }
                case 0: {
                    LOGGER_EVENT.fine("Caret Model Position " + caretPosition + " => " + caretPosition2);
                    break;
                }
            }
        }
        if (this._listenerList == null) {
            return;
        }
        if (caretPosition2.equals(caretPosition)) {
            return;
        }
        Object[] objectArray = this._listenerList.getListenerList();
        CaretEvent caretEvent = new CaretEvent(this._editor, n, caretPosition, caretPosition2);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CaretListener.class) continue;
            ((CaretListener)objectArray[i + 1]).caretUpdated(caretEvent);
        }
    }

    private int getLineEndOffsetExcludeLineBreak(int n) {
        char c;
        int n2;
        String string = this._editor.getLineText(n);
        if (string == null) {
            return 0;
        }
        for (n2 = string.length(); n2 > 0 && ((c = string.charAt(n2 - 1)) == '\r' || c == '\n'); --n2) {
        }
        return n2;
    }

    @Override
    public void moveCaret(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        boolean bl4 = n2 > 0 || n2 == 0 && n > 0;
        int n4 = bl4 ? Math.min(this._editor.getLeadSelectionOffset(), this._editor.getAnchorSelectionOffset()) : Math.max(this._editor.getLeadSelectionOffset(), this._editor.getAnchorSelectionOffset());
        CaretPosition caretPosition = this.getViewPosition();
        CaretPosition caretPosition2 = this.getModelPosition();
        if (!this._editor.isVirtualSpaceAllowed()) {
            if (caretPosition.column == 0 && caretPosition.line > 0 && n < 0) {
                this.setOffset(this._editor.getLineStartOffset(caretPosition2.line - 1) + this.getLineEndOffsetExcludeLineBreak(caretPosition2.line - 1));
                if (n + 1 < 0) {
                    this.moveCaret(n + 1, n2, bl, bl2, bl3);
                } else {
                    this.adjustSelectionAndScroll(bl, bl3, n4);
                }
                return;
            }
            if (caretPosition2.column >= this.getLineEndOffsetExcludeLineBreak(caretPosition2.line) && n > 0 && this.getOffset() < this._editor.getDocumentLength()) {
                FoldingSpan foldingSpan;
                n3 = 0;
                if (this._editor.getFoldingModel() instanceof DefaultFoldingModel && (foldingSpan = ((DefaultFoldingModel)this._editor.getFoldingModel()).getOutermostSpanAtOffset(this.getOffset())) != null && this._editor.getLineNumber(foldingSpan.getStartOffset()) == caretPosition2.line) {
                    CaretPosition caretPosition3 = this._editor.offsetToViewPosition(foldingSpan.getStartOffset());
                    if (caretPosition3.column + (foldingSpan.getDescription() == null ? 0 : foldingSpan.getDescription().length()) > caretPosition.column) {
                        n3 = 1;
                    }
                }
                if (n3 == 0) {
                    this.setOffset(this._editor.getLineStartOffset(caretPosition2.line + 1));
                    if (n - 1 > 0) {
                        this.moveCaret(n - 1, n2, bl, bl2, bl3);
                    } else {
                        this.adjustSelectionAndScroll(bl, bl3, n4);
                    }
                    return;
                }
            }
        }
        n3 = Math.max(caretPosition.line + n2, 0);
        int n5 = this._editor.viewToModelLine(n3);
        int n6 = this._editor.getDocument().isLineLoaded(caretPosition2.line) && this._editor.getDocument().isLineLoaded(n5) ? Math.max(this._editor.getCorrespondingColumn(caretPosition.column, caretPosition2.line, n5) + n, 0) : caretPosition.column + n;
        CaretPosition caretPosition4 = new CaretPosition(n3, n6);
        if (!this._editor.isVirtualSpaceAllowed() && n2 != 0) {
            int n7;
            CaretPosition caretPosition5 = this._editor.viewToModelPosition(caretPosition4);
            int n8 = this._editor.modelPositionToOffset(caretPosition5);
            if (n8 >= (n7 = this._editor.getLineStartOffset(caretPosition5.line)) + this.getLineEndOffsetExcludeLineBreak(caretPosition5.line)) {
                this.setOffset(n8);
                this.adjustSelectionAndScroll(bl, bl3, n4);
                return;
            }
            int n9 = this._editor.getMagicCaretPosition() + this._editor.getHorizontalOffset();
            int n10 = this._editor.offsetToX(n8);
            if (n10 < n9) {
                this.setOffset(this._editor.xToOffset(caretPosition4.line, n9));
                this.adjustSelectionAndScroll(bl, bl3, n4);
                return;
            }
        }
        this.setViewPosition(caretPosition4);
        this.adjustSelectionAndScroll(bl, bl3, n4);
    }

    private void adjustSelectionAndScroll(boolean bl, boolean bl2, int n) {
        SelectionModel selectionModel = this._editor.getSelectionModel();
        if (bl) {
            selectionModel.setSelection(n, this.getOffset());
        } else {
            selectionModel.clearSelection();
        }
        if (bl2) {
            this._editor.scrollToCaret();
        }
        this._editor.setBlink(true);
    }

    @Override
    public void updateViewPosition() {
        this._viewPosition = this._editor.modelToViewPosition(this._modelPosition);
    }
}

