/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.EntirePageEdit;
import com.jidesoft.editor.LazyLoadUndoableEdit;
import com.jidesoft.editor.PageLoadEvent;
import com.jidesoft.editor.PageLoadListener;
import com.jidesoft.editor.SubPageEdit;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class LazyLoadDocument
extends SyntaxDocument {
    private File _inputFile;
    private String _fileName;
    private String _charsetName = "UTF-8";
    private int _pageLineSize = 10000;
    private int _pageLineSizePending = -1;
    private int _maximumPages = 5;
    private long _fileLengthInFile;
    private long _fileLengthInMemory = 0L;
    private int _totalLineCountInFile = 0;
    private int _totalLineCountInMemory = 0;
    private int _maxLineLength = 0;
    private final List<PageDefinition> _pageCache = new Vector<PageDefinition>();
    private final List<PageDefinition> _unmodifiedPages = new Vector<PageDefinition>();
    private LazyLoadCharSequence _lazyLoadString;
    private DocumentListener _documentListener;
    private PageDefinition _currentPage;
    private boolean _batchProcess;
    private boolean _saving;
    private Thread _fileReadThroughThread;
    private Thread _pageLoadThread;
    private final int[] _linesToLoad = new int[]{-1, -1};
    private static final Logger LOGGER = Logger.getLogger(LazyLoadDocument.class.getName());
    private static final long serialVersionUID = 4831963629433286757L;
    private boolean _tokenAll;
    private boolean _fileReadThrough;

    public LazyLoadDocument() {
        this._documentListener = new DocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                List list = LazyLoadDocument.this._pageCache;
                synchronized (list) {
                    Document document = documentEvent.getDocument();
                    PageDefinition pageDefinition = LazyLoadDocument.this.getPageFromDocument(document);
                    if (pageDefinition == null) {
                        return;
                    }
                    int n = LazyLoadDocument.this._pageCache.indexOf(pageDefinition) + 1;
                    DocumentEvent.ElementChange elementChange = documentEvent.getChange(document.getDefaultRootElement());
                    int n2 = documentEvent.getOffset() + pageDefinition.getStartOffsetInMemory();
                    if (elementChange != null) {
                        int n3 = elementChange.getIndex() + pageDefinition.getStartLineInMemory();
                        Element[] elementArray = elementChange.getChildrenAdded();
                        int n4 = elementArray.length - elementChange.getChildrenRemoved().length;
                        if (LazyLoadDocument.this.tokenMarker != null) {
                            LazyLoadDocument.this.tokenMarker.insertLines(n3 + 1, n4);
                        }
                        if (n4 > 0) {
                            LazyLoadDocument.this.updateStartLineInPages(n, n4);
                        }
                    }
                    LazyLoadDocument.this.updateOffsetInPages(n, documentEvent.getLength());
                    LazyLoadDocument.this.setPageModified(pageDefinition);
                    if (!LazyLoadDocument.this.isBatchProcess()) {
                        LazyLoadDocument.this.fireInsertUpdate(LazyLoadDocument.this.createCombinedDocumentEvent(n2, documentEvent));
                    }
                    LazyLoadDocument.this.verifyConsistency();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                List list = LazyLoadDocument.this._pageCache;
                synchronized (list) {
                    Document document = documentEvent.getDocument();
                    PageDefinition pageDefinition = LazyLoadDocument.this.getPageFromDocument(document);
                    if (pageDefinition == null) {
                        return;
                    }
                    int n = LazyLoadDocument.this._pageCache.indexOf(pageDefinition) + 1;
                    DocumentEvent.ElementChange elementChange = documentEvent.getChange(document.getDefaultRootElement());
                    int n2 = documentEvent.getOffset() + pageDefinition.getStartOffsetInMemory();
                    int n3 = pageDefinition.getStartLineInMemory() + pageDefinition.getDocument().getDefaultRootElement().getElementIndex(n2 - pageDefinition.getStartOffsetInMemory());
                    if (elementChange != null) {
                        Element[] elementArray = elementChange.getChildrenAdded();
                        int n4 = elementChange.getChildrenRemoved().length - elementArray.length;
                        if (LazyLoadDocument.this.tokenMarker != null) {
                            LazyLoadDocument.this.tokenMarker.deleteLines(n3 + 1, n4);
                        }
                        LazyLoadDocument.this.updateStartLineInPages(n, -n4);
                    }
                    LazyLoadDocument.this.updateOffsetInPages(n, -documentEvent.getLength());
                    LazyLoadDocument.this.setPageModified(pageDefinition);
                    if (!LazyLoadDocument.this.isBatchProcess()) {
                        LazyLoadDocument.this.fireRemoveUpdate(LazyLoadDocument.this.createCombinedDocumentEvent(n2, documentEvent));
                    }
                    LazyLoadDocument.this.verifyConsistency();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    protected DocumentEvent createCombinedDocumentEvent(int n, DocumentEvent documentEvent) {
        return new CombinedDocumentEvent(n, documentEvent);
    }

    protected DocumentEvent createCombinedDocumentEvent(int n, int n2, DocumentEvent.EventType eventType) {
        return new CombinedDocumentEvent(n, n2, eventType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageDefinition getPageFromDocument(Document document) {
        if (this._currentPage != null && this._currentPage.getDocument() == document) {
            return this._currentPage;
        }
        List<PageDefinition> list = this._pageCache;
        synchronized (list) {
            for (PageDefinition pageDefinition : this._pageCache.toArray(new PageDefinition[this._pageCache.size()])) {
                if (pageDefinition.getDocument() != document) continue;
                this.pageQueried(pageDefinition);
                return pageDefinition;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPageModified(PageDefinition pageDefinition) {
        pageDefinition.setModified(true);
        List<PageDefinition> list = this._unmodifiedPages;
        synchronized (list) {
            if (this._unmodifiedPages.contains(pageDefinition)) {
                this._unmodifiedPages.remove(pageDefinition);
            }
        }
    }

    private void verifyConsistency() {
    }

    private File getInputFile() {
        return this._inputFile;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String string) {
        this.setFileName(string, "UTF-8");
    }

    public void setFileName(String string, String string2) {
        if (!JideSwingUtilities.equals(this.getFileName(), string) || !JideSwingUtilities.equals(string2, this._charsetName)) {
            this._charsetName = string2;
            this._fileName = string;
            if (this._fileReadThroughThread != null && this._fileReadThroughThread.isAlive()) {
                return;
            }
            this._inputFile = new File(this._fileName);
            this.readFileTwoSteps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileTwoSteps() {
        this._fileReadThrough = false;
        this._fileReadThroughThread = null;
        this._currentPage = null;
        this._totalLineCountInFile = 0;
        this._totalLineCountInMemory = 0;
        this._fileLengthInMemory = 0L;
        this._fileLengthInFile = 0L;
        this._maxLineLength = 0;
        this._linesToLoad[0] = -1;
        this._linesToLoad[1] = -1;
        List<PageDefinition> list = this._pageCache;
        synchronized (list) {
            this._pageCache.clear();
        }
        try {
            this.readThroughFile(this._fileName, true);
        }
        catch (Exception exception) {
            this._totalLineCountInFile = 0;
            this._totalLineCountInMemory = 0;
            this._fileLengthInMemory = 0L;
            this._fileLengthInFile = 0L;
        }
        if (this._fileLengthInFile > 0L && !this._fileReadThrough) {
            this._fileReadThroughThread = this.createFileReadThread();
            this._fileReadThroughThread.start();
        }
    }

    private Thread createFileReadThread() {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                String string = LazyLoadDocument.this.getFileName();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Start a thread to read through file:" + LazyLoadDocument.this._fileName);
                }
                try {
                    LazyLoadDocument.this.readThroughFile(string, false);
                }
                catch (Exception exception) {
                    try {
                        LazyLoadDocument.this._totalLineCountInFile = 0;
                        LazyLoadDocument.this._totalLineCountInMemory = 0;
                        LazyLoadDocument.this._fileLengthInMemory = 0L;
                        LazyLoadDocument.this._fileLengthInFile = 0L;
                    }
                    catch (Throwable throwable) {
                        LazyLoadDocument.this._fileReadThrough = true;
                        LazyLoadDocument.this._fileReadThroughThread = null;
                        if (!JideSwingUtilities.equals(string, LazyLoadDocument.this._fileName) && LazyLoadDocument.this._fileName != null) {
                            LazyLoadDocument.this._fileReadThrough = false;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LazyLoadDocument.this._inputFile = new File(LazyLoadDocument.this._fileName);
                                    LazyLoadDocument.this.readFileTwoSteps();
                                }
                            });
                        }
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, LazyLoadDocument.this._fileLengthInFile == 0L ? "Failed to read through file." : "File read through successfully.");
                        }
                        throw throwable;
                    }
                    LazyLoadDocument.this._fileReadThrough = true;
                    LazyLoadDocument.this._fileReadThroughThread = null;
                    if (!JideSwingUtilities.equals(string, LazyLoadDocument.this._fileName) && LazyLoadDocument.this._fileName != null) {
                        LazyLoadDocument.this._fileReadThrough = false;
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, LazyLoadDocument.this._fileLengthInFile == 0L ? "Failed to read through file." : "File read through successfully.");
                    }
                }
                LazyLoadDocument.this._fileReadThrough = true;
                LazyLoadDocument.this._fileReadThroughThread = null;
                if (!JideSwingUtilities.equals(string, LazyLoadDocument.this._fileName) && LazyLoadDocument.this._fileName != null) {
                    LazyLoadDocument.this._fileReadThrough = false;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, LazyLoadDocument.this._fileLengthInFile == 0L ? "Failed to read through file." : "File read through successfully.");
                }
            }
        });
    }

    @Override
    public int getLength() {
        return (int)this._fileLengthInMemory;
    }

    private void readThroughFile(String string, boolean bl) throws BadLocationException {
        if (this.getInputFile() == null) {
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = this.getPageLineSize();
            char[] cArray = new char[n5];
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.getInputFile()), this._charsetName);
            this._fileLengthInFile = this.getInputFile().length();
            if (this._fileLengthInMemory == 0L) {
                this._fileLengthInMemory = this._fileLengthInFile;
            }
            if (this._fileLengthInFile <= 0L) {
                this.setTotalLineCountInFile(1, false);
                this._fileReadThrough = true;
                this.createNewPage(0, 0);
                return;
            }
            if (bl || this._pageCache.size() < 1) {
                n4 = 0;
                n3 = 0;
            } else {
                PageDefinition pageDefinition = this._pageCache.get(this._pageCache.size() - 1);
                n4 = pageDefinition.getStartOffsetInFile() + pageDefinition.getOriginalLength();
                n3 = pageDefinition.getStartLineInFile() + pageDefinition.getPageLineCount();
                inputStreamReader.skip(n4);
            }
            int n6 = this.getMaxLineLength();
            int n7 = n4;
            char c = '\u0000';
            boolean bl2 = false;
            boolean bl3 = false;
            do {
                n2 = inputStreamReader.read(cArray, 0, this._pageLineSize);
                for (n = 0; n < n2; ++n) {
                    char c2;
                    if (bl3) {
                        if (++n3 % n5 == 0) {
                            this.createNewPage(n4 + n - (bl2 ? 1 : 0), n3);
                        }
                        n6 = Math.max(n6, n4 + n - n7);
                        n7 = n4 + n;
                        bl3 = false;
                    }
                    if ((c2 = cArray[n]) == '\n' || c2 == '\r') {
                        if (bl3) {
                            bl2 = true;
                            bl3 = false;
                        } else if (bl2) {
                            if (c != c2) {
                                bl2 = false;
                                bl3 = true;
                            } else {
                                bl2 = true;
                                bl3 = true;
                            }
                        } else {
                            bl2 = true;
                        }
                    } else {
                        if (bl2) {
                            if (++n3 % n5 == 0) {
                                this.createNewPage(n4 + n, n3);
                            }
                            n6 = Math.max(n6, n4 + n - n7);
                            n7 = n4 + n;
                        }
                        bl2 = false;
                        bl3 = false;
                    }
                    c = c2;
                }
                if (n2 < this._pageLineSize) {
                    n4 += n2;
                    break;
                }
                n4 += this._pageLineSize;
            } while (JideSwingUtilities.equals(this._fileName, string) && (!bl || n3 < n5));
            n2 = 0;
            if (bl2 || bl3 || (long)n4 >= this._fileLengthInFile) {
                ++n3;
                n2 = 1;
                n6 = Math.max(n6, n4 - n7);
            }
            if (!bl) {
                if (n2 == 0) {
                    ++n3;
                }
                this.createNewPage(n4, n3);
                this._fileLengthInFile = n4;
                this._fileLengthInMemory = n4;
            } else if ((long)n4 >= this._fileLengthInFile) {
                this.createNewPage(n4, n3);
            }
            n = n3;
            if (!bl || (long)n4 >= this._fileLengthInFile) {
                this._fileReadThrough = true;
                this.setTotalLineCountInFile(n, true);
            } else {
                this.setTotalLineCountInFile((int)this._fileLengthInFile / n4 * n, false);
            }
            if (this._pageLineSizePending >= 50) {
                this.setPageLineSize(this._pageLineSizePending);
            }
            this.setMaxLineLength(n6);
            if (bl) {
                PageDefinition[] pageDefinitionArray = this._pageCache.toArray(new PageDefinition[this._pageCache.size()]);
                for (PageDefinition pageDefinition : pageDefinitionArray) {
                    this.loadPage(pageDefinition, false);
                }
                if (n3 < n5) {
                    if (this._pageCache.size() == 0) {
                        this.createNewPage(n4, n3);
                        PageDefinition pageDefinition = this._pageCache.get(0);
                        this.loadPage(pageDefinition, false);
                        this._fileLengthInFile = this._fileLengthInMemory = (long)pageDefinition.getDocument().getLength();
                        this._totalLineCountInFile = this._totalLineCountInMemory = pageDefinition.getDocument().getDefaultRootElement().getElementCount();
                    }
                    this._fileReadThrough = true;
                }
            }
            inputStreamReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createNewPage(int n, int n2) {
        PageDefinition pageDefinition = new PageDefinition();
        if (this._pageCache.size() == 0) {
            pageDefinition.setStartLineInFile(0);
            pageDefinition.setStartOffsetInFile(0);
            pageDefinition.setPageLineCount(n2);
            pageDefinition.setOriginalLength(n);
            pageDefinition.setStartLineInMemory(0);
            pageDefinition.setStartOffsetInMemory(0);
        } else {
            int n3 = this._pageCache.size() - 1;
            PageDefinition pageDefinition2 = this._pageCache.get(n3);
            pageDefinition.setStartLineInFile(pageDefinition2.getStartLineInFile() + pageDefinition2.getPageLineCount());
            pageDefinition.setStartOffsetInFile(pageDefinition2.getStartOffsetInFile() + pageDefinition2.getOriginalLength());
            pageDefinition.setPageLineCount(n2 - pageDefinition.getStartLineInFile());
            pageDefinition.setOriginalLength(n - pageDefinition.getStartOffsetInFile());
            while ((pageDefinition2.getStartLineInMemory() < 0 || pageDefinition2.getStartOffsetInMemory() < 0) && --n3 >= 0) {
                pageDefinition2 = this._pageCache.get(n3);
            }
            if (n3 >= 0) {
                pageDefinition.setStartLineInMemory(pageDefinition2.getStartLineInMemory() + (pageDefinition2.getDocument() == null ? pageDefinition2.getPageLineCount() : pageDefinition2.getDocument().getDefaultRootElement().getElementCount() - 1));
                pageDefinition.setStartOffsetInMemory(pageDefinition2.getStartOffsetInMemory() + (pageDefinition2.getDocument() == null ? pageDefinition2.getOriginalLength() : pageDefinition2.getDocument().getLength()));
            } else {
                pageDefinition.setStartLineInMemory(0);
                pageDefinition.setStartOffsetInMemory(0);
            }
        }
        this._pageCache.add(pageDefinition);
    }

    @Override
    public Element getDefaultRootElement() {
        return super.getDefaultRootElement();
    }

    @Override
    protected AbstractDocument.AbstractElement createDefaultRoot() {
        return new AbstractDocument.AbstractElement(null, null){
            private static final long serialVersionUID = -6273206975857610000L;

            @Override
            public int getStartOffset() {
                return 0;
            }

            @Override
            public int getEndOffset() {
                return (int)LazyLoadDocument.this._fileLengthInMemory - 1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Element getElement(int n) {
                List list = LazyLoadDocument.this._pageCache;
                synchronized (list) {
                    PageDefinition pageDefinition = LazyLoadDocument.this.getPageFromLine(n);
                    if (pageDefinition == null) {
                        return null;
                    }
                    if (pageDefinition.getDocument() == null) {
                        LazyLoadDocument.this.loadPage(pageDefinition, false);
                        LazyLoadDocument.this.pageQueried(pageDefinition);
                    }
                    if (pageDefinition.getDocument() == null) {
                        return null;
                    }
                    return pageDefinition.getDocument().getDefaultRootElement().getElement(n - pageDefinition.getStartLineInMemory());
                }
            }

            @Override
            public int getElementCount() {
                return LazyLoadDocument.this._totalLineCountInMemory;
            }

            @Override
            public int getElementIndex(int n) {
                return LazyLoadDocument.this.internalGetLineNumber(n);
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            public boolean getAllowsChildren() {
                return true;
            }

            public Enumeration children() {
                return null;
            }
        };
    }

    private PageDefinition getPageFromLine(int n) {
        return this.getPageFromLine(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageDefinition getPageFromLine(int n, boolean bl) {
        List<PageDefinition> list = this._pageCache;
        synchronized (list) {
            if (this._pageCache.size() == 0) {
                return null;
            }
            PageDefinition pageDefinition = null;
            PageDefinition pageDefinition2 = this._pageCache.get(this._pageCache.size() - 1);
            if (this._currentPage != null) {
                int n2 = this._currentPage.getStartLineInMemory() + (this._currentPage.getDocument() == null ? this._currentPage.getPageLineCount() : this._currentPage.getDocument().getDefaultRootElement().getElementCount()) - 1;
                if (this._currentPage == pageDefinition2) {
                    ++n2;
                }
                if (this._currentPage.getStartLineInMemory() >= 0 && this._currentPage.getStartLineInMemory() <= n && n2 >= n && (n2 != n || n >= this._totalLineCountInMemory - 1 && this._currentPage == pageDefinition2)) {
                    pageDefinition = this._currentPage;
                }
            }
            if (pageDefinition == null) {
                for (PageDefinition pageDefinition3 : this._pageCache.toArray(new PageDefinition[this._pageCache.size()])) {
                    int n3 = pageDefinition3.getStartLineInMemory() + (pageDefinition3.getDocument() == null ? pageDefinition3.getPageLineCount() : pageDefinition3.getDocument().getDefaultRootElement().getElementCount()) - 1;
                    if (pageDefinition3 == pageDefinition2) {
                        ++n3;
                    }
                    if (pageDefinition3.getStartLineInMemory() < 0 || pageDefinition3.getStartLineInMemory() > n || n3 < n || pageDefinition3.getDocument() != null && n3 == n && (n < this._totalLineCountInMemory - 1 || pageDefinition3 != pageDefinition2)) continue;
                    pageDefinition = pageDefinition3;
                    break;
                }
            }
            if (!bl || pageDefinition == null) {
                return pageDefinition;
            }
            if (pageDefinition.getDocument() == null) {
                this.loadPage(pageDefinition, false);
            }
            this.pageQueried(pageDefinition);
            return pageDefinition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageQueried(PageDefinition pageDefinition) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._currentPage = pageDefinition;
            List<PageDefinition> list = this._unmodifiedPages;
            synchronized (list) {
                this._unmodifiedPages.remove(pageDefinition);
                if (!pageDefinition.isModified()) {
                    this._unmodifiedPages.add(0, pageDefinition);
                }
                if (this._unmodifiedPages.size() >= this.getMaximumPages()) {
                    for (int i = this._unmodifiedPages.size() - 1; i >= this.getMaximumPages(); --i) {
                        PageDefinition pageDefinition2 = this._unmodifiedPages.get(i);
                        if (pageDefinition2 == this._currentPage) continue;
                        pageDefinition2.setDocument(null);
                        this._unmodifiedPages.remove(i);
                    }
                }
            }
        }
        List<PageDefinition> list = this._unmodifiedPages;
        synchronized (list) {
            if (!this._unmodifiedPages.contains(pageDefinition)) {
                if (this._unmodifiedPages.size() > 1) {
                    this._unmodifiedPages.add(1, pageDefinition);
                } else {
                    this._unmodifiedPages.add(pageDefinition);
                }
            }
            if (this._unmodifiedPages.size() >= this.getMaximumPages()) {
                for (int i = this._unmodifiedPages.size() - 1; i >= this.getMaximumPages(); --i) {
                    PageDefinition pageDefinition3 = this._unmodifiedPages.get(i);
                    if (pageDefinition3 == this._currentPage) continue;
                    pageDefinition3.setDocument(null);
                    this._unmodifiedPages.remove(i);
                }
            }
        }
    }

    private PageDefinition getPageFromOffset(int n) {
        return this.getPageFromOffset(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageDefinition getPageFromOffset(int n, boolean bl) {
        List<PageDefinition> list = this._pageCache;
        synchronized (list) {
            PageDefinition pageDefinition = null;
            if (this._currentPage != null) {
                int n2 = this._currentPage.getStartOffsetInMemory() + (this._currentPage.getDocument() == null ? this._currentPage.getOriginalLength() : this._currentPage.getDocument().getLength());
                if (this._currentPage.getStartOffsetInMemory() >= 0 && this._currentPage.getStartOffsetInMemory() <= n && n2 >= n && (n2 != n || (long)n >= this._fileLengthInMemory)) {
                    pageDefinition = this._currentPage;
                }
            }
            if (pageDefinition == null) {
                for (PageDefinition pageDefinition2 : this._pageCache.toArray(new PageDefinition[this._pageCache.size()])) {
                    int n3 = pageDefinition2.getStartOffsetInMemory() + (pageDefinition2.getDocument() == null ? pageDefinition2.getOriginalLength() : pageDefinition2.getDocument().getLength());
                    if (pageDefinition2.getStartOffsetInMemory() < 0 || pageDefinition2.getStartOffsetInMemory() > n || n3 < n || n3 == n && (long)n < this._fileLengthInMemory) continue;
                    pageDefinition = pageDefinition2;
                    break;
                }
            }
            if (!bl || pageDefinition == null) {
                return pageDefinition;
            }
            if (pageDefinition.getDocument() == null) {
                this.loadPage(pageDefinition, false);
            }
            this.pageQueried(pageDefinition);
            return pageDefinition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startLoadPage(int n, int n2) {
        if (this.isLineLoaded(n) && this.isLineLoaded(n2)) {
            return;
        }
        int[] nArray = this._linesToLoad;
        synchronized (this._linesToLoad) {
            this._linesToLoad[0] = n;
            this._linesToLoad[1] = n2;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (this._pageLoadThread == null || !this._pageLoadThread.isAlive()) {
                this._pageLoadThread = this.createPageLoadThread();
                this._pageLoadThread.start();
            }
            return;
        }
    }

    private Thread createPageLoadThread() {
        return new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[MONITOR]], but top level block is 17[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPage(PageDefinition pageDefinition, boolean bl) {
        int n;
        if (SwingUtilities.isEventDispatchThread() && LOGGER.isLoggable(Level.FINE) && SystemInfo.isJdk15Above()) {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            StackTraceElement[] stackTraceElementArray = map.get(Thread.currentThread());
            StringBuffer stringBuffer = new StringBuffer();
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            n = stackTraceElementArray2.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[i];
                stringBuffer.append("\tat ");
                stringBuffer.append(stackTraceElement);
                stringBuffer.append("\n");
            }
            LOGGER.log(Level.FINE, stringBuffer.toString());
        }
        int n2 = pageDefinition.getStartLineInFile();
        boolean bl2 = true;
        try {
            long l;
            if (!bl) {
                this.firePageStartLoadingEvent(n2, bl);
            }
            if ((l = Runtime.getRuntime().freeMemory()) >= (long)((n = pageDefinition.getOriginalLength()) * 4)) {
                this.readInBuffer(pageDefinition, bl);
            } else {
                bl2 = false;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            if (pageDefinition.getDocument() != null) {
                Element element;
                int n3 = pageDefinition.getDocument().getDefaultRootElement().getElementCount();
                int n4 = this._pageCache.indexOf(pageDefinition);
                if (n4 == this._pageCache.size() - 1 && n4 != 0 && (element = pageDefinition.getDocument().getDefaultRootElement().getElement(n3 - 1)).getStartOffset() == element.getEndOffset()) {
                    --n3;
                }
                if (n3 != pageDefinition.getPageLineCount() && n3 != pageDefinition.getPageLineCount() + 1) {
                    int n5 = pageDefinition.getPageLineCount() - n3;
                    pageDefinition.setPageLineCount(n3);
                    ++n4;
                    while (n4 < this._pageCache.size()) {
                        this._pageCache.get(n4).setStartLineInFile(this._pageCache.get(n4).getStartLineInFile() - n5);
                        this._pageCache.get(n4).setStartLineInMemory(this._pageCache.get(n4).getStartLineInMemory() - n5);
                        ++n4;
                    }
                    this.setTotalLineCountInFile(this.getTotalLineCountInFile() - n5, true);
                }
            }
            if (!bl2) {
                this.firePageLoadFailedEvent(n2, bl);
            } else if (!bl) {
                this.firePageLoadedEvent(n2, bl);
            }
        }
    }

    @Override
    public int getLineNumber(int n) {
        return this.internalGetLineNumber(n);
    }

    private int internalGetLineNumber(int n) {
        PageDefinition pageDefinition;
        if (n == 0) {
            return 0;
        }
        if (n == this.getLength()) {
            return this._totalLineCountInMemory - 1;
        }
        if (n == this.getLength() - 1 && ((pageDefinition = this.getPageFromOffset(n, false)) == null || pageDefinition.getDocument() == null)) {
            return this._totalLineCountInMemory - 2;
        }
        pageDefinition = this.getPageFromOffset(n);
        if (pageDefinition == null || pageDefinition.getDocument() == null) {
            return -1;
        }
        return pageDefinition.getStartLineInMemory() + pageDefinition.getDocument().getDefaultRootElement().getElementIndex(n - pageDefinition.getStartOffsetInMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needContinueLoading(PageDefinition pageDefinition) {
        int[] nArray = this._linesToLoad;
        synchronized (this._linesToLoad) {
            for (int n : this._linesToLoad) {
                if (pageDefinition.getStartLineInMemory() > n || n >= pageDefinition.getStartLineInMemory() + pageDefinition.getOriginalLength() && (n != 0 || pageDefinition.getOriginalLength() != 0)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    private void readInBuffer(PageDefinition pageDefinition, boolean bl) throws BadLocationException {
        if (this.getInputFile() == null || this._fileLengthInFile < 0L || pageDefinition == null) {
            return;
        }
        try {
            if (bl && !this.needContinueLoading(pageDefinition)) {
                return;
            }
            int n = pageDefinition.getOriginalLength();
            char[] cArray = new char[n];
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.getInputFile()), this._charsetName);
            inputStreamReader.skip(pageDefinition.getStartOffsetInFile());
            if (bl) {
                int n2 = 0;
                int n3 = 0;
                while (n > 0) {
                    if (n3 % 100 == 0 && !this.needContinueLoading(pageDefinition)) {
                        inputStreamReader.close();
                        return;
                    }
                    int n4 = Math.min(1024, n);
                    inputStreamReader.read(cArray, n2, n4);
                    n2 += n4;
                    n -= n4;
                    ++n3;
                }
            } else {
                inputStreamReader.read(cArray, 0, n);
            }
            inputStreamReader.close();
            AbstractDocument abstractDocument = this.createDocumentForPage();
            abstractDocument.setDocumentFilter(this.getDocumentFilter());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray);
            abstractDocument.insertString(0, stringBuffer.toString(), null);
            abstractDocument.addDocumentListener(this._documentListener);
            pageDefinition.setDocument(abstractDocument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected AbstractDocument createDocumentForPage() {
        return new PlainDocument();
    }

    @Override
    public String getText(int n, int n2) throws BadLocationException {
        PageDefinition pageDefinition;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 > 0 && (pageDefinition = this.getPageFromOffset(n)) != null && pageDefinition.getDocument() != null) {
            int n3 = this.getOffsetInPage(n, pageDefinition);
            int n4 = Math.min(pageDefinition.getDocument().getLength() - n3, n2);
            stringBuffer.append(pageDefinition.getDocument().getText(n3, n4));
            n2 -= n4;
            if (n4 == 0) break;
            n += n4;
        }
        return stringBuffer.toString();
    }

    @Override
    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        PageDefinition pageDefinition = this.getPageFromOffset(n);
        if (pageDefinition == null || pageDefinition.getDocument() == null) {
            return;
        }
        int n3 = this.getOffsetInPage(n, pageDefinition);
        int n4 = Math.min(pageDefinition.getDocument().getLength() - n3, n2);
        if (n4 < 0) {
            pageDefinition = this.getPageFromOffset(n);
            if (pageDefinition == null || pageDefinition.getDocument() == null) {
                return;
            }
            n3 = this.getOffsetInPage(n, pageDefinition);
        }
        pageDefinition.getDocument().getText(n3, n4, segment);
    }

    @Override
    public String getLineText(int n) throws BadLocationException {
        PageDefinition pageDefinition = this.getPageFromOffset(n);
        if (pageDefinition == null || pageDefinition.getDocument() == null) {
            return "";
        }
        int n2 = n - pageDefinition.getStartOffsetInMemory();
        Element element = pageDefinition.getDocument().getDefaultRootElement();
        int n3 = element.getElementIndex(n2);
        int n4 = element.getElement(n3).getStartOffset();
        int n5 = element.getElement(n3).getEndOffset();
        return pageDefinition.getDocument().getText(n4, n5 - n4);
    }

    @Override
    void tokenizeLines(final int n, final int n2, final boolean bl, final boolean bl2) {
        if (this._tokenAll) {
            return;
        }
        this._tokenAll = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Start the thread to token all lines");
                }
                while (!LazyLoadDocument.this._fileReadThrough) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                LazyLoadDocument.super.tokenizeLines(n, n2, bl, bl2);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Finished the thread to token all lines");
                }
                LazyLoadDocument.this._tokenAll = false;
            }
        }).start();
    }

    public int getPageLineSize() {
        return this._pageLineSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageLineSize(int n) {
        if (n < 50) {
            throw new IllegalArgumentException("The page line size should be at least 50.");
        }
        if (this._saving || !this._fileReadThrough) {
            this._pageLineSizePending = n;
            return;
        }
        List<PageDefinition> list = this._pageCache;
        synchronized (list) {
            for (PageDefinition pageDefinition : this._pageCache.toArray(new PageDefinition[this._pageCache.size()])) {
                if (!pageDefinition.isModified() && pageDefinition.getStartLineInMemory() >= 0 && pageDefinition.getStartOffsetInMemory() >= 0) continue;
                this._pageLineSizePending = n;
                return;
            }
            this._pageLineSize = n;
            this._pageLineSizePending = -1;
            this._pageCache.clear();
            this.readFileTwoSteps();
        }
    }

    private int getTotalLineCountInFile() {
        return this._totalLineCountInFile;
    }

    private void setTotalLineCountInFile(int n, boolean bl) {
        if (bl && n != this.getTotalLineCountInFile() && this.getTokenMarker() != null) {
            if (n < this.getTotalLineCountInFile()) {
                this.getTokenMarker().deleteLines(n, this.getTotalLineCountInFile() - n - 1);
            } else {
                this.getTokenMarker().insertLines(this.getTotalLineCountInFile(), n - this.getTotalLineCountInFile());
            }
        }
        this._totalLineCountInMemory += n - this._totalLineCountInFile;
        this._totalLineCountInFile = n;
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, this.getLength(), DocumentEvent.EventType.INSERT));
    }

    public CharSequence getLazyLoadText() {
        if (this._lazyLoadString == null) {
            this._lazyLoadString = new LazyLoadCharSequence(this);
        }
        return this._lazyLoadString;
    }

    @Override
    public char charAt(int n) throws BadLocationException {
        String string = this.getText(n, 1);
        return string != null && string.length() >= 1 ? string.charAt(0) : (char)'\u0000';
    }

    @Override
    public void setTokenMarker(TokenMarker tokenMarker) {
        if (this.getTokenMarker() == tokenMarker) {
            return;
        }
        if (this.getTokenMarker() != null) {
            this.getTokenMarker().setDocument(null);
        }
        this.tokenMarker = tokenMarker;
        if (tokenMarker == null) {
            return;
        }
        this.getTokenMarker().setDocument(this);
        this.getTokenMarker().insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    @Override
    public boolean isLineLoaded(int n) {
        PageDefinition pageDefinition = this.getPageFromLine(n, false);
        return pageDefinition != null && pageDefinition.getDocument() != null;
    }

    @Override
    public boolean isOffsetLoaded(int n) {
        PageDefinition pageDefinition = this.getPageFromOffset(n, false);
        return pageDefinition != null && pageDefinition.getDocument() != null;
    }

    private void ensureOffsetAvailable(int n) {
        if (this._fileReadThrough) {
            return;
        }
        if (this.getPageFromOffset(n, false) != null) {
            return;
        }
        if (this._fileReadThroughThread == null || !this._fileReadThroughThread.isAlive()) {
            this._fileReadThroughThread = this.createFileReadThread();
            this._fileReadThroughThread.start();
        }
        while (!this._fileReadThrough) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getMaximumPages() {
        return this._maximumPages;
    }

    public void setMaximumPages(int n) {
        this._maximumPages = n;
    }

    int getMaxLineLength() {
        return this._maxLineLength;
    }

    private void setMaxLineLength(int n) {
        this._maxLineLength = n;
    }

    public void addPageLoadingListener(PageLoadListener pageLoadListener) {
        this.listenerList.add(PageLoadListener.class, pageLoadListener);
    }

    public void removePageLoadingListener(PageLoadListener pageLoadListener) {
        this.listenerList.remove(PageLoadListener.class, pageLoadListener);
    }

    public PageLoadListener[] getPageLoadListeners() {
        return (PageLoadListener[])this.listenerList.getListeners(PageLoadListener.class);
    }

    protected void firePageStartLoadingEvent(final int n, final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = LazyLoadDocument.this.listenerList.getListenerList();
                PageLoadEvent pageLoadEvent = new PageLoadEvent(this, 0, n, bl);
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != PageLoadListener.class) continue;
                    ((PageLoadListener)objectArray[i + 1]).pageLoadingStart(pageLoadEvent);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void firePageLoadFailedEvent(final int n, final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = LazyLoadDocument.this.listenerList.getListenerList();
                PageLoadEvent pageLoadEvent = new PageLoadEvent(this, 2, n, bl);
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != PageLoadListener.class) continue;
                    ((PageLoadListener)objectArray[i + 1]).pageLoadFailed(pageLoadEvent);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void firePageLoadedEvent(final int n, final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = LazyLoadDocument.this.listenerList.getListenerList();
                PageLoadEvent pageLoadEvent = new PageLoadEvent(this, 1, n, bl);
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != PageLoadListener.class) continue;
                    ((PageLoadListener)objectArray[i + 1]).pageLoaded(pageLoadEvent);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    boolean isBatchProcess() {
        return this._batchProcess;
    }

    void setBatchProcess(boolean bl) {
        this._batchProcess = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOffsetInPages(int n, int n2) {
        List<PageDefinition> list = this._pageCache;
        synchronized (list) {
            this._fileLengthInMemory += (long)n2;
            if (n >= this._pageCache.size() || n < 0) {
                return;
            }
            for (int i = n; i < this._pageCache.size(); ++i) {
                PageDefinition pageDefinition = this._pageCache.get(i);
                if (pageDefinition.getStartOffsetInMemory() < 0) continue;
                pageDefinition.setStartOffsetInMemory(pageDefinition.getStartOffsetInMemory() + n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStartLineInPages(int n, int n2) {
        List<PageDefinition> list = this._pageCache;
        synchronized (list) {
            this._totalLineCountInMemory += n2;
            if (n >= this._pageCache.size() || n < 0) {
                return;
            }
            for (int i = n; i < this._pageCache.size(); ++i) {
                PageDefinition pageDefinition = this._pageCache.get(i);
                if (pageDefinition.getStartLineInMemory() < 0) continue;
                pageDefinition.setStartLineInMemory(pageDefinition.getStartLineInMemory() + n2);
            }
        }
    }

    @Override
    void syncLineInfoOnInsert(DocumentEvent documentEvent) {
    }

    @Override
    void syncLineInfoOnRemove(DocumentEvent documentEvent) {
    }

    protected boolean needUndoRedo(int n, int n2, DocumentEvent.EventType eventType) {
        return true;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        this.insertString(n, string, attributeSet, false);
    }

    void insertString(int n, String string, AttributeSet attributeSet, boolean bl) throws BadLocationException {
        if (this._saving) {
            PortingUtils.notifyUser();
            return;
        }
        if (string.length() <= 0) {
            return;
        }
        PageDefinition pageDefinition = this.getPageFromOffset(n);
        if (pageDefinition != null && pageDefinition.getDocument() != null) {
            pageDefinition.getDocument().insertString(this.getOffsetInPage(n, pageDefinition), string, attributeSet);
            if (!bl && this.needUndoRedo(n, string.length(), DocumentEvent.EventType.INSERT)) {
                LazyLoadUndoableEdit lazyLoadUndoableEdit = new LazyLoadUndoableEdit(this);
                lazyLoadUndoableEdit.addEdit(new AbstractDocument.DefaultDocumentEvent(this, n, string.length(), DocumentEvent.EventType.INSERT));
                lazyLoadUndoableEdit.addEdit(new AbstractDocument.DefaultDocumentEvent(this, n, string.length(), DocumentEvent.EventType.REMOVE));
                lazyLoadUndoableEdit.addEdit(new SubPageEdit(this, n, DocumentEvent.EventType.INSERT, string));
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, lazyLoadUndoableEdit));
            }
        }
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        this.remove(n, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAvailablePages() {
        List<PageDefinition> list = this._pageCache;
        synchronized (list) {
            int n = 0;
            for (PageDefinition pageDefinition : this._pageCache.toArray(new PageDefinition[this._pageCache.size()])) {
                if (pageDefinition.getStartLineInMemory() < 0 || pageDefinition.getStartOffsetInMemory() < 0) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(int n, int n2, boolean bl) throws BadLocationException {
        if (this._saving) {
            PortingUtils.notifyUser();
            return;
        }
        boolean bl2 = false;
        if (n == 0 && n2 == this.getLength()) {
            this.ensureOffsetAvailable(n + n2 - 1);
            n2 = this.getLength();
            bl2 = true;
        }
        if (n2 <= 0) {
            return;
        }
        LazyLoadUndoableEdit lazyLoadUndoableEdit = null;
        if (!bl && this.needUndoRedo(n, n2, DocumentEvent.EventType.REMOVE)) {
            lazyLoadUndoableEdit = new LazyLoadUndoableEdit(this);
            lazyLoadUndoableEdit.addEdit(new AbstractDocument.DefaultDocumentEvent(this, n, n2, DocumentEvent.EventType.REMOVE));
            lazyLoadUndoableEdit.addEdit(new AbstractDocument.DefaultDocumentEvent(this, n, n2, DocumentEvent.EventType.INSERT));
        }
        int n3 = this.internalGetLineNumber(n);
        int n4 = n + n2 - 1;
        int n5 = this.internalGetLineNumber(n4);
        PageDefinition pageDefinition = this.getPageFromLine(n3, false);
        PageDefinition pageDefinition2 = this.getPageFromLine(n5, false);
        if (pageDefinition == null || pageDefinition2 == null) {
            return;
        }
        if (pageDefinition == pageDefinition2) {
            int n6 = this.getOffsetInPage(n, pageDefinition);
            if (pageDefinition.getDocument() == null) {
                pageDefinition = this.getPageFromLine(n3);
            }
            if (n6 == 0 && n2 == pageDefinition.getDocument().getLength() && this.getAvailablePages() > 1) {
                this.setBatchProcess(true);
                DocumentEvent documentEvent = this.createCombinedDocumentEvent(n, n2, DocumentEvent.EventType.REMOVE);
                this.removeEntirePage(pageDefinition);
                if (lazyLoadUndoableEdit != null) {
                    lazyLoadUndoableEdit.addEdit(new EntirePageEdit(this, pageDefinition));
                }
                this.setBatchProcess(false);
                this.fireRemoveUpdate(documentEvent);
            } else {
                String string = pageDefinition.getDocument().getText(n6, n2);
                pageDefinition.getDocument().remove(n6, n2);
                if (lazyLoadUndoableEdit != null) {
                    lazyLoadUndoableEdit.addEdit(new SubPageEdit(this, n, DocumentEvent.EventType.REMOVE, string));
                }
            }
        } else {
            List<PageDefinition> list = this._pageCache;
            synchronized (list) {
                String string;
                this.setBatchProcess(true);
                DocumentEvent documentEvent = this.createCombinedDocumentEvent(n, n2, DocumentEvent.EventType.REMOVE);
                int n7 = this.getOffsetInPage(n, pageDefinition);
                int n8 = this.getOffsetInPage(n4, pageDefinition2);
                String string2 = null;
                if (!bl2 && n != this.getLineStartOffset(n3) && n4 != this.getLineEndOffset(n5)) {
                    string2 = this.getText(n4 + 1, this.getLineEndOffset(n5) - n4 - 1 - 1);
                    n8 += this.getLineEndOffset(n5) - n4;
                }
                if (!(n7 != 0 || bl2 && pageDefinition.getDocument() != null)) {
                    this.removeEntirePage(pageDefinition);
                    if (lazyLoadUndoableEdit != null) {
                        lazyLoadUndoableEdit.addEdit(new EntirePageEdit(this, pageDefinition));
                    }
                } else {
                    if (pageDefinition.getDocument() == null) {
                        pageDefinition = this.getPageFromLine(n3);
                    }
                    string = pageDefinition.getDocument().getText(n7, pageDefinition.getDocument().getLength() - n7 - (n == this.getLineStartOffset(n3) ? 0 : 1));
                    pageDefinition.getDocument().remove(n7, pageDefinition.getDocument().getLength() - n7 - (n == this.getLineStartOffset(n3) ? 0 : 1));
                    if (lazyLoadUndoableEdit != null) {
                        lazyLoadUndoableEdit.addEdit(new SubPageEdit(this, n, DocumentEvent.EventType.REMOVE, string));
                    }
                }
                if (pageDefinition.getStartLineInFile() + this.getPageLineSize() < pageDefinition2.getStartLineInFile()) {
                    PageDefinition pageDefinition3;
                    int n9 = this._pageCache.indexOf(pageDefinition);
                    int n10 = this._pageCache.indexOf(pageDefinition2);
                    for (int i = n9 + 1; i < n10 && (pageDefinition3 = this._pageCache.get(i)) != pageDefinition; ++i) {
                        this.removeEntirePage(pageDefinition3);
                        if (lazyLoadUndoableEdit == null) continue;
                        lazyLoadUndoableEdit.addEdit(new EntirePageEdit(this, pageDefinition3));
                    }
                }
                if (n8 >= (pageDefinition2.getDocument() == null ? pageDefinition2.getOriginalLength() - 1 : pageDefinition2.getDocument().getLength() - 1) && (pageDefinition2.getDocument() == null || this.getAvailablePages() > 1)) {
                    this.removeEntirePage(pageDefinition2);
                    if (lazyLoadUndoableEdit != null) {
                        lazyLoadUndoableEdit.addEdit(new EntirePageEdit(this, pageDefinition2));
                    }
                } else {
                    if (pageDefinition2.getDocument() == null) {
                        pageDefinition2 = this.getPageFromLine(n5);
                    }
                    string = pageDefinition2.getDocument().getText(0, n8 + 1);
                    pageDefinition2.getDocument().remove(0, n8 + 1);
                    if (lazyLoadUndoableEdit != null) {
                        lazyLoadUndoableEdit.addEdit(new SubPageEdit(this, n, DocumentEvent.EventType.REMOVE, string));
                    }
                }
                if (string2 != null) {
                    pageDefinition.getDocument().insertString(n7, string2, null);
                    if (lazyLoadUndoableEdit != null) {
                        lazyLoadUndoableEdit.addEdit(new SubPageEdit(this, n, DocumentEvent.EventType.REMOVE, string2));
                    }
                }
                if (bl2) {
                    this._totalLineCountInMemory = 1;
                }
                this.setBatchProcess(false);
                this.fireRemoveUpdate(documentEvent);
            }
        }
        if (!bl && lazyLoadUndoableEdit != null) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, lazyLoadUndoableEdit));
        }
    }

    void restoreEntirePage(PageDefinition pageDefinition) {
        int n;
        int n2;
        int n3 = this._pageCache.indexOf(pageDefinition) + 1;
        int n4 = 0;
        int n5 = 0;
        for (n2 = n3 - 2; n2 >= 0; --n2) {
            PageDefinition pageDefinition2 = this._pageCache.get(n2);
            if (pageDefinition2.getStartLineInMemory() < 0 || pageDefinition2.getStartOffsetInMemory() < 0) continue;
            n4 = pageDefinition2.getStartLineInMemory() + (pageDefinition2.getDocument() == null ? pageDefinition2.getPageLineCount() : pageDefinition2.getDocument().getDefaultRootElement().getElementCount() - 1);
            n5 = pageDefinition2.getStartOffsetInMemory() + (pageDefinition2.getDocument() == null ? pageDefinition2.getOriginalLength() : pageDefinition2.getDocument().getLength());
            break;
        }
        pageDefinition.setStartLineInMemory(n4);
        pageDefinition.setStartOffsetInMemory(n5);
        n2 = pageDefinition.getDocument() != null ? pageDefinition.getDocument().getDefaultRootElement().getElementCount() - 1 : pageDefinition.getPageLineCount();
        int n6 = n = pageDefinition.getDocument() != null ? pageDefinition.getDocument().getLength() : pageDefinition.getOriginalLength();
        if (this.tokenMarker != null) {
            this.tokenMarker.insertLines(n4, n2);
        }
        this.updateStartLineInPages(n3, n2);
        this.updateOffsetInPages(n3, n);
        this.verifyConsistency();
    }

    void removeEntirePage(PageDefinition pageDefinition) {
        int n;
        int n2 = pageDefinition.getStartLineInMemory();
        if (n2 < 0 || pageDefinition.getStartOffsetInMemory() < 0) {
            System.err.println("Trying to delete an empty page.");
            return;
        }
        int n3 = pageDefinition.getDocument() != null ? pageDefinition.getDocument().getDefaultRootElement().getElementCount() - 1 : pageDefinition.getPageLineCount();
        int n4 = n = pageDefinition.getDocument() != null ? pageDefinition.getDocument().getLength() : pageDefinition.getOriginalLength();
        if (this.tokenMarker != null) {
            this.tokenMarker.deleteLines(n2, n3);
        }
        int n5 = this._pageCache.indexOf(pageDefinition) + 1;
        this.updateStartLineInPages(n5, -n3);
        this.updateOffsetInPages(n5, -n);
        if (!pageDefinition.isModified()) {
            pageDefinition.setDocument(null);
            if (this._currentPage == pageDefinition) {
                this._currentPage = null;
            }
        }
        pageDefinition.setStartLineInMemory(-1);
        pageDefinition.setStartOffsetInMemory(-1);
        this.verifyConsistency();
    }

    private int getOffsetInPage(int n, PageDefinition pageDefinition) {
        if (pageDefinition.getStartOffsetInMemory() < 0) {
            return -1;
        }
        return n - pageDefinition.getStartOffsetInMemory();
    }

    @Override
    public int getLineStartOffset(int n) {
        if (!this.isLineLoaded(n) && n == this.getLineCount() - 1) {
            return this.getLength();
        }
        PageDefinition pageDefinition = this.getPageFromLine(n);
        if (pageDefinition == null || pageDefinition.getDocument() == null) {
            return this.getLength() + 1;
        }
        Element element = pageDefinition.getDocument().getDefaultRootElement();
        int n2 = n - pageDefinition.getStartLineInMemory();
        if (n2 >= element.getElementCount()) {
            if (pageDefinition == this._pageCache.get(this._pageCache.size() - 1)) {
                return this.getLength() + 1;
            }
            throw new IllegalStateException("test");
        }
        Element element2 = element.getElement(n2);
        if (element2 == null) {
            throw new IllegalStateException("test");
        }
        return element2.getStartOffset() + pageDefinition.getStartOffsetInMemory();
    }

    @Override
    public int getLineEndOffset(int n) {
        Element element;
        PageDefinition pageDefinition;
        if (!this.isLineLoaded(n)) {
            if (n == this.getLineCount() - 1) {
                return this.getLength();
            }
            if (n == this.getLineCount() - 2) {
                return this.getLength() - 1;
            }
        }
        if ((pageDefinition = this.getPageFromLine(n)) == null || pageDefinition.getDocument() == null) {
            return this.getLength() + 1;
        }
        Element element2 = pageDefinition.getDocument().getDefaultRootElement();
        int n2 = n - pageDefinition.getStartLineInMemory();
        if (n2 >= element2.getElementCount()) {
            if (pageDefinition == this._pageCache.get(this._pageCache.size() - 1)) {
                n2 = element2.getElementCount() - 1;
            } else {
                throw new IllegalStateException("test");
            }
        }
        if ((element = element2.getElement(n2)) == null) {
            throw new IllegalStateException("test");
        }
        return element.getEndOffset() - 1 + pageDefinition.getStartOffsetInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeToOutputStream(OutputStreamWriter outputStreamWriter) throws IOException, BadLocationException {
        if (!this._fileReadThrough) {
            return false;
        }
        this._saving = true;
        try {
            PageDefinition pageDefinition;
            for (int i = 0; i < this.getLineCount() - 1 && (pageDefinition = this.getPageFromLine(i)) != null; i += pageDefinition.getDocument().getDefaultRootElement().getElementCount() - 1) {
                if (pageDefinition.getStartLineInMemory() != i) {
                    break;
                }
                outputStreamWriter.write(pageDefinition.getDocument().getText(0, pageDefinition.getDocument().getLength()));
                outputStreamWriter.flush();
            }
        }
        finally {
            this._saving = false;
            if (this._pageLineSizePending >= 50) {
                this.setPageLineSize(this._pageLineSizePending);
            }
        }
        return true;
    }

    static /* synthetic */ int[] access$2100(LazyLoadDocument lazyLoadDocument) {
        return lazyLoadDocument._linesToLoad;
    }

    static /* synthetic */ PageDefinition access$2200(LazyLoadDocument lazyLoadDocument, int n, boolean bl) {
        return lazyLoadDocument.getPageFromLine(n, bl);
    }

    class LazyLoadElementChange
    implements DocumentEvent.ElementChange {
        CombinedDocumentEvent _event;
        Element _element;

        public LazyLoadElementChange(CombinedDocumentEvent combinedDocumentEvent, Element element) {
            this._event = combinedDocumentEvent;
            this._element = element;
        }

        @Override
        public Element getElement() {
            return this._element;
        }

        @Override
        public int getIndex() {
            if (this._event._originalEvent == null) {
                if (this._event._deletedLineCount <= 0) {
                    return -1;
                }
                PageDefinition pageDefinition = LazyLoadDocument.this.getPageFromOffset(this._event._offsetInMemory);
                if (pageDefinition.getDocument() == null || pageDefinition.getStartOffsetInMemory() < 0) {
                    return -1;
                }
                Element element = pageDefinition.getDocument().getDefaultRootElement();
                int n = element.getElementIndex(this._event._offsetInMemory - pageDefinition.getStartOffsetInMemory());
                return n + pageDefinition.getStartLineInMemory();
            }
            return LazyLoadDocument.this.internalGetLineNumber(this._event._offsetInMemory);
        }

        @Override
        public Element[] getChildrenRemoved() {
            if (this._event._originalEvent == null) {
                if (this._event._deletedLineCount <= 0) {
                    return new Element[0];
                }
                PageDefinition pageDefinition = LazyLoadDocument.this.getPageFromOffset(this._event._offsetInMemory);
                if (pageDefinition.getDocument() == null || pageDefinition.getStartOffsetInMemory() < 0) {
                    return new Element[0];
                }
                Element element = pageDefinition.getDocument().getDefaultRootElement();
                int n = element.getElementIndex(this._event._offsetInMemory - pageDefinition.getStartOffsetInMemory());
                int n2 = pageDefinition.getStartOffsetInMemory() + element.getElement(n).getStartOffset();
                int n3 = pageDefinition.getStartOffsetInMemory() + element.getElement(n).getEndOffset();
                Element[] elementArray = new Element[this._event._deletedLineCount];
                elementArray[0] = new AbstractDocument.LeafElement(LazyLoadDocument.this, this._element, null, n2, this._event._offsetInMemory);
                if (this._event._deletedLineCount > 1) {
                    elementArray[((CombinedDocumentEvent)this._event)._deletedLineCount - 1] = new AbstractDocument.LeafElement(LazyLoadDocument.this, this._element, null, this._event._offsetInMemory, n3);
                }
                for (int i = 1; i < this._event._deletedLineCount - 1; ++i) {
                    elementArray[i] = new AbstractDocument.LeafElement(LazyLoadDocument.this, this._element, null, this._event._offsetInMemory, this._event._offsetInMemory);
                }
                return elementArray;
            }
            DocumentEvent.ElementChange elementChange = this._event._originalEvent.getChange(this._event._originalEvent.getDocument().getDefaultRootElement());
            if (elementChange == null) {
                return new Element[0];
            }
            Element[] elementArray = elementChange.getChildrenRemoved();
            int n = this._event._offsetInMemory - elementChange.getIndex();
            Element[] elementArray2 = new Element[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                elementArray2[i] = new AbstractDocument.LeafElement(LazyLoadDocument.this, this._element, null, elementArray[i].getStartOffset() + n, elementArray[i].getEndOffset() + n);
            }
            return elementArray2;
        }

        @Override
        public Element[] getChildrenAdded() {
            if (this._event._originalEvent == null) {
                if (this._event._deletedLineCount <= 0) {
                    return new Element[0];
                }
                PageDefinition pageDefinition = LazyLoadDocument.this.getPageFromOffset(this._event._offsetInMemory);
                if (pageDefinition.getDocument() == null || pageDefinition.getStartOffsetInMemory() < 0) {
                    return new Element[0];
                }
                Element element = pageDefinition.getDocument().getDefaultRootElement();
                int n = element.getElementIndex(this._event._offsetInMemory - pageDefinition.getStartOffsetInMemory());
                int n2 = pageDefinition.getStartOffsetInMemory() + element.getElement(n).getStartOffset();
                int n3 = pageDefinition.getStartOffsetInMemory() + element.getElement(n).getEndOffset();
                Element[] elementArray = new Element[]{new AbstractDocument.LeafElement(LazyLoadDocument.this, this._element, null, n2, n3)};
                return elementArray;
            }
            DocumentEvent.ElementChange elementChange = this._event._originalEvent.getChange(this._event._originalEvent.getDocument().getDefaultRootElement());
            if (elementChange == null) {
                return new Element[0];
            }
            Element[] elementArray = elementChange.getChildrenAdded();
            int n = this._event._offsetInMemory - elementChange.getIndex();
            Element[] elementArray2 = new Element[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                elementArray2[i] = new AbstractDocument.LeafElement(LazyLoadDocument.this, this._element, null, elementArray[i].getStartOffset() + n, elementArray[i].getEndOffset() + n);
            }
            return elementArray2;
        }

        public int getInsertedLineCount() {
            if (this._event._originalEvent == null) {
                return this._event._deletedLineCount <= 0 ? 0 : 1 - this._event._deletedLineCount;
            }
            DocumentEvent.ElementChange elementChange = this._event._originalEvent.getChange(this._event._originalEvent.getDocument().getDefaultRootElement());
            if (elementChange == null) {
                return 0;
            }
            return elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length;
        }
    }

    private class CombinedDocumentEvent
    extends AbstractDocument.DefaultDocumentEvent {
        private DocumentEvent _originalEvent;
        private int _offsetInMemory;
        private int _deletedLineCount;
        private static final long serialVersionUID = -162881120391412897L;

        public CombinedDocumentEvent(int n, DocumentEvent documentEvent) {
            super(LazyLoadDocument.this, n, documentEvent.getLength(), documentEvent.getType());
            this._originalEvent = documentEvent;
            this._offsetInMemory = n;
        }

        public CombinedDocumentEvent(int n, int n2, DocumentEvent.EventType eventType) {
            super(LazyLoadDocument.this, n, n2, eventType);
            this._offsetInMemory = n;
            int n3 = LazyLoadDocument.this.internalGetLineNumber(n);
            int n4 = LazyLoadDocument.this.internalGetLineNumber(n + n2);
            this._deletedLineCount = n4 - n3 + 1;
        }

        @Override
        public DocumentEvent.ElementChange getChange(Element element) {
            if (element != LazyLoadDocument.this.getDefaultRootElement()) {
                return null;
            }
            return new LazyLoadElementChange(this, element);
        }
    }

    private class LazyLoadCharSequence
    implements CharSequence {
        private SyntaxDocument _document;

        public LazyLoadCharSequence(LazyLoadDocument lazyLoadDocument2) {
            this._document = lazyLoadDocument2;
        }

        @Override
        public int length() {
            return this._document.getLength();
        }

        @Override
        public char charAt(int n) {
            try {
                return this._document.charAt(n);
            }
            catch (BadLocationException badLocationException) {
                return '\u0000';
            }
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            try {
                return this._document.getText(n, n2 - n + 1);
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }
    }

    class PageDefinition {
        private int _startOffsetInFile;
        private int _startLineInFile;
        private int _startOffsetInMemory;
        private int _startLineInMemory;
        private int _originalLength;
        private int _pageLineCount;
        private AbstractDocument _document;
        private boolean _modified;

        PageDefinition() {
        }

        public int getStartOffsetInFile() {
            return this._startOffsetInFile;
        }

        public void setStartOffsetInFile(int n) {
            this._startOffsetInFile = n;
        }

        public int getStartLineInFile() {
            return this._startLineInFile;
        }

        public void setStartLineInFile(int n) {
            this._startLineInFile = n;
        }

        public int getPageLineCount() {
            return this._pageLineCount;
        }

        public void setPageLineCount(int n) {
            this._pageLineCount = n;
        }

        public AbstractDocument getDocument() {
            return this._document;
        }

        public void setDocument(AbstractDocument abstractDocument) {
            this._document = abstractDocument;
        }

        public boolean isModified() {
            return this._modified;
        }

        public void setModified(boolean bl) {
            this._modified = bl;
        }

        public int getOriginalLength() {
            return this._originalLength;
        }

        public void setOriginalLength(int n) {
            this._originalLength = n;
        }

        public int getStartLineInMemory() {
            return this._startLineInMemory;
        }

        public void setStartLineInMemory(int n) {
            this._startLineInMemory = n;
        }

        public int getStartOffsetInMemory() {
            return this._startOffsetInMemory;
        }

        public void setStartOffsetInMemory(int n) {
            this._startOffsetInMemory = n;
        }
    }
}

