/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorFindAndReplaceTarget;
import com.jidesoft.editor.highlight.DefaultHighlighter;
import com.jidesoft.editor.highlight.Highlighter;
import com.jidesoft.editor.selection.DefaultSelectionModel;
import com.jidesoft.editor.selection.SelectionEvent;
import com.jidesoft.editor.selection.SelectionListener;
import com.jidesoft.editor.selection.SelectionModel;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.BadLocationException;

public class CodeEditorSelectionFindAndReplaceTarget
extends CodeEditorFindAndReplaceTarget
implements SelectionListener,
PropertyChangeListener {
    static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(204, 204, 255);
    private Color _highlightColor = null;
    private Highlighter.HighlightPainter _highlightPainter;
    private int _highlightLength = 0;
    private Object _existingHighlight = null;

    public CodeEditorSelectionFindAndReplaceTarget(CodeEditor codeEditor) {
        super(codeEditor);
        codeEditor.getSelectionModel().addSelectionListener(this);
        codeEditor.addPropertyChangeListener("columnSelectionEnabled", this);
        this.setHighlightColor(DEFAULT_HIGHLIGHT_COLOR);
    }

    public Color getHighlightColor() {
        if (this._highlightColor != null) {
            return this._highlightColor;
        }
        return DEFAULT_HIGHLIGHT_COLOR;
    }

    public void setHighlightColor(Color color) {
        this._highlightColor = color;
        this._highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this._highlightColor);
    }

    @Override
    public CharSequence getCurrentText() {
        this.setTargetChanged(false);
        SelectionModel selectionModel = this.getCodeEditor().getSelectionModel();
        return selectionModel.hasSelection() ? selectionModel.getSelectedText() : super.getCurrentText();
    }

    @Override
    public JComponent getConfigurationPanel() {
        return new JLabel(this.getResourceString("FindAndReplace.selectedText"));
    }

    public boolean hasHighlight() {
        return this._existingHighlight != null;
    }

    @Override
    public void replace(int n, int n2, String string) throws BadLocationException {
        if (this.getCodeEditor().getSelectionModel().hasSelection()) {
            try {
                n = !this.getCodeEditor().getSelectionModel().isColumnSelectionMode() ? (n += this.getCodeEditor().getSelectionStart()) : this.getCodeEditor().getSelectionModel().offsetInSelectionToOffsetInDocument(n);
                super.replace(n, n2, string);
                if (!this.getCodeEditor().getSelectionModel().isColumnSelectionMode()) {
                    this.getCodeEditor().getSelectionModel().setSelection(this.getCodeEditor().getSelectionModel().getSelectionStart(), this.getCodeEditor().getSelectionModel().getSelectionEnd() + (string.length() - n2));
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            super.replace(n, n2, string);
        }
    }

    @Override
    public void adjustCurrentPosition(String string, boolean bl) {
    }

    @Override
    public void highlight(int n, int n2) {
        if (this.getCodeEditor().getSelectionModel().hasSelection()) {
            try {
                if (this._existingHighlight != null) {
                    this.getCodeEditor().getHighlighter().removeHighlight(this._existingHighlight);
                }
                if (!this.getCodeEditor().getSelectionModel().isColumnSelectionMode()) {
                    int n3 = this.getCodeEditor().getSelectionStart();
                    this._existingHighlight = this.getCodeEditor().getHighlighter().addHighlight(n + n3, n2 + n3, this._highlightPainter);
                    this._highlightLength = n2 - n;
                    this.getCodeEditor().getCaretModel().setOffset(n2 + n3);
                } else if (this.getCodeEditor().getSelectionModel() instanceof DefaultSelectionModel) {
                    n = this.getCodeEditor().getSelectionModel().offsetInSelectionToOffsetInDocument(n);
                    n2 = this.getCodeEditor().getSelectionModel().offsetInSelectionToOffsetInDocument(n2);
                    this._existingHighlight = this.getCodeEditor().getHighlighter().addHighlight(n, n2, this._highlightPainter);
                    this._highlightLength = n2 - n;
                    this.getCodeEditor().getCaretModel().setOffset(n2);
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            super.highlight(n, n2);
        }
    }

    @Override
    public int getCurrentPosition(boolean bl) {
        int n;
        if (!this.getCodeEditor().getSelectionModel().hasSelection()) {
            return 0;
        }
        if (!this.hasHighlight()) {
            return bl ? 0 : this.getCodeEditor().getSelectionModel().getSelectedText().length();
        }
        int n2 = n = bl ? this.getCodeEditor().getCaretModel().getOffset() : this.getCodeEditor().getCaretModel().getOffset() - this._highlightLength;
        if (this.getCodeEditor().getSelectionModel() instanceof DefaultSelectionModel) {
            return this.getCodeEditor().getSelectionModel().offsetInDocumentToOffsetInSelection(n);
        }
        return n - this.getCodeEditor().getSelectionStart();
    }

    @Override
    public void selectionChanged(SelectionEvent selectionEvent) {
        this.setTargetChanged(true);
        if (this._existingHighlight != null) {
            this.getCodeEditor().getHighlighter().removeHighlight(this._existingHighlight);
            this._existingHighlight = null;
        }
        this._highlightLength = 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setTargetChanged(true);
        if (this._existingHighlight != null) {
            this.getCodeEditor().getHighlighter().removeHighlight(this._existingHighlight);
            this._existingHighlight = null;
        }
        this._highlightLength = 0;
    }

    Highlighter.HighlightPainter getHighlightPainter() {
        return this._highlightPainter;
    }

    @Override
    public void replaceAllEnds() {
        super.replaceAllEnds();
        if (this.getCodeEditor().getSelectionModel().isColumnSelectionMode()) {
            this.getCodeEditor().getSelectionModel().setSelection(this.getCodeEditor().getSelectionModel().getSelectionStartViewPosition(), this.getCodeEditor().getSelectionModel().getSelectionEndViewPosition());
        } else {
            this.getCodeEditor().getSelectionModel().setSelection(this.getCodeEditor().getSelectionModel().getSelectionStart(), this.getCodeEditor().getSelectionModel().getSelectionEnd());
        }
    }
}

