/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.highlight.DefaultHighlighter;
import com.jidesoft.editor.highlight.Highlighter;
import com.jidesoft.editor.selection.SelectionListener;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBar;
import com.jidesoft.swing.WholeWordsSupport;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class CodeEditorSearchable
extends Searchable
implements DocumentListener,
PropertyChangeListener,
WholeWordsSupport {
    private static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(204, 204, 255);
    private Color _highlightColor = null;
    private Highlighter.HighlightPainter _highlightPainter;
    private CodeEditor _editor;
    private boolean _highlightingAll;
    private boolean _wholeWords = false;

    public CodeEditorSearchable(CodeEditor codeEditor) {
        super(codeEditor);
        this._editor = codeEditor;
        codeEditor.getDocument().addDocumentListener(this);
        codeEditor.addPropertyChangeListener(this);
        this.setHighlightColor(DEFAULT_HIGHLIGHT_COLOR);
    }

    public Color getHighlightColor() {
        if (this._highlightColor != null) {
            return this._highlightColor;
        }
        return DEFAULT_HIGHLIGHT_COLOR;
    }

    public void setHighlightColor(Color color) {
        this._highlightColor = color;
        this._highlightPainter = new SearchableHighlighterPainter(this._highlightColor);
    }

    @Override
    public void firePropertyChangeEvent(String string) {
        super.firePropertyChangeEvent(string);
        this._editor.clearSearchHighlighters();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"firstLine".equals(propertyChangeEvent.getPropertyName()) && !"visibleLines".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (!this._highlightingAll) {
            return;
        }
        this.highlightAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void highlightAll() {
        this._highlightingAll = true;
        String string = this.getSearchingText();
        int n = this._editor.viewToModelLine(this._editor.getFirstLine());
        int n2 = this._editor.getVisibleLines();
        int n3 = this._editor.getLineStartOffset(n);
        int n4 = this._editor.getLineStartOffset(n + n2);
        int n5 = -1;
        int n6 = n3;
        int n7 = this.getCursor();
        this.setCursor(n6);
        boolean bl = this.isRepeats();
        int n8 = this._editor.getCaretModel().getOffset();
        this.setRepeats(false);
        try {
            while (n6 != -1 && n6 >= n3 && n6 < n4) {
                n6 = this.findNext(string);
                if (n6 == -1) continue;
                if (n5 == -1) {
                    n5 = n6;
                }
                this.select(n6, string);
            }
            if (n5 != -1) {
                this.select(n5, string);
            }
        }
        finally {
            this.setRepeats(bl);
            this._editor.getCaretModel().setOffset(n8);
        }
        this.setCursor(n7);
    }

    @Override
    protected void cancelHighlightAll() {
        super.cancelHighlightAll();
        this._highlightingAll = false;
    }

    @Override
    protected void setSelectedIndex(int n, boolean bl) {
        String string = this.getSearchingText();
        if (n >= 0) {
            if (bl) {
                this._editor.setCaretPosition(n + string.length());
                try {
                    this._editor.getHighlighter().addHighlight(n, n + string.length(), this._highlightPainter);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                this.removeAllSearchableHighlights();
                if (this.getSearchableProvider() instanceof SearchableBar && ((SearchableBar)this.getSearchableProvider()).isHighlightAll()) {
                    try {
                        this._editor.getHighlighter().addHighlight(n, n + string.length(), this._highlightPainter);
                    }
                    catch (BadLocationException badLocationException) {}
                } else {
                    this._editor.select(n, n + string.length(), true);
                }
            }
        } else {
            this._editor.getSelectionModel().clearSelection();
            if (!bl) {
                this.removeAllSearchableHighlights();
            }
        }
    }

    private void removeAllSearchableHighlights() {
        Highlighter highlighter = this._editor.getHighlighter();
        if (highlighter instanceof DefaultHighlighter) {
            Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
            for (int i = highlightArray.length - 1; i >= 0; --i) {
                Highlighter.Highlight highlight = highlightArray[i];
                if (!(highlight.getPainter() instanceof SearchableHighlighterPainter)) continue;
                highlighter.removeHighlight(((DefaultHighlighter)highlighter).getHighlightInfo(i));
            }
        }
    }

    @Override
    protected int getSelectedIndex() {
        return this._editor.getSelectionModel().getSelectionStart();
    }

    @Override
    protected Object getElementAt(int n) {
        String string = this.getSearchingText();
        if (string != null) {
            int n2;
            int n3 = string.length();
            if (n + n3 > (n2 = this.getElementCount())) {
                n3 = this.getElementCount() - n;
            }
            return this._editor.getText(n, n3);
        }
        return "";
    }

    @Override
    protected int getElementCount() {
        return this._editor.getDocumentLength();
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.hidePopup();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.hidePopup();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.hidePopup();
    }

    @Override
    public boolean isActivateKey(KeyEvent keyEvent) {
        return keyEvent.getID() == 401 && keyEvent.getKeyCode() == 114 && (8 & keyEvent.getModifiers()) != 0;
    }

    @Override
    public int findLast(String string) {
        return this._editor.getDocument().findPrevious(new String[]{string}, this._editor.getDocumentLength(), 0, this.isCaseSensitive(), this.isWholeWords());
    }

    @Override
    public int findFirst(String string) {
        return this._editor.getDocument().findNext(new String[]{string}, 0, this._editor.getDocumentLength(), this.isCaseSensitive(), this.isWholeWords());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findFromCursor(String string) {
        int n;
        int n2;
        if (this.isCountMatch()) {
            SelectionListener[] selectionListenerArray;
            n2 = this.isReverseOrder();
            this.setReverseOrder(false);
            for (SelectionListener selectionListener : selectionListenerArray = this._editor.getSelectionModel().getSelectionListeners()) {
                this._editor.getSelectionModel().removeSelectionListener(selectionListener);
            }
            try {
                int n3;
                int n4;
                int n5 = n4 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
                if (n4 < 0) {
                    n4 = 0;
                }
                int n6 = -1;
                this._matchCount = -1;
                do {
                    this.setSelectedIndex(n6, false);
                    n3 = n6;
                    n6 = this._editor.getDocument().findNext(new String[]{string}, n3, this._editor.getDocumentLength(), this.isCaseSensitive(), this.isWholeWords()) + 1;
                    ++this._matchCount;
                } while (n6 > n3);
                --this._matchCount;
                this.setSelectedIndex(n4, false);
            }
            finally {
                this.setReverseOrder(n2 != 0);
                for (SelectionListener selectionListener : selectionListenerArray) {
                    this._editor.getSelectionModel().addSelectionListener(selectionListener);
                }
            }
        }
        int n7 = n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = this._editor.getDocument().findNext(new String[]{string}, n2, this._editor.getDocumentLength(), this.isCaseSensitive(), this.isWholeWords())) < 0 && (n = this._editor.getDocument().findNext(new String[]{string}, 0, Math.min(n2 + string.length() - 1, this._editor.getDocumentLength()), this.isCaseSensitive(), this.isWholeWords())) >= n2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int findNext(String string) {
        int n;
        int n2;
        int n3 = n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = this._editor.getDocument().findNext(new String[]{string}, n2 + 1, this._editor.getDocumentLength(), this.isCaseSensitive(), this.isWholeWords())) == -1 && this.isRepeats() && (n = this._editor.getDocument().findNext(new String[]{string}, 0, n2, this.isCaseSensitive(), this.isWholeWords())) >= n2) {
            n = -1;
        }
        return n;
    }

    @Override
    public int findPrevious(String string) {
        int n;
        int n2;
        int n3 = n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = this._editor.getDocument().findPrevious(new String[]{string}, n2, 0, this.isCaseSensitive(), this.isWholeWords())) == -1 && this.isRepeats() && (n = this._editor.getDocument().findPrevious(new String[]{string}, this.getElementCount(), n2, this.isCaseSensitive(), this.isWholeWords())) <= n2) {
            n = -1;
        }
        return n;
    }

    @Override
    public boolean isWholeWords() {
        return this._wholeWords;
    }

    @Override
    public void setWholeWords(boolean bl) {
        this.hidePopup();
        this._wholeWords = bl;
    }

    @Override
    protected void searchingTextEmpty() {
        if (!(this.getSearchableProvider() instanceof SearchableBar) || !((SearchableBar)this.getSearchableProvider()).isHighlightAll()) {
            this._editor.getCaretModel().moveCaret(-1, 0, false, false, true);
        }
        this.setSelectedIndex(-1, false);
    }

    private class SearchableHighlighterPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public SearchableHighlighterPainter(Color color) {
            super(color);
        }
    }
}

