/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.marker.AbstractRowMarkerSupport;
import com.jidesoft.marker.MarkerModel;
import com.jidesoft.range.IntegerRange;
import java.awt.Point;

public class CodeEditorMarkerSupport
extends AbstractRowMarkerSupport {
    private CodeEditor _codeEditor;

    public CodeEditorMarkerSupport(CodeEditor codeEditor) {
        this._codeEditor = codeEditor;
    }

    @Override
    public MarkerModel getMarkerModel() {
        return this._codeEditor.getMarkerModel();
    }

    @Override
    public void scrollTo(int n, int n2, boolean bl) {
        this._codeEditor.select(n, n2, true);
        this._codeEditor.requestFocus();
    }

    @Override
    public Point indexToPoint(int n, int n2) {
        int n3;
        CaretPosition caretPosition = this._codeEditor.offsetToViewPosition(n);
        int n4 = caretPosition.line;
        int n5 = this._codeEditor.getVisualLineCount();
        if (n5 * (n3 = this._codeEditor.getLineHeight()) < n2) {
            return new Point(0, n4 * n3);
        }
        return new Point(0, (int)((double)(n4 * n2) / (double)n5));
    }

    @Override
    public IntegerRange pointToIndexRange(Point point, int n) {
        int n2;
        int n3 = point.y;
        int n4 = this._codeEditor.getVisualLineCount();
        if (n4 * (n2 = this._codeEditor.getLineHeight()) < n) {
            int n5 = n3 / n2;
            if (n5 > n4) {
                n5 = n4 - 1;
            }
            return new IntegerRange(n5, n5);
        }
        if (n4 < n) {
            double d = (double)n4 / (double)n;
            int n6 = (int)((double)n3 * d);
            return new IntegerRange(n6, n6);
        }
        double d = (double)n4 / (double)n;
        return new IntegerRange((int)((double)n3 * d), (int)((double)(n3 + 1) * d) - 1);
    }

    @Override
    public int getRowHeight() {
        return this._codeEditor.getLineHeight();
    }

    @Override
    public int getRowCount() {
        return this._codeEditor.getLineCount();
    }
}

