/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.margin.MarginSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CodeEditorMarginSupport
implements MarginSupport {
    protected CodeEditor _codeEditor;
    private Map<MarginSupport.RepaintCallback, FoldingSpanListener> _cache;
    private DocumentListener _documentListener;
    private PropertyChangeListener _propertyChangeListener;

    public CodeEditorMarginSupport(CodeEditor codeEditor) {
        this._codeEditor = codeEditor;
        this._cache = new HashMap<MarginSupport.RepaintCallback, FoldingSpanListener>();
    }

    public CodeEditor getCodeEditor() {
        return this._codeEditor;
    }

    @Override
    public int getViewPosition() {
        return this._codeEditor.getVerticalScrollBar().getValue();
    }

    @Override
    public int getViewSize() {
        return this._codeEditor.getHeight();
    }

    @Override
    public void installListeners(final MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        FoldingSpanListener foldingSpanListener = this._cache.get(repaintCallback);
        if (foldingSpanListener == null) {
            foldingSpanListener = new FoldingSpanListener(){

                @Override
                public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
                    if (!foldingSpanEvent.isAdjusting()) {
                        repaintCallback.repaint();
                    }
                }
            };
            this._codeEditor.getFoldingModel().addFoldingSpanListener(foldingSpanListener);
            this._cache.put(repaintCallback, foldingSpanListener);
        }
        if (modelChangedCallback != null) {
            if (this._documentListener == null) {
                this._documentListener = new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }
                };
            }
            if (this._propertyChangeListener == null) {
                this._propertyChangeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object;
                        Object object2 = propertyChangeEvent.getOldValue();
                        if (object2 instanceof Document) {
                            ((Document)object2).removeDocumentListener(CodeEditorMarginSupport.this._documentListener);
                        }
                        if ((object = propertyChangeEvent.getNewValue()) instanceof Document) {
                            ((Document)object).addDocumentListener(CodeEditorMarginSupport.this._documentListener);
                        }
                        modelChangedCallback.modelChanged(propertyChangeEvent);
                    }
                };
            }
            this._codeEditor.addPropertyChangeListener("document", this._propertyChangeListener);
            SyntaxDocument syntaxDocument = this._codeEditor.getDocument();
            if (syntaxDocument != null) {
                syntaxDocument.addDocumentListener(this._documentListener);
            }
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        FoldingSpanListener foldingSpanListener;
        if (this._propertyChangeListener != null) {
            this._codeEditor.removePropertyChangeListener("document", this._propertyChangeListener);
        }
        if (this._documentListener != null && this._codeEditor.getDocument() != null) {
            this._codeEditor.getDocument().removeDocumentListener(this._documentListener);
        }
        if ((foldingSpanListener = this._cache.get(repaintCallback)) != null) {
            this._codeEditor.getFoldingModel().removeFoldingSpanListener(foldingSpanListener);
        }
    }
}

