/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.editor.CodeEditorIconsFactory;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClipboardsDialog
extends StandardDialog {
    private List<Transferable> _clipboards;
    public JList _list;
    public JTextArea _textArea;
    public Font _font;
    private static final ImageIcon CLIP_TEXT = CodeEditorIconsFactory.getImageIcon("icons/clip_text.png");

    public ClipboardsDialog(Frame frame, String string, List<Transferable> list, Font font) throws HeadlessException {
        super(frame, string);
        this.setClipboards(list);
        this._font = font;
    }

    public ClipboardsDialog(Dialog dialog, String string, List<Transferable> list, Font font) throws HeadlessException {
        super(dialog, string);
        this.setClipboards(list);
        this._font = font;
    }

    private void setClipboards(List<Transferable> list) {
        this._clipboards = list == null ? new ArrayList<Transferable>() : list;
    }

    public Transferable getSelectedClipboard() {
        Transferable transferable;
        int n = this._list.getSelectedIndex();
        if (n != -1 && (transferable = this._clipboards.get(n)) instanceof Transferable) {
            return transferable;
        }
        return null;
    }

    @Override
    public JComponent createContentPanel() {
        this._list = new JList(new AbstractListModel(){
            private static final long serialVersionUID = -1751723554995065516L;

            @Override
            public int getSize() {
                return ClipboardsDialog.this._clipboards.size();
            }

            @Override
            public Object getElementAt(int n) {
                return ClipboardsDialog.this._clipboards.get(n);
            }
        });
        this._list.setCellRenderer(new TransferableCellRenderer());
        this._list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    ClipboardsDialog.this.getDefaultAction().actionPerformed(null);
                }
            }
        });
        this._list.setVisibleRowCount(10);
        this._list.setFont(this._font);
        this._textArea = new JTextArea();
        this._textArea.setFont(this._font);
        this._textArea.setEditable(false);
        this._list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Transferable transferable = ClipboardsDialog.this.getSelectedClipboard();
                if (transferable != null) {
                    try {
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        ClipboardsDialog.this._textArea.setText(string);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        ClipboardsDialog.this._textArea.setText(unsupportedFlavorException.getLocalizedMessage());
                    }
                    catch (IOException iOException) {
                        ClipboardsDialog.this._textArea.setText(iOException.getLocalizedMessage());
                    }
                } else {
                    ClipboardsDialog.this._textArea.setText("");
                }
            }
        });
        this._list.setSelectedIndex(0);
        this._textArea.setRows(10);
        this._textArea.setColumns(60);
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(new JScrollPane(this._list));
        jPanel.add(new JScrollPane(this._textArea));
        return jPanel;
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 6, 10));
        AbstractAction abstractAction = new AbstractAction(JideSwingUtilities.getOKString(this.getLocale())){
            private static final long serialVersionUID = -4291142455223458317L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClipboardsDialog.this.setDialogResult(0);
                ClipboardsDialog.this.setVisible(false);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(JideSwingUtilities.getCancelString(this.getLocale())){
            private static final long serialVersionUID = 4804630766173155881L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClipboardsDialog.this.setDialogResult(-1);
                ClipboardsDialog.this.setVisible(false);
            }
        };
        JButton jButton = new JButton(abstractAction);
        buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)new JButton(abstractAction2), "CANCEL");
        this.setDefaultCancelAction(abstractAction2);
        this.setDefaultAction(abstractAction);
        this.getRootPane().setDefaultButton(jButton);
        return buttonPanel;
    }

    @Override
    public JComponent createBannerPanel() {
        return null;
    }

    private class TransferableCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            Object object3 = "...";
            if (object instanceof Transferable) {
                try {
                    object2 = (String)((Transferable)object).getTransferData(DataFlavor.stringFlavor);
                    int n2 = ((String)object2).indexOf(10);
                    object3 = n2 == -1 ? object2 : ((String)object2).substring(0, n2) + "...";
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    object3 = unsupportedFlavorException.getLocalizedMessage();
                }
                catch (IOException iOException) {
                    object3 = iOException.getLocalizedMessage();
                }
            }
            if ((object2 = super.getListCellRendererComponent((JList<?>)jList, object3, n, bl, bl2)) instanceof JLabel) {
                ((JLabel)object2).setIcon(CLIP_TEXT);
            }
            return object2;
        }
    }
}

