/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.AbstractCodeEditorIntelliHints;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.Sticky;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class AbstractListCodeEditorIntelliHints
extends AbstractCodeEditorIntelliHints {
    protected JList _list;
    protected KeyStroke[] _keyStrokes;
    protected JideScrollPane _scroll;
    protected int _minimumPopupWidth = 100;

    public AbstractListCodeEditorIntelliHints(CodeEditor codeEditor) {
        super(codeEditor);
    }

    @Override
    public JComponent createHintsComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this._list = this.createList();
        this._list.setVisibleRowCount(10);
        this.addSticky();
        this._scroll = new JideScrollPane(this.getList());
        this.getList().setFocusable(false);
        this._scroll.setHorizontalScrollBarPolicy(31);
        this._scroll.setBorder(BorderFactory.createEmptyBorder());
        this._scroll.getVerticalScrollBar().setFocusable(false);
        this._scroll.getHorizontalScrollBar().setFocusable(false);
        jPanel.add((Component)this._scroll, "Center");
        return jPanel;
    }

    protected void addSticky() {
        new Sticky(this._list);
    }

    protected JList createList() {
        JList jList = new JList(){

            @Override
            public int getVisibleRowCount() {
                int n = this.getModel().getSize();
                return n < super.getVisibleRowCount() ? n : super.getVisibleRowCount();
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                if (this.getModel().getSize() == 0) {
                    return new Dimension(0, 0);
                }
                Dimension dimension = super.getPreferredScrollableViewportSize();
                dimension.width = Math.max(dimension.width, AbstractListCodeEditorIntelliHints.this.getMinimumPopupWidth());
                return dimension;
            }
        };
        jList.getActionMap().put("selectNextRow", new AbstractAction(){
            private static final long serialVersionUID = -2771445203168902756L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JList jList = (JList)actionEvent.getSource();
                int n = jList.getModel().getSize();
                if (n > 0) {
                    int n2 = jList.getSelectedIndex() + 1;
                    if (n2 >= n) {
                        n2 = 0;
                    }
                    jList.setSelectedIndex(n2);
                    jList.ensureIndexIsVisible(n2);
                }
            }
        });
        jList.getActionMap().put("selectPreviousRow", new AbstractAction(){
            private static final long serialVersionUID = -1656268164787469098L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JList jList = (JList)actionEvent.getSource();
                int n = jList.getModel().getSize();
                if (n > 0) {
                    int n2 = jList.getSelectedIndex() - 1;
                    if (n2 < 0) {
                        n2 = n - 1;
                    }
                    jList.setSelectedIndex(n2);
                    jList.ensureIndexIsVisible(n2);
                }
            }
        });
        return jList;
    }

    protected JList getList() {
        return this._list;
    }

    protected void setListData(Object[] objectArray) {
        this.resetSelection();
        this.getList().setListData(objectArray);
        if (this._scroll != null) {
            this._scroll.setViewportView(this.getList());
        }
    }

    protected void setListData(Vector<?> vector) {
        this.resetSelection();
        this.getList().setListData(vector);
        if (this._scroll != null) {
            this._scroll.setViewportView(this.getList());
        }
    }

    private void resetSelection() {
        this.getList().getSelectionModel().setAnchorSelectionIndex(-1);
        this.getList().getSelectionModel().setLeadSelectionIndex(-1);
        this.getList().getSelectionModel().clearSelection();
    }

    @Override
    public Object getSelectedHint() {
        return this.getList().getSelectedValue();
    }

    @Override
    public JComponent getDelegateComponent() {
        return this.getList();
    }

    @Override
    public KeyStroke[] getDelegateKeyStrokes() {
        if (this._keyStrokes == null) {
            this._keyStrokes = new KeyStroke[8];
            this._keyStrokes[0] = KeyStroke.getKeyStroke(40, 0);
            this._keyStrokes[1] = KeyStroke.getKeyStroke(38, 0);
            this._keyStrokes[2] = KeyStroke.getKeyStroke(34, 0);
            this._keyStrokes[3] = KeyStroke.getKeyStroke(33, 0);
            this._keyStrokes[4] = KeyStroke.getKeyStroke(36, 0);
            this._keyStrokes[5] = KeyStroke.getKeyStroke(35, 0);
            this._keyStrokes[6] = KeyStroke.getKeyStroke(27, 0);
            this._keyStrokes[7] = KeyStroke.getKeyStroke(10, 0);
        }
        return this._keyStrokes;
    }

    public int getMinimumPopupWidth() {
        return this._minimumPopupWidth;
    }

    public void setMinimumPopupWidth(int n) {
        this._minimumPopupWidth = n;
    }

    @Override
    public boolean updateHints(Object object) {
        return false;
    }

    @Override
    public boolean updateHints(Object object, boolean bl) {
        return this.updateHints(object);
    }
}

