/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.hints.IntelliHints;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.DelegateAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;

public abstract class AbstractCodeEditorIntelliHints
implements IntelliHints {
    private JidePopup _popup;
    private CodeEditor _codeEditor;
    private JComponent _hintsComponent;
    private KeyListener _keyListener;
    private FocusListener _focusListener;
    private MouseListener _mouseListener;
    private boolean _keyTyped = false;
    private boolean _autoPopup = false;
    private List<KeyStroke> _showHintsKeyStrokes;
    private DelegateAction _showAction;
    private String _delimiters = " \t";
    private int _popupDelay = 200;
    private final DelegateAction acceptAction = new DelegateAction(){
        private static final long serialVersionUID = 818798975216716710L;

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            AbstractCodeEditorIntelliHints abstractCodeEditorIntelliHints = AbstractCodeEditorIntelliHints.getIntelliHints(jComponent);
            if (abstractCodeEditorIntelliHints != null) {
                abstractCodeEditorIntelliHints.hideHintsPopup();
                if (abstractCodeEditorIntelliHints.getSelectedHint() != null) {
                    abstractCodeEditorIntelliHints.setHintsEnabled(false);
                    abstractCodeEditorIntelliHints.acceptHint(abstractCodeEditorIntelliHints.getSelectedHint());
                    abstractCodeEditorIntelliHints.setHintsEnabled(true);
                    return true;
                }
            }
            return false;
        }
    };
    private final DelegateAction hideAction = new DelegateAction(){
        private static final long serialVersionUID = -2356564033432685097L;

        @Override
        public boolean isDelegateEnabled() {
            return AbstractCodeEditorIntelliHints.this._codeEditor.isEnabled() && AbstractCodeEditorIntelliHints.this.isHintsPopupVisible();
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled()) {
                AbstractCodeEditorIntelliHints.this.hideHintsPopup();
                return true;
            }
            return false;
        }
    };
    private final DocumentListener _documentListener = new DocumentListener(){
        Timer _timer = null;

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.startTimer();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.startTimer();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        void startTimer() {
            if (this._timer == null || this._timer.getInitialDelay() != AbstractCodeEditorIntelliHints.this.getPopupDelay()) {
                if (this._timer != null) {
                    this._timer.stop();
                }
                this._timer = new Timer(AbstractCodeEditorIntelliHints.this.getPopupDelay(), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (AbstractCodeEditorIntelliHints.this.isKeyTyped()) {
                            if (AbstractCodeEditorIntelliHints.this.isHintsPopupVisible() || AbstractCodeEditorIntelliHints.this.isAutoPopup()) {
                                AbstractCodeEditorIntelliHints.this.showHintsPopup(true);
                            }
                            AbstractCodeEditorIntelliHints.this.setKeyTyped(false);
                        }
                    }
                });
            }
            if (this._timer.isRunning()) {
                this._timer.restart();
            } else {
                this._timer.setRepeats(false);
                this._timer.start();
            }
        }
    };

    public AbstractCodeEditorIntelliHints(CodeEditor codeEditor) {
        this._popup = this.createPopup();
        this.install(codeEditor);
    }

    public void install(CodeEditor codeEditor) {
        KeyStroke[] keyStrokeArray;
        this.uninstall();
        this._codeEditor = codeEditor;
        if (this._codeEditor == null) {
            throw new IllegalArgumentException("The installer could not accept a null CodeEditor as its parameter.");
        }
        codeEditor.putClientProperty("INTELLI_HINTS", this);
        codeEditor.getDocument().addDocumentListener(this._documentListener);
        this._keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (27 != keyEvent.getKeyCode() && 10 != keyEvent.getKeyCode()) {
                    AbstractCodeEditorIntelliHints.this.setKeyTyped(true);
                }
            }
        };
        codeEditor.addKeyListener(this._keyListener);
        this._focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Container container = AbstractCodeEditorIntelliHints.this._popup.getTopLevelAncestor();
                if (container == null) {
                    return;
                }
                Component component = focusEvent.getOppositeComponent();
                if (container == component || container.isAncestorOf(component)) {
                    return;
                }
                AbstractCodeEditorIntelliHints.this.hideHintsPopup();
            }
        };
        codeEditor.addFocusListener(this._focusListener);
        this._mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AbstractCodeEditorIntelliHints.this.hideHintsPopup();
            }
        };
        codeEditor.getPainter().addMouseListener(this._mouseListener);
        this._showAction = new DelegateAction(){
            private static final long serialVersionUID = -6405015607399407217L;

            @Override
            public boolean isDelegateEnabled() {
                return (AbstractCodeEditorIntelliHints.this.getDelegateComponent() == null || AbstractCodeEditorIntelliHints.this.getDelegateComponent().isEnabled()) && !AbstractCodeEditorIntelliHints.this.isHintsPopupVisible();
            }

            @Override
            public boolean delegateActionPerformed(ActionEvent actionEvent) {
                JComponent jComponent = (JComponent)actionEvent.getSource();
                AbstractCodeEditorIntelliHints abstractCodeEditorIntelliHints = AbstractCodeEditorIntelliHints.getIntelliHints(jComponent);
                if (abstractCodeEditorIntelliHints != null && jComponent.isEnabled() && !abstractCodeEditorIntelliHints.isHintsPopupVisible()) {
                    abstractCodeEditorIntelliHints.showHintsPopup(false);
                    return true;
                }
                return false;
            }
        };
        this.addShowHintsKeyStroke(this.getShowHintsKeyStroke());
        for (KeyStroke keyStroke : keyStrokeArray = this.getDelegateKeyStrokes()) {
            DelegateAction.replaceAction(codeEditor, 0, keyStroke, new LazyDelegateAction(keyStroke));
        }
    }

    public void uninstall() {
        CodeEditor codeEditor = this.getCodeEditor();
        if (codeEditor == null) {
            return;
        }
        codeEditor.putClientProperty("INTELLI_HINTS", null);
        codeEditor.getDocument().removeDocumentListener(this._documentListener);
        codeEditor.removeKeyListener(this._keyListener);
        codeEditor.removeFocusListener(this._focusListener);
        codeEditor.getPainter().removeMouseListener(this._mouseListener);
        DelegateAction.restoreAction((JComponent)this.getCodeEditor(), 0, KeyStroke.getKeyStroke(27, 0), this.hideAction);
        DelegateAction.restoreAction((JComponent)this.getCodeEditor(), 0, KeyStroke.getKeyStroke(10, 0), this.acceptAction);
        for (KeyStroke keyStroke : this._showHintsKeyStrokes) {
            DelegateAction.restoreAction(this.getCodeEditor(), 0, keyStroke);
        }
        for (KeyStroke keyStroke : this.getDelegateKeyStrokes()) {
            DelegateAction.restoreAction(codeEditor, 0, keyStroke);
        }
        this._codeEditor = null;
    }

    protected JidePopup createPopup() {
        JidePopup jidePopup = JidePopupFactory.getSharedInstance().createPopup();
        jidePopup.setKeepPreviousSize(false);
        jidePopup.setLayout(new BorderLayout());
        jidePopup.setResizable(true);
        jidePopup.setPopupBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("controlDkShadow"), 1));
        jidePopup.setMovable(false);
        jidePopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                DelegateAction.restoreAction((JComponent)AbstractCodeEditorIntelliHints.this.getCodeEditor(), 0, KeyStroke.getKeyStroke(27, 0), AbstractCodeEditorIntelliHints.this.hideAction);
                DelegateAction.restoreAction((JComponent)AbstractCodeEditorIntelliHints.this.getCodeEditor(), 0, KeyStroke.getKeyStroke(10, 0), AbstractCodeEditorIntelliHints.this.acceptAction);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        jidePopup.setTransient(true);
        return jidePopup;
    }

    public CodeEditor getCodeEditor() {
        return this._codeEditor;
    }

    @Override
    public void acceptHint(Object object) {
        int n;
        String string;
        if (object == null) {
            return;
        }
        CaretPosition caretPosition = this.getCodeEditor().getCaretModel().getModelPosition();
        String string2 = this.getCodeEditor().getLineText(caretPosition.line);
        String string3 = string = this.getContext() instanceof String ? (String)this.getContext() : "";
        if (string.length() > 0 && (n = string2.lastIndexOf(string, caretPosition.column - 1)) >= 0 && caretPosition.column <= string2.length()) {
            this.getCodeEditor().select(this.getCodeEditor().modelPositionToOffset(new CaretPosition(caretPosition.line, n)), this.getCodeEditor().modelPositionToOffset(new CaretPosition(caretPosition.line, caretPosition.column)));
        }
        this.getCodeEditor().insertChar(object.toString());
    }

    protected void showHintsPopup(boolean bl) {
        if (this._popup == null) {
            return;
        }
        if (this._hintsComponent == null) {
            this._hintsComponent = this.createHintsComponent();
            this._popup.add(this._hintsComponent);
            this.getDelegateComponent().setRequestFocusEnabled(false);
            this.getDelegateComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    AbstractCodeEditorIntelliHints.this.hideHintsPopup();
                    AbstractCodeEditorIntelliHints.this.setHintsEnabled(false);
                    AbstractCodeEditorIntelliHints.this.acceptHint(AbstractCodeEditorIntelliHints.this.getSelectedHint());
                    AbstractCodeEditorIntelliHints.this.setHintsEnabled(true);
                }
            });
        }
        if (this.getCodeEditor().isEnabled() && this.getCodeEditor().hasFocus() && this.updateHints(this.getContext(), bl)) {
            DelegateAction.replaceAction(this.getCodeEditor(), 0, KeyStroke.getKeyStroke(27, 0), this.hideAction);
            DelegateAction.replaceAction((JComponent)this.getCodeEditor(), 0, KeyStroke.getKeyStroke(10, 0), this.acceptAction, true);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            try {
                Rectangle rectangle = this.getCaretRectangleForPopup();
                n2 = rectangle.y;
                n = rectangle.x;
                n3 = rectangle.height;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            this._popup.setOwner(this.getCodeEditor());
            this._popup.showPopup(new Insets(n2 + 4 + this.getCodeEditor().getPainter().getY(), n + this.getCodeEditor().getPainter().getX(), this.getCodeEditor().getHeight() - n3 - n2 - 6, 0));
        } else {
            this._popup.hidePopup();
        }
    }

    protected Rectangle getCaretRectangleForPopup() throws BadLocationException {
        return new Rectangle(this.getCodeEditor().getCaretLocation(), new Dimension(4, 8));
    }

    protected Object getContext() {
        CaretPosition caretPosition = this.getCodeEditor().getCaretModel().getModelPosition();
        String string = this.getCodeEditor().getLineText(caretPosition.line);
        if (caretPosition.column == 0) {
            return "";
        }
        if (caretPosition.column > string.length()) {
            return "";
        }
        String string2 = this.getDelimiters();
        string = string.substring(0, caretPosition.column);
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n = string.lastIndexOf(c);
            string = string.substring(n + 1);
        }
        return string;
    }

    protected void hideHintsPopup() {
        if (this._popup != null) {
            this._popup.hidePopup();
        }
        this.setKeyTyped(false);
    }

    public void setHintsEnabled(boolean bl) {
        if (!bl) {
            this.getCodeEditor().getDocument().removeDocumentListener(this._documentListener);
        } else {
            this.getCodeEditor().getDocument().addDocumentListener(this._documentListener);
        }
    }

    public boolean isHintsPopupVisible() {
        return this._popup != null && this._popup.isPopupVisible();
    }

    public boolean isAutoPopup() {
        return this._autoPopup;
    }

    public void setAutoPopup(boolean bl) {
        this._autoPopup = bl;
    }

    public abstract KeyStroke[] getDelegateKeyStrokes();

    public abstract JComponent getDelegateComponent();

    protected KeyStroke getShowHintsKeyStroke() {
        return KeyStroke.getKeyStroke(32, 2);
    }

    public void addShowHintsKeyStroke(KeyStroke keyStroke) {
        if (this._showHintsKeyStrokes == null) {
            this._showHintsKeyStrokes = new ArrayList<KeyStroke>();
        }
        this._showHintsKeyStrokes.add(keyStroke);
        DelegateAction.replaceAction(this.getCodeEditor(), 0, keyStroke, this._showAction);
    }

    public void removeShowHintsKeyStroke(KeyStroke keyStroke) {
        if (this._showHintsKeyStrokes != null) {
            this._showHintsKeyStrokes.remove(keyStroke);
            DelegateAction.restoreAction((JComponent)this.getCodeEditor(), 0, keyStroke, this._showAction);
        }
    }

    public KeyStroke[] getAllShowHintsKeyStrokes() {
        if (this._showHintsKeyStrokes == null) {
            return new KeyStroke[0];
        }
        return this._showHintsKeyStrokes.toArray(new KeyStroke[this._showHintsKeyStrokes.size()]);
    }

    private boolean isKeyTyped() {
        return this._keyTyped;
    }

    private void setKeyTyped(boolean bl) {
        this._keyTyped = bl;
    }

    public String getDelimiters() {
        return this._delimiters;
    }

    public void setDelimiters(String string) {
        this._delimiters = string;
    }

    public static AbstractCodeEditorIntelliHints getIntelliHints(JComponent jComponent) {
        Object object = jComponent.getClientProperty("INTELLI_HINTS");
        if (object instanceof AbstractCodeEditorIntelliHints) {
            return (AbstractCodeEditorIntelliHints)object;
        }
        return null;
    }

    public int getPopupDelay() {
        return this._popupDelay;
    }

    public void setPopupDelay(int n) {
        if (n >= 0) {
            this._popupDelay = n;
        }
    }

    private class LazyDelegateAction
    extends DelegateAction {
        private final KeyStroke _keyStroke;
        private static final long serialVersionUID = 2258648528763679043L;

        public LazyDelegateAction(KeyStroke keyStroke) {
            this._keyStroke = keyStroke;
        }

        @Override
        public boolean isDelegateEnabled() {
            Action action = this.getHintsPopupAction();
            return action != null && action.isEnabled();
        }

        private Action getHintsPopupAction() {
            if (AbstractCodeEditorIntelliHints.this.isHintsPopupVisible() && AbstractCodeEditorIntelliHints.this.getDelegateComponent() != null) {
                Object object = AbstractCodeEditorIntelliHints.this.getDelegateComponent().getInputMap().get(this._keyStroke);
                Object object2 = object = object == null ? AbstractCodeEditorIntelliHints.this.getCodeEditor().getInputMap(1).get(this._keyStroke) : object;
                if (object != null) {
                    return AbstractCodeEditorIntelliHints.this.getDelegateComponent().getActionMap().get(object);
                }
            }
            return null;
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            Action action = this.getHintsPopupAction();
            if (action != null) {
                action.actionPerformed(new ActionEvent(AbstractCodeEditorIntelliHints.this.getDelegateComponent(), 0, String.valueOf(action.getValue("ActionCommandKey"))));
                return true;
            }
            return false;
        }
    }
}

