/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.document;

import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentPane;
import com.jidesoft.document.IDocumentGroup;
import com.jidesoft.document.TdiMouseInputAdapter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.Color;
import java.awt.Component;

public class TdiGroup
extends JideTabbedPane
implements IDocumentGroup {
    private TdiMouseInputAdapter _mouseListener;

    public TdiGroup() {
        super(1, 1);
        this.setOpaque(false);
        this.setCloseTabOnMouseMiddleButton(true);
        this.installListeners();
        this.setTabColorProvider(new JideTabbedPane.ColorProvider(){

            @Override
            public Color getBackgroundAt(int n) {
                String string;
                DocumentPane documentPane;
                int n2;
                Component component = TdiGroup.this.getDocumentAt(n);
                if (TdiGroup.this.getParent() instanceof DocumentPane && (n2 = (documentPane = (DocumentPane)TdiGroup.this.getParent()).globalIndexOfDocument(string = documentPane.getNameOf(component))) >= 0 && n2 < documentPane.getDocumentCount() && documentPane.getTabColorProvider() != null) {
                    return documentPane.getTabColorProvider().getBackgroundAt(n2);
                }
                return null;
            }

            @Override
            public Color getForegroundAt(int n) {
                DocumentPane documentPane;
                int n2;
                Component component = TdiGroup.this.getDocumentAt(n);
                if (TdiGroup.this.getParent() instanceof DocumentPane && (n2 = (documentPane = (DocumentPane)TdiGroup.this.getParent()).globalIndexOfDocument(documentPane.getNameOf(component))) >= 0 && n2 < documentPane.getDocumentCount() && documentPane.getTabColorProvider() != null) {
                    return documentPane.getTabColorProvider().getForegroundAt(n2);
                }
                return null;
            }

            @Override
            public float getGradientRatio(int n) {
                DocumentPane documentPane;
                int n2;
                Component component = TdiGroup.this.getDocumentAt(n);
                if (TdiGroup.this.getParent() instanceof DocumentPane && (n2 = (documentPane = (DocumentPane)TdiGroup.this.getParent()).globalIndexOfDocument(documentPane.getNameOf(component))) >= 0 && n2 < documentPane.getDocumentCount() && documentPane.getTabColorProvider() != null) {
                    return documentPane.getTabColorProvider().getGradientRatio(n2);
                }
                return 0.0f;
            }
        });
    }

    @Override
    public void addDocument(DocumentComponent documentComponent) {
        this.addTab(documentComponent.getDisplayTitle(), documentComponent.getIcon(), documentComponent.getComponent(), documentComponent.getTooltip());
        this.updateTitle(documentComponent);
    }

    @Override
    public void addDocument(DocumentComponent documentComponent, int n) {
        if (n != -1) {
            this.insertTab(documentComponent.getDisplayTitle(), documentComponent.getIcon(), documentComponent.getComponent(), documentComponent.getTooltip(), n);
        } else {
            this.addTab(documentComponent.getDisplayTitle(), documentComponent.getIcon(), documentComponent.getComponent(), documentComponent.getTooltip());
        }
        this.updateTitle(documentComponent);
    }

    @Override
    public void removeDocument(int n) {
        this.removeTabAt(n);
    }

    @Override
    public void removeDocument(DocumentComponent documentComponent) {
        this.removeDocument(this.indexOfComponent(documentComponent.getComponent()));
    }

    @Override
    public void updateTitle(DocumentComponent documentComponent) {
        int n = this.indexOfComponent(documentComponent.getComponent());
        if (n != -1) {
            this.setTitleAt(n, documentComponent.getDisplayTitle());
            this.setIconAt(n, documentComponent.getIcon());
            this.setToolTipTextAt(n, documentComponent.getTooltip());
            this.setBackgroundAt(n, documentComponent.getBackground());
            this.setForegroundAt(n, documentComponent.getForeground());
        }
    }

    @Override
    @Deprecated
    public void updateComponent(DocumentComponent documentComponent) {
        int n = this.indexOfTab(documentComponent.getTitle());
        if (n != -1) {
            this.setComponentAt(n, documentComponent.getComponent());
        }
    }

    @Override
    public void updateComponent(DocumentComponent documentComponent, Component component) {
        int n = this.indexOfComponent(component);
        if (n != -1) {
            this.setComponentAt(n, documentComponent.getComponent());
        }
    }

    @Override
    public void setSelectedDocument(Component component) {
        if (this.indexOfComponent(component) != -1) {
            this.setSelectedComponent(component);
        }
    }

    @Override
    public Component getSelectedDocument() {
        return this.getSelectedComponent();
    }

    @Override
    public Component getDocumentAt(int n) {
        return this.getComponentAt(n);
    }

    @Override
    public int getDocumentCount() {
        return this.getTabCount();
    }

    public void installListeners() {
        TdiMouseInputAdapter tdiMouseInputAdapter = this.createMouseInputAdapter();
        if (!JideSwingUtilities.isMouseListenerRegistered(this, tdiMouseInputAdapter)) {
            this.addMouseListener(tdiMouseInputAdapter);
        }
        if (!JideSwingUtilities.isMouseMotionListenerRegistered(this, tdiMouseInputAdapter)) {
            this.addMouseMotionListener(tdiMouseInputAdapter);
        }
    }

    public void uninstallListeners() {
        TdiMouseInputAdapter tdiMouseInputAdapter = this.createMouseInputAdapter();
        this.removeMouseListener(tdiMouseInputAdapter);
        this.removeMouseMotionListener(tdiMouseInputAdapter);
    }

    private TdiMouseInputAdapter createMouseInputAdapter() {
        if (this._mouseListener == null) {
            this._mouseListener = new TdiMouseInputAdapter(this);
        }
        return this._mouseListener;
    }

    @Override
    public int indexOfDocument(Component component) {
        return this.indexOfComponent(component);
    }

    @Override
    public void moveSelectedDocumentTo(int n) {
        this.moveSelectedTabTo(n);
    }

    private DocumentComponent getDocumentComponent(Component component) {
        if (this.getParent() instanceof DocumentPane) {
            DocumentPane documentPane = (DocumentPane)this.getParent();
            return documentPane.getDocument(documentPane.getNameOf(component));
        }
        return null;
    }

    @Override
    public boolean isTabClosableAt(int n) {
        Component component = this.getComponentAt(n);
        DocumentComponent documentComponent = this.getDocumentComponent(component);
        if (documentComponent != null) {
            return documentComponent.isClosable();
        }
        return super.isTabClosableAt(n);
    }
}

