/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.document;

import com.jidesoft.document.CloneableDocumentComponent;
import com.jidesoft.document.DefaultStringConverter;
import com.jidesoft.document.DialogFloatingDocumentContainer;
import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentComponentFactory;
import com.jidesoft.document.DocumentPanePersistenceUtils;
import com.jidesoft.document.FloatingDocumentContainer;
import com.jidesoft.document.FrameFloatingDocumentContainer;
import com.jidesoft.document.IDocumentGroup;
import com.jidesoft.document.IDocumentPane;
import com.jidesoft.document.PopupMenuCustomizer;
import com.jidesoft.document.PreviousState;
import com.jidesoft.document.Resource;
import com.jidesoft.document.TdiDockingManager;
import com.jidesoft.document.TdiGroup;
import com.jidesoft.document.TdiUtils;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.AbstractLayoutPersistence;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class DocumentPane
extends JideSplitPane
implements SwingConstants,
IDocumentPane,
ChangeListener,
PropertyChangeListener {
    private final Map<String, DocumentComponent> _documents = new HashMap<String, DocumentComponent>();
    private final Map<Component, String> _documentNames = new HashMap<Component, String>();
    private final List<String> _documentNamesArray = new ArrayList<String>();
    final List<FloatingDocumentContainer> _floatingContainers = new ArrayList<FloatingDocumentContainer>();
    private Border _groupBorder;
    protected int _tabPlacement = 1;
    private String _activeDocumentName;
    private PopupMenuCustomizer _popupMenuCustomizer;
    private StringConverter _titleConverter;
    private static final StringConverter DEFAULT_TITLE_CONVERTER;
    private boolean _groupsAllowed = true;
    private boolean _reorderAllowed = true;
    private boolean _rearrangeAllowed = true;
    private boolean _floatingAllowed = true;
    private boolean _dragPassUnmovableAllowed = true;
    public static final int TABBED_DOCUMENT_INTERFACE = 1;
    private static final int ENHANCED_SINGLE_DOCUMENT_INTERFACE = 2;
    private TabbedPaneCustomizer _tabbedPaneCustomizer;
    private int _mode = 1;
    private boolean _updateTitle = true;
    private AbstractLayoutPersistence _layoutPersistence = new DocumentPaneLayoutPersistence();
    private TdiDockingManager _dockingManager = new TdiDockingManager(this);
    private PropertyChangeListener _propertyChangeListener;
    private boolean _showContextMenu = true;
    String _focusActiveDocument = null;
    public static final String PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED = "heavyweightComponentEnabled";
    public static final String PROPERTY_MAXIMUM_GROUP_COUNT = "maximumGroupCount";
    private boolean _heavyweightComponentEnabled = false;
    private int _maximumGroupCount = 0;
    private boolean _useGlassPaneEnabled = true;
    private int _floatingContainerCloseAction;
    private DocumentTabColorProvider _tabColorProvider;
    private int _floatingContainerType = 1;
    public static final String PROPERTY_FLOATING_CONTAINER_TYPE = "floatingContainerType";
    public static final String CONTEXT_MENU_CLOSE = "DocumentPane.close";
    public static final String CONTEXT_MENU_CLOSE_OTHERS = "DocumentPane.closeOthers";
    public static final String CONTEXT_MENU_CLOSE_ALL = "DocumentPane.closeAll";
    public static final String CONTEXT_MENU_NEXT = "DocumentPane.next";
    public static final String CONTEXT_MENU_PREVIOUS = "DocumentPane.previous";
    public static final String CONTEXT_MENU_NEW_HORIZONTAL_GROUP = "DocumentPane.newHorizontalGroup";
    public static final String CONTEXT_MENU_NEW_VERTICAL_GROUP = "DocumentPane.newVerticalGroup";
    public static final String CONTEXT_MENU_SPLIT_HORIZONTALLY = "DocumentPane.splitHorizontally";
    public static final String CONTEXT_MENU_SPLIT_VERTICALLY = "DocumentPane.splitVertically";
    public static final String CONTEXT_MENU_MOVE_TO_NEXT = "DocumentPane.moveToNext";
    public static final String CONTEXT_MENU_MOVE_TO_PREVIOUS = "DocumentPane.moveToPrevious";
    public static final String CONTEXT_MENU_MOVE_TO_THIS = "DocumentPane.moveToThis";
    public static final String CONTEXT_MENU_CHANGE_ORIENTATION = "DocumentPane.changeOrientation";
    public static final String CONTEXT_MENU_FLOATING = "DocumentPane.floating";
    public static final String CONTEXT_MENU_DOCKING = "DocumentPane.docking";
    public static final String CONTEXT_MENU_CANCEL = "DocumentPane.cancel";
    private boolean _activateNext = true;
    List<DocumentComponent> _documentComponentList;
    private DocumentComponentFactory _documentComponentFactory;

    public DocumentPane() {
        this.registerKeyStrokes();
    }

    @Override
    public Color getBackground() {
        return UIDefaultsLookup.getColor("Workspace.background");
    }

    @Override
    public void openDocument(DocumentComponent documentComponent) {
        this.openDocument(documentComponent, false);
    }

    public void openDocument(final DocumentComponent documentComponent, final boolean bl) {
        if (documentComponent == null) {
            throw new IllegalArgumentException("The document that passed in is null.");
        }
        if (this._documents.get(documentComponent.getName()) != null) {
            throw new IllegalArgumentException("The document with name \"" + documentComponent.getName() + "\" has been opened. Please specify a new name for this document.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalOpenDocument(documentComponent, bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.internalOpenDocument(documentComponent, bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalOpenDocument(DocumentComponent documentComponent, boolean bl) {
        documentComponent.setDocumentPane(this);
        this.addToMap(documentComponent);
        documentComponent.getComponent().setPreferredSize(new Dimension(200, 200));
        if (bl) {
            IDocumentGroup iDocumentGroup = this.createDocumentGroup();
            this.add((Component)((Object)iDocumentGroup), "flexible");
            iDocumentGroup.addDocument(documentComponent);
            this.floatDocument(documentComponent.getName());
            documentComponent.fireDocumentComponentEvent(5999);
        } else {
            IDocumentGroup iDocumentGroup;
            if (this.getComponentCount() == 0) {
                iDocumentGroup = this.createDocumentGroup();
                this.add((Component)((Object)iDocumentGroup), "flexible");
            } else {
                String string = this.getActiveDocumentName();
                if (string != null && !this.isDocumentFloating(string)) {
                    iDocumentGroup = this.getDocumentGroup(string);
                } else if (this.getPaneCount() > 0) {
                    iDocumentGroup = (IDocumentGroup)((Object)this.getPaneAt(0));
                } else {
                    iDocumentGroup = this.createDocumentGroup();
                    this.add((Component)((Object)iDocumentGroup), "flexible");
                }
                if (iDocumentGroup == null) {
                    Component component = this.getComponent(0);
                    if (component instanceof IDocumentGroup) {
                        iDocumentGroup = (IDocumentGroup)((Object)this.getComponent(0));
                    } else {
                        throw new RuntimeException("Invalid component in DocumentPane. Except TabbedPane, get " + component.getClass().getName());
                    }
                }
            }
            iDocumentGroup.addDocument(documentComponent);
            documentComponent.fireDocumentComponentEvent(5999);
        }
    }

    @Override
    public boolean isDocumentOpened(String string) {
        return this._documents.get(string) != null;
    }

    void addToMap(DocumentComponent documentComponent) {
        this.addToMap(documentComponent, -1);
    }

    private void addToMap(DocumentComponent documentComponent, int n) {
        this._documents.put(documentComponent.getName(), documentComponent);
        this._documentNames.put(documentComponent.getComponent(), documentComponent.getName());
        if (n < 0) {
            this._documentNamesArray.add(documentComponent.getName());
        } else {
            this._documentNamesArray.add(n, documentComponent.getName());
        }
        documentComponent.addPropertyChangeListener(this);
    }

    private void removeFromMap(String string, Component component) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null) {
            documentComponent.removePropertyChangeListener(this);
        }
        this._documents.remove(string);
        if (component != null) {
            this._documentNames.remove(component);
            this._documentNamesArray.remove(string);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        IDocumentGroup iDocumentGroup;
        if ("component".equals(propertyChangeEvent.getPropertyName())) {
            TdiGroup tdiGroup;
            Object object = propertyChangeEvent.getSource();
            if (object instanceof DocumentComponent && (tdiGroup = (TdiGroup)TdiUtils.getGroupOf((Component)propertyChangeEvent.getOldValue(), this)) != null) {
                DocumentComponent documentComponent = (DocumentComponent)object;
                tdiGroup.updateComponent(documentComponent, (Component)propertyChangeEvent.getOldValue());
                this.removeFromMap(documentComponent.getName(), (Component)propertyChangeEvent.getOldValue());
                this.addToMap(documentComponent);
            }
        } else if ("title".equals(propertyChangeEvent.getPropertyName()) || "tooltip".equals(propertyChangeEvent.getPropertyName()) || "background".equals(propertyChangeEvent.getPropertyName()) || "foreground".equals(propertyChangeEvent.getPropertyName()) || "icon".equals(propertyChangeEvent.getPropertyName())) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof DocumentComponent) {
                String string = ((DocumentComponent)object).getName();
                this.updateDocument(string);
            }
        } else if ("icon".equals(propertyChangeEvent.getPropertyName())) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof DocumentComponent) {
                String string = ((DocumentComponent)object).getName();
                this.updateDocument(string);
            }
        } else if ("closable".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof DocumentComponent && (iDocumentGroup = this.getDocumentGroup(((DocumentComponent)propertyChangeEvent.getSource()).getName())) instanceof JideTabbedPane) {
            ((JideTabbedPane)((Object)iDocumentGroup)).updateUI();
        }
    }

    @Override
    public void activateGroup(IDocumentGroup iDocumentGroup) {
        String string = this.getActiveDocumentName();
        IDocumentGroup iDocumentGroup2 = this.getDocumentGroup(string);
        if (iDocumentGroup != null && iDocumentGroup.equals(iDocumentGroup2)) {
            if (UIDefaultsLookup.getBoolean("DocumentPane.boldActiveTab")) {
                if (iDocumentGroup2 instanceof JideTabbedPane) {
                    ((JideTabbedPane)((Object)iDocumentGroup2)).setBoldActiveTab(true);
                }
                for (int i = 0; i < this.getDocumentGroupCount(); ++i) {
                    IDocumentGroup iDocumentGroup3 = this.getDocumentGroupAt(i);
                    if (iDocumentGroup3 == iDocumentGroup2 || !(iDocumentGroup3 instanceof JideTabbedPane)) continue;
                    ((JideTabbedPane)((Object)iDocumentGroup3)).setBoldActiveTab(false);
                }
            }
            if (this._activeDocumentName != null && this.getDocument(this._activeDocumentName) != null && iDocumentGroup.getDocumentCount() > 0) {
                iDocumentGroup.setSelectedDocument(this.getDocument(this._activeDocumentName).getComponent());
            }
            return;
        }
        if (UIDefaultsLookup.getBoolean("DocumentPane.boldActiveTab") && iDocumentGroup2 instanceof JideTabbedPane) {
            ((JideTabbedPane)((Object)iDocumentGroup2)).setBoldActiveTab(false);
        }
        if (iDocumentGroup != null) {
            this.setActiveDocument(this.getNameOf(iDocumentGroup.getSelectedDocument()));
            if (UIDefaultsLookup.getBoolean("DocumentPane.boldActiveTab") && iDocumentGroup instanceof JideTabbedPane) {
                ((JideTabbedPane)((Object)iDocumentGroup)).setBoldActiveTab(true);
            }
        }
    }

    protected IDocumentGroup createDocumentGroup() {
        switch (this._mode) {
            case 2: {
                return null;
            }
        }
        final TdiGroup tdiGroup = this.createTdiGroup();
        tdiGroup.setTabPlacement(this.getTabPlacement());
        tdiGroup.setBorder(this._groupBorder);
        tdiGroup.setCloseAction(new AbstractAction(){
            private static final long serialVersionUID = -730159551624518149L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof Component) {
                    DocumentPane.this.closeSingleDocument(DocumentPane.this.getNameOf((Component)actionEvent.getSource()));
                } else {
                    DocumentPane.this.closeSingleDocument(DocumentPane.this.getNameOf(tdiGroup.getSelectedDocument()));
                }
            }
        });
        tdiGroup.setShowTabButtons(true);
        tdiGroup.setShowIconsOnTab(true);
        tdiGroup.setUseDefaultShowIconsOnTab(false);
        tdiGroup.setUseDefaultShowCloseButtonOnTab(true);
        tdiGroup.getModel().addChangeListener(this);
        tdiGroup.setStringConverter(this.getTitleConverter());
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() instanceof Integer && propertyChangeEvent.getSource() instanceof JideTabbedPane) {
                        int n = (Integer)propertyChangeEvent.getNewValue();
                        String string = ((JideTabbedPane)propertyChangeEvent.getSource()).getTitleAt(n);
                        String string2 = DocumentPane.this.getNameOf(((JideTabbedPane)propertyChangeEvent.getSource()).getComponentAt(n));
                        DocumentComponent documentComponent = DocumentPane.this.getDocument(string2);
                        if (documentComponent != null) {
                            documentComponent.setTitle(string);
                        }
                    }
                }
            };
        }
        tdiGroup.addPropertyChangeListener("indexForTitle", this._propertyChangeListener);
        if (this._tabbedPaneCustomizer != null) {
            this._tabbedPaneCustomizer.customize(tdiGroup);
        }
        return tdiGroup;
    }

    @Override
    public IDocumentGroup getDocumentGroup(String string) {
        IDocumentGroup iDocumentGroup;
        DocumentComponent documentComponent;
        if (string != null && (documentComponent = this.getDocument(string)) != null && (iDocumentGroup = (IDocumentGroup)((Object)SwingUtilities.getAncestorOfClass(IDocumentGroup.class, documentComponent.getComponent()))) != null) {
            return iDocumentGroup;
        }
        return null;
    }

    protected TdiGroup createTdiGroup() {
        return new TdiGroup();
    }

    @Override
    public void closeDocument(String string) {
        this.closeDocument(string, false);
    }

    private void closeDocument(final String string, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalCloseDocument(string, this._activateNext, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentPane.this.internalCloseDocument(string, DocumentPane.this._activateNext, bl);
                }
            });
        }
    }

    private void internalCloseDocument(String string, boolean bl, boolean bl2) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            return;
        }
        if (!documentComponent.isClosable() && !bl2) {
            return;
        }
        documentComponent.setAllowClosing(true);
        documentComponent.fireDocumentComponentEvent(6000);
        if (documentComponent.allowClosing()) {
            JComponent jComponent = documentComponent.getComponent();
            int n = this.getDocumentGroupCount();
            for (int i = 0; i < n; ++i) {
                IDocumentGroup iDocumentGroup = this.getDocumentGroupAt(i);
                for (int j = 0; j < iDocumentGroup.getDocumentCount(); ++j) {
                    Component component = iDocumentGroup.getDocumentAt(j);
                    if (!component.equals(jComponent)) continue;
                    this.closeDocument(iDocumentGroup, j, string, jComponent, documentComponent, bl);
                    return;
                }
            }
        }
    }

    private void closeDocument(final IDocumentGroup iDocumentGroup, final int n, final String string, final Component component, final DocumentComponent documentComponent, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalCloseDocument(documentComponent, iDocumentGroup, n, string, component, bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.internalCloseDocument(documentComponent, iDocumentGroup, n, string, component, bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
        documentComponent.fireDocumentComponentEvent(6001);
    }

    private void internalCloseDocument(DocumentComponent documentComponent, IDocumentGroup iDocumentGroup, int n, String string, Component component, boolean bl) {
        if (documentComponent == null || iDocumentGroup == null) {
            return;
        }
        DocumentComponent documentComponent2 = this.getActiveDocument();
        if (documentComponent2 != null && documentComponent2.equals(documentComponent)) {
            this.setActiveDocument(null, false);
        }
        documentComponent.cleanup();
        iDocumentGroup.removeDocument(n);
        this.removeIfEmpty(iDocumentGroup);
        this.removeFromMap(string, component);
        if (bl) {
            this.activateNextDocument(iDocumentGroup);
        }
        this.repaint();
    }

    private void activateNextDocument(IDocumentGroup iDocumentGroup) {
        if (iDocumentGroup != null && iDocumentGroup.getDocumentCount() > 0) {
            this.internalSetActiveDocument(this.getNameOf(iDocumentGroup.getSelectedDocument()), true);
        } else if (this.getDocumentGroupCount() > 0) {
            this.activateGroup(this.getDocumentGroupAt(0));
        } else {
            this._activeDocumentName = null;
        }
    }

    @Override
    public void closeSingleDocument(String string) {
        this.closeDocument(string);
    }

    @Override
    public void closeAll() {
        this.closeAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(boolean bl) {
        Set<String> set = this._documents.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        this._activateNext = false;
        this._focusActiveDocument = null;
        try {
            for (String string : stringArray) {
                if (bl) {
                    this.closeDocument(string, bl);
                    continue;
                }
                this.closeDocument(string);
            }
        }
        finally {
            this._activateNext = true;
        }
    }

    @Override
    public void closeAllButThis(String string) {
        String[] stringArray;
        Set<String> set = this._documents.keySet();
        for (String string2 : stringArray = set.toArray(new String[set.size()])) {
            if (string.equals(string2)) continue;
            this.closeDocument(string2);
        }
    }

    @Override
    public void setActiveDocument(String string) {
        this.setActiveDocument(string, true);
    }

    @Override
    public void setActiveDocument(final String string, final boolean bl) {
        if (string != null && string.equals(this._activeDocumentName) && !bl) {
            return;
        }
        if (bl) {
            this._focusActiveDocument = string;
        }
        if (string != null && !this.isDocumentOpened(string)) {
            throw new IllegalArgumentException("Document \"" + string + "\" is not opened.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalSetActiveDocument(string, bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.internalSetActiveDocument(string, bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalSetActiveDocument(String string, boolean bl) {
        if (!JideSwingUtilities.equals(this._activeDocumentName, string)) {
            DocumentComponent documentComponent = this.getActiveDocument();
            TdiGroup tdiGroup = null;
            if (documentComponent != null) {
                tdiGroup = (TdiGroup)TdiUtils.getGroupOf(documentComponent.getComponent(), this);
                documentComponent.fireDocumentComponentEvent(6003);
            }
            this._activeDocumentName = string;
            DocumentComponent documentComponent2 = this.getActiveDocument();
            IDocumentGroup iDocumentGroup = null;
            if (documentComponent2 != null) {
                documentComponent2.fireDocumentComponentEvent(6002);
                iDocumentGroup = (IDocumentGroup)((Object)TdiUtils.getGroupOf(documentComponent2.getComponent(), this));
            }
            if (tdiGroup != null && this.isUpdateTitle()) {
                tdiGroup.updateTitle(documentComponent);
            }
            if (iDocumentGroup != null) {
                iDocumentGroup.setSelectedDocument(documentComponent2.getComponent());
                this.activateGroup(iDocumentGroup);
                if (this.isUpdateTitle()) {
                    iDocumentGroup.updateTitle(documentComponent2);
                }
            } else {
                this.activateGroup(null);
            }
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentPane.this.requestFocusForActiveDocument();
                }
            });
        }
    }

    protected void requestFocusForActiveDocument() {
        DocumentComponent documentComponent = this.getActiveDocument();
        if (documentComponent != null) {
            IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)TdiUtils.getGroupOf(documentComponent.getComponent(), this));
            if (documentComponent.getLastFocusedComponent() != null || documentComponent.getDefaultFocusComponent() != null) {
                documentComponent.refocusLastFocusedComponent();
            } else if (iDocumentGroup instanceof TdiGroup && ((TdiGroup)iDocumentGroup).getLastFocusedComponent(iDocumentGroup.getSelectedDocument()) == null) {
                ((TdiGroup)iDocumentGroup).requestFocus();
            } else {
                documentComponent.refocusLastFocusedComponent();
            }
        }
    }

    @Override
    public DocumentComponent getActiveDocument() {
        return this.getDocument(this.getActiveDocumentName());
    }

    @Override
    public String getActiveDocumentName() {
        return this._activeDocumentName;
    }

    @Override
    public void nextDocument() {
        if (this._activeDocumentName != null) {
            DocumentComponent documentComponent = this.getDocument(this._activeDocumentName);
            IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)TdiUtils.getGroupOf(documentComponent.getComponent(), this));
            if (iDocumentGroup.getDocumentCount() > 1 && iDocumentGroup.indexOfDocument(documentComponent.getComponent()) < iDocumentGroup.getDocumentCount() - 1) {
                Component component = iDocumentGroup.getDocumentAt(iDocumentGroup.indexOfDocument(documentComponent.getComponent()) + 1);
                iDocumentGroup.setSelectedDocument(component);
                this.setActiveDocument(this.getNameOf(component));
            } else if (this.getDocumentGroupCount() > 1 && this.indexOfDocumentGroup(iDocumentGroup) < this.getDocumentGroupCount() - 1) {
                IDocumentGroup iDocumentGroup2 = this.getDocumentGroupAt(this.indexOfPane((Component)((Object)iDocumentGroup)) + 1);
                Component component = iDocumentGroup2.getDocumentAt(0);
                iDocumentGroup2.setSelectedDocument(component);
                this.setActiveDocument(this.getNameOf(component));
            } else {
                IDocumentGroup iDocumentGroup3 = this.getDocumentGroupAt(0);
                if (iDocumentGroup3 != null) {
                    Component component = iDocumentGroup3.getDocumentAt(0);
                    iDocumentGroup3.setSelectedDocument(component);
                    this.setActiveDocument(this.getNameOf(component));
                }
            }
        }
    }

    @Override
    public void prevDocument() {
        if (this._activeDocumentName != null) {
            DocumentComponent documentComponent = this.getDocument(this._activeDocumentName);
            IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)TdiUtils.getGroupOf(documentComponent.getComponent(), this));
            if (iDocumentGroup.getDocumentCount() > 1 && iDocumentGroup.indexOfDocument(documentComponent.getComponent()) > 0) {
                Component component = iDocumentGroup.getDocumentAt(iDocumentGroup.indexOfDocument(documentComponent.getComponent()) - 1);
                iDocumentGroup.setSelectedDocument(component);
                this.setActiveDocument(this.getNameOf(component));
            } else if (this.getDocumentGroupCount() > 1 && this.indexOfDocumentGroup(iDocumentGroup) > 0) {
                IDocumentGroup iDocumentGroup2 = this.getDocumentGroupAt(this.indexOfDocumentGroup(iDocumentGroup) - 1);
                Component component = iDocumentGroup2.getDocumentAt(iDocumentGroup2.getDocumentCount() - 1);
                iDocumentGroup2.setSelectedDocument(component);
                this.setActiveDocument(this.getNameOf(component));
            } else {
                IDocumentGroup iDocumentGroup3 = this.getDocumentGroupAt(this.getDocumentGroupCount() - 1);
                if (iDocumentGroup3 != null) {
                    Component component = iDocumentGroup3.getDocumentAt(iDocumentGroup3.getDocumentCount() - 1);
                    iDocumentGroup3.setSelectedDocument(component);
                    this.setActiveDocument(this.getNameOf(component));
                }
            }
        }
    }

    public String getNextDocument(String string) {
        if (string != null) {
            DocumentComponent documentComponent = this.getDocument(string);
            IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)TdiUtils.getGroupOf(documentComponent.getComponent(), this));
            if (iDocumentGroup.getDocumentCount() > 1 && iDocumentGroup.indexOfDocument(documentComponent.getComponent()) < iDocumentGroup.getDocumentCount() - 1) {
                Component component = iDocumentGroup.getDocumentAt(iDocumentGroup.indexOfDocument(documentComponent.getComponent()) + 1);
                return this.getNameOf(component);
            }
            if (this.getPaneCount() > 1 && this.indexOfPane((Component)((Object)iDocumentGroup)) >= 0 && this.indexOfPane((Component)((Object)iDocumentGroup)) < this.getPaneCount() - 1) {
                IDocumentGroup iDocumentGroup2 = (IDocumentGroup)((Object)this.getPaneAt(this.indexOfPane((Component)((Object)iDocumentGroup)) + 1));
                Component component = iDocumentGroup2.getDocumentAt(0);
                return this.getNameOf(component);
            }
        } else if (this.getDocumentGroupCount() > 0 && this.getDocumentGroupAt(0) != null && this.getDocumentGroupAt(0).getDocumentCount() > 0) {
            return this.getNameOf(this.getDocumentGroupAt(0).getDocumentAt(0));
        }
        return null;
    }

    public String getPreviousDocument(String string) {
        if (string != null) {
            DocumentComponent documentComponent = this.getDocument(string);
            IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)TdiUtils.getGroupOf(documentComponent.getComponent(), this));
            if (iDocumentGroup.getDocumentCount() > 1 && iDocumentGroup.indexOfDocument(documentComponent.getComponent()) > 0) {
                Component component = iDocumentGroup.getDocumentAt(iDocumentGroup.indexOfDocument(documentComponent.getComponent()) - 1);
                return this.getNameOf(component);
            }
            if (this.getPaneCount() > 1 && this.indexOfPane((Component)((Object)iDocumentGroup)) > 0) {
                IDocumentGroup iDocumentGroup2 = (IDocumentGroup)((Object)this.getPaneAt(this.indexOfPane((Component)((Object)iDocumentGroup)) - 1));
                Component component = iDocumentGroup2.getDocumentAt(iDocumentGroup2.getDocumentCount() - 1);
                return this.getNameOf(component);
            }
        } else if (this.getDocumentGroupCount() > 0 && this.getDocumentGroupAt(this.getDocumentGroupCount() - 1) != null && this.getDocumentGroupAt(this.getDocumentGroupCount() - 1).getDocumentCount() > 0) {
            IDocumentGroup iDocumentGroup = this.getDocumentGroupAt(this.getDocumentGroupCount() - 1);
            return this.getNameOf(iDocumentGroup.getDocumentAt(iDocumentGroup.getDocumentCount() - 1));
        }
        return null;
    }

    @Override
    public void moveDocument(String string, int n) {
        this.moveDocument(string, n, -1);
    }

    @Override
    public void moveDocument(String string, final int n, final int n2) {
        if (n != 0 && !this.isGroupsAllowed()) {
            return;
        }
        if (n < 0 || n >= this.getPaneCount()) {
            throw new IllegalArgumentException("Group index out of bound " + n + " " + this.getComponentCount());
        }
        final DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            throw new IllegalArgumentException("Document with name \"" + string + "\" doesn't exist. Call openDocument first to open it first.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalMoveDocument(documentComponent, n, n2);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.internalMoveDocument(documentComponent, n, n2);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalMoveDocument(DocumentComponent documentComponent, int n, int n2) {
        IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)TdiUtils.getGroupOf(documentComponent.getComponent(), this));
        if (n < 0) {
            n = 0;
        }
        if (n > this.getDocumentGroupCount()) {
            n = this.getDocumentGroupCount() - 1;
        }
        IDocumentGroup iDocumentGroup2 = (IDocumentGroup)((Object)this.getPaneAt(n));
        documentComponent.fireDocumentComponentEvent(6004);
        if (documentComponent.allowMoving()) {
            if (!iDocumentGroup.equals(iDocumentGroup2)) {
                iDocumentGroup.removeDocument(documentComponent);
                iDocumentGroup2.addDocument(documentComponent);
                this.removeIfEmpty(iDocumentGroup);
            }
            iDocumentGroup2.setSelectedDocument(documentComponent.getComponent());
            if (n2 != -1) {
                iDocumentGroup2.moveSelectedDocumentTo(n2);
            }
            this.internalSetActiveDocument(documentComponent.getName(), true);
            documentComponent.fireDocumentComponentEvent(6005);
        }
    }

    private void removeIfEmpty(IDocumentGroup iDocumentGroup) {
        Container container;
        if (this.isDocumentGroupEmpty(iDocumentGroup) && (container = ((Component)((Object)iDocumentGroup)).getParent()) != null) {
            JideSwingUtilities.removeFromParentWithFocusTransfer((Component)((Object)iDocumentGroup));
            if (iDocumentGroup instanceof TdiGroup) {
                ((TdiGroup)iDocumentGroup).uninstallListeners();
            }
        }
    }

    protected boolean isDocumentGroupEmpty(IDocumentGroup iDocumentGroup) {
        return iDocumentGroup.getDocumentCount() == 0;
    }

    @Override
    public void newDocumentGroup(final String string, final int n, final int n2) {
        if (!this.isGroupsAllowed()) {
            return;
        }
        if (!this.isMoreDocumentGroupAllowed()) {
            return;
        }
        if (string == null) {
            return;
        }
        final DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalNewDocumentGroup(documentComponent, n, n2);
            this.activateGroup(this.getDocumentGroup(string));
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.internalNewDocumentGroup(documentComponent, n, n2);
                        DocumentPane.this.activateGroup(DocumentPane.this.getDocumentGroup(string));
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalNewDocumentGroup(DocumentComponent documentComponent, int n, int n2) {
        if (this.isMoreDocumentGroupAllowed()) {
            documentComponent.fireDocumentComponentEvent(6004);
            if (documentComponent.allowMoving()) {
                if (n2 != this.getOrientation()) {
                    this.setOrientation(n2);
                }
                IDocumentGroup iDocumentGroup = this.createDocumentGroup();
                IDocumentGroup iDocumentGroup2 = (IDocumentGroup)((Object)TdiUtils.getGroupOf(documentComponent.getComponent(), this));
                iDocumentGroup2.removeDocument(documentComponent);
                if (n < 0) {
                    n = 0;
                }
                if (n > this.getDocumentGroupCount()) {
                    n = this.getDocumentGroupCount();
                }
                if (n * 2 > this.getComponentCount()) {
                    this.add((Component)((Object)iDocumentGroup), "flexible");
                } else {
                    this.add((Component)((Object)iDocumentGroup), "flexible", n * 2);
                }
                iDocumentGroup.addDocument(documentComponent);
                this.remove((Component)((Object)iDocumentGroup));
                if (n * 2 > this.getComponentCount()) {
                    this.add((Component)((Object)iDocumentGroup), "flexible");
                } else {
                    this.add((Component)((Object)iDocumentGroup), "flexible", n * 2);
                }
                this.removeIfEmpty(iDocumentGroup2);
                documentComponent.fireDocumentComponentEvent(6005);
            }
        }
    }

    protected boolean isMoreDocumentGroupAllowed() {
        return this.getMaximumGroupCount() <= 0 || this.getDocumentGroupCount() < this.getMaximumGroupCount();
    }

    @Override
    public String getNameOf(Component component) {
        if (component == null) {
            return null;
        }
        return this._documentNames.get(component);
    }

    @Override
    public DocumentComponent getDocument(String string) {
        return this._documents.get(string);
    }

    @Override
    public DocumentComponent getDocumentAt(int n) {
        String string = this.getDocumentNameAt(n);
        return this.getDocument(string);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        String string = this.getActiveDocumentName();
        IDocumentGroup iDocumentGroup = this.getDocumentGroup(string);
        if (iDocumentGroup instanceof JideTabbedPane && ((JideTabbedPane)((Object)iDocumentGroup)).getModel() == changeEvent.getSource()) {
            Component component = iDocumentGroup.getSelectedDocument();
            if (component != null) {
                String string2 = this.getNameOf(component);
                this.setActiveDocument(string2, false);
            } else {
                this.setActiveDocument(null);
            }
        }
    }

    public final void customizePopupMenu(JPopupMenu jPopupMenu, String string, IDocumentGroup iDocumentGroup, boolean bl) {
        PopupMenuCustomizer popupMenuCustomizer = this.getPopupMenuCustomizer();
        if (popupMenuCustomizer != null) {
            popupMenuCustomizer.customizePopupMenu(jPopupMenu, this, string, iDocumentGroup, bl);
        }
    }

    @Override
    public StringConverter getTitleConverter() {
        if (this._titleConverter != null) {
            return this._titleConverter;
        }
        return DEFAULT_TITLE_CONVERTER;
    }

    @Override
    public void setTitleConverter(StringConverter stringConverter) {
        this._titleConverter = stringConverter;
    }

    @Override
    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this._popupMenuCustomizer;
    }

    @Override
    public void setPopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this._popupMenuCustomizer = popupMenuCustomizer;
    }

    @Override
    public boolean isGroupsAllowed() {
        return this._groupsAllowed;
    }

    @Override
    public void setGroupsAllowed(boolean bl) {
        this._groupsAllowed = bl;
    }

    @Override
    public boolean isReorderAllowed() {
        return this._reorderAllowed;
    }

    @Override
    public void setReorderAllowed(boolean bl) {
        this._reorderAllowed = bl;
    }

    public boolean isRearrangeAllowed() {
        return this._rearrangeAllowed;
    }

    public void setRearrangeAllowed(boolean bl) {
        this._rearrangeAllowed = bl;
    }

    public boolean isFloatingAllowed() {
        return this._floatingAllowed;
    }

    public void setFloatingAllowed(boolean bl) {
        this._floatingAllowed = bl;
    }

    @Override
    public int getDocumentCount() {
        return this._documentNamesArray.size();
    }

    @Override
    public String getDocumentNameAt(int n) {
        if (n < 0 || n > this.getDocumentCount() - 1) {
            throw new IllegalArgumentException("Index out of bound.");
        }
        return this._documentNamesArray.get(n);
    }

    @Override
    public String[] getDocumentNames() {
        return this._documentNamesArray.toArray(new String[this._documentNamesArray.size()]);
    }

    @Override
    public int indexOfDocument(String string) {
        JComponent jComponent;
        IDocumentGroup iDocumentGroup;
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null && (iDocumentGroup = (IDocumentGroup)((Object)TdiUtils.getGroupOf(jComponent = documentComponent.getComponent(), this))) != null) {
            return iDocumentGroup.indexOfDocument(jComponent);
        }
        return -1;
    }

    int globalIndexOfDocument(String string) {
        if (string != null) {
            for (int i = 0; i < this.getDocumentCount(); ++i) {
                if (!string.equals(this.getDocumentAt(i).getName())) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int groupIndexOfDocument(String string) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null) {
            JComponent jComponent = this.getDocument(string).getComponent();
            TdiGroup tdiGroup = (TdiGroup)TdiUtils.getGroupOf(jComponent, this);
            return this.indexOfDocumentGroup(tdiGroup);
        }
        return -1;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this._groupBorder = UIDefaultsLookup.getBorder("DocumentPane.groupBorder") != null ? UIDefaultsLookup.getBorder("DocumentPane.groupBorder") : BorderFactory.createLineBorder(Color.gray);
        for (int i = 0; i < this.getPaneCount(); ++i) {
            JComponent jComponent = (JComponent)this.getPaneAt(i);
            jComponent.setBorder(this._groupBorder);
        }
        if (this.getActiveDocumentName() != null) {
            this.updateDocument(this.getActiveDocumentName());
        }
    }

    public int getTabPlacement() {
        return this._tabPlacement;
    }

    public void setTabPlacement(int n) {
        if (n != 1 && n != 3 && n != 2 && n != 4) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT or RIGHT.");
        }
        if (this._tabPlacement != n) {
            int n2 = this._tabPlacement;
            this._tabPlacement = n;
            for (int i = 0; i < this.getPaneCount(); ++i) {
                JComponent jComponent = (JComponent)this.getPaneAt(i);
                if (!(jComponent instanceof JideTabbedPane)) continue;
                ((JideTabbedPane)jComponent).setTabPlacement(this._tabPlacement);
            }
            this.firePropertyChange("tabPlacement", n2, n);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isDragPassUnmovableAllowed() {
        return this._dragPassUnmovableAllowed;
    }

    public void setDragPassUnmovableAllowed(boolean bl) {
        this._dragPassUnmovableAllowed = bl;
    }

    public DocumentTabColorProvider getTabColorProvider() {
        return this._tabColorProvider;
    }

    public void setTabColorProvider(DocumentTabColorProvider documentTabColorProvider) {
        this._tabColorProvider = documentTabColorProvider;
    }

    public TabbedPaneCustomizer getTabbedPaneCustomizer() {
        return this._tabbedPaneCustomizer;
    }

    public void setTabbedPaneCustomizer(TabbedPaneCustomizer tabbedPaneCustomizer) {
        this._tabbedPaneCustomizer = tabbedPaneCustomizer;
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalSetTabbedPaneCustomizer();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.internalSetTabbedPaneCustomizer();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalSetTabbedPaneCustomizer() {
        JideSwingUtilities.setRecursively(this, new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component component) {
                return component instanceof TdiGroup;
            }

            @Override
            public void action(Component component) {
                DocumentPane.this._tabbedPaneCustomizer.customize((TdiGroup)component);
            }

            @Override
            public void postAction(Component component) {
            }
        });
        this.validate();
        this.repaint();
    }

    @Override
    public void updateDocument(String string) {
        TdiGroup tdiGroup;
        final DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null && (tdiGroup = (TdiGroup)TdiUtils.getGroupOf(documentComponent.getComponent(), this)) != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.internalUpdateDocument(tdiGroup, documentComponent);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DocumentPane.this.internalUpdateDocument(tdiGroup, documentComponent);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
                }
            }
        }
    }

    private void internalUpdateDocument(IDocumentGroup iDocumentGroup, DocumentComponent documentComponent) {
        iDocumentGroup.updateTitle(documentComponent);
    }

    @Override
    public void renameDocument(String string, String string2) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            throw new IllegalArgumentException("Document \"" + string + "\" is not opened.");
        }
        int n = this._documentNamesArray.indexOf(string);
        this.removeFromMap(string, documentComponent.getComponent());
        documentComponent.setName(string2);
        this.addToMap(documentComponent, n);
        if (this.getActiveDocumentName() != null && this.getActiveDocumentName().equals(string)) {
            this._activeDocumentName = string2;
        }
    }

    private void registerKeyStrokes() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        AbstractAction abstractAction = new AbstractAction("nextDocument"){
            private static final long serialVersionUID = 8776435163544111997L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DocumentPane.this.nextDocument();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction("prevDocument"){
            private static final long serialVersionUID = 1011492280119136975L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DocumentPane.this.prevDocument();
            }
        };
        Object object = abstractAction2.getValue("Name");
        inputMap.put(KeyStroke.getKeyStroke(37, 512), object);
        actionMap.put(object, abstractAction2);
        Object object2 = abstractAction.getValue("Name");
        inputMap.put(KeyStroke.getKeyStroke(39, 512), object2);
        actionMap.put(object2, abstractAction);
    }

    @Override
    public boolean isFocusCycleRoot() {
        return true;
    }

    public boolean isUpdateTitle() {
        return this._updateTitle;
    }

    public void setUpdateTitle(boolean bl) {
        this._updateTitle = bl;
    }

    public int getDocumentGroupIndexAt(Point point) {
        Component component = SwingUtilities.getDeepestComponentAt(this, point.x, point.y);
        if ((component = TdiUtils.getGroupOf(component, this)) == null) {
            return -1;
        }
        return this.indexOfPane(component);
    }

    @Override
    public int getDocumentGroupCount() {
        return this.getPaneCount() + this._floatingContainers.size();
    }

    @Override
    public IDocumentGroup getDocumentGroupAt(int n) {
        int n2 = this.getPaneCount();
        if (n < n2) {
            return (IDocumentGroup)((Object)this.getPaneAt(n));
        }
        return this._floatingContainers.get(n - n2).getDocumentGroup();
    }

    public int indexOfDocumentGroup(IDocumentGroup iDocumentGroup) {
        int n = this.getDocumentGroupCount();
        for (int i = 0; i < n; ++i) {
            IDocumentGroup iDocumentGroup2 = this.getDocumentGroupAt(i);
            if (iDocumentGroup2 != iDocumentGroup) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getSelectedIndexAtGroupIndex(int n) {
        if (n >= 0 && n < this.getDocumentGroupCount()) {
            IDocumentGroup iDocumentGroup = this.getDocumentGroupAt(n);
            if (iDocumentGroup != null) {
                return iDocumentGroup.getSelectedIndex();
            }
            return -1;
        }
        throw new IndexOutOfBoundsException(n + " is outside the range [0, " + (this.getDocumentGroupCount() - 1) + "].");
    }

    @Override
    public void setOpenedDocuments(List<DocumentComponent> list) {
        this._documentComponentList = new ArrayList<DocumentComponent>();
        for (DocumentComponent documentComponent : list) {
            this._documentComponentList.add(documentComponent);
        }
    }

    void clearOpenedDocuments() {
        if (this._documentComponentList != null) {
            this._documentComponentList.clear();
            this._documentComponentList = null;
        }
    }

    DocumentComponent findDocumentComponent(String string) {
        for (DocumentComponent documentComponent : this._documentComponentList) {
            if (documentComponent == null || !documentComponent.getName().equals(string)) continue;
            return documentComponent;
        }
        return null;
    }

    @Override
    public void setDocumentEnabled(String string, boolean bl) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            return;
        }
        JComponent jComponent = documentComponent.getComponent();
        for (int i = 0; i < this.getDocumentGroupCount(); ++i) {
            IDocumentGroup iDocumentGroup = this.getDocumentGroupAt(i);
            if (!(iDocumentGroup instanceof JideTabbedPane)) continue;
            for (int j = 0; j < iDocumentGroup.getDocumentCount(); ++j) {
                Component component = iDocumentGroup.getDocumentAt(j);
                if (!component.equals(jComponent)) continue;
                if (((JideTabbedPane)((Object)iDocumentGroup)).isEnabledAt(j) != bl) {
                    ((JideTabbedPane)((Object)iDocumentGroup)).setEnabledAt(j, bl);
                    documentComponent.firePropertyChange("enabled", !bl, bl);
                }
                return;
            }
        }
    }

    public DocumentComponentFactory getDocumentComponentFactory() {
        return this._documentComponentFactory;
    }

    public void setDocumentComponentFactory(DocumentComponentFactory documentComponentFactory) {
        this._documentComponentFactory = documentComponentFactory;
    }

    @Override
    public LayoutPersistence getLayoutPersistence() {
        return this._layoutPersistence;
    }

    static String readString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n > 0x100000) {
            throw new IOException("The layout is corrupted. Please remove it and try again.");
        }
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = dataInputStream.readChar();
        }
        return new String(cArray);
    }

    static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(string.length());
            for (int i = 0; i < string.length(); ++i) {
                dataOutputStream.writeChar(string.charAt(i));
            }
        }
    }

    @Override
    public void dispose() {
        this._dockingManager.dispose();
        this._dockingManager = null;
    }

    TdiDockingManager getTdiDockingManager() {
        return this._dockingManager;
    }

    public boolean isShowContextMenu() {
        return this._showContextMenu;
    }

    public void setShowContextMenu(boolean bl) {
        this._showContextMenu = bl;
    }

    @Override
    protected JideSplitPaneDivider createSplitPaneDivider() {
        JideSplitPaneDivider jideSplitPaneDivider = super.createSplitPaneDivider();
        jideSplitPaneDivider.setOpaque(true);
        return jideSplitPaneDivider;
    }

    @Override
    public boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    @Override
    public void setHeavyweightComponentEnabled(boolean bl) {
        boolean bl2 = this._heavyweightComponentEnabled;
        if (this._heavyweightComponentEnabled != bl) {
            this._heavyweightComponentEnabled = bl;
            this.firePropertyChange(PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED, bl2, this._heavyweightComponentEnabled);
        }
        if (this.isHeavyweightComponentEnabled()) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        }
    }

    public int getMaximumGroupCount() {
        return this._maximumGroupCount;
    }

    public void setMaximumGroupCount(int n) {
        int n2 = this._maximumGroupCount;
        if (n2 != n) {
            this._maximumGroupCount = n;
            this.firePropertyChange(PROPERTY_MAXIMUM_GROUP_COUNT, new Integer(n2), new Integer(n));
        }
    }

    protected int getNextAvailableIndex(String string) {
        int n = 2;
        while (this.isDocumentOpened(string + ":" + n)) {
            ++n;
        }
        return n;
    }

    public void splitDocument(String string, int n, int n2) {
        DocumentComponent documentComponent;
        if (this.isMoreDocumentGroupAllowed() && (documentComponent = this.getDocument(string)) instanceof CloneableDocumentComponent) {
            try {
                Object object = ((CloneableDocumentComponent)((Object)documentComponent)).clone();
                if (object instanceof DocumentComponent) {
                    DocumentComponent documentComponent2 = (DocumentComponent)object;
                    documentComponent2.setName(documentComponent.getName() + ":" + this.getNextAvailableIndex(documentComponent.getName()));
                    this.openDocument(documentComponent2);
                    this.newDocumentGroup(documentComponent2.getName(), n, n2);
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    public boolean isUseGlassPaneEnabled() {
        return this._useGlassPaneEnabled;
    }

    public void setUseGlassPaneEnabled(boolean bl) {
        this._useGlassPaneEnabled = bl;
    }

    public void populateContextMenu(JPopupMenu jPopupMenu) {
        if (this.getActiveDocument() != null) {
            this.populateContextMenu(jPopupMenu, this.getActiveDocument().getComponent(), null, null, true);
        }
    }

    protected void populateContextMenu(JPopupMenu jPopupMenu, Component component, TdiGroup tdiGroup, TdiGroup tdiGroup2, boolean bl) {
        Object object;
        Object object2;
        String string;
        if (bl) {
            if (tdiGroup2 == null) {
                tdiGroup2 = (TdiGroup)TdiUtils.getGroupOf(component, this);
            }
            tdiGroup = tdiGroup2;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (this.isMoreDocumentGroupAllowed()) {
            if (this.getComponentCount() == 1) {
                bl2 = true;
                bl3 = true;
                bl4 = true;
                bl5 = true;
            } else if (this.getOrientation() == 0) {
                bl2 = true;
                bl4 = true;
            } else {
                bl3 = true;
                bl5 = true;
            }
        }
        if (tdiGroup.getTabCount() == 1) {
            bl3 = false;
            bl2 = false;
        }
        if ((string = this.getNameOf(component)) == null) {
            return;
        }
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent == null) {
            return;
        }
        if (bl) {
            String string2;
            JMenuItem jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_CLOSE));
            jMenuItem.setName(CONTEXT_MENU_CLOSE);
            jMenuItem.setMnemonic(this.getResourceString("DocumentPane.close.mnemonic").charAt(0));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DocumentPane.this.closeSingleDocument(string);
                }
            });
            jMenuItem.setEnabled(documentComponent.isClosable());
            jPopupMenu.add(jMenuItem);
            if (!this.isDocumentFloating(string) && this.getDocumentCount() > 1) {
                boolean bl6 = false;
                boolean bl7 = false;
                for (int i = 0; !(i >= this.getDocumentCount() || bl6 && bl7); ++i) {
                    object2 = this.getDocumentAt(i);
                    boolean bl8 = ((DocumentComponent)object2).isClosable();
                    if (bl8) {
                        bl6 = true;
                    }
                    if (object2 == documentComponent || !bl8) continue;
                    bl7 = true;
                }
                jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_CLOSE_OTHERS));
                jMenuItem.setName(CONTEXT_MENU_CLOSE_OTHERS);
                jMenuItem.setMnemonic(this.getResourceString("DocumentPane.closeOthers.mnemonic").charAt(0));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.closeAllButThis(string);
                    }
                });
                jPopupMenu.add(jMenuItem);
                jMenuItem.setEnabled(bl7);
                jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_CLOSE_ALL));
                jMenuItem.setName(CONTEXT_MENU_CLOSE_ALL);
                jMenuItem.setMnemonic(this.getResourceString("DocumentPane.closeAll.mnemonic").charAt(0));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.closeAll();
                    }
                });
                jPopupMenu.add(jMenuItem);
                jMenuItem.setEnabled(bl6);
            }
            if ((string2 = this.getNextDocument(string)) != null) {
                jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_NEXT));
                jMenuItem.setName(CONTEXT_MENU_NEXT);
                jMenuItem.setMnemonic(this.getResourceString("DocumentPane.next.mnemonic").charAt(0));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.setActiveDocument(string2);
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
            if ((object = this.getPreviousDocument(string)) != null) {
                jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_PREVIOUS));
                jMenuItem.setName(CONTEXT_MENU_PREVIOUS);
                jMenuItem.setMnemonic(this.getResourceString("DocumentPane.previous.mnemonic").charAt(0));
                jMenuItem.addActionListener(new ActionListener((String)object){
                    final /* synthetic */ String val$previousDocumentName;
                    {
                        this.val$previousDocumentName = string;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.setActiveDocument(this.val$previousDocumentName);
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
        }
        final int n = this.indexOfPane(tdiGroup2);
        if (this.isGroupsAllowed() && this.isRearrangeAllowed() && n != -1) {
            boolean bl9 = false;
            if (jPopupMenu.getComponentCount() == 0) {
                bl9 = true;
            }
            if (bl2) {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_NEW_HORIZONTAL_GROUP), UIDefaultsLookup.getIcon("DocumentPane.newHorizontalGroupIcon"));
                ((Component)object).setName(CONTEXT_MENU_NEW_HORIZONTAL_GROUP);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.newHorizontalGroup.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.newDocumentGroup(string, n + 1, 0);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
            if (bl3) {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_NEW_VERTICAL_GROUP), UIDefaultsLookup.getIcon("DocumentPane.newVerticalGroupIcon"));
                ((Component)object).setName(CONTEXT_MENU_NEW_VERTICAL_GROUP);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.newVerticalGroup.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.newDocumentGroup(string, n + 1, 1);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
            if (bl4 && this.getDocument(string) instanceof CloneableDocumentComponent) {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_SPLIT_HORIZONTALLY));
                ((Component)object).setName(CONTEXT_MENU_SPLIT_HORIZONTALLY);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.splitHorizontally.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.splitDocument(string, n + 1, 0);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
            if (bl5 && this.getDocument(string) instanceof CloneableDocumentComponent) {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_SPLIT_VERTICALLY));
                ((Component)object).setName(CONTEXT_MENU_SPLIT_VERTICALLY);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.splitVertically.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.splitDocument(string, n + 1, 1);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
            if (tdiGroup.equals(tdiGroup2)) {
                if (n < this.getPaneCount() - 1) {
                    object = new JMenuItem(this.getResourceString(CONTEXT_MENU_MOVE_TO_NEXT));
                    ((Component)object).setName(CONTEXT_MENU_MOVE_TO_NEXT);
                    ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.moveToNext.mnemonic").charAt(0));
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DocumentPane.this.moveDocument(string, n + 1);
                        }
                    });
                    if (!bl9) {
                        jPopupMenu.addSeparator();
                        bl9 = true;
                    }
                    jPopupMenu.add((JMenuItem)object);
                }
                if (n > 0) {
                    object = new JMenuItem(this.getResourceString(CONTEXT_MENU_MOVE_TO_PREVIOUS));
                    ((Component)object).setName(CONTEXT_MENU_MOVE_TO_PREVIOUS);
                    ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.moveToPrevious.mnemonic").charAt(0));
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DocumentPane.this.moveDocument(string, n - 1);
                        }
                    });
                    if (!bl9) {
                        jPopupMenu.addSeparator();
                        bl9 = true;
                    }
                    jPopupMenu.add((JMenuItem)object);
                }
            } else {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_MOVE_TO_THIS));
                ((Component)object).setName(CONTEXT_MENU_MOVE_TO_THIS);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.moveToThis.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.moveDocument(string, n);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
            if (this.getPaneCount() > 1) {
                object = new JMenuItem(this.getResourceString(CONTEXT_MENU_CHANGE_ORIENTATION));
                ((Component)object).setName(CONTEXT_MENU_CHANGE_ORIENTATION);
                ((AbstractButton)object).setMnemonic(this.getResourceString("DocumentPane.changeOrientation.mnemonic").charAt(0));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.setOrientation(DocumentPane.this.getOrientation() == 1 ? 0 : 1);
                    }
                });
                if (!bl9) {
                    jPopupMenu.addSeparator();
                    bl9 = true;
                }
                jPopupMenu.add((JMenuItem)object);
            }
        }
        if (this.isFloatingAllowed()) {
            JideSwingUtilities.addSeparatorIfNecessary(jPopupMenu);
            if (this.isDocumentFloating(string)) {
                JMenuItem jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_DOCKING));
                jMenuItem.setName(CONTEXT_MENU_DOCKING);
                jMenuItem.setMnemonic(this.getResourceString("DocumentPane.docking.mnemonic").charAt(0));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.dockDocument(string);
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
            boolean bl10 = true;
            int n2 = this._floatingContainers.size();
            FloatingDocumentContainer floatingDocumentContainer = null;
            if (this.isDocumentFloating(string)) {
                --n2;
                floatingDocumentContainer = (FloatingDocumentContainer)((Object)SwingUtilities.getAncestorOfClass(FloatingDocumentContainer.class, this.getDocument(string).getComponent()));
                if (floatingDocumentContainer != null && floatingDocumentContainer.getDocumentGroup().getDocumentCount() <= 1) {
                    bl10 = false;
                }
            }
            if (bl10) {
                object2 = new JMenuItem(this.getResourceString(CONTEXT_MENU_FLOATING));
                ((Component)object2).setName(CONTEXT_MENU_FLOATING);
                ((AbstractButton)object2).setMnemonic(this.getResourceString("DocumentPane.floating.mnemonic").charAt(0));
                ((AbstractButton)object2).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DocumentPane.this.floatDocument(string, false);
                    }
                });
                jPopupMenu.add((JMenuItem)object2);
            }
            if (n2 > 0) {
                object2 = new JMenu(this.getResourceString("DocumentPane.floatingTo"));
                ((AbstractButton)object2).setMnemonic(this.getResourceString("DocumentPane.floatingTo.mnemonic").charAt(0));
                for (FloatingDocumentContainer floatingDocumentContainer2 : this._floatingContainers) {
                    if (floatingDocumentContainer2 == floatingDocumentContainer) continue;
                    final FloatingDocumentContainer floatingDocumentContainer3 = floatingDocumentContainer2;
                    JMenuItem jMenuItem = new JMenuItem(floatingDocumentContainer3.getTitle());
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DocumentPane.this.floatDocument(floatingDocumentContainer3, string);
                        }
                    });
                    ((Container)object2).add(jMenuItem);
                }
                jPopupMenu.add((JMenuItem)object2);
            }
        }
        if (!bl && jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
            JMenuItem jMenuItem = new JMenuItem(this.getResourceString(CONTEXT_MENU_CANCEL));
            jMenuItem.setName(CONTEXT_MENU_CANCEL);
            jPopupMenu.add(jMenuItem);
        }
    }

    protected String getResourceString(String string) {
        return Resource.getResourceBundle(this.getLocale()).getString(string);
    }

    @Override
    public void floatDocument(String string) {
        this.floatDocument(string, true);
    }

    public void floatDocument(final String string, final boolean bl) {
        if (this._documents.get(string) == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalFloatDocument(string, bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.internalFloatDocument(string, bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalFloatDocument(String string, boolean bl) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null) {
            Container container;
            Object object;
            this.activateGroup(null);
            PreviousState previousState = PreviousState.createPreviousState(documentComponent);
            if (!this.isDocumentFloating(string)) {
                documentComponent.setFloatPreviousState(previousState);
            }
            PreviousState previousState2 = documentComponent.getDockPreviousState();
            FloatingDocumentContainer floatingDocumentContainer = null;
            if (bl && previousState2 != null && (object = PreviousState.findDocumentGroup(this, previousState2, string)) != null && (container = ((JComponent)object).getTopLevelAncestor()) instanceof FloatingDocumentContainer) {
                floatingDocumentContainer = (FloatingDocumentContainer)((Object)container);
            }
            if (floatingDocumentContainer == null) {
                floatingDocumentContainer = this.createFloatingDocumentContainer();
                try {
                    object = this.adjustNextFloatingDocumentLocation(documentComponent, this.getLocationOnScreen(), previousState2 == null ? null : previousState2.fcBounds.getLocation());
                    floatingDocumentContainer.setLocation((Point)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._floatingContainers.add(floatingDocumentContainer);
            }
            object = documentComponent.getComponent().getParent();
            if (previousState2 != null) {
                int n = PreviousState.findDocumentIndex(this, floatingDocumentContainer.getDocumentGroup(), previousState2, string);
                floatingDocumentContainer.getDocumentGroup().addDocument(documentComponent, n);
            } else {
                floatingDocumentContainer.getDocumentGroup().addDocument(documentComponent);
            }
            if (object instanceof IDocumentGroup) {
                IDocumentGroup iDocumentGroup = (IDocumentGroup)object;
                this.removeIfEmpty(iDocumentGroup);
            }
            Dimension dimension = this.adjustNextFloatingDocumentSize(documentComponent, previousState2 == null ? null : previousState2.fcBounds.getSize());
            floatingDocumentContainer.setPreferredSize(dimension.width == 0 || dimension.height == 0 ? this.getSize() : dimension);
            floatingDocumentContainer.pack();
            floatingDocumentContainer.setVisible(true);
            documentComponent.fireDocumentComponentEvent(6007);
            this.internalSetActiveDocument(string, true);
        }
    }

    protected Dimension adjustNextFloatingDocumentSize(DocumentComponent documentComponent, Dimension dimension) {
        return documentComponent.getComponent().getSize();
    }

    protected Point adjustNextFloatingDocumentLocation(DocumentComponent documentComponent, Point point, Point point2) {
        if (point2 != null) {
            return point2;
        }
        point.x += 20;
        point.y += 20;
        boolean bl = false;
        do {
            boolean bl2 = false;
            for (FloatingDocumentContainer floatingDocumentContainer : this._floatingContainers) {
                if (point.x != floatingDocumentContainer.getX() || point.y != floatingDocumentContainer.getY()) continue;
                point.x += 20;
                point.y += 20;
                bl2 = true;
                bl = true;
                break;
            }
            if (bl2) continue;
            bl = false;
        } while (bl);
        return point;
    }

    @Override
    public void floatDocument(final FloatingDocumentContainer floatingDocumentContainer, final String string) {
        if (this._documents.get(string) == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalFloatDocument(floatingDocumentContainer, string);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.internalFloatDocument(floatingDocumentContainer, string);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalFloatDocument(FloatingDocumentContainer floatingDocumentContainer, String string) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null) {
            PreviousState previousState = PreviousState.createPreviousState(documentComponent);
            if (!this.isDocumentFloating(string)) {
                documentComponent.setFloatPreviousState(previousState);
            }
            Container container = documentComponent.getComponent().getParent();
            floatingDocumentContainer.getDocumentGroup().addDocument(documentComponent);
            if (container instanceof IDocumentGroup) {
                IDocumentGroup iDocumentGroup = (IDocumentGroup)((Object)container);
                this.removeIfEmpty(iDocumentGroup);
                List<FloatingDocumentContainer> list = this.getFloatingContainers();
                for (FloatingDocumentContainer floatingDocumentContainer2 : list) {
                    if (floatingDocumentContainer2 == floatingDocumentContainer || floatingDocumentContainer2 == null || floatingDocumentContainer2.getDocumentGroup() != container) continue;
                    floatingDocumentContainer2.updateTitle();
                    break;
                }
            }
            documentComponent.fireDocumentComponentEvent(6007);
            this.activateGroup(floatingDocumentContainer.getDocumentGroup());
            floatingDocumentContainer.toFront();
            floatingDocumentContainer.updateTitle();
        }
    }

    protected FloatingDocumentContainer createFloatingDocumentContainer() {
        Window window = this.getFloatingContainerType() == 0 ? new DialogFloatingDocumentContainer(this) : new FrameFloatingDocumentContainer(this);
        Container container = this.getTopLevelAncestor();
        if (container instanceof Frame && window instanceof Frame) {
            ((Frame)window).setIconImage(((Frame)container).getIconImage());
            if (SystemInfo.isJdk6Above()) {
                ((Frame)window).setIconImages(((Frame)container).getIconImages());
            }
        }
        window.addWindowListener(new WindowAdapter((FloatingDocumentContainer)((Object)window)){
            final /* synthetic */ FloatingDocumentContainer val$container;
            {
                this.val$container = floatingDocumentContainer;
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                DocumentPane.this.removeFloatingContainer(this.val$container);
            }
        });
        return window;
    }

    void removeFloatingContainer(FloatingDocumentContainer floatingDocumentContainer) {
        this._floatingContainers.remove(floatingDocumentContainer);
    }

    @Override
    public void dockDocument(final String string) {
        if (this._documents.get(string) == null) {
            return;
        }
        if (!this.isDocumentFloating(string)) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalDockDocument(string);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DocumentPane.this.internalDockDocument(string);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalDockDocument(String string) {
        DocumentComponent documentComponent = this.getDocument(string);
        if (documentComponent != null) {
            PreviousState previousState = PreviousState.createPreviousState(documentComponent);
            documentComponent.setDockPreviousState(previousState);
            PreviousState previousState2 = documentComponent.getFloatPreviousState();
            IDocumentGroup iDocumentGroup = null;
            if (previousState2 != null) {
                iDocumentGroup = PreviousState.findDocumentGroup(this, previousState2, string);
            }
            boolean bl = false;
            int n = -1;
            if (iDocumentGroup == null) {
                if (this.getPaneCount() == 0) {
                    iDocumentGroup = this.createDocumentGroup();
                    bl = true;
                } else if (!this.isGroupsAllowed()) {
                    iDocumentGroup = this.getDocumentGroupAt(0);
                    n = 0;
                } else {
                    int n2 = n = previousState2 != null ? PreviousState.findDocumentGroupIndex(this, previousState2, string) : -1;
                    if (n != -1) {
                        iDocumentGroup = this.createDocumentGroup();
                        bl = true;
                    } else {
                        iDocumentGroup = this.getDocumentGroupAt(0);
                    }
                }
            }
            if (previousState2 != null) {
                int n3 = PreviousState.findDocumentIndex(this, iDocumentGroup, previousState2, string);
                iDocumentGroup.addDocument(documentComponent, n3);
            } else {
                iDocumentGroup.addDocument(documentComponent);
            }
            if (bl) {
                if (n == -1) {
                    this.add((Component)((Object)iDocumentGroup), "flexible");
                } else {
                    n = Math.min(n, this.getPaneCount());
                    this.add((Component)((Object)iDocumentGroup), "flexible", n);
                }
            }
            documentComponent.fireDocumentComponentEvent(6006);
            this.internalSetActiveDocument(string, true);
        }
    }

    @Override
    public void dockDocuments(FloatingDocumentContainer floatingDocumentContainer) {
        IDocumentGroup iDocumentGroup = floatingDocumentContainer.getDocumentGroup();
        for (int i = iDocumentGroup.getDocumentCount() - 1; i >= 0; --i) {
            this.dockDocument(this._documentNames.get(iDocumentGroup.getDocumentAt(i)));
        }
    }

    @Override
    public void closeDocuments(FloatingDocumentContainer floatingDocumentContainer) {
        IDocumentGroup iDocumentGroup = floatingDocumentContainer.getDocumentGroup();
        for (int i = iDocumentGroup.getDocumentCount() - 1; i >= 0; --i) {
            this.closeDocument(this._documentNames.get(iDocumentGroup.getDocumentAt(i)));
        }
    }

    @Override
    public boolean isDocumentFloating(String string) {
        JComponent jComponent;
        DocumentComponent documentComponent = this.getDocument(string);
        Container container = jComponent = documentComponent.getComponent();
        do {
            if (!(container instanceof DocumentPane)) continue;
            return false;
        } while ((container = container.getParent()) != null);
        return jComponent.getTopLevelAncestor() instanceof FloatingDocumentContainer;
    }

    @Override
    public List<FloatingDocumentContainer> getFloatingContainers() {
        return this._floatingContainers;
    }

    @Override
    public int getFloatingContainerCloseAction() {
        return this._floatingContainerCloseAction;
    }

    @Override
    public void setFloatingContainerCloseAction(int n) {
        this._floatingContainerCloseAction = n;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container container = this.getTopLevelAncestor();
        if (container instanceof Frame) {
            for (FloatingDocumentContainer floatingDocumentContainer : this._floatingContainers) {
                if (!(floatingDocumentContainer instanceof Frame)) continue;
                ((Frame)((Object)floatingDocumentContainer)).setIconImage(((Frame)container).getIconImage());
                if (!SystemInfo.isJdk6Above()) continue;
                ((Frame)((Object)floatingDocumentContainer)).setIconImages(((Frame)container).getIconImages());
            }
        }
        for (FloatingDocumentContainer floatingDocumentContainer : this._floatingContainers) {
            floatingDocumentContainer.setVisible(true);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        for (FloatingDocumentContainer floatingDocumentContainer : this._floatingContainers) {
            floatingDocumentContainer.setVisible(false);
        }
    }

    protected String getFloatingContainerTitle(TdiGroup tdiGroup) {
        int n = tdiGroup.getSelectedIndex();
        if (n != -1) {
            String string = tdiGroup.getDisplayTitleAt(n);
            int n2 = tdiGroup.getTabCount();
            return string + (n2 > 1 ? " (" + n2 + ")" : "");
        }
        return null;
    }

    @Override
    public int getFloatingContainerType() {
        String string = SecurityUtils.getProperty("documentPane.floatingContainerType", null);
        if (string != null) {
            if ("dialog".equals(string)) {
                return 0;
            }
            if ("frame".equals(string)) {
                return 1;
            }
        }
        return this._floatingContainerType;
    }

    @Override
    public void setFloatingContainerType(int n) {
        int n2 = this._floatingContainerType;
        if (n2 != n) {
            this._floatingContainerType = n;
            this.firePropertyChange(PROPERTY_FLOATING_CONTAINER_TYPE, n2, this._floatingContainerType);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(DocumentPane.class.getName(), 2);
        }
        DEFAULT_TITLE_CONVERTER = new DefaultStringConverter(30, 14);
    }

    public static interface DocumentTabColorProvider {
        public Color getBackgroundAt(int var1);

        public Color getForegroundAt(int var1);

        public float getGradientRatio(int var1);
    }

    private class DocumentPaneLayoutPersistence
    extends AbstractLayoutPersistence {
        private boolean _loadDataSuccessful = true;

        private DocumentPaneLayoutPersistence() {
        }

        @Override
        public void beginLoadLayoutData() {
        }

        @Override
        public boolean loadLayoutFrom(Document document) {
            this._loadDataSuccessful = DocumentPanePersistenceUtils.internalLoad(DocumentPane.this, document, this.getLoadCallback());
            return this._loadDataSuccessful;
        }

        @Override
        public boolean loadLayoutFrom(InputStream inputStream) {
            Object object;
            this._loadDataSuccessful = false;
            if (inputStream == null) {
                this.resetToDefault();
                return this._loadDataSuccessful;
            }
            InputStream inputStream2 = inputStream;
            if (this.isNeedFormatCheck()) {
                try {
                    object = PersistenceUtils.bufferStreamToArray(inputStream);
                }
                catch (IOException iOException) {
                    this.resetToDefault();
                    return this._loadDataSuccessful;
                }
                inputStream2 = new ByteArrayInputStream((byte[])object);
                if (PersistenceUtils.isXmlFormat((byte[])object)) {
                    try {
                        DocumentPanePersistenceUtils.load(DocumentPane.this, inputStream2, this.getLoadCallback());
                    }
                    catch (Exception exception) {
                        this.resetToDefault();
                        return this._loadDataSuccessful;
                    }
                    return true;
                }
            }
            try {
                int n;
                Object object2;
                Object object3;
                int n2;
                int n3;
                object = new DataInputStream(inputStream2);
                int n4 = ((DataInputStream)object).readInt();
                if (!this.isVersionCompatible(n4)) {
                    this.resetToDefault();
                    return this._loadDataSuccessful;
                }
                if (DocumentPane.this._documentComponentList == null) {
                    DocumentPane.this._documentComponentList = new ArrayList<DocumentComponent>();
                    for (n3 = 0; n3 < DocumentPane.this.getDocumentCount(); ++n3) {
                        DocumentPane.this._documentComponentList.add(DocumentPane.this.getDocumentAt(n3));
                    }
                }
                DocumentPane.this.closeAll(true);
                n3 = ((DataInputStream)object).readInt();
                boolean bl = (n3 & 0x10) != 0;
                DocumentPane.this.setOrientation(n3 & 1);
                String string = DocumentPane.readString((DataInputStream)object);
                int n5 = ((DataInputStream)object).readInt();
                for (n2 = 0; n2 < n5; ++n2) {
                    Dimension dimension = new Dimension();
                    dimension.width = ((DataInputStream)object).readInt();
                    dimension.height = ((DataInputStream)object).readInt();
                    int n6 = ((DataInputStream)object).readInt();
                    JComponent jComponent = null;
                    object3 = DocumentPane.this.createDocumentGroup();
                    int n7 = ((DataInputStream)object).readInt();
                    for (int i = 0; i < n7; ++i) {
                        String string2 = DocumentPane.readString((DataInputStream)object);
                        if (string2 == null || string2.length() <= 0) continue;
                        DocumentComponent documentComponent = DocumentPane.this.findDocumentComponent(string2);
                        if (documentComponent == null && (object2 = DocumentPane.this.getDocumentComponentFactory()) != null && (documentComponent = object2.create(string2)) != null) {
                            DocumentPane.this._documentComponentList.add(documentComponent);
                        }
                        if (documentComponent == null) continue;
                        documentComponent.setDocumentPane(DocumentPane.this);
                        DocumentPane.this.addToMap(documentComponent);
                        object3.addDocument(documentComponent);
                        documentComponent.fireDocumentComponentEvent(5999);
                        documentComponent.fireDocumentComponentEvent(6006);
                        documentComponent.getComponent().setPreferredSize(new Dimension(200, 200));
                        if (i != n6) continue;
                        jComponent = documentComponent.getComponent();
                    }
                    if (object3.getDocumentCount() <= 0) continue;
                    ((JComponent)object3).setPreferredSize(dimension);
                    DocumentPane.this.add((Component)((JComponent)object3), "flexible");
                    if (jComponent == null) continue;
                    object3.setSelectedDocument(jComponent);
                }
                n2 = 0;
                try {
                    n2 = ((DataInputStream)object).readInt();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (n = 0; n < n2; ++n) {
                    Rectangle rectangle = new Rectangle();
                    rectangle.x = ((DataInputStream)object).readInt();
                    rectangle.y = ((DataInputStream)object).readInt();
                    rectangle.width = ((DataInputStream)object).readInt();
                    rectangle.height = ((DataInputStream)object).readInt();
                    int n8 = ((DataInputStream)object).readInt();
                    object3 = null;
                    FloatingDocumentContainer floatingDocumentContainer = DocumentPane.this.createFloatingDocumentContainer();
                    DocumentPane.this._floatingContainers.add(floatingDocumentContainer);
                    IDocumentGroup iDocumentGroup = floatingDocumentContainer.getDocumentGroup();
                    int n9 = ((DataInputStream)object).readInt();
                    for (int i = 0; i < n9; ++i) {
                        DocumentComponent documentComponent;
                        object2 = DocumentPane.readString((DataInputStream)object);
                        if (object2 == null || ((String)object2).length() <= 0 || (documentComponent = DocumentPane.this.findDocumentComponent((String)object2)) == null) continue;
                        documentComponent.setDocumentPane(DocumentPane.this);
                        DocumentPane.this.addToMap(documentComponent);
                        iDocumentGroup.addDocument(documentComponent);
                        documentComponent.fireDocumentComponentEvent(5999);
                        documentComponent.fireDocumentComponentEvent(6007);
                        documentComponent.getComponent().setPreferredSize(new Dimension(200, 200));
                        if (i != n8) continue;
                        object3 = documentComponent.getComponent();
                    }
                    if (iDocumentGroup.getDocumentCount() <= 0) continue;
                    floatingDocumentContainer.pack();
                    floatingDocumentContainer.setBounds(rectangle);
                    floatingDocumentContainer.setVisible(true);
                    if (object3 == null) continue;
                    iDocumentGroup.setSelectedDocument((Component)object3);
                }
                if (bl) {
                    DocumentPane.this.setProportionalLayout(((DataInputStream)object).readBoolean());
                    if (DocumentPane.this.isProportionalLayout()) {
                        DocumentPane.this.setInitiallyEven(((DataInputStream)object).readBoolean());
                        n = ((DataInputStream)object).readInt();
                        if (n > 0) {
                            double[] dArray = new double[n];
                            for (int i = 0; i < dArray.length; ++i) {
                                dArray[i] = ((DataInputStream)object).readDouble();
                            }
                            DocumentPane.this.setProportions(dArray);
                        }
                    }
                }
                if (string != null && DocumentPane.this.isDocumentOpened(string)) {
                    DocumentPane.this.setActiveDocument(string);
                }
                DocumentPane.this.clearOpenedDocuments();
                this._loadDataSuccessful = true;
            }
            catch (IOException iOException) {
                this.resetToDefault();
            }
            return this._loadDataSuccessful;
        }

        @Override
        public void saveLayoutTo(Document document) throws ParserConfigurationException {
            DocumentPanePersistenceUtils.saveToDocument(DocumentPane.this, document, this.getSaveCallback());
        }

        @Override
        public void saveLayoutTo(OutputStream outputStream) throws IOException {
            Object object;
            int n;
            if (this.isXmlFormat()) {
                try {
                    DocumentPanePersistenceUtils.save(DocumentPane.this, outputStream);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                return;
            }
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(this._version);
            int n2 = DocumentPane.this.getOrientation();
            dataOutputStream.writeInt(n2 | 0x10);
            String string = DocumentPane.this.getActiveDocumentName();
            DocumentPane.writeString(dataOutputStream, string);
            int n3 = DocumentPane.this.getPaneCount();
            dataOutputStream.writeInt(n3);
            for (n = 0; n < n3; ++n) {
                IDocumentGroup iDocumentGroup = DocumentPane.this.getDocumentGroupAt(n);
                object = ((JComponent)((Object)iDocumentGroup)).getPreferredSize();
                dataOutputStream.writeInt(((Dimension)object).width);
                dataOutputStream.writeInt(((Dimension)object).height);
                dataOutputStream.writeInt(iDocumentGroup.getSelectedIndex());
                int n4 = iDocumentGroup.getDocumentCount();
                dataOutputStream.writeInt(n4);
                for (int i = 0; i < n4; ++i) {
                    Component component = iDocumentGroup.getDocumentAt(i);
                    String string2 = DocumentPane.this.getNameOf(component);
                    DocumentPane.writeString(dataOutputStream, string2);
                }
            }
            n = DocumentPane.this._floatingContainers.size();
            dataOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                object = DocumentPane.this._floatingContainers.get(i);
                IDocumentGroup iDocumentGroup = object.getDocumentGroup();
                Rectangle rectangle = object.getBounds();
                dataOutputStream.writeInt(rectangle.x);
                dataOutputStream.writeInt(rectangle.y);
                dataOutputStream.writeInt(rectangle.width);
                dataOutputStream.writeInt(rectangle.height);
                dataOutputStream.writeInt(iDocumentGroup.getSelectedIndex());
                int n5 = iDocumentGroup.getDocumentCount();
                dataOutputStream.writeInt(n5);
                for (int j = 0; j < n5; ++j) {
                    Component component = iDocumentGroup.getDocumentAt(j);
                    String string3 = DocumentPane.this.getNameOf(component);
                    DocumentPane.writeString(dataOutputStream, string3);
                }
            }
            dataOutputStream.writeBoolean(DocumentPane.this.isProportionalLayout());
            if (DocumentPane.this.isProportionalLayout()) {
                dataOutputStream.writeBoolean(DocumentPane.this.isInitiallyEven());
                double[] dArray = DocumentPane.this.getProportions();
                dataOutputStream.writeInt(dArray == null ? -1 : dArray.length);
                if (dArray != null) {
                    for (Object object2 : (Object)dArray) {
                        dataOutputStream.writeDouble((double)object2);
                    }
                }
            }
        }

        @Override
        public void resetToDefault() {
            if (DocumentPane.this._documentComponentList == null) {
                DocumentPane.this._documentComponentList = new ArrayList<DocumentComponent>();
                for (int i = 0; i < DocumentPane.this.getDocumentCount(); ++i) {
                    DocumentPane.this._documentComponentList.add(DocumentPane.this.getDocumentAt(i));
                }
            }
            DocumentPane.this.closeAll();
            for (DocumentComponent documentComponent : DocumentPane.this._documentComponentList) {
                if (DocumentPane.this.isDocumentOpened(documentComponent.getName())) continue;
                DocumentPane.this.openDocument(documentComponent);
            }
            DocumentPane.this.clearOpenedDocuments();
        }

        @Override
        public boolean isLoadDataSuccessful() {
            return this._loadDataSuccessful;
        }

        @Override
        public void loadInitialLayout(Document document) {
        }
    }

    public static interface TabbedPaneCustomizer {
        public void customize(JideTabbedPane var1);
    }
}

