/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class NotificationFlasher
implements ActionListener {
    private DockableFrame _frame;
    private FrameContainer _fc;
    private AutoHideContainer _ac;
    private Color _notificationBackground;
    private Color _notificationForeground;
    private int _steps;
    private Timer _timer;
    private int _currentStep;

    public NotificationFlasher(FrameContainer frameContainer, DockableFrame dockableFrame, int n, int n2, int n3) {
        this._fc = frameContainer;
        this._frame = dockableFrame;
        this._steps = n3;
        this._currentStep = 0;
        this._timer = new Timer(n2, this);
        this._timer.setInitialDelay(n);
        this._notificationBackground = this._frame.getDockingManager().getNotificationBackground();
        this._notificationForeground = this._frame.getDockingManager().getNotificationForeground();
    }

    public NotificationFlasher(AutoHideContainer autoHideContainer, DockableFrame dockableFrame, int n, int n2, int n3) {
        this._frame = dockableFrame;
        this._ac = autoHideContainer;
        SidePaneItem sidePaneItem = autoHideContainer.getSidePaneItem(dockableFrame);
        SidePaneGroup sidePaneGroup = autoHideContainer.getSidePaneGroup(dockableFrame);
        sidePaneGroup.setSelectedItem(sidePaneItem);
        this._steps = n3;
        this._currentStep = 0;
        this._timer = new Timer(n2, this);
        this._timer.setInitialDelay(n);
        this._notificationBackground = this._frame.getDockingManager().getNotificationBackground();
        this._notificationForeground = this._frame.getDockingManager().getNotificationForeground();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.flash(this._currentStep % 2 == 0);
        ++this._currentStep;
        if (this._steps != -1 && this._currentStep >= this._steps) {
            this.stop();
        }
    }

    public void start() {
        if (this._timer != null) {
            this._timer.start();
        }
    }

    public void stop() {
        this.flash(this._frame.isNotified() && !this._frame.isActive());
        if (this._timer != null) {
            this._timer.stop();
        }
    }

    public void interrupt() {
        this.stop();
    }

    public boolean isRunning() {
        return this._timer != null && this._timer.isRunning();
    }

    private void flash(boolean bl) {
        SidePaneItem sidePaneItem;
        Color color = null;
        Color color2 = null;
        if (bl) {
            color = this._notificationBackground;
            color2 = this._notificationForeground;
        }
        if (this._fc != null) {
            int n = this._fc.indexOfComponent(this._frame);
            if (n != -1) {
                this._fc.setBackgroundAt(n, color);
                this._fc.setForegroundAt(n, color2);
                this._fc.repaint();
            }
        } else if (this._ac != null && (sidePaneItem = this._ac.getSidePaneItem(this._frame)) != null) {
            sidePaneItem.setForeground(color2);
            sidePaneItem.setBackground(color);
            this._ac.repaint();
        }
    }
}

