/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockID;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableFrameMouseInputAdapter;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.DragableDockable;
import com.jidesoft.docking.PreviousState;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;

public class FrameContainer
extends JideTabbedPane
implements ComponentListener,
ContainerListener,
DragableDockable,
PropertyChangeListener {
    private DockableFrameMouseInputAdapter _borderListener;
    private DockingManager _dockingManager;
    private int _dockedWidth;
    private int _dockedHeight;
    private int _autohideWidth;
    private int _autohideHeight;
    private DockableFrame _previousSelectedFrame;
    private int _dockID = 0;

    FrameContainer() {
        this(null);
    }

    public FrameContainer(DockingManager dockingManager) {
        this(dockingManager, 3, 1);
    }

    public FrameContainer(DockingManager dockingManager, int n, int n2) {
        super(n, n2);
        this._dockingManager = dockingManager;
        if (this._dockingManager != null) {
            this.setTabResizeMode(2);
            this.setHideOneTab(true);
            this.addContainerListener(this);
            this.addComponentListener(this);
            this.resetDockID();
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() instanceof DockableFrame) {
                        ((DockableFrame)actionEvent.getSource()).getCloseAction().actionPerformed(actionEvent);
                    }
                }
            };
            this.setCloseAction(abstractAction);
            this.setOpaque(false);
            this.setAutoFocusOnTabHideClose(false);
            this.setAutoRequestFocus(false);
            this.setCloseTabOnMouseMiddleButton(true);
        }
    }

    @Override
    public void updateUI() {
        Insets insets;
        Insets insets2;
        super.updateUI();
        if (this._borderListener == null) {
            this._borderListener = new DockableFrameMouseInputAdapter(this);
        }
        if (!JideSwingUtilities.isMouseListenerRegistered(this, this._borderListener)) {
            this.addMouseListener(this._borderListener);
        }
        if (!JideSwingUtilities.isMouseMotionListenerRegistered(this, this._borderListener)) {
            this.addMouseMotionListener(this._borderListener);
        }
        if (((insets2 = this.getContentBorderInsets()) == null || insets2 instanceof UIResource) && (insets = UIDefaultsLookup.getInsets("FrameContainer.contentBorderInsets")) != null) {
            this.setContentBorderInsets(insets);
        }
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof DockableFrame) {
            containerEvent.getChild().addPropertyChangeListener(this);
        }
        if (!SystemInfo.isJdk6Above() && !(containerEvent.getChild() instanceof UIResource)) {
            this.fireStateChanged();
        }
    }

    @Override
    public boolean isEnabledAt(int n) {
        DockableFrame dockableFrame = this.getFrame(n);
        return super.isEnabledAt(n) && (dockableFrame == null || dockableFrame.isEnabled());
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof DockableFrame) {
            containerEvent.getChild().removePropertyChangeListener(this);
        }
        if (this.getTabCount() == 0 || this.getTabCount() == 1 && this.getComponentAt(0).equals(containerEvent.getChild())) {
            if (this.getParent() == null) {
                return;
            }
            if (this.getParent() instanceof ContainerContainer) {
                ((ContainerContainer)this.getParent()).removePane(containerEvent.getComponent());
            } else {
                this.getParent().remove(containerEvent.getComponent());
            }
        }
        if (!SystemInfo.isJdk6Above() && !(containerEvent.getChild() instanceof UIResource)) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.getDockingManager().getDockedFrameContainer() == null) {
            return;
        }
        if (!DockingUtils.containsInMainContainer(this.getDockingManager().getDockedFrameContainer(), this)) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                Component component = this.getComponentAt(i);
                if (!(component instanceof DragableDockable)) continue;
                Rectangle rectangle = component.getBounds();
                Point point = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point, component);
                rectangle.x = point.x;
                rectangle.y = point.y;
                try {
                    if (component instanceof DockableFrame) {
                        ((DockableFrame)component).setSettingSize(true);
                    }
                    ((DragableDockable)((Object)component)).setUndockedBounds(rectangle);
                    continue;
                }
                finally {
                    if (component instanceof DockableFrame) {
                        ((DockableFrame)component).setSettingSize(false);
                    }
                }
            }
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void addTab(DockableFrame dockableFrame) {
        this.addTab(dockableFrame, false);
    }

    public void addTab(DockableFrame dockableFrame, boolean bl) {
        boolean bl2 = this.isSuppressStateChangedEvents();
        boolean bl3 = this.isSuppressSetSelectedIndex();
        this.setSuppressStateChangedEvents(bl);
        int n = this.getSelectedIndex();
        if (n != -1) {
            this.setSuppressSetSelectedIndex(bl);
        }
        super.addTab(dockableFrame.getTabTitle(), dockableFrame.getFrameIcon(), dockableFrame, dockableFrame.getToolTipText());
        this.setSuppressStateChangedEvents(bl2);
        this.setSuppressSetSelectedIndex(bl3);
    }

    public void insertTab(DockableFrame dockableFrame, int n) {
        this.insertTab(dockableFrame, n, false);
    }

    public void insertTab(DockableFrame dockableFrame, int n, boolean bl) {
        boolean bl2 = this.isSuppressSetSelectedIndex();
        boolean bl3 = this.isSuppressStateChangedEvents();
        this.setSuppressSetSelectedIndex(bl);
        int n2 = this.getSelectedIndex();
        if (n2 != -1) {
            this.setSuppressSetSelectedIndex(bl);
        }
        this.setSuppressStateChangedEvents(bl);
        this.insertTab(dockableFrame.getTabTitle(), dockableFrame.getFrameIcon(), dockableFrame, dockableFrame.getToolTipText() == null ? dockableFrame.getTitle() : dockableFrame.getToolTipText(), n);
        this.setSuppressSetSelectedIndex(bl2);
        this.setSuppressStateChangedEvents(bl3);
    }

    @Override
    public void setTitleAt(int n, String string) {
        DockableFrame dockableFrame = this.getFrame(n);
        if (dockableFrame != null) {
            dockableFrame.setTabTitle(string);
        }
        super.setTitleAt(n, string);
    }

    public void remove(Component component, boolean bl) {
        boolean bl2 = this.isSuppressSetSelectedIndex();
        boolean bl3 = this.isSuppressStateChangedEvents();
        this.setSuppressSetSelectedIndex(bl);
        int n = this.getSelectedIndex();
        if (n != -1) {
            this.setSuppressSetSelectedIndex(bl);
        }
        this.setSuppressStateChangedEvents(bl);
        super.remove(component);
        this.setSuppressSetSelectedIndex(bl2);
        this.setSuppressStateChangedEvents(bl3);
    }

    @Override
    public void setSelectedComponent(Component component) {
        super.setSelectedComponent(component);
        if (component instanceof DockableFrame) {
            this.setPreviousSelectedFrame((DockableFrame)component);
        }
    }

    public void setSelectedIndex(int n, boolean bl) {
        boolean bl2 = this.isSuppressSetSelectedIndex();
        boolean bl3 = this.isSuppressStateChangedEvents();
        this.setSuppressSetSelectedIndex(bl);
        int n2 = this.getSelectedIndex();
        if (n2 != -1) {
            this.setSuppressSetSelectedIndex(bl);
        }
        this.setSuppressStateChangedEvents(bl);
        this.setSelectedIndex(n);
        this.setSuppressSetSelectedIndex(bl2);
        this.setSuppressStateChangedEvents(bl3);
    }

    @Override
    public void setSelectedIndex(int n) {
        if (this.isSuppressSetSelectedIndex()) {
            return;
        }
        super.setSelectedIndex(n);
    }

    @Override
    public void popupSelectedIndex(int n) {
        super.popupSelectedIndex(n);
        DockableFrame dockableFrame = this.getFrame(n);
        if (dockableFrame != null) {
            this._dockingManager.activateFrame(dockableFrame.getKey());
        }
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    public void setDockingManager(DockingManager dockingManager) {
        this._dockingManager = dockingManager;
    }

    @Override
    public void setDockedWidth(int n) {
        this._dockedWidth = n;
    }

    @Override
    public void setDockedHeight(int n) {
        this._dockedHeight = n;
    }

    @Override
    public void setAutohideWidth(int n) {
        this._autohideWidth = n;
    }

    @Override
    public void setAutohideHeight(int n) {
        this._autohideHeight = n;
    }

    @Override
    public int getDockedWidth() {
        if (this._dockedWidth <= 0) {
            return this.getPreferredSize().width;
        }
        return this._dockedWidth;
    }

    @Override
    public int getDockedHeight() {
        if (this._dockedHeight <= 0) {
            return this.getPreferredSize().height;
        }
        return this._dockedHeight;
    }

    @Override
    public int getAutohideWidth() {
        if (this._autohideWidth <= 0) {
            return this.getPreferredSize().width;
        }
        return this._autohideWidth;
    }

    @Override
    public int getAutohideHeight() {
        if (this._autohideHeight <= 0) {
            return this.getPreferredSize().height;
        }
        return this._autohideHeight;
    }

    @Override
    public void setUndockedBounds(Rectangle rectangle) {
        this.setBounds(rectangle);
    }

    @Override
    public Rectangle getUndockedBounds() {
        return this.getBounds();
    }

    @Override
    public int getDockID() {
        return this._dockID;
    }

    @Override
    public void setDockID(int n) {
        this._dockID = n;
        if (this._dockingManager != null) {
            DockID.getInstance(this._dockingManager).reserveID(this._dockID);
        }
    }

    @Override
    public void resetDockID() {
        this._dockID = DockID.getInstance(this._dockingManager).getID(this.getDockID());
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!(this.getComponentAt(i) instanceof DockableFrame)) continue;
            DockableFrame dockableFrame = (DockableFrame)this.getComponentAt(i);
            dockableFrame.resetDockID();
        }
    }

    public DockableFrame getSelectedFrame() {
        return (DockableFrame)this.getSelectedComponent();
    }

    public DockableFrame getFrame(int n) {
        return (DockableFrame)this.getComponentAt(n);
    }

    public int getFrameIndex(DockableFrame dockableFrame) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (this.getComponentAt(i) != dockableFrame) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setHiddenPreviousState(PreviousState previousState) {
        if (this.getSelectedFrame() == null) {
            return;
        }
        this.getSelectedFrame().setHiddenPreviousState(previousState);
    }

    @Override
    public PreviousState getHiddenPreviousState() {
        return this.getSelectedFrame() == null ? null : this.getSelectedFrame().getHiddenPreviousState();
    }

    @Override
    public void setDockPreviousState(PreviousState previousState) {
    }

    @Override
    public PreviousState getDockPreviousState() {
        return null;
    }

    @Override
    public void setFloatPreviousState(PreviousState previousState) {
        if (this.getSelectedFrame() == null) {
            return;
        }
        this.getSelectedFrame().setFloatPreviousState(previousState);
    }

    @Override
    public PreviousState getFloatPreviousState() {
        return this.getSelectedFrame() == null ? null : this.getSelectedFrame().getFloatPreviousState();
    }

    @Override
    public void setAutohidePreviousState(PreviousState previousState) {
        if (this.getSelectedFrame() == null) {
            return;
        }
        this.getSelectedFrame().setAutohidePreviousState(previousState);
    }

    @Override
    public PreviousState getAutohidePreviousState() {
        return this.getSelectedFrame() == null ? null : this.getSelectedFrame().getAutohidePreviousState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        if ("tabTitle".equals(propertyChangeEvent.getPropertyName())) {
            int n2 = this.indexOfComponent((Component)propertyChangeEvent.getSource());
            if (n2 != -1) {
                this.setTitleAt(n2, (String)propertyChangeEvent.getNewValue());
            }
        } else if ("ToolTipText".equals(propertyChangeEvent.getPropertyName())) {
            int n3 = this.indexOfComponent((Component)propertyChangeEvent.getSource());
            if (n3 != -1) {
                this.setToolTipTextAt(n3, (String)propertyChangeEvent.getNewValue());
            }
        } else if ("frameIcon".equals(propertyChangeEvent.getPropertyName()) && (n = this.indexOfComponent((Component)propertyChangeEvent.getSource())) != -1) {
            this.setIconAt(n, (Icon)propertyChangeEvent.getNewValue());
        }
    }

    DockableFrame getPreviousSelectedFrame() {
        if (this._previousSelectedFrame != null && this._previousSelectedFrame.getParent() == this) {
            return this._previousSelectedFrame;
        }
        return null;
    }

    void setPreviousSelectedFrame(DockableFrame dockableFrame) {
        this._previousSelectedFrame = dockableFrame;
    }

    public boolean isAllFloatable() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (((DockableFrame)this.getComponentAt(i)).isFloatable()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllAutohidable() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (((DockableFrame)this.getComponentAt(i)).isAutohidable()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllAutohidable(int n) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            DockableFrame dockableFrame = (DockableFrame)this.getComponentAt(i);
            if (dockableFrame.isAutohidable() && (dockableFrame.getPreferredAutohideSide() == -1 || dockableFrame.getPreferredAutohideSide() == n)) continue;
            return false;
        }
        return true;
    }

    public boolean isAllHidable() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (((DockableFrame)this.getComponentAt(i)).isHidable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTabClosableAt(int n) {
        if (n >= this.getTabCount()) {
            return true;
        }
        if (this._dockingManager != null && !this._dockingManager.isHidable()) {
            return false;
        }
        Component component = this.getComponentAt(n);
        if (component instanceof DockableFrame && ((DockableFrame)component).getContext() != null) {
            return ((DockableFrame)component).isHidable();
        }
        return super.isTabClosableAt(n);
    }

    @Override
    public boolean hasFocusComponent() {
        DockableFrame dockableFrame = this.getSelectedFrame();
        return dockableFrame != null && dockableFrame.isActive() && (dockableFrame.getDockingManager() == null || dockableFrame.getDockingManager().isActive()) || this.isTabEditing();
    }

    @Override
    public void repaintTabAreaAndContentBorder() {
        super.repaintTabAreaAndContentBorder();
        DockableFrame dockableFrame = this.getSelectedFrame();
        if (dockableFrame != null && dockableFrame.getUI() != null && dockableFrame.getUI().getTitlePane() != null) {
            dockableFrame.getUI().getTitlePane().repaint();
        }
    }
}

